/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Level;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.ext.jaxrs.internal.provider.AbstractProvider;
import org.restlet.ext.jaxrs.internal.util.Converter;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;
import org.restlet.service.ConverterService;

@Provider
public class ConverterProvider
extends AbstractProvider<Object> {
    private ConverterService converterService;

    public ConverterProvider() {
        Application application = Application.getCurrent();
        if (application != null) {
            this.converterService = application.getConverterService();
        }
        if (this.converterService == null) {
            this.converterService = new ConverterService();
        }
    }

    private ConverterService getConverterService() {
        return this.converterService;
    }

    @Override
    public long getSize(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Representation representation = null;
        try {
            Variant targetVariant = new Variant(Converter.toRestletMediaType(mediaType));
            representation = this.getConverterService().toRepresentation(object, targetVariant, null);
        }
        catch (IOException e) {
            Context.getCurrentLogger().log(Level.FINE, "Unable to get the size", e);
        }
        return representation == null ? -1L : representation.getSize();
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Variant sourceVariant = new Variant(Converter.toRestletMediaType(mediaType));
        List classes = this.getConverterService().getObjectClasses(sourceVariant);
        for (Class clazz : classes) {
            if (!clazz.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        List variants;
        try {
            Variant targetVariant = new Variant(Converter.toRestletMediaType(mediaType));
            variants = this.getConverterService().getVariants(type, targetVariant);
        }
        catch (IOException e) {
            throw new ResourceException((Throwable)e);
        }
        return variants != null && !variants.isEmpty();
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        InputRepresentation sourceRepresentation = new InputRepresentation(entityStream, Converter.toRestletMediaType(mediaType));
        return this.getConverterService().toObject((Representation)sourceRepresentation, type, null);
    }

    @Override
    public void writeTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        Variant targetVariant = new Variant(Converter.toRestletMediaType(mediaType));
        Representation representation = this.getConverterService().toRepresentation(object, targetVariant, null);
        if (representation != null) {
            representation.write(entityStream);
        }
    }
}

