/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.restlet.ext.jaxrs.internal.provider.AbstractProvider;

abstract class AbstractJaxbProvider<T>
extends AbstractProvider<T> {
    private ContextResolver<JAXBContext> contextResolver;

    AbstractJaxbProvider() {
    }

    protected JAXBContext getJaxbContext(Class<?> type) throws JAXBException {
        JAXBContext jaxbContext;
        if (this.contextResolver != null && (jaxbContext = (JAXBContext)this.contextResolver.getContext(type)) != null) {
            return jaxbContext;
        }
        try {
            return JAXBContext.newInstance((Class[])new Class[]{type});
        }
        catch (NoClassDefFoundError e) {
            throw new WebApplicationException(Response.serverError().entity((Object)e.getMessage()).build());
        }
    }

    abstract Logger getLogger();

    @Override
    public final long getSize(T object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    void marshal(Object object, OutputStream entityStream) throws IOException {
        Class<?> type = object.getClass();
        try {
            JAXBContext jaxbContext = this.getJaxbContext(object.getClass());
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.marshal(object, entityStream);
        }
        catch (JAXBException e) {
            throw AbstractJaxbProvider.logAndIOExc(this.getLogger(), "Could not marshal the " + type.getName(), e);
        }
    }

    public void setContextResolver(ContextResolver<JAXBContext> contextResolver) {
        this.contextResolver = contextResolver;
    }

    @Context
    void setContextResolver(Providers providers) {
        this.contextResolver = providers.getContextResolver(JAXBContext.class, MediaType.APPLICATION_XML_TYPE);
    }
}

