/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs.internal.exceptions;

import javax.ws.rs.Path;
import org.restlet.ext.jaxrs.internal.exceptions.JaxRsException;

public class IllegalPathException
extends JaxRsException {
    private static final long serialVersionUID = 6796414811480666857L;
    private final Path path;

    private static String createMessage(IllegalArgumentException iae, Path path) {
        String message;
        Throwable cause;
        if (iae != null && (cause = iae.getCause()) != null && ((message = cause.getMessage()) == null || message.length() == 0)) {
            return "The given path (" + path + ") is invalid";
        }
        return null;
    }

    public IllegalPathException(Path path, IllegalArgumentException iae) {
        super(IllegalPathException.createMessage(iae, path), iae);
        this.path = path;
    }

    public IllegalPathException(Path path, String message) {
        super(message);
        this.path = path;
    }

    public IllegalPathException(Path path, String message, IllegalArgumentException iae) {
        super(message, iae);
        this.path = path;
    }

    @Override
    public IllegalArgumentException getCause() {
        Throwable cause = super.getCause();
        if (cause instanceof IllegalArgumentException) {
            return (IllegalArgumentException)cause;
        }
        IllegalArgumentException iae = new IllegalArgumentException(this.getMessage());
        if (cause != null) {
            iae.setStackTrace(cause.getStackTrace());
        }
        return iae;
    }

    public Path getPath() {
        return this.path;
    }
}

