/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.jaxrs;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.RuntimeDelegate;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.Engine;
import org.restlet.ext.jaxrs.InstantiateException;
import org.restlet.ext.jaxrs.ObjectFactory;
import org.restlet.ext.jaxrs.internal.core.CallContext;
import org.restlet.ext.jaxrs.internal.core.ThreadLocalizedContext;
import org.restlet.ext.jaxrs.internal.exceptions.ConvertRepresentationException;
import org.restlet.ext.jaxrs.internal.exceptions.ImplementationException;
import org.restlet.ext.jaxrs.internal.exceptions.MethodInvokeException;
import org.restlet.ext.jaxrs.internal.exceptions.MissingAnnotationException;
import org.restlet.ext.jaxrs.internal.exceptions.RequestHandledException;
import org.restlet.ext.jaxrs.internal.provider.BufferedReaderProvider;
import org.restlet.ext.jaxrs.internal.provider.ByteArrayProvider;
import org.restlet.ext.jaxrs.internal.provider.ConverterProvider;
import org.restlet.ext.jaxrs.internal.provider.FileProvider;
import org.restlet.ext.jaxrs.internal.provider.InputStreamProvider;
import org.restlet.ext.jaxrs.internal.provider.ReaderProvider;
import org.restlet.ext.jaxrs.internal.provider.SimpleXmlProvider;
import org.restlet.ext.jaxrs.internal.provider.SourceProvider;
import org.restlet.ext.jaxrs.internal.provider.StreamingOutputProvider;
import org.restlet.ext.jaxrs.internal.provider.StringProvider;
import org.restlet.ext.jaxrs.internal.provider.WebAppExcMapper;
import org.restlet.ext.jaxrs.internal.provider.WwwFormFormProvider;
import org.restlet.ext.jaxrs.internal.provider.WwwFormMmapProvider;
import org.restlet.ext.jaxrs.internal.spi.RuntimeDelegateImpl;
import org.restlet.ext.jaxrs.internal.todo.NotYetImplementedException;
import org.restlet.ext.jaxrs.internal.util.AlgorithmUtil;
import org.restlet.ext.jaxrs.internal.util.Converter;
import org.restlet.ext.jaxrs.internal.util.ExceptionHandler;
import org.restlet.ext.jaxrs.internal.util.JaxRsOutputRepresentation;
import org.restlet.ext.jaxrs.internal.util.MatchingResult;
import org.restlet.ext.jaxrs.internal.util.PathRegExp;
import org.restlet.ext.jaxrs.internal.util.RemainingPath;
import org.restlet.ext.jaxrs.internal.util.SortedMetadata;
import org.restlet.ext.jaxrs.internal.util.Util;
import org.restlet.ext.jaxrs.internal.util.WrappedRequestForHttpHeaders;
import org.restlet.ext.jaxrs.internal.wrappers.ResourceClass;
import org.restlet.ext.jaxrs.internal.wrappers.ResourceClasses;
import org.restlet.ext.jaxrs.internal.wrappers.ResourceMethod;
import org.restlet.ext.jaxrs.internal.wrappers.ResourceMethodOrLocator;
import org.restlet.ext.jaxrs.internal.wrappers.ResourceObject;
import org.restlet.ext.jaxrs.internal.wrappers.RootResourceClass;
import org.restlet.ext.jaxrs.internal.wrappers.SubResourceLocator;
import org.restlet.ext.jaxrs.internal.wrappers.provider.ExtensionBackwardMapping;
import org.restlet.ext.jaxrs.internal.wrappers.provider.JaxRsProviders;
import org.restlet.ext.jaxrs.internal.wrappers.provider.MessageBodyWriter;
import org.restlet.ext.jaxrs.internal.wrappers.provider.MessageBodyWriterSubSet;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.restlet.service.MetadataService;

public class JaxRsRestlet
extends Restlet {
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private final ExceptionHandler excHandler;
    private volatile ObjectFactory objectFactory;
    private final JaxRsProviders providers;
    private final ResourceClasses resourceClasses;
    private final ThreadLocalizedContext tlContext = new ThreadLocalizedContext();

    public JaxRsRestlet(Context context, MetadataService metadataService) {
        super(context);
        ExtensionBackwardMapping extensionBackwardMapping = new ExtensionBackwardMapping(metadataService);
        this.excHandler = new ExceptionHandler(this.getLogger());
        this.providers = new JaxRsProviders(this.objectFactory, this.tlContext, extensionBackwardMapping, this.getLogger());
        this.resourceClasses = new ResourceClasses(this.tlContext, this.providers, extensionBackwardMapping, this.getLogger());
        this.loadDefaultProviders();
    }

    public boolean addClass(Class<?> jaxRsClass) throws IllegalArgumentException {
        if (jaxRsClass == null) {
            throw new IllegalArgumentException("The JAX-RS class to add must not be null");
        }
        boolean used = false;
        if (Util.isRootResourceClass(jaxRsClass)) {
            used = this.resourceClasses.addRootClass(jaxRsClass);
        }
        if (Util.isProvider(jaxRsClass) && this.providers.addClass(jaxRsClass)) {
            used = true;
        }
        if (!used) {
            this.getLogger().warning("The class " + jaxRsClass + " is neither a provider nor a root resource class");
        }
        return used;
    }

    private boolean addDefaultProvider(Object jaxRsProvider) {
        try {
            return this.addSingleton(jaxRsProvider, true);
        }
        catch (GenericSignatureFormatError e) {
            this.getLogger().warning("Unable to add default provider class : " + jaxRsProvider);
            return false;
        }
    }

    public boolean addSingleton(Object jaxRsProviderOrRootresourceObject) throws IllegalArgumentException {
        return this.addSingleton(jaxRsProviderOrRootresourceObject, false);
    }

    private boolean addSingleton(Object jaxRsProvider, boolean defaultProvider) throws IllegalArgumentException {
        if (jaxRsProvider instanceof String) {
            try {
                jaxRsProvider = Engine.loadClass((String)((String)jaxRsProvider)).newInstance();
            }
            catch (ClassNotFoundException e) {
                this.getLogger().fine("Unable to load provider class : " + jaxRsProvider);
                jaxRsProvider = null;
            }
            catch (InstantiationException e) {
                this.getLogger().fine("Unable to instantiate provider : " + jaxRsProvider);
                jaxRsProvider = null;
            }
            catch (IllegalAccessException e) {
                this.getLogger().fine("Unable to access to provider : " + jaxRsProvider);
                jaxRsProvider = null;
            }
            catch (NoClassDefFoundError e) {
                this.getLogger().fine("Unable to load provider class : " + jaxRsProvider);
                jaxRsProvider = null;
            }
        } else {
            if (jaxRsProvider == null) {
                throw new IllegalArgumentException("The JAX-RS object to add must not be null");
            }
            if (jaxRsProvider instanceof Class) {
                throw new IllegalArgumentException("The JAX-RS object to add must not be a java.lang.Class");
            }
        }
        boolean used = false;
        if (jaxRsProvider != null) {
            if (defaultProvider || Util.isProvider(jaxRsProvider.getClass())) {
                used = this.providers.addSingleton(jaxRsProvider, defaultProvider);
            }
            if (Util.isRootResourceClass(jaxRsProvider.getClass())) {
                throw new NotYetImplementedException("only providers are allowed as singletons for now");
            }
            if (!used) {
                String warning = "The class " + jaxRsProvider.getClass() + " is neither a provider nor a root resource class";
                this.getLogger().warning(warning);
            }
        }
        return used;
    }

    public void attachDefault(Restlet notMatchedRestlet) {
        this.setNoRootResClHandler(notMatchedRestlet);
        this.setNoResourceClHandler(notMatchedRestlet);
        this.setNoResMethodHandler(notMatchedRestlet);
    }

    private Representation convertToRepresentation(Object entity, ResourceMethod resourceMethod, MediaType jaxRsResponseMediaType, MultivaluedMap<String, Object> jaxRsRespHeaders, SortedMetadata<MediaType> accMediaTypes) throws ImplementationException {
        Object repr;
        Class entityClass;
        Type genericReturnType;
        if (entity instanceof Representation) {
            Representation repr2 = (Representation)entity;
            repr2.setCharacterSet(Util.getSupportedCharSet(repr2.getCharacterSet()));
            if (jaxRsResponseMediaType != null) {
                repr2.setMediaType(Converter.getMediaTypeWithoutParams(jaxRsResponseMediaType));
            }
            return repr2;
        }
        Annotation[] methodAnnotations = resourceMethod != null ? resourceMethod.getAnnotations() : EMPTY_ANNOTATION_ARRAY;
        if (entity instanceof GenericEntity) {
            GenericEntity genericEntity = (GenericEntity)entity;
            genericReturnType = genericEntity.getType();
            entityClass = genericEntity.getRawType();
            entity = genericEntity.getEntity();
        } else {
            entityClass = entity != null ? entity.getClass() : null;
            genericReturnType = resourceMethod != null ? resourceMethod.getGenericReturnType() : null;
            if (genericReturnType instanceof Class && ((Class)genericReturnType).isAssignableFrom(javax.ws.rs.core.Response.class)) {
                genericReturnType = entityClass;
            }
        }
        WrappedRequestForHttpHeaders httpResponseHeaders = new WrappedRequestForHttpHeaders(this.tlContext.get().getResponse(), jaxRsRespHeaders);
        if (entity != null) {
            MediaType respMediaType = this.determineMediaType(jaxRsResponseMediaType, resourceMethod, entityClass, genericReturnType);
            MessageBodyWriterSubSet mbws = this.providers.writerSubSet(entityClass, genericReturnType);
            if (mbws.isEmpty()) {
                throw this.excHandler.noMessageBodyWriter(entityClass, genericReturnType, methodAnnotations, null, null);
            }
            MessageBodyWriter mbw = mbws.getBestWriter(respMediaType, methodAnnotations, accMediaTypes);
            if (mbw == null) {
                throw this.excHandler.noMessageBodyWriter(entityClass, genericReturnType, methodAnnotations, respMediaType, accMediaTypes);
            }
            repr = new JaxRsOutputRepresentation<Object>(entity, genericReturnType, respMediaType, methodAnnotations, mbw, httpResponseHeaders);
        } else {
            repr = new EmptyRepresentation();
            repr.setMediaType(this.determineMediaType(jaxRsResponseMediaType, resourceMethod, entityClass, genericReturnType));
        }
        repr.setCharacterSet(Util.getSupportedCharSet(httpResponseHeaders));
        return repr;
    }

    private ResourceObject createSubResource(ResourceObject o, SubResourceLocator subResourceLocator, CallContext callContext) throws WebApplicationException, RequestHandledException {
        try {
            o = subResourceLocator.createSubResource(o, this.resourceClasses, this.getLogger());
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw this.excHandler.runtimeExecption(e, subResourceLocator, callContext, "Could not create new instance of resource class");
        }
        catch (MissingAnnotationException e) {
            throw this.excHandler.missingAnnotation(e, callContext, "Could not create new instance of resource class");
        }
        catch (InstantiateException e) {
            throw this.excHandler.instantiateExecption(e, callContext, "Could not create new instance of resource class");
        }
        catch (InvocationTargetException e) {
            throw this.handleInvocationTargetExc(e);
        }
        catch (ConvertRepresentationException e) {
            throw this.excHandler.convertRepresentationExc(e);
        }
        return o;
    }

    private MediaType determineMediaType(MediaType jaxRsResponseMediaType, ResourceMethod resourceMethod, Class<?> entityClass, Type genericReturnType) throws WebApplicationException {
        if (jaxRsResponseMediaType != null) {
            return jaxRsResponseMediaType;
        }
        if (resourceMethod == null) {
            return MediaType.TEXT_PLAIN;
        }
        CallContext callContext = this.tlContext.get();
        Collection<MediaType> p = resourceMethod.getProducedMimes();
        if (p.isEmpty()) {
            p = this.providers.writerSubSet(entityClass, genericReturnType).getAllProducibleMediaTypes();
        }
        if (p.isEmpty()) {
            return MediaType.ALL;
        }
        p = Util.sortByConcreteness(p);
        SortedMetadata<MediaType> a = callContext.getAccMediaTypes();
        if (a.isEmpty()) {
            a = SortedMetadata.getMediaTypeAll();
        }
        ArrayList<MediaType> m = new ArrayList<MediaType>();
        for (MediaType a1 : a) {
            for (MediaType p1 : p) {
                if (!a1.equals((Object)p1)) continue;
                m.add(a1);
            }
        }
        for (MediaType a1 : a) {
            for (MediaType p1 : p) {
                if (!a1.includes((Metadata)p1)) continue;
                m.add(MediaType.getMostSpecific((MediaType[])new MediaType[]{a1, p1}));
            }
        }
        for (MediaType a1 : a) {
            for (MediaType p1 : p) {
                if (!a1.isCompatible((Metadata)p1)) continue;
                m.add(MediaType.getMostSpecific((MediaType[])new MediaType[]{a1, p1}));
            }
        }
        if (m.isEmpty()) {
            this.excHandler.notAcceptableWhileDetermineMediaType();
        }
        for (MediaType mediaType : m) {
            if (!mediaType.isConcrete()) continue;
            return mediaType;
        }
        if (m.contains(MediaType.ALL) || m.contains(MediaType.APPLICATION_ALL)) {
            return MediaType.APPLICATION_OCTET_STREAM;
        }
        throw this.excHandler.notAcceptableWhileDetermineMediaType();
    }

    public Restlet getNoResMethodHandler() {
        return this.excHandler.getNoResMethodHandler();
    }

    public Restlet getNoResourceClHandler() {
        return this.excHandler.getNoResourceClHandler();
    }

    public Restlet getNoRootResClHandler() {
        return this.excHandler.getNoRootResClHandler();
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public Set<Class<?>> getRootResourceClasses() {
        HashSet rrcs = new HashSet();
        for (RootResourceClass rootResourceClass : this.resourceClasses.roots()) {
            rrcs.add(rootResourceClass.getJaxRsClass());
        }
        return Collections.unmodifiableSet(rrcs);
    }

    public Collection<String> getRootUris() {
        ArrayList<String> uris = new ArrayList<String>();
        for (RootResourceClass rrc : this.resourceClasses.roots()) {
            uris.add(rrc.getPathRegExp().getPathTemplateEnc());
        }
        return Collections.unmodifiableCollection(uris);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Request request, Response response) {
        super.handle(request, response);
        ResourceObject resourceObject = null;
        Reference baseRef = request.getResourceRef().getBaseRef();
        request.setRootRef(new Reference(baseRef.toString()));
        try {
            CallContext callContext = new CallContext(request, response);
            this.tlContext.set(callContext);
            try {
                ResObjAndMeth resObjAndMeth = this.requestMatching();
                callContext.setReadOnly();
                ResourceMethod resourceMethod = resObjAndMeth.resourceMethod;
                resourceObject = resObjAndMeth.resourceObject;
                Object result = this.invokeMethod(resourceMethod, resourceObject);
                this.handleResult(result, resourceMethod);
            }
            catch (WebApplicationException e) {
                this.jaxRsRespToRestletResp(this.providers.convert(e), null);
                Representation entity = request.getEntity();
                if (entity != null) {
                    entity.release();
                }
                return;
            }
        }
        catch (RequestHandledException e) {
        }
        finally {
            Representation entity = request.getEntity();
            if (entity != null) {
                entity.release();
            }
        }
    }

    private RequestHandledException handleInvocationTargetExc(InvocationTargetException ite) throws RequestHandledException {
        Throwable cause = ite.getCause();
        if (cause instanceof ResourceException) {
            Status status = ((ResourceException)cause).getStatus();
            Response restletResponse = this.tlContext.get().getResponse();
            restletResponse.setStatus(status);
        } else {
            javax.ws.rs.core.Response jaxRsResp = this.providers.convert(cause);
            this.jaxRsRespToRestletResp(jaxRsResp, null);
        }
        throw new RequestHandledException();
    }

    private void handleResult(Object result, ResourceMethod resourceMethod) {
        Response restletResponse = this.tlContext.get().getResponse();
        if (result instanceof javax.ws.rs.core.Response) {
            this.jaxRsRespToRestletResp((javax.ws.rs.core.Response)result, resourceMethod);
        } else if (result instanceof Response.ResponseBuilder) {
            String warning = "the method " + resourceMethod + " returnef a ResponseBuilder. You should " + "call responseBuilder.build() in the resource method";
            this.getLogger().warning(warning);
            this.jaxRsRespToRestletResp(((Response.ResponseBuilder)result).build(), resourceMethod);
        } else {
            if (result == null) {
                restletResponse.setStatus(Status.SUCCESS_NO_CONTENT);
            } else {
                restletResponse.setStatus(Status.SUCCESS_OK);
            }
            SortedMetadata<MediaType> accMediaTypes = this.tlContext.get().getAccMediaTypes();
            restletResponse.setEntity(this.convertToRepresentation(result, resourceMethod, null, null, accMediaTypes));
        }
    }

    private ResObjAndMeth identifyMethod(ResObjAndRemPath resObjAndRemPath, MediaType givenMediaType) throws RequestHandledException {
        CallContext callContext = this.tlContext.get();
        Method httpMethod = callContext.getRequest().getMethod();
        ResourceObject resObj = resObjAndRemPath.resourceObject;
        RemainingPath u = resObjAndRemPath.u;
        ResourceClass resourceClass = resObj.getResourceClass();
        Collection<ResourceMethod> resourceMethods = resourceClass.getMethodsForPath(u);
        if (resourceMethods.isEmpty()) {
            this.excHandler.resourceMethodNotFound();
        }
        boolean alsoGet = httpMethod.equals((Object)Method.HEAD);
        AlgorithmUtil.removeNotSupportedHttpMethod(resourceMethods, httpMethod, alsoGet);
        if (resourceMethods.isEmpty()) {
            Set<Method> allowedMethods = resourceClass.getAllowedMethods(u);
            if (httpMethod.equals((Object)Method.OPTIONS)) {
                callContext.getResponse().getAllowedMethods().addAll(allowedMethods);
                throw new RequestHandledException();
            }
            this.excHandler.methodNotAllowed(allowedMethods);
        }
        if (givenMediaType != null) {
            Collection<ResourceMethod> supporting = resourceMethods;
            resourceMethods = new ArrayList<ResourceMethod>();
            for (ResourceMethod resourceMethod : supporting) {
                if (!resourceMethod.isGivenMediaTypeSupported(givenMediaType)) continue;
                resourceMethods.add(resourceMethod);
            }
            if (resourceMethods.isEmpty()) {
                this.excHandler.unsupportedMediaType(supporting);
            }
        }
        SortedMetadata<MediaType> accMediaTypes = callContext.getAccMediaTypes();
        Collection<ResourceMethod> supporting = resourceMethods;
        resourceMethods = new ArrayList<ResourceMethod>();
        for (ResourceMethod resourceMethod : supporting) {
            if (!resourceMethod.isAcceptedMediaTypeSupported(accMediaTypes)) continue;
            resourceMethods.add(resourceMethod);
        }
        if (resourceMethods.isEmpty()) {
            this.excHandler.noResourceMethodForAccMediaTypes(supporting);
        }
        ResourceMethod bestResourceMethod = AlgorithmUtil.getBestMethod(resourceMethods, givenMediaType, accMediaTypes, httpMethod);
        MatchingResult mr = bestResourceMethod.getPathRegExp().match(u);
        AlgorithmUtil.addPathVarsToMap(mr, callContext);
        String matchedUriPart = mr.getMatched();
        if (matchedUriPart.length() > 0) {
            Object jaxRsResObj = resObj.getJaxRsResourceObject();
            callContext.addForMatched(jaxRsResObj, matchedUriPart);
        }
        return new ResObjAndMeth(resObj, bestResourceMethod);
    }

    private RroRemPathAndMatchedPath identifyRootResource(RemainingPath u) throws WebApplicationException, RequestHandledException {
        ArrayList<RootResourceClass> eAndCs = new ArrayList<RootResourceClass>();
        for (RootResourceClass rootResourceClass : this.resourceClasses.roots()) {
            PathRegExp rrcPathRegExp = rootResourceClass.getPathRegExp();
            MatchingResult matchingResult = rrcPathRegExp.match(u);
            if (matchingResult == null) continue;
            if (matchingResult.getFinalCapturingGroup().isEmptyOrSlash()) {
                eAndCs.add(rootResourceClass);
                continue;
            }
            if (!rootResourceClass.hasSubResourceMethodsOrLocators()) continue;
            eAndCs.add(rootResourceClass);
        }
        if (eAndCs.isEmpty()) {
            this.excHandler.rootResourceNotFound();
        }
        RootResourceClass tClass = (RootResourceClass)AlgorithmUtil.getFirstByNoOfLiteralCharsNoOfCapturingGroups(eAndCs);
        PathRegExp rMatch = tClass.getPathRegExp();
        MatchingResult matchResult = rMatch.match(u);
        u = matchResult.getFinalCapturingGroup();
        AlgorithmUtil.addPathVarsToMap(matchResult, this.tlContext.get());
        ResourceObject o = this.instantiateRrc(tClass);
        return new RroRemPathAndMatchedPath(o, u, matchResult.getMatched());
    }

    private ResourceObject instantiateRrc(RootResourceClass rrc) throws WebApplicationException, RequestHandledException {
        ResourceObject o;
        try {
            o = rrc.getInstance(this.objectFactory);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw this.excHandler.runtimeExecption(e, null, this.tlContext.get(), "Could not create new instance of root resource class");
        }
        catch (InstantiateException e) {
            throw this.excHandler.instantiateExecption(e, this.tlContext.get(), "Could not create new instance of root resource class");
        }
        catch (InvocationTargetException e) {
            throw this.handleInvocationTargetExc(e);
        }
        return o;
    }

    private Object invokeMethod(ResourceMethod resourceMethod, ResourceObject resourceObject) throws WebApplicationException, RequestHandledException {
        Object result;
        try {
            result = resourceMethod.invoke(resourceObject);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (InvocationTargetException ite) {
            throw this.handleInvocationTargetExc(ite);
        }
        catch (RuntimeException e) {
            throw this.excHandler.runtimeExecption(e, resourceMethod, this.tlContext.get(), "Can not invoke the resource method");
        }
        catch (MethodInvokeException e) {
            throw this.excHandler.methodInvokeException(e, this.tlContext.get(), "Can not invoke the resource method");
        }
        catch (ConvertRepresentationException e) {
            throw this.excHandler.convertRepresentationExc(e);
        }
        return result;
    }

    private void jaxRsRespToRestletResp(javax.ws.rs.core.Response jaxRsResponse, ResourceMethod resourceMethod) {
        Response restletResponse = this.tlContext.get().getResponse();
        restletResponse.setStatus(Status.valueOf((int)jaxRsResponse.getStatus()));
        MultivaluedMap httpHeaders = jaxRsResponse.getMetadata();
        MediaType respMediaType = Util.getMediaType((MultivaluedMap<String, Object>)httpHeaders);
        Object jaxRsEntity = jaxRsResponse.getEntity();
        SortedMetadata<MediaType> accMediaType = respMediaType != null ? SortedMetadata.get(respMediaType) : this.tlContext.get().getAccMediaTypes();
        restletResponse.setEntity(this.convertToRepresentation(jaxRsEntity, resourceMethod, respMediaType, (MultivaluedMap<String, Object>)httpHeaders, accMediaType));
        Util.copyResponseHeaders((MultivaluedMap<String, Object>)httpHeaders, restletResponse);
    }

    private void loadDefaultProviders() {
        this.addDefaultProvider(new BufferedReaderProvider());
        this.addDefaultProvider(new ByteArrayProvider());
        this.addDefaultProvider("org.restlet.ext.jaxrs.internal.provider.DataSourceProvider");
        this.addDefaultProvider("org.restlet.ext.jaxrs.internal.provider.FileUploadProvider");
        this.addDefaultProvider(new ConverterProvider());
        this.addDefaultProvider(new FileProvider());
        this.addDefaultProvider(new InputStreamProvider());
        this.addDefaultProvider("org.restlet.ext.jaxrs.internal.provider.JaxbElementProvider");
        this.addDefaultProvider("org.restlet.ext.jaxrs.internal.provider.JaxbProvider");
        this.addDefaultProvider("org.restlet.ext.jaxrs.internal.provider.MultipartProvider");
        this.addDefaultProvider(new SimpleXmlProvider());
        this.addDefaultProvider(new ReaderProvider());
        this.addDefaultProvider(new StreamingOutputProvider());
        this.addDefaultProvider(new StringProvider());
        this.addDefaultProvider(new WwwFormFormProvider());
        this.addDefaultProvider(new WwwFormMmapProvider());
        this.addDefaultProvider(new SourceProvider());
        this.addDefaultProvider(new WebAppExcMapper());
        this.addDefaultProvider("org.restlet.ext.jaxrs.internal.provider.JsonProvider");
    }

    private ResObjAndRemPath obtainObject(RroRemPathAndMatchedPath rroRemPathAndMatchedPath) throws WebApplicationException, RequestHandledException {
        ResourceObject o = rroRemPathAndMatchedPath.rootResObj;
        RemainingPath u = rroRemPathAndMatchedPath.u;
        ResourceClass resClass = o.getResourceClass();
        CallContext callContext = this.tlContext.get();
        callContext.addForMatched(o.getJaxRsResourceObject(), rroRemPathAndMatchedPath.matchedUriPath);
        while (!u.isEmptyOrSlash()) {
            ArrayList<ResourceMethodOrLocator> eWithMethod = new ArrayList<ResourceMethodOrLocator>();
            for (ResourceMethodOrLocator methodOrLocator : resClass.getResourceMethodsAndLocators()) {
                PathRegExp pathRegExp = methodOrLocator.getPathRegExp();
                MatchingResult matchingResult = pathRegExp.match(u);
                if (matchingResult == null) continue;
                if (matchingResult.getFinalCapturingGroup().isEmptyOrSlash()) {
                    eWithMethod.add(methodOrLocator);
                    continue;
                }
                if (!(methodOrLocator instanceof SubResourceLocator)) continue;
                eWithMethod.add(methodOrLocator);
            }
            if (eWithMethod.isEmpty()) {
                this.excHandler.resourceNotFound();
            }
            ResourceMethodOrLocator firstMeth = (ResourceMethodOrLocator)AlgorithmUtil.getFirstByNoOfLiteralCharsNoOfCapturingGroups(eWithMethod);
            PathRegExp rMatch = firstMeth.getPathRegExp();
            MatchingResult matchingResult = rMatch.match(u);
            AlgorithmUtil.addPathVarsToMap(matchingResult, callContext);
            if (firstMeth instanceof ResourceMethod) {
                return new ResObjAndRemPath(o, u);
            }
            String matchedUriPart = matchingResult.getMatched();
            Object jaxRsResObj = o.getJaxRsResourceObject();
            callContext.addForMatched(jaxRsResObj, matchedUriPart);
            u = matchingResult.getFinalCapturingGroup();
            SubResourceLocator subResourceLocator = (SubResourceLocator)firstMeth;
            o = this.createSubResource(o, subResourceLocator, callContext);
            resClass = o.getResourceClass();
        }
        return new ResObjAndRemPath(o, u);
    }

    private ResObjAndMeth requestMatching() throws RequestHandledException, WebApplicationException {
        Request restletRequest = this.tlContext.get().getRequest();
        RemainingPath u = new RemainingPath(restletRequest.getResourceRef().getRemainingPart());
        RroRemPathAndMatchedPath rrm = this.identifyRootResource(u);
        ResObjAndRemPath resourceObjectAndPath = this.obtainObject(rrm);
        Representation entity = restletRequest.getEntity();
        MediaType givenMediaType = entity != null ? entity.getMediaType() : null;
        ResObjAndMeth method = this.identifyMethod(resourceObjectAndPath, givenMediaType);
        return method;
    }

    public void setNoResMethodHandler(Restlet noResMethodHandler) {
        this.excHandler.setNoResMethodHandler(noResMethodHandler);
    }

    public void setNoResourceClHandler(Restlet noResourceClHandler) {
        this.excHandler.setNoResourceClHandler(noResourceClHandler);
    }

    public void setNoRootResClHandler(Restlet noRootResClHandler) {
        this.excHandler.setNoRootResClHandler(noRootResClHandler);
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
        this.providers.setObjectFactory(objectFactory);
    }

    public void start() throws Exception {
        this.providers.initAll();
        super.start();
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
    }

    class RroRemPathAndMatchedPath {
        private String matchedUriPath;
        private ResourceObject rootResObj;
        private RemainingPath u;

        RroRemPathAndMatchedPath(ResourceObject rootResObj, RemainingPath u, String matchedUriPath) {
            this.rootResObj = rootResObj;
            this.u = u;
            this.matchedUriPath = matchedUriPath;
        }
    }

    class ResObjAndRemPath {
        private ResourceObject resourceObject;
        private RemainingPath u;

        ResObjAndRemPath(ResourceObject resourceObject, RemainingPath u) {
            this.resourceObject = resourceObject;
            this.u = u;
        }
    }

    class ResObjAndMeth {
        private ResourceMethod resourceMethod;
        private ResourceObject resourceObject;

        ResObjAndMeth(ResourceObject resourceObject, ResourceMethod resourceMethod) {
            this.resourceObject = resourceObject;
            this.resourceMethod = resourceMethod;
        }
    }
}

