/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.smpp.parameter;

import com.cloudhopper.smpp.tlv.Tlv;
import com.cloudhopper.smpp.tlv.TlvConvertException;
import java.util.Collection;
import javolution.util.FastList;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.restcomm.smpp.parameter.TlvProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TlvSet {
    private static final String TLV = "tlv";
    private FastList<Tlv> optionalParameters = new FastList();
    protected static final XMLFormat<TlvSet> TLV_SET_XML = new XMLFormat<TlvSet>(TlvSet.class){

        public void read(XMLFormat.InputElement xml, TlvSet tlvSet) throws XMLStreamException {
            tlvSet.optionalParameters.clear();
            while (xml.hasNext()) {
                TlvProxy tlvProxy = (TlvProxy)xml.get(TlvSet.TLV, TlvProxy.class);
                if (tlvProxy == null || tlvProxy.tag < 0 || tlvProxy.value == null) continue;
                Tlv tlv = new Tlv(tlvProxy.tag, tlvProxy.value);
                tlvSet.optionalParameters.add((Object)tlv);
            }
        }

        public void write(TlvSet tlvSet, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (tlvSet.optionalParameters != null && tlvSet.optionalParameters.size() > 0) {
                for (int i1 = 0; i1 < tlvSet.optionalParameters.size(); ++i1) {
                    Tlv tlv = (Tlv)tlvSet.optionalParameters.get(i1);
                    TlvProxy tlvProxy = new TlvProxy();
                    tlvProxy.tag = tlv.getTag();
                    tlvProxy.value = tlv.getValue();
                    xml.add((Object)tlvProxy, TlvSet.TLV, TlvProxy.class);
                }
            }
        }
    };

    public int getOptionalParameterCount() {
        if (this.optionalParameters == null) {
            return 0;
        }
        return this.optionalParameters.size();
    }

    public FastList<Tlv> getOptionalParameters() {
        return this.optionalParameters;
    }

    public void addOptionalParameter(Tlv tlv) {
        if (this.optionalParameters == null) {
            this.optionalParameters = new FastList();
        }
        this.optionalParameters.add((Object)tlv);
    }

    public Tlv removeOptionalParameter(short tag) {
        int i = this.findOptionalParameter(tag);
        if (i < 0) {
            return null;
        }
        return (Tlv)this.optionalParameters.remove(i);
    }

    public Tlv setOptionalParameter(Tlv tlv) {
        int i = this.findOptionalParameter(tlv.getTag());
        if (i < 0) {
            this.addOptionalParameter(tlv);
            return null;
        }
        return (Tlv)this.optionalParameters.set(i, (Object)tlv);
    }

    public boolean hasOptionalParameter(short tag) {
        return this.findOptionalParameter(tag) >= 0;
    }

    protected int findOptionalParameter(short tag) {
        if (this.optionalParameters == null) {
            return -1;
        }
        int i = 0;
        FastList.Node node = this.optionalParameters.head();
        FastList.Node end = this.optionalParameters.tail();
        while ((node = node.getNext()) != end) {
            Tlv tlv = (Tlv)node.getValue();
            if (tlv.getTag() == tag) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Tlv getOptionalParameter(short tag) {
        if (this.optionalParameters == null) {
            return null;
        }
        int i = this.findOptionalParameter(tag);
        if (i < 0) {
            return null;
        }
        return (Tlv)this.optionalParameters.get(i);
    }

    public void addAllOptionalParameter(Collection<Tlv> tlvs) {
        if (this.optionalParameters == null) {
            this.optionalParameters = new FastList();
        }
        this.optionalParameters.addAll(tlvs);
    }

    public void clearAllOptionalParameter() {
        if (this.optionalParameters == null) {
            this.optionalParameters = new FastList();
        }
        this.optionalParameters.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TlvSet [");
        if (this.optionalParameters != null) {
            boolean isFirst = true;
            for (Tlv tlv : this.optionalParameters) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(", ");
                }
                sb.append(tlv.getTagName());
                sb.append("=");
                try {
                    sb.append(tlv.getValueAsString());
                }
                catch (TlvConvertException e) {}
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

