/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.smpp.oam;

import com.cloudhopper.smpp.SmppBindType;
import java.util.Arrays;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.mobicents.ss7.management.console.ShellExecutor;
import org.restcomm.smpp.Esme;
import org.restcomm.smpp.SmppInterfaceVersionType;
import org.restcomm.smpp.SmppManagement;
import org.restcomm.smpp.SmppServerManagement;

public class SmppShellExecutor
implements ShellExecutor {
    private static final Logger logger = Logger.getLogger(SmppShellExecutor.class);
    private SmppManagement smppManagement;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String MAP_CACHE_KEY_VALUE_SEPARATOR = " : ";

    public void start() throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Started SmppShellExecutor " + this.getSmppManagement().getName()));
        }
    }

    public SmppManagement getSmppManagement() {
        return this.smppManagement;
    }

    public void setSmppManagement(SmppManagement smppManagement) {
        this.smppManagement = smppManagement;
    }

    private String modifyEsme(String[] args) throws Exception {
        if (args.length < 6 || args.length > 58) {
            return "Invalid Command";
        }
        String name = args[3];
        if (name == null) {
            return "Invalid Command";
        }
        Esme esme = this.smppManagement.getEsmeManagement().getEsmeByName(name);
        if (esme == null) {
            throw new Exception(String.format("No Esme found with given name %s", name));
        }
        int count = 4;
        while (count < args.length) {
            String key;
            if ((key = args[count++]) == null) {
                return "Invalid Command";
            }
            if (key.equals("password")) {
                esme.setPassword(args[count++]);
                continue;
            }
            if (key.equals("networkid")) {
                esme.setNetworkId(Integer.parseInt(args[count++]));
                continue;
            }
            if (key.equals("split-long-messages")) {
                esme.setSplitLongMessages(Boolean.parseBoolean(args[count++]));
                continue;
            }
            if (key.equals("esme-ton")) {
                byte esmeTonType = Byte.parseByte(args[count++]);
                esme.setEsmeTon(esmeTonType);
                continue;
            }
            if (key.equals("esme-npi")) {
                byte esmeNpiType = Byte.parseByte(args[count++]);
                esme.setEsmeNpi(esmeNpiType);
                continue;
            }
            if (key.equals("esme-range")) {
                String esmeAddrRange = args[count++];
                esme.setEsmeAddressRange(esmeAddrRange);
                continue;
            }
            if (key.equals("window-size")) {
                int windowSize = Integer.parseInt(args[count++]);
                esme.setWindowSize(windowSize);
                continue;
            }
            if (key.equals("connect-timeout")) {
                long connectTimeout = Long.parseLong(args[count++]);
                esme.setConnectTimeout(connectTimeout);
                continue;
            }
            if (key.equals("request-expiry-timeout")) {
                long requestExpiryTimeout = Long.parseLong(args[count++]);
                esme.setRequestExpiryTimeout(requestExpiryTimeout);
                continue;
            }
            if (key.equals("client-bind-timeout")) {
                long clientBindTimeout = Long.parseLong(args[count++]);
                esme.setClientBindTimeout(clientBindTimeout);
                continue;
            }
            if (key.equals("window-monitor-interval")) {
                long windowMonitorInterval = Long.parseLong(args[count++]);
                esme.setWindowMonitorInterval(windowMonitorInterval);
                continue;
            }
            if (key.equals("window-wait-timeout")) {
                long windowWaitTimeout = Long.parseLong(args[count++]);
                esme.setWindowWaitTimeout(windowWaitTimeout);
                continue;
            }
            if (key.equals("counters-enabled")) {
                boolean countersEnabled = Boolean.parseBoolean(args[count++]);
                esme.setCountersEnabled(countersEnabled);
                continue;
            }
            if (key.equals("enquire-link-delay")) {
                int enquireLinkDelay = Integer.parseInt(args[count++]);
                esme.setEnquireLinkDelay(enquireLinkDelay);
                continue;
            }
            if (key.equals("enquire-link-delay-server")) {
                int enquireLinkDelayServer = Integer.parseInt(args[count++]);
                esme.setEnquireLinkDelayServer(enquireLinkDelayServer);
                continue;
            }
            if (key.equals("link-drop-server")) {
                long linkDropServer = Long.parseLong(args[count++]);
                esme.setLinkStartFirstTime(true);
                esme.setLinkDropServer(linkDropServer);
                continue;
            }
            if (key.equals("charging-enabled")) {
                boolean chargingEnabled = Boolean.parseBoolean(args[count++]);
                esme.setChargingEnabled(chargingEnabled);
                continue;
            }
            if (key.equals("source-ton")) {
                int sourceTon = Integer.parseInt(args[count++]);
                esme.setSourceTon(sourceTon);
                continue;
            }
            if (key.equals("source-npi")) {
                int sourceNpi = Integer.parseInt(args[count++]);
                esme.setSourceNpi(sourceNpi);
                continue;
            }
            if (key.equals("source-range")) {
                String sourceAddressRange = args[count++];
                esme.setSourceAddressRange(sourceAddressRange);
                continue;
            }
            if (key.equals("routing-ton")) {
                int routingTon = Integer.parseInt(args[count++]);
                esme.setRoutingTon(routingTon);
                continue;
            }
            if (key.equals("routing-npi")) {
                int routingNpi = Integer.parseInt(args[count++]);
                esme.setRoutingNpi(routingNpi);
                continue;
            }
            if (key.equals("routing-range")) {
                String routingAddressRange = args[count++];
                esme.setRoutingAddressRange(routingAddressRange);
                continue;
            }
            if (key.equals("ratelimit-second")) {
                long val = Long.parseLong(args[count++]);
                esme.setRateLimitPerSecond(val);
                continue;
            }
            if (key.equals("ratelimit-minute")) {
                long val = Long.parseLong(args[count++]);
                esme.setRateLimitPerMinute(val);
                continue;
            }
            if (key.equals("ratelimit-hour")) {
                long val = Long.parseLong(args[count++]);
                esme.setRateLimitPerHour(val);
                continue;
            }
            if (key.equals("ratelimit-day")) {
                long val = Long.parseLong(args[count++]);
                esme.setRateLimitPerDay(val);
                continue;
            }
            if (key.equals("national-language-locking-shift")) {
                int val = Integer.parseInt(args[count++]);
                esme.setNationalLanguageLockingShift(val);
                continue;
            }
            if (key.equals("national-language-single-shift")) {
                int val = Integer.parseInt(args[count++]);
                esme.setNationalLanguageSingleShift(val);
                continue;
            }
            if (key.equals("dest-addr-send-limit")) {
                int val = Integer.parseInt(args[count++]);
                esme.setDestAddrSendLimit(val);
                continue;
            }
            if (key.equals("min-message-length")) {
                int val = Integer.parseInt(args[count++]);
                esme.setMinMessageLength(val);
                continue;
            }
            if (key.equals("max-message-length")) {
                int val = Integer.parseInt(args[count++]);
                esme.setMaxMessageLength(val);
                continue;
            }
            return "Invalid Command";
        }
        return String.format("Successfully modified ESME name=%s", esme.getName());
    }

    private String createEsme(String[] args) throws Exception {
        if (args.length < 9 || args.length > 69) {
            return "Invalid Command";
        }
        String name = args[3];
        if (name == null) {
            return "Invalid Command";
        }
        String systemId = args[4];
        if (systemId == null) {
            return "Invalid Command";
        }
        String host = args[5];
        if (host == null) {
            return "Invalid Command";
        }
        String strPort = args[6];
        int intPort = -1;
        if (strPort == null) {
            return "Invalid Command";
        }
        try {
            intPort = Integer.parseInt(strPort);
        }
        catch (Exception e) {
            return "Invalid Command";
        }
        String smppBindTypeStr = args[7];
        if (smppBindTypeStr == null) {
            return "Invalid Command";
        }
        String smppSessionTypeStr = args[8];
        if (smppSessionTypeStr == null) {
            return "Invalid Command";
        }
        String systemType = null;
        String smppVersionType = SmppInterfaceVersionType.SMPP34.getType();
        byte esmeTonType = -1;
        byte esmeNpiType = -1;
        String esmeAddrRange = null;
        String clusterName = name;
        String password = null;
        int networkId = 0;
        boolean splitLongMessages = false;
        long rateLimitPerSecond = 0L;
        long rateLimitPerMinute = 0L;
        long rateLimitPerHour = 0L;
        long rateLimitPerDay = 0L;
        int count = 9;
        int windowSize = 1;
        long connectTimeout = 10000L;
        long requestExpiryTimeout = -1L;
        long clientBindTimeout = 5000L;
        long windowMonitorInterval = -1L;
        long windowWaitTimeout = 60000L;
        boolean countersEnabled = true;
        int enquireLinkDelay = 30000;
        int enquireLinkDelayServer = 0;
        long linkDropServer = 0L;
        boolean chargingEnabled = false;
        int sourceTon = -1;
        int sourceNpi = -1;
        String sourceAddressRange = "^[0-9a-zA-Z]*";
        int routinigTon = -1;
        int routingNpi = -1;
        String routingAddressRange = "^[0-9a-zA-Z]*";
        int nationalLanguageSingleShift = -1;
        int nationalLanguageLockingShift = -1;
        int destAddrSendLimit = 0;
        int minMessageLength = -1;
        int maxMessageLength = -1;
        while (count < args.length) {
            String key;
            if ((key = args[count++]) == null) {
                return "Invalid Command";
            }
            if (key.equals("password")) {
                password = args[count++];
                continue;
            }
            if (key.equals("networkid")) {
                networkId = Integer.parseInt(args[count++]);
                continue;
            }
            if (key.equals("split-long-messages")) {
                splitLongMessages = Boolean.parseBoolean(args[count++]);
                continue;
            }
            if (key.equals("system-type")) {
                systemType = args[count++];
                continue;
            }
            if (key.equals("interface-version")) {
                smppVersionType = args[count++];
                continue;
            }
            if (key.equals("esme-ton")) {
                esmeTonType = Byte.parseByte(args[count++]);
                continue;
            }
            if (key.equals("esme-npi")) {
                esmeNpiType = Byte.parseByte(args[count++]);
                continue;
            }
            if (key.equals("esme-range")) {
                esmeAddrRange = args[count++];
                continue;
            }
            if (key.equals("window-size")) {
                windowSize = Integer.parseInt(args[count++]);
                continue;
            }
            if (key.equals("connect-timeout")) {
                connectTimeout = Long.parseLong(args[count++]);
                continue;
            }
            if (key.equals("request-expiry-timeout")) {
                requestExpiryTimeout = Long.parseLong(args[count++]);
                continue;
            }
            if (key.equals("client-bind-timeout")) {
                clientBindTimeout = Long.parseLong(args[count++]);
                continue;
            }
            if (key.equals("window-monitor-interval")) {
                windowMonitorInterval = Long.parseLong(args[count++]);
                continue;
            }
            if (key.equals("window-wait-timeout")) {
                windowWaitTimeout = Long.parseLong(args[count++]);
                continue;
            }
            if (key.equals("cluster-name")) {
                clusterName = args[count++];
                continue;
            }
            if (key.equals("counters-enabled")) {
                countersEnabled = Boolean.parseBoolean(args[count++]);
                continue;
            }
            if (key.equals("enquire-link-delay")) {
                enquireLinkDelay = Integer.parseInt(args[count++]);
                continue;
            }
            if (key.equals("enquire-link-delay-server")) {
                enquireLinkDelayServer = Integer.parseInt(args[count++]);
                continue;
            }
            if (key.equals("link-drop-server")) {
                linkDropServer = Long.parseLong(args[count++]);
                continue;
            }
            if (key.equals("charging-enabled")) {
                chargingEnabled = Boolean.parseBoolean(args[count++]);
                continue;
            }
            if (key.equals("source-ton")) {
                sourceTon = Integer.parseInt(args[count++]);
                continue;
            }
            if (key.equals("source-npi")) {
                sourceNpi = Integer.parseInt(args[count++]);
                continue;
            }
            if (key.equals("source-range")) {
                sourceAddressRange = args[count++];
                continue;
            }
            if (key.equals("routing-ton")) {
                routinigTon = Integer.parseInt(args[count++]);
                continue;
            }
            if (key.equals("routing-npi")) {
                routingNpi = Integer.parseInt(args[count++]);
                continue;
            }
            if (key.equals("routing-range")) {
                routingAddressRange = args[count++];
                continue;
            }
            if (key.equals("ratelimit-second")) {
                rateLimitPerSecond = Long.parseLong(args[count++]);
                continue;
            }
            if (key.equals("ratelimit-minute")) {
                rateLimitPerMinute = Long.parseLong(args[count++]);
                continue;
            }
            if (key.equals("ratelimit-hour")) {
                rateLimitPerHour = Long.parseLong(args[count++]);
                continue;
            }
            if (key.equals("ratelimit-day")) {
                rateLimitPerDay = Long.parseLong(args[count++]);
                continue;
            }
            if (key.equals("national-language-single-shift")) {
                nationalLanguageSingleShift = Integer.parseInt(args[count++]);
                continue;
            }
            if (key.equals("national-language-locking-shift")) {
                nationalLanguageLockingShift = Integer.parseInt(args[count++]);
                continue;
            }
            if (key.equals("dest-addr-send-limit")) {
                destAddrSendLimit = Integer.parseInt(args[count++]);
                continue;
            }
            if (key.equals("min-message-length")) {
                minMessageLength = Integer.parseInt(args[count++]);
                continue;
            }
            if (key.equals("max-message-length")) {
                maxMessageLength = Integer.parseInt(args[count++]);
                continue;
            }
            return "Invalid Command";
        }
        Esme esme = this.smppManagement.getEsmeManagement().createEsme(name, systemId, password, host, intPort, chargingEnabled, smppBindTypeStr, systemType, smppVersionType, esmeTonType, esmeNpiType, esmeAddrRange, smppSessionTypeStr, windowSize, connectTimeout, requestExpiryTimeout, clientBindTimeout, windowMonitorInterval, windowWaitTimeout, clusterName, countersEnabled, enquireLinkDelay, enquireLinkDelayServer, linkDropServer, sourceTon, sourceNpi, sourceAddressRange, routinigTon, routingNpi, routingAddressRange, networkId, splitLongMessages, rateLimitPerSecond, rateLimitPerMinute, rateLimitPerHour, rateLimitPerDay, nationalLanguageSingleShift, nationalLanguageLockingShift, destAddrSendLimit, minMessageLength, maxMessageLength);
        return String.format("Successfully created ESME name=%s", esme.getName());
    }

    private String destroyEsme(String[] args) throws Exception {
        if (args.length < 4) {
            return "Invalid Command";
        }
        String esmeName = args[3];
        if (esmeName == null) {
            return "Invalid Command";
        }
        Esme esme = this.smppManagement.getEsmeManagement().destroyEsme(esmeName);
        return String.format("Successfully deleted Esme with given name %s", esmeName);
    }

    private String showEsme(String[] args) {
        if (args.length < 3) {
            return "Invalid Command";
        }
        String esmeName = null;
        if (args.length > 3) {
            esmeName = args[3];
        }
        StringBuffer sb = new StringBuffer();
        if (esmeName == null) {
            FastList<Esme> esmes = this.smppManagement.getEsmeManagement().getEsmes();
            if (esmes.size() == 0) {
                return "No ESME defined yet";
            }
            for (Esme esme : esmes) {
                sb.append("\n");
                esme.show(sb);
            }
        } else {
            Esme esme = this.smppManagement.getEsmeManagement().getEsmeByName(esmeName);
            if (esme == null) {
                return String.format("No Esme found with given name %s", esmeName);
            }
            esme.show(sb);
        }
        return sb.toString();
    }

    private String manageSmppServerSet(String[] options) throws Exception {
        if (options.length != 5) {
            return "Invalid Command";
        }
        SmppServerManagement smppServerManagement = this.smppManagement.getSmppServerManagement();
        String parName = options[3].toLowerCase();
        if (parName.equals("port")) {
            smppServerManagement.setBindPort(Integer.parseInt(options[4]));
        } else if (parName.equals("bindtimeout")) {
            int val = Integer.parseInt(options[4]);
            smppServerManagement.setBindTimeout(val);
        } else if (parName.equals("writetimeout")) {
            int val = Integer.parseInt(options[4]);
            smppServerManagement.setWriteTimeout(val);
        } else if (parName.equals("systemid")) {
            smppServerManagement.setSystemId(options[4]);
        } else if (parName.equals("autonegotiateversion")) {
            boolean val = Boolean.parseBoolean(options[4]);
            smppServerManagement.setAutoNegotiateInterfaceVersion(val);
        } else if (parName.equals("interfaceversion")) {
            double val = Double.parseDouble(options[4]);
            smppServerManagement.setInterfaceVersion(val);
        } else if (parName.equals("maxconnectionsize")) {
            int val = Integer.parseInt(options[4]);
            smppServerManagement.setMaxConnectionSize(val);
        } else if (parName.equals("smppactivitytimeout")) {
            int val = Integer.parseInt(options[4]);
            smppServerManagement.setSmppActivityTimeout(val);
        } else if (parName.equals("defaultwindowsize")) {
            int val = Integer.parseInt(options[4]);
            smppServerManagement.setDefaultWindowSize(val);
        } else if (parName.equals("defaultwindowwaittimeout")) {
            int val = Integer.parseInt(options[4]);
            smppServerManagement.setDefaultWindowWaitTimeout(val);
        } else if (parName.equals("defaultrequestexpirytimeout")) {
            int val = Integer.parseInt(options[4]);
            smppServerManagement.setDefaultRequestExpiryTimeout(val);
        } else if (parName.equals("defaultwindowmonitorinterval")) {
            int val = Integer.parseInt(options[4]);
            smppServerManagement.setDefaultWindowMonitorInterval(val);
        } else if (parName.equals("defaultsessioncountersenabled")) {
            boolean val = Boolean.parseBoolean(options[4]);
            smppServerManagement.setDefaultSessionCountersEnabled(val);
        } else if (parName.equals("bindipaddress")) {
            String val = options[4];
            smppServerManagement.setBindIpAddress(val);
        } else {
            return "Invalid Command";
        }
        return "Parameter has been successfully set. The changed value will take effect after SmppServer is restarted";
    }

    private String manageSmppServerGet(String[] options) throws Exception {
        SmppServerManagement smppServerManagement = this.smppManagement.getSmppServerManagement();
        if (options.length == 4) {
            String parName = options[3].toLowerCase();
            StringBuilder sb = new StringBuilder();
            sb.append(options[3]);
            sb.append(" = ");
            if (parName.equals("port")) {
                sb.append(smppServerManagement.getBindPort());
            } else if (parName.equals("bindtimeout")) {
                sb.append(smppServerManagement.getBindTimeout());
            } else if (parName.equals("writetimeout")) {
                sb.append(smppServerManagement.getWriteTimeout());
            } else if (parName.equals("systemid")) {
                sb.append(smppServerManagement.getSystemId());
            } else if (parName.equals("autonegotiateversion")) {
                sb.append(smppServerManagement.isAutoNegotiateInterfaceVersion());
            } else if (parName.equals("interfaceversion")) {
                sb.append(smppServerManagement.getInterfaceVersion());
            } else if (parName.equals("maxconnectionsize")) {
                sb.append(smppServerManagement.getMaxConnectionSize());
            } else if (parName.equals("smppactivitytimeout")) {
                sb.append(smppServerManagement.getSmppActivityTimeout());
            } else if (parName.equals("defaultwindowsize")) {
                sb.append(smppServerManagement.getDefaultWindowSize());
            } else if (parName.equals("defaultwindowwaittimeout")) {
                sb.append(smppServerManagement.getDefaultWindowWaitTimeout());
            } else if (parName.equals("defaultrequestexpirytimeout")) {
                sb.append(smppServerManagement.getDefaultRequestExpiryTimeout());
            } else if (parName.equals("defaultwindowmonitorinterval")) {
                sb.append(smppServerManagement.getDefaultWindowMonitorInterval());
            } else if (parName.equals("defaultsessioncountersenabled")) {
                sb.append(smppServerManagement.isDefaultSessionCountersEnabled());
            } else if (parName.equals("bindipaddress")) {
                sb.append(smppServerManagement.getBindIpAddress());
            } else {
                return "Invalid Command";
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("port = ");
        sb.append(smppServerManagement.getBindPort());
        sb.append("\n");
        sb.append("bind-ip-address = ");
        sb.append(smppServerManagement.getBindIpAddress());
        sb.append("\n");
        sb.append("bind-timeout = ");
        sb.append(smppServerManagement.getBindTimeout());
        sb.append("\n");
        sb.append("write-timeout = ");
        sb.append(smppServerManagement.getWriteTimeout());
        sb.append("\n");
        sb.append("system-id = ");
        sb.append(smppServerManagement.getSystemId());
        sb.append("\n");
        sb.append("auto-negotiate-version = ");
        sb.append(smppServerManagement.isAutoNegotiateInterfaceVersion());
        sb.append("\n");
        sb.append("interface-version = ");
        sb.append(smppServerManagement.getInterfaceVersion());
        sb.append("\n");
        sb.append("max-connection-size = ");
        sb.append(smppServerManagement.getMaxConnectionSize());
        sb.append("\n");
        sb.append("smpp-activity-timeout = ");
        sb.append(smppServerManagement.getSmppActivityTimeout());
        sb.append("\n");
        sb.append("default-window-size = ");
        sb.append(smppServerManagement.getDefaultWindowSize());
        sb.append("\n");
        sb.append("default-window-wait-timeout = ");
        sb.append(smppServerManagement.getDefaultWindowWaitTimeout());
        sb.append("\n");
        sb.append("default-request-expiry-timeout = ");
        sb.append(smppServerManagement.getDefaultRequestExpiryTimeout());
        sb.append("\n");
        sb.append("default-window-monitor-interval = ");
        sb.append(smppServerManagement.getDefaultWindowMonitorInterval());
        sb.append("\n");
        sb.append("default-session-counters-enabled = ");
        sb.append(smppServerManagement.isDefaultSessionCountersEnabled());
        sb.append("\n");
        return sb.toString();
    }

    private String startEsme(String[] args) throws Exception {
        if (args.length != 4) {
            return "Invalid Command";
        }
        SmppBindType smppBindType = SmppBindType.TRANSCEIVER;
        if (args.length == 5) {
            smppBindType = SmppBindType.valueOf((String)args[4]);
        }
        if (smppBindType == null) {
            throw new Exception(String.format("Invalid SMPP Bind Type %s. Allowed are TRANSCEIVER, TRANSMITTER or RECEIVER", args[4]));
        }
        this.smppManagement.getEsmeManagement().startEsme(args[3]);
        return String.format("Successfully started ESME name=%s", args[3]);
    }

    private String stopEsme(String[] args) throws Exception {
        if (args.length != 4) {
            return "Invalid Command";
        }
        this.smppManagement.getEsmeManagement().stopEsme(args[3]);
        return String.format("Successfully stopped ESME name=%s", args[3]);
    }

    private String executeSmpp(String[] args) {
        try {
            if (args.length < 2 || args.length > 50) {
                return "Invalid Command";
            }
            if (args[1] == null) {
                return "Invalid Command";
            }
            if (args[1].equals("esme")) {
                String rasCmd = args[2];
                if (rasCmd == null) {
                    return "Invalid Command";
                }
                if (rasCmd.equals("create")) {
                    return this.createEsme(args);
                }
                if (rasCmd.equals("modify")) {
                    return this.modifyEsme(args);
                }
                if (rasCmd.equals("delete")) {
                    return this.destroyEsme(args);
                }
                if (rasCmd.equals("show")) {
                    return this.showEsme(args);
                }
                if (rasCmd.equals("start")) {
                    return this.startEsme(args);
                }
                if (rasCmd.equals("stop")) {
                    return this.stopEsme(args);
                }
                return "Invalid Command";
            }
            if (args[1].equals("smppserver")) {
                String rasCmd = args[2];
                if (rasCmd == null) {
                    return "Invalid Command";
                }
                if (rasCmd.equals("set")) {
                    return this.manageSmppServerSet(args);
                }
                if (rasCmd.equals("get")) {
                    return this.manageSmppServerGet(args);
                }
                return "Invalid Command";
            }
            return "Invalid Command";
        }
        catch (Exception e) {
            logger.error((Object)String.format("Error while executing comand %s", Arrays.toString(args)), (Throwable)e);
            return e.getMessage();
        }
    }

    public String execute(String[] args) {
        if (args[0].equals("smpp")) {
            return this.executeSmpp(args);
        }
        return "Invalid Command";
    }

    public boolean handles(String command) {
        return "smpp".equals(command);
    }
}

