/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.smpp;

import com.cloudhopper.smpp.impl.DefaultSmppSession;
import com.cloudhopper.smpp.pdu.EnquireLink;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.restcomm.smpp.Esme;
import org.restcomm.smpp.EsmeManagement;

public class SmppServerOpsThread
implements Runnable {
    private static final Logger logger = Logger.getLogger(SmppServerOpsThread.class);
    protected volatile boolean started = true;
    private static final int MAX_ENQUIRE_FAILED = 1;
    private FastMap<String, Long> esmesServer;
    private final EsmeManagement esmeManagement;
    private Object waitObject = new Object();

    public SmppServerOpsThread(EsmeManagement esmeManagement) {
        this.esmeManagement = esmeManagement;
        this.esmesServer = esmeManagement.esmesServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStarted(boolean started) {
        this.started = started;
        Object object = this.waitObject;
        synchronized (object) {
            this.waitObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleList(String esmeServerName, Long delayValue) {
        Object object = this.esmesServer;
        synchronized (object) {
            this.esmesServer.put((Object)esmeServerName, (Object)delayValue);
        }
        object = this.waitObject;
        synchronized (object) {
            this.waitObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEnquireList(String esmeServerName) {
        Object object = this.esmesServer;
        synchronized (object) {
            this.esmesServer.remove((Object)esmeServerName);
        }
        object = this.waitObject;
        synchronized (object) {
            this.waitObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"SmppServerOpsThread started.");
        }
        while (this.started) {
            FastList pendingList = new FastList();
            try {
                FastMap<String, Long> fastMap = this.esmesServer;
                synchronized (fastMap) {
                    for (String esmeServerName : this.esmesServer.keySet()) {
                        Long delay;
                        Esme nextServer = this.esmeManagement.getEsmeByName(esmeServerName);
                        if (!nextServer.isStarted()) {
                            nextServer.setServerBound(false);
                        }
                        if (!nextServer.getLinkDropServerEnabled() && !nextServer.getEnquireServerEnabled() || !nextServer.isServerBound() || (delay = (Long)this.esmesServer.get((Object)nextServer.getName())) > System.currentTimeMillis()) continue;
                        pendingList.add((Object)nextServer);
                    }
                }
                for (Esme change : pendingList) {
                    if (change.getLinkDropServerEnabled()) {
                        this.serverLinkDown(change);
                        continue;
                    }
                    this.enquireLink(change);
                }
                Object object = this.waitObject;
                synchronized (object) {
                    this.waitObject.wait(5000L);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Error while looping SmpServerOpsThread thread", (Throwable)e);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"SmppServerOpsThread for stopped.");
        }
    }

    private void enquireLink(Esme esme) {
        DefaultSmppSession smppSession = esme.getSmppSession();
        if (smppSession != null && smppSession.isBound() && esme.isServerBound()) {
            try {
                smppSession.enquireLink(new EnquireLink(), 10000L);
                esme.resetEnquireLinkFail();
                this.scheduleList(esme.getName(), System.currentTimeMillis() + (long)esme.getEnquireLinkDelay());
            }
            catch (Exception e) {
                logger.error((Object)String.format("Exception while trying to send ENQUIRE_LINK for ESME SystemId=%s", esme.getSystemId()), (Throwable)e);
                esme.incEnquireLinkFail();
            }
        } else {
            logger.warn((Object)String.format("Sending ENQURE_LINK failed for ESME SystemId=%s as SmppSession is =%s !", esme.getSystemId(), smppSession == null ? null : smppSession.getStateName()));
            if (smppSession != null) {
                try {
                    smppSession.close();
                }
                catch (Exception e) {
                    logger.error((Object)String.format("Failed to close smpp server session for %s.", smppSession.getConfiguration().getName()));
                }
                smppSession.destroy();
                return;
            }
        }
        if (1 <= esme.getEnquireLinkFail()) {
            logger.warn((Object)("Can't send ENQUIRE_LINK for ESME SystemId=" + esme.getSystemId()));
            try {
                smppSession.close();
            }
            catch (Exception e) {
                logger.error((Object)String.format("Failed to close smpp server session for %s.", smppSession.getConfiguration().getName()));
            }
            smppSession.destroy();
        }
    }

    private void serverLinkDown(Esme esme) {
        DefaultSmppSession smppSession = esme.getSmppSession();
        if (!esme.getLinkStartFirstTime()) {
            if (!esme.checkLinkRecvMessage()) {
                logger.warn((Object)("linkDropServer dropped connection because no packet received for ESME SystemId=" + esme.getSystemId()));
                try {
                    smppSession.close();
                }
                catch (Exception e) {
                    logger.error((Object)String.format("Failed to close smpp server session for %s.", smppSession.getConfiguration().getName()));
                }
                smppSession.destroy();
            } else {
                esme.setLinkRecvMessage(false);
                this.scheduleList(esme.getName(), System.currentTimeMillis() + esme.getLinkDropServer());
            }
        } else {
            esme.setLinkStartFirstTime(false);
            this.scheduleList(esme.getName(), System.currentTimeMillis() + esme.getLinkDropServer());
        }
    }
}

