/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.smpp;

import com.cloudhopper.smpp.SmppServerConfiguration;
import com.cloudhopper.smpp.SmppServerHandler;
import com.cloudhopper.smpp.impl.DefaultSmppServer;
import com.cloudhopper.smpp.ssl.SslConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javolution.text.TextBuilder;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.restcomm.smpp.DefaultSmppServerHandler;
import org.restcomm.smpp.EsmeManagement;
import org.restcomm.smpp.SmppServerManagementMBean;
import org.restcomm.smpp.SmppServerOpsThread;
import org.restcomm.smpp.SmppSessionHandlerInterface;
import org.restcomm.smpp.SslConfigurationWrapper;

public class SmppServerManagement
extends SslConfigurationWrapper
implements SmppServerManagementMBean {
    private static final Logger logger = Logger.getLogger(SmppServerManagement.class);
    private static final String PORT = "port";
    private static final String BIND_TIMEOUT = "bindTimeout";
    private static final String WRITE_TIMEOUT = "writeTimeout";
    private static final String SYSTEM_ID = "systemId";
    private static final String AUTO_NEGOTIATION_VERSION = "autoNegotiateInterfaceVersion";
    private static final String INTERFACE_VERSION = "interfaceVersion";
    private static final String MAX_CONNECTION_SIZE = "maxConnectionSize";
    private static final String SMPP_ACTIVITY_TIMEOUT = "smppActivityTimeout";
    private static final String DEFAULT_WINDOW_SIZE = "defaultWindowSize";
    private static final String DEFAULT_WINDOW_WAIT_TIMEOUT = "defaultWindowWaitTimeout";
    private static final String DEFAULT_REQUEST_EXPIRY_TIMEOUT = "defaultRequestExpiryTimeout";
    private static final String DEFAULT_WINDOW_MONITOR_INTERVAL = "defaultWindowMonitorInterval";
    private static final String DEFAULT_SESSION_COUNTERS_ENABLED = "defaultSessionCountersEnabled";
    private static final String BIND_IP_ADDRESS = "bindIpAddress";
    private static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private static final XMLBinding binding = new XMLBinding();
    private static final String PERSIST_FILE_NAME = "smppserver.xml";
    private final TextBuilder persistFile = TextBuilder.newInstance();
    private String persistDir = null;
    private final String name;
    private ThreadPoolExecutor executor;
    private ScheduledThreadPoolExecutor monitorExecutor;
    private final EsmeManagement esmeManagement;
    private int port = 2776;
    private long bindTimeout = 5000L;
    private long writeTimeout = 0L;
    private String systemId = "RestCommSMSC";
    private boolean autoNegotiateInterfaceVersion = true;
    private double interfaceVersion = 3.4;
    private int maxConnectionSize = 100;
    private int smppActivityTimeout = 120;
    private int defaultWindowSize = 100;
    private long defaultWindowWaitTimeout = 30000L;
    private long defaultRequestExpiryTimeout = 30000L;
    private long defaultWindowMonitorInterval = 15000L;
    private boolean defaultSessionCountersEnabled = true;
    private String bindIpAddress = "0.0.0.0";
    private DefaultSmppServer defaultSmppServer = null;
    private SmppSessionHandlerInterface smppSessionHandlerInterface;
    private SmppServerOpsThread smppServerOpsThread;

    public SmppServerManagement(String name, EsmeManagement esmeManagement, SmppSessionHandlerInterface smppSessionHandlerInterface) {
        this.name = name;
        this.esmeManagement = esmeManagement;
        this.smppSessionHandlerInterface = smppSessionHandlerInterface;
        binding.setClassAttribute(CLASS_ATTRIBUTE);
    }

    public String getName() {
        return this.name;
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    public void setBindTimeout(long bindTimeout) {
        this.bindTimeout = bindTimeout;
        this.store();
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
        this.store();
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
        this.store();
    }

    public void setAutoNegotiateInterfaceVersion(boolean autoNegotiateInterfaceVersion) {
        this.autoNegotiateInterfaceVersion = autoNegotiateInterfaceVersion;
        this.store();
    }

    public void setInterfaceVersion(double interfaceVersion) {
        this.interfaceVersion = interfaceVersion;
        this.store();
    }

    public void setMaxConnectionSize(int maxConnectionSize) {
        this.maxConnectionSize = maxConnectionSize;
        this.store();
    }

    public void setSmppActivityTimeout(int smppActivityTimeout) {
        this.smppActivityTimeout = smppActivityTimeout;
        this.store();
    }

    public void setDefaultWindowSize(int defaultWindowSize) {
        this.defaultWindowSize = defaultWindowSize;
        this.store();
    }

    public void setDefaultWindowWaitTimeout(long defaultWindowWaitTimeout) {
        this.defaultWindowWaitTimeout = defaultWindowWaitTimeout;
        this.store();
    }

    public void setDefaultRequestExpiryTimeout(long defaultRequestExpiryTimeout) {
        this.defaultRequestExpiryTimeout = defaultRequestExpiryTimeout;
        this.store();
    }

    public void setDefaultWindowMonitorInterval(long defaultWindowMonitorInterval) {
        this.defaultWindowMonitorInterval = defaultWindowMonitorInterval;
        this.store();
    }

    public void setDefaultSessionCountersEnabled(boolean defaultSessionCountersEnabled) {
        this.defaultSessionCountersEnabled = defaultSessionCountersEnabled;
        this.store();
    }

    public void setBindIpAddress(String bindIpAddress) {
        this.bindIpAddress = bindIpAddress;
        this.store();
    }

    public void start() throws Exception {
        if (this.smppSessionHandlerInterface == null) {
            throw new Exception("SmppSessionHandlerInterface is not set!");
        }
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty("smsc.persist.dir", System.getProperty("user.dir"))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
        logger.info((Object)String.format("Loading SMPP Server Properties from %s", this.persistFile.toString()));
        try {
            this.load();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)String.format("Failed to load the SMSC configuration file. \n%s", e.getMessage()));
        }
        SmppServerConfiguration configuration = new SmppServerConfiguration();
        configuration.setName(this.name);
        configuration.setPort(this.port);
        configuration.setBindTimeout(this.bindTimeout);
        configuration.setSystemId(this.systemId);
        configuration.setAutoNegotiateInterfaceVersion(this.autoNegotiateInterfaceVersion);
        if (this.interfaceVersion == 3.4) {
            configuration.setInterfaceVersion((byte)52);
        } else if (this.interfaceVersion == 3.3) {
            configuration.setInterfaceVersion((byte)51);
        }
        configuration.setMaxConnectionSize(this.maxConnectionSize);
        configuration.setNonBlockingSocketsEnabled(true);
        configuration.setHost(this.bindIpAddress);
        configuration.setDefaultRequestExpiryTimeout(this.defaultRequestExpiryTimeout);
        configuration.setDefaultWindowMonitorInterval(this.defaultWindowMonitorInterval);
        configuration.setDefaultWindowSize(this.defaultWindowSize);
        configuration.setDefaultWindowWaitTimeout(this.defaultWindowWaitTimeout);
        configuration.setDefaultSessionCountersEnabled(this.defaultSessionCountersEnabled);
        configuration.setJmxEnabled(false);
        if (this.isUseSsl()) {
            logger.info((Object)String.format("%s SmppServer will use SSL Configuration", this.name));
            SslConfiguration sslConfiguration = this.getWrappedSslConfig();
            configuration.setUseSsl(true);
            configuration.setSslConfiguration(sslConfiguration);
        }
        this.executor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        this.monitorExecutor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, new ThreadFactory(){
            private AtomicInteger sequence = new AtomicInteger(0);

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("SmppServer-SessionWindowMonitorPool-" + this.sequence.getAndIncrement());
                return t;
            }
        });
        this.smppServerOpsThread = new SmppServerOpsThread(this.esmeManagement);
        this.defaultSmppServer = new DefaultSmppServer(configuration, (SmppServerHandler)new DefaultSmppServerHandler(this.esmeManagement, this.smppServerOpsThread, this.smppSessionHandlerInterface), (ExecutorService)this.executor, (ScheduledExecutorService)this.monitorExecutor);
        logger.info((Object)"Starting SMPP server...");
        this.defaultSmppServer.start();
        logger.info((Object)"SMPP server started");
        new Thread(this.smppServerOpsThread).start();
    }

    public void stop() throws Exception {
        logger.info((Object)"Stopping SmppServerOpsThread...");
        this.smppServerOpsThread.setStarted(false);
        logger.info((Object)"SmppServerOpsThread stopped");
        logger.info((Object)"Stopping SMPP server...");
        this.defaultSmppServer.stop();
        this.monitorExecutor.shutdownNow();
        this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        this.executor.shutdown();
        logger.info((Object)"SMPP server stopped");
        logger.info((Object)String.format("Server counters: %s", this.defaultSmppServer.getCounters()));
        this.store();
    }

    public int getBindPort() {
        return this.port;
    }

    public void setBindPort(int port) {
        this.port = port;
        this.store();
    }

    public long getBindTimeout() {
        return this.bindTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public boolean isAutoNegotiateInterfaceVersion() {
        return this.autoNegotiateInterfaceVersion;
    }

    public double getInterfaceVersion() {
        return this.interfaceVersion;
    }

    public int getMaxConnectionSize() {
        return this.maxConnectionSize;
    }

    public int getSmppActivityTimeout() {
        return this.smppActivityTimeout;
    }

    public int getDefaultWindowSize() {
        return this.defaultWindowSize;
    }

    public long getDefaultWindowWaitTimeout() {
        return this.defaultWindowWaitTimeout;
    }

    public long getDefaultRequestExpiryTimeout() {
        return this.defaultRequestExpiryTimeout;
    }

    public long getDefaultWindowMonitorInterval() {
        return this.defaultWindowMonitorInterval;
    }

    public boolean isDefaultSessionCountersEnabled() {
        return this.defaultSessionCountersEnabled;
    }

    public boolean isStarted() {
        return this.defaultSmppServer != null && this.defaultSmppServer.isStarted();
    }

    public void resetCounters() {
        if (this.defaultSmppServer != null) {
            this.defaultSmppServer.resetCounters();
        }
    }

    public int getSessionSize() {
        if (this.defaultSmppServer != null) {
            return this.defaultSmppServer.getSessionSize();
        }
        return 0;
    }

    public int getTransceiverSessionSize() {
        if (this.defaultSmppServer != null) {
            return this.defaultSmppServer.getTransceiverSessionSize();
        }
        return 0;
    }

    public int getTransmitterSessionSize() {
        if (this.defaultSmppServer != null) {
            return this.defaultSmppServer.getTransmitterSessionSize();
        }
        return 0;
    }

    public int getReceiverSessionSize() {
        if (this.defaultSmppServer != null) {
            return this.defaultSmppServer.getReceiverSessionSize();
        }
        return 0;
    }

    public int getConnectionSize() {
        if (this.defaultSmppServer != null) {
            return this.defaultSmppServer.getConnectionSize();
        }
        return 0;
    }

    public boolean isNonBlockingSocketsEnabled() {
        if (this.defaultSmppServer != null) {
            return this.defaultSmppServer.isNonBlockingSocketsEnabled();
        }
        return false;
    }

    public boolean isReuseAddress() {
        if (this.defaultSmppServer != null) {
            return this.defaultSmppServer.isReuseAddress();
        }
        return false;
    }

    public int getChannelConnects() {
        if (this.defaultSmppServer != null) {
            return this.defaultSmppServer.getChannelConnects();
        }
        return 0;
    }

    public int getChannelDisconnects() {
        if (this.defaultSmppServer != null) {
            return this.defaultSmppServer.getChannelDisconnects();
        }
        return 0;
    }

    public int getBindTimeouts() {
        if (this.defaultSmppServer != null) {
            return this.defaultSmppServer.getBindTimeouts();
        }
        return 0;
    }

    public int getBindRequested() {
        if (this.defaultSmppServer != null) {
            return this.defaultSmppServer.getBindRequested();
        }
        return 0;
    }

    public int getSessionCreated() {
        if (this.defaultSmppServer != null) {
            return this.defaultSmppServer.getSessionCreated();
        }
        return 0;
    }

    public int getSessionDestroyed() {
        if (this.defaultSmppServer != null) {
            return this.defaultSmppServer.getSessionDestroyed();
        }
        return 0;
    }

    public String getBindIpAddress() {
        return this.bindIpAddress;
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            writer.write((Object)this.port, PORT, Integer.class);
            writer.write((Object)this.bindTimeout, BIND_TIMEOUT, Long.class);
            writer.write((Object)this.writeTimeout, WRITE_TIMEOUT, Long.class);
            writer.write((Object)this.systemId, SYSTEM_ID, String.class);
            writer.write((Object)this.autoNegotiateInterfaceVersion, AUTO_NEGOTIATION_VERSION, Boolean.class);
            writer.write((Object)this.interfaceVersion, INTERFACE_VERSION, Double.class);
            writer.write((Object)this.maxConnectionSize, MAX_CONNECTION_SIZE, Integer.class);
            writer.write((Object)this.smppActivityTimeout, SMPP_ACTIVITY_TIMEOUT, Integer.class);
            writer.write((Object)this.defaultWindowSize, DEFAULT_WINDOW_SIZE, Integer.class);
            writer.write((Object)this.defaultWindowWaitTimeout, DEFAULT_WINDOW_WAIT_TIMEOUT, Long.class);
            writer.write((Object)this.defaultRequestExpiryTimeout, DEFAULT_REQUEST_EXPIRY_TIMEOUT, Long.class);
            writer.write((Object)this.defaultWindowMonitorInterval, DEFAULT_WINDOW_MONITOR_INTERVAL, Long.class);
            writer.write((Object)this.defaultSessionCountersEnabled, DEFAULT_SESSION_COUNTERS_ENABLED, Boolean.class);
            writer.write((Object)this.bindIpAddress, BIND_IP_ADDRESS, String.class);
            writer.write((Object)this.useSsl, "useSsl", Boolean.class);
            writer.write((Object)this.wrappedSslConfig.getCertAlias(), "certAlias", String.class);
            writer.write((Object)this.wrappedSslConfig.getCrlPath(), "crlPath", String.class);
            writer.write((Object)this.wrappedSslConfig.getKeyManagerFactoryAlgorithm(), "keyManagerFactoryAlgorithm", String.class);
            writer.write((Object)this.wrappedSslConfig.getKeyManagerPassword(), "keyManagerPassword", String.class);
            writer.write((Object)this.wrappedSslConfig.getKeyStorePassword(), "keyStorePassword", String.class);
            writer.write((Object)this.wrappedSslConfig.getKeyStoreProvider(), "keyStoreProvider", String.class);
            writer.write((Object)this.wrappedSslConfig.getKeyStorePath(), "keyStorePath", String.class);
            writer.write((Object)this.wrappedSslConfig.getKeyStoreType(), "keyStoreType", String.class);
            writer.write((Object)this.wrappedSslConfig.getMaxCertPathLength(), "maxCertPathLength", Integer.class);
            writer.write((Object)this.wrappedSslConfig.getNeedClientAuth(), "needClientAuth", Boolean.class);
            writer.write((Object)this.wrappedSslConfig.getOcspResponderURL(), "ocspResponderURL", String.class);
            writer.write((Object)this.wrappedSslConfig.getProtocol(), "protocol", String.class);
            writer.write((Object)this.wrappedSslConfig.getProvider(), "provider", String.class);
            writer.write((Object)this.wrappedSslConfig.getSecureRandomAlgorithm(), "secureRandomAlgorithm", String.class);
            writer.write((Object)this.wrappedSslConfig.getSslSessionCacheSize(), "sslSessionCacheSize", Integer.class);
            writer.write((Object)this.wrappedSslConfig.getSslSessionTimeout(), "sslSessionTimeout", Integer.class);
            writer.write((Object)this.wrappedSslConfig.getTrustManagerFactoryAlgorithm(), "trustManagerFactoryAlgorithm", String.class);
            writer.write((Object)this.wrappedSslConfig.getTrustStorePassword(), "trustStorePassword", String.class);
            writer.write((Object)this.wrappedSslConfig.getTrustStorePath(), "trustStorePath", String.class);
            writer.write((Object)this.wrappedSslConfig.getTrustStoreProvider(), "trustStoreProvider", String.class);
            writer.write((Object)this.wrappedSslConfig.getTrustStoreType(), "trustStoreType", String.class);
            writer.write((Object)this.wrappedSslConfig.getWantClientAuth(), "wantClientAuth", Boolean.class);
            writer.write((Object)this.wrappedSslConfig.isAllowRenegotiate(), "allowRenegotiate", Boolean.class);
            writer.write((Object)this.wrappedSslConfig.isEnableCRLDP(), "enableCRLDP", Boolean.class);
            writer.write((Object)this.wrappedSslConfig.isSessionCachingEnabled(), "sessionCachingEnabled", Boolean.class);
            writer.write((Object)this.wrappedSslConfig.isTrustAll(), "trustAll", Boolean.class);
            writer.write((Object)this.wrappedSslConfig.isValidateCerts(), "validateCerts", Boolean.class);
            writer.write((Object)this.wrappedSslConfig.isValidatePeerCerts(), "validatePeerCerts", Boolean.class);
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error while persisting the Rule state in file", (Throwable)e);
        }
    }

    public void load() throws FileNotFoundException {
        if (this.persistDir != null) {
            TextBuilder oldFileName = new TextBuilder();
            oldFileName.append(this.persistDir).append(File.separator).append("SmscManagement").append("_").append(PERSIST_FILE_NAME);
            Path oldPath = FileSystems.getDefault().getPath(oldFileName.toString(), new String[0]);
            Path newPath = FileSystems.getDefault().getPath(this.persistFile.toString(), new String[0]);
            if (Files.exists(oldPath, new LinkOption[0]) && Files.notExists(newPath, new LinkOption[0])) {
                try {
                    Files.move(oldPath, newPath, new CopyOption[0]);
                }
                catch (IOException e) {
                    logger.warn((Object)"Exception when trying to rename old config file", (Throwable)e);
                }
            }
        }
        XMLObjectReader reader = null;
        try {
            reader = XMLObjectReader.newInstance((InputStream)new FileInputStream(this.persistFile.toString()));
            reader.setBinding(binding);
            this.port = (Integer)reader.read(PORT, Integer.class);
            this.bindTimeout = (Long)reader.read(BIND_TIMEOUT, Long.class);
            Long vall = (Long)reader.read(WRITE_TIMEOUT, Long.class);
            if (vall != null) {
                this.writeTimeout = vall;
            }
            this.systemId = (String)reader.read(SYSTEM_ID, String.class);
            this.autoNegotiateInterfaceVersion = (Boolean)reader.read(AUTO_NEGOTIATION_VERSION, Boolean.class);
            this.interfaceVersion = (Double)reader.read(INTERFACE_VERSION, Double.class);
            this.maxConnectionSize = (Integer)reader.read(MAX_CONNECTION_SIZE, Integer.class);
            Integer valI = (Integer)reader.read(SMPP_ACTIVITY_TIMEOUT, Integer.class);
            if (valI != null) {
                this.smppActivityTimeout = valI;
            }
            this.defaultWindowSize = (Integer)reader.read(DEFAULT_WINDOW_SIZE, Integer.class);
            this.defaultWindowWaitTimeout = ((Integer)reader.read(DEFAULT_WINDOW_WAIT_TIMEOUT, Integer.class)).intValue();
            this.defaultRequestExpiryTimeout = ((Integer)reader.read(DEFAULT_REQUEST_EXPIRY_TIMEOUT, Integer.class)).intValue();
            this.defaultWindowMonitorInterval = ((Integer)reader.read(DEFAULT_WINDOW_MONITOR_INTERVAL, Integer.class)).intValue();
            this.defaultSessionCountersEnabled = (Boolean)reader.read(DEFAULT_SESSION_COUNTERS_ENABLED, Boolean.class);
            String val = (String)reader.read(BIND_IP_ADDRESS, String.class);
            if (val != null) {
                this.bindIpAddress = val;
            }
            this.useSsl = (Boolean)reader.read("useSsl", Boolean.class);
            this.wrappedSslConfig.setCertAlias((String)reader.read("certAlias", String.class));
            this.wrappedSslConfig.setCrlPath((String)reader.read("crlPath", String.class));
            this.wrappedSslConfig.setKeyManagerFactoryAlgorithm((String)reader.read("keyManagerFactoryAlgorithm", String.class));
            this.wrappedSslConfig.setKeyManagerPassword((String)reader.read("keyManagerPassword", String.class));
            this.wrappedSslConfig.setKeyStorePassword((String)reader.read("keyStorePassword", String.class));
            this.wrappedSslConfig.setKeyStoreProvider((String)reader.read("keyStoreProvider", String.class));
            this.wrappedSslConfig.setKeyStorePath((String)reader.read("keyStorePath", String.class));
            this.wrappedSslConfig.setKeyStoreType((String)reader.read("keyStoreType", String.class));
            this.wrappedSslConfig.setMaxCertPathLength(((Integer)reader.read("maxCertPathLength", Integer.class)).intValue());
            this.wrappedSslConfig.setNeedClientAuth(((Boolean)reader.read("needClientAuth", Boolean.class)).booleanValue());
            this.wrappedSslConfig.setOcspResponderURL((String)reader.read("ocspResponderURL", String.class));
            this.wrappedSslConfig.setProtocol((String)reader.read("protocol", String.class));
            this.wrappedSslConfig.setProvider((String)reader.read("provider", String.class));
            this.wrappedSslConfig.setSecureRandomAlgorithm((String)reader.read("secureRandomAlgorithm", String.class));
            this.wrappedSslConfig.setSslSessionCacheSize(((Integer)reader.read("sslSessionCacheSize", Integer.class)).intValue());
            this.wrappedSslConfig.setSslSessionTimeout(((Integer)reader.read("sslSessionTimeout", Integer.class)).intValue());
            this.wrappedSslConfig.setTrustManagerFactoryAlgorithm((String)reader.read("trustManagerFactoryAlgorithm", String.class));
            this.wrappedSslConfig.setTrustStorePassword((String)reader.read("trustStorePassword", String.class));
            this.wrappedSslConfig.setTrustStorePath((String)reader.read("trustStorePath", String.class));
            this.wrappedSslConfig.setTrustStoreProvider((String)reader.read("trustStoreProvider", String.class));
            this.wrappedSslConfig.setTrustStoreType((String)reader.read("trustStoreType", String.class));
            this.wrappedSslConfig.setWantClientAuth(((Boolean)reader.read("wantClientAuth", Boolean.class)).booleanValue());
            this.wrappedSslConfig.setAllowRenegotiate(((Boolean)reader.read("allowRenegotiate", Boolean.class)).booleanValue());
            this.wrappedSslConfig.setEnableCRLDP(((Boolean)reader.read("enableCRLDP", Boolean.class)).booleanValue());
            this.wrappedSslConfig.setSessionCachingEnabled(((Boolean)reader.read("sessionCachingEnabled", Boolean.class)).booleanValue());
            this.wrappedSslConfig.setTrustAll(((Boolean)reader.read("trustAll", Boolean.class)).booleanValue());
            this.wrappedSslConfig.setValidateCerts(((Boolean)reader.read("validateCerts", Boolean.class)).booleanValue());
            this.wrappedSslConfig.setValidatePeerCerts(((Boolean)reader.read("validatePeerCerts", Boolean.class)).booleanValue());
            reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }
}

