/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.smpp;

import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javolution.xml.XMLBinding;
import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.restcomm.smpp.Esme;
import org.restcomm.smpp.EsmeManagement;
import org.restcomm.smpp.EsmeManagementMBean;
import org.restcomm.smpp.SmppClientManagement;
import org.restcomm.smpp.SmppClientManagementMBean;
import org.restcomm.smpp.SmppManagementMBean;
import org.restcomm.smpp.SmppServerManagement;
import org.restcomm.smpp.SmppServerManagementMBean;
import org.restcomm.smpp.SmppSessionHandlerInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmppManagement
implements SmppManagementMBean {
    private static final Logger logger = Logger.getLogger(SmppManagement.class);
    public static final String JMX_DOMAIN = "org.restcomm.smpp";
    public static final String JMX_LAYER_ESME_MANAGEMENT = "EsmeManagement";
    public static final String JMX_LAYER_SMPP_SERVER_MANAGEMENT = "SmppServerManagement";
    public static final String JMX_LAYER_SMPP_CLIENT_MANAGEMENT = "SmppClientManagement";
    protected static final String SMSC_PERSIST_DIR_KEY = "smsc.persist.dir";
    protected static final String USER_DIR_KEY = "user.dir";
    private static final XMLBinding binding = new XMLBinding();
    private static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private static SmppManagement instance = null;
    private boolean isStarted = false;
    private final String name;
    private String persistDir = null;
    private MBeanServer mbeanServer = null;
    private SmppSessionHandlerInterface smppSessionHandlerInterface = null;
    private EsmeManagement esmeManagement = null;
    private SmppServerManagement smppServerManagement = null;
    private SmppClientManagement smppClientManagement = null;

    private SmppManagement(String name) {
        this.name = name;
        this.esmeManagement = EsmeManagement.getInstance(this.name);
        binding.setClassAttribute(CLASS_ATTRIBUTE);
        binding.setAlias(Esme.class, "esme");
    }

    public static SmppManagement getInstance(String name) {
        if (instance == null) {
            instance = new SmppManagement(name);
        }
        return instance;
    }

    public static SmppManagement getInstance() {
        return instance;
    }

    @Override
    public Object getSmppManagementInstance() {
        return instance;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public String getPersistDir() {
        return this.persistDir;
    }

    @Override
    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    public EsmeManagement getEsmeManagement() {
        return this.esmeManagement;
    }

    public SmppServerManagement getSmppServerManagement() {
        return this.smppServerManagement;
    }

    @Override
    public void setSmppSessionHandlerInterface(SmppSessionHandlerInterface smppSessionHandlerInterface) {
        this.smppSessionHandlerInterface = smppSessionHandlerInterface;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public void start() {
        this.isStarted = true;
    }

    @Override
    public void startSmppManagement() throws Exception {
        if (this.mbeanServer == null) {
            this.mbeanServer = MBeanServerLocator.locateJBoss();
        }
        this.esmeManagement.setPersistDir(this.persistDir);
        if (this.mbeanServer != null) {
            this.esmeManagement.setMbeanServer(this.mbeanServer);
        }
        this.esmeManagement.start();
        ObjectName esmeObjNname = new ObjectName("org.restcomm.smpp:layer=EsmeManagement,name=" + this.getName());
        this.registerMBean(this.esmeManagement, EsmeManagementMBean.class, false, esmeObjNname);
        this.isStarted = true;
        logger.info((Object)"Started SmppManagement");
        this.smppServerManagement = new SmppServerManagement(this.name, this.esmeManagement, this.smppSessionHandlerInterface);
        this.smppServerManagement.setPersistDir(this.persistDir);
        this.smppServerManagement.start();
        ObjectName smppServerManaObjName = new ObjectName("org.restcomm.smpp:layer=SmppServerManagement,name=" + this.getName());
        this.registerMBean(this.smppServerManagement, SmppServerManagementMBean.class, true, smppServerManaObjName);
        this.smppClientManagement = new SmppClientManagement(this.name, this.esmeManagement, this.smppSessionHandlerInterface);
        this.esmeManagement.setSmppClient(this.smppClientManagement);
        this.smppClientManagement.start();
        ObjectName smppClientManaObjName = new ObjectName("org.restcomm.smpp:layer=SmppClientManagement,name=" + this.getName());
        this.registerMBean(this.smppClientManagement, SmppClientManagementMBean.class, true, smppClientManaObjName);
    }

    @Override
    public void stopSmppManagement() throws Exception {
        this.isStarted = false;
        this.esmeManagement.stop();
        ObjectName esmeObjNname = new ObjectName("org.restcomm.smpp:layer=EsmeManagement,name=" + this.getName());
        this.unregisterMbean(esmeObjNname);
        this.smppServerManagement.stop();
        ObjectName smppServerManaObjName = new ObjectName("org.restcomm.smpp:layer=SmppServerManagement,name=" + this.getName());
        this.unregisterMbean(smppServerManaObjName);
        this.smppClientManagement.stop();
        ObjectName smppClientManaObjName = new ObjectName("org.restcomm.smpp:layer=SmppClientManagement,name=" + this.getName());
        this.unregisterMbean(smppClientManaObjName);
    }

    protected <T> void registerMBean(T implementation, Class<T> mbeanInterface, boolean isMXBean, ObjectName name) {
        try {
            this.mbeanServer.registerMBean(implementation, name);
        }
        catch (InstanceAlreadyExistsException e) {
            logger.error((Object)String.format("Error while registering MBean %s", mbeanInterface.getName()), (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            logger.error((Object)String.format("Error while registering MBean %s", mbeanInterface.getName()), (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            logger.error((Object)String.format("Error while registering MBean %s", mbeanInterface.getName()), (Throwable)e);
        }
    }

    protected void unregisterMbean(ObjectName name) throws Exception {
        try {
            this.mbeanServer.unregisterMBean(name);
        }
        catch (MBeanRegistrationException e) {
            logger.error((Object)String.format("Error while unregistering MBean %s", name), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            logger.error((Object)String.format("Error while unregistering MBean %s", name), (Throwable)e);
        }
    }
}

