/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.smpp;

import com.cloudhopper.smpp.PduAsyncResponse;
import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.impl.DefaultSmppClient;
import com.cloudhopper.smpp.impl.DefaultSmppSession;
import com.cloudhopper.smpp.pdu.EnquireLink;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.ssl.SslConfiguration;
import com.cloudhopper.smpp.type.Address;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.restcomm.smpp.ChangeRequest;
import org.restcomm.smpp.Esme;
import org.restcomm.smpp.SmppManagement;
import org.restcomm.smpp.SmppSessionHandlerInterface;

public class SmppClientOpsThread
implements Runnable {
    private static final Logger logger = Logger.getLogger(SmppClientOpsThread.class);
    private static final long SCHEDULE_CONNECT_DELAY = 30000L;
    protected volatile boolean started = true;
    private FastList<ChangeRequest> pendingChanges = new FastList();
    private Object waitObject = new Object();
    private final DefaultSmppClient clientBootstrap;
    private final SmppSessionHandlerInterface smppSessionHandlerInterface;

    public SmppClientOpsThread(DefaultSmppClient clientBootstrap, SmppSessionHandlerInterface smppSessionHandlerInterface) {
        this.clientBootstrap = clientBootstrap;
        this.smppSessionHandlerInterface = smppSessionHandlerInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStarted(boolean started) {
        this.started = started;
        Object object = this.waitObject;
        synchronized (object) {
            this.waitObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleConnect(Esme esme) {
        Object object = this.pendingChanges;
        synchronized (object) {
            this.pendingChanges.add((Object)new ChangeRequest(esme, 0, System.currentTimeMillis() + 30000L));
        }
        object = this.waitObject;
        synchronized (object) {
            this.waitObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleEnquireLink(Esme esme) {
        Object object = this.pendingChanges;
        synchronized (object) {
            this.pendingChanges.add((Object)new ChangeRequest(esme, 2, System.currentTimeMillis() + (long)esme.getEnquireLinkDelay()));
        }
        object = this.waitObject;
        synchronized (object) {
            this.waitObject.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)"SmppClientOpsThread started.");
        }
        while (this.started) {
            FastList pendingList = new FastList();
            try {
                FastList<ChangeRequest> fastList = this.pendingChanges;
                synchronized (fastList) {
                    for (ChangeRequest change : this.pendingChanges) {
                        switch (change.getType()) {
                            case 0: {
                                if (!change.getEsme().isStarted()) {
                                    this.pendingChanges.remove((Object)change);
                                    break;
                                }
                                if (change.getExecutionTime() > System.currentTimeMillis()) break;
                                this.pendingChanges.remove((Object)change);
                                this.initiateConnection(change.getEsme());
                                break;
                            }
                            case 2: {
                                if (!change.getEsme().isStarted()) {
                                    this.pendingChanges.remove((Object)change);
                                    break;
                                }
                                if (!change.getEsme().getEnquireClientEnabled() || change.getExecutionTime() > System.currentTimeMillis()) break;
                                pendingList.add((Object)change.getEsme());
                                this.pendingChanges.remove((Object)change);
                            }
                        }
                    }
                }
                for (Esme change : pendingList) {
                    this.enquireLink(change);
                }
                Object object = this.waitObject;
                synchronized (object) {
                    this.waitObject.wait(5000L);
                }
            }
            catch (InterruptedException e) {
                logger.error((Object)"Error while looping SmppClientOpsThread thread", (Throwable)e);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)"SmppClientOpsThread for stopped.");
        }
    }

    private void enquireLink(Esme esme) {
        DefaultSmppSession smppSession = esme.getSmppSession();
        if (!esme.isStarted()) {
            return;
        }
        if (smppSession != null && smppSession.isBound()) {
            try {
                smppSession.enquireLink(new EnquireLink(), 10000L);
                this.scheduleEnquireLink(esme);
                return;
            }
            catch (RecoverablePduException e) {
                logger.warn((Object)String.format("RecoverablePduException while sending the ENQURE_LINK for ESME SystemId=%s", esme.getSystemId()), (Throwable)e);
                this.scheduleEnquireLink(esme);
                return;
            }
            catch (Exception e) {
                logger.error((Object)String.format("Exception while trying to send ENQUIRE_LINK for ESME SystemId=%s", esme.getSystemId()), (Throwable)e);
                try {
                    smppSession.close();
                }
                catch (Exception ex) {
                    logger.error((Object)String.format("Failed to close smpp client session for %s.", smppSession.getConfiguration().getName()));
                }
                this.scheduleConnect(esme);
            }
        } else {
            logger.warn((Object)String.format("Sending ENQURE_LINK fialed for ESME SystemId=%s as SmppSession is =%s !", esme.getSystemId(), smppSession == null ? null : smppSession.getStateName()));
            if (smppSession != null) {
                try {
                    smppSession.close();
                }
                catch (Exception e) {
                    logger.error((Object)String.format("Failed to close smpp client session for %s.", smppSession.getConfiguration().getName()));
                }
            }
            this.scheduleConnect(esme);
        }
    }

    private void initiateConnection(Esme esme) {
        if (!esme.isStarted()) {
            return;
        }
        DefaultSmppSession smppSession = esme.getSmppSession();
        if (smppSession != null && smppSession.isBound() || smppSession != null && smppSession.isBinding()) {
            return;
        }
        SmppSession session0 = null;
        try {
            SmppSessionConfiguration config0 = new SmppSessionConfiguration();
            config0.setWindowSize(esme.getWindowSize());
            config0.setName(esme.getSystemId());
            config0.setType(esme.getSmppBindType());
            config0.setBindTimeout(esme.getClientBindTimeout());
            config0.setHost(esme.getHost());
            config0.setPort(esme.getPort());
            config0.setConnectTimeout(esme.getConnectTimeout());
            config0.setSystemId(esme.getSystemId());
            config0.setPassword(esme.getPassword());
            config0.setSystemType(esme.getSystemType());
            config0.getLoggingOptions().setLogBytes(true);
            config0.setRequestExpiryTimeout(esme.getRequestExpiryTimeout());
            config0.setWindowMonitorInterval(esme.getWindowMonitorInterval());
            config0.setCountersEnabled(esme.isCountersEnabled());
            config0.setWriteTimeout(SmppManagement.getInstance().getSmppServerManagement().getWriteTimeout());
            int addressTon = esme.getEsmeTon();
            int addressNpi = esme.getEsmeNpi();
            String addressRange = esme.getEsmeAddressRange();
            Address addressRangeObj = new Address();
            if (addressTon != -1) {
                addressRangeObj.setTon((byte)addressTon);
            }
            if (addressNpi != -1) {
                addressRangeObj.setNpi((byte)addressNpi);
            }
            if (addressRange != null) {
                addressRangeObj.setAddress(addressRange);
            }
            config0.setAddressRange(addressRangeObj);
            ClientSmppSessionHandler sessionHandler = new ClientSmppSessionHandler(esme, this.smppSessionHandlerInterface.createNewSmppSessionHandler(esme));
            if (esme.isUseSsl()) {
                logger.info((Object)String.format("%s ESME will use SSL Configuration", esme.getName()));
                SslConfiguration sslConfiguration = esme.getWrappedSslConfig();
                config0.setUseSsl(true);
                config0.setSslConfiguration(sslConfiguration);
            }
            session0 = this.clientBootstrap.bind(config0, (SmppSessionHandler)sessionHandler);
            esme.setSmppSession((DefaultSmppSession)session0);
            this.scheduleEnquireLink(esme);
        }
        catch (Exception e) {
            logger.error((Object)String.format("Exception when trying to bind client SMPP connection for ESME systemId=%s", esme.getSystemId()), (Throwable)e);
            if (session0 != null) {
                session0.close();
            }
            this.scheduleConnect(esme);
        }
    }

    protected class ClientSmppSessionHandler
    implements SmppSessionHandler {
        private final Esme esme;
        private final SmppSessionHandler wrappedSmppSessionHandler;

        public ClientSmppSessionHandler(Esme esme, SmppSessionHandler wrappedSmppSessionHandler) {
            this.esme = esme;
            this.wrappedSmppSessionHandler = wrappedSmppSessionHandler;
        }

        public String lookupResultMessage(int arg0) {
            return null;
        }

        public String lookupTlvTagName(short arg0) {
            return null;
        }

        public void fireChannelUnexpectedlyClosed() {
            this.wrappedSmppSessionHandler.fireChannelUnexpectedlyClosed();
            this.esme.getSmppSession().close();
            SmppClientOpsThread.this.scheduleConnect(this.esme);
        }

        public void fireExpectedPduResponseReceived(PduAsyncResponse pduAsyncResponse) {
            this.wrappedSmppSessionHandler.fireExpectedPduResponseReceived(pduAsyncResponse);
        }

        public void firePduRequestExpired(PduRequest pduRequest) {
            this.wrappedSmppSessionHandler.firePduRequestExpired(pduRequest);
        }

        public PduResponse firePduRequestReceived(PduRequest pduRequest) {
            return this.wrappedSmppSessionHandler.firePduRequestReceived(pduRequest);
        }

        public void fireRecoverablePduException(RecoverablePduException e) {
            this.wrappedSmppSessionHandler.fireRecoverablePduException(e);
        }

        public void fireUnexpectedPduResponseReceived(PduResponse pduResponse) {
            this.wrappedSmppSessionHandler.fireUnexpectedPduResponseReceived(pduResponse);
        }

        public void fireUnknownThrowable(Throwable e) {
            this.wrappedSmppSessionHandler.fireUnknownThrowable(e);
            this.esme.getSmppSession().close();
            SmppClientOpsThread.this.scheduleConnect(this.esme);
        }

        public void fireUnrecoverablePduException(UnrecoverablePduException e) {
            this.wrappedSmppSessionHandler.fireUnrecoverablePduException(e);
            this.esme.getSmppSession().close();
            SmppClientOpsThread.this.scheduleConnect(this.esme);
        }
    }
}

