/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.smpp;

import com.cloudhopper.commons.util.windowing.Window;
import com.cloudhopper.commons.util.windowing.WindowFuture;
import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.impl.DefaultSmppClient;
import com.cloudhopper.smpp.impl.DefaultSmppSession;
import com.cloudhopper.smpp.pdu.PduRequest;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.restcomm.smpp.Esme;
import org.restcomm.smpp.EsmeManagement;
import org.restcomm.smpp.SmppClientManagementMBean;
import org.restcomm.smpp.SmppClientOpsThread;
import org.restcomm.smpp.SmppSessionHandlerInterface;

public class SmppClientManagement
implements SmppClientManagementMBean {
    private static final Logger logger = Logger.getLogger(SmppClientManagement.class);
    private final EsmeManagement esmeManagement;
    private final SmppSessionHandlerInterface smppSessionHandlerInterface;
    private final String name;
    private ThreadPoolExecutor executor;
    private ScheduledThreadPoolExecutor monitorExecutor;
    private DefaultSmppClient clientBootstrap = null;
    private SmppClientOpsThread smppClientOpsThread = null;
    private int expectedSessions = 25;

    public SmppClientManagement(String name, EsmeManagement esmeManagement, SmppSessionHandlerInterface smppSessionHandlerInterface) {
        this.name = name;
        this.esmeManagement = esmeManagement;
        this.smppSessionHandlerInterface = smppSessionHandlerInterface;
    }

    public void start() throws Exception {
        this.executor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        this.monitorExecutor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, new ThreadFactory(){
            private AtomicInteger sequence = new AtomicInteger(0);

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("SmppServer-SessionWindowMonitorPool-" + this.sequence.getAndIncrement());
                return t;
            }
        });
        this.clientBootstrap = new DefaultSmppClient((ExecutorService)this.executor, 25, (ScheduledExecutorService)this.monitorExecutor);
        this.smppClientOpsThread = new SmppClientOpsThread(this.clientBootstrap, this.smppSessionHandlerInterface);
        new Thread(this.smppClientOpsThread).start();
        FastList<Esme> esmes = this.esmeManagement.esmes;
        FastList.Node n = esmes.head();
        FastList.Node end = esmes.tail();
        while ((n = n.getNext()) != end) {
            Esme esme = (Esme)n.getValue();
            if (esme.getSmppSessionType() != SmppSession.Type.CLIENT) continue;
            this.startSmppClientSession(esme);
        }
    }

    public void stop() throws Exception {
        this.smppClientOpsThread.setStarted(false);
        this.clientBootstrap.destroy();
        this.executor.shutdownNow();
        this.monitorExecutor.shutdownNow();
    }

    protected void startSmppClientSession(Esme esme) {
        this.smppClientOpsThread.scheduleConnect(esme);
    }

    protected void stopSmppClientSession(Esme esme) {
        DefaultSmppSession smppSession = esme.getSmppSession();
        if (smppSession != null) {
            if (smppSession.isBound()) {
                try {
                    smppSession.unbind(5000L);
                }
                catch (Exception e) {
                    logger.error((Object)String.format("Failed to unbind smpp client session for %s.", smppSession.getConfiguration().getName()));
                }
            }
            try {
                smppSession.close();
            }
            catch (Exception e) {
                logger.error((Object)String.format("Failed to close smpp client session for %s.", smppSession.getConfiguration().getName()));
            }
            Window wind = smppSession.getSendWindow();
            Map futures = wind.createSortedSnapshot();
            for (WindowFuture future : futures.values()) {
                logger.warn((Object)("Firing of onPduRequestTimeout from SmppClientManagement.stopSmppClientSession() - 1: " + ((PduRequest)future.getRequest()).toString()));
                smppSession.expired(future);
            }
            smppSession.destroy();
        }
    }

    public String getName() {
        return this.name;
    }

    public int getExpectedSessions() {
        return this.expectedSessions;
    }

    public void setExpectedSessions(int expectedSessions) {
        this.expectedSessions = expectedSessions;
    }
}

