/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.smpp;

public class GenerateType {
    public static final int FLAG_DATAGRAMM = 1;
    public static final int FLAG_TRANSACTIONAL = 2;
    public static final int FLAG_STORE_AND_FORWARD = 4;
    private int value;

    public GenerateType(int value) {
        this.value = value;
    }

    public GenerateType(boolean datagramm, boolean transactional, boolean storeAndForward) {
        this.value = (datagramm ? 1 : 0) | (transactional ? 2 : 0) | (storeAndForward ? 4 : 0);
    }

    public int getValue() {
        return this.value;
    }

    public boolean isDatagramm() {
        return (this.value & 1) != 0;
    }

    public boolean isTransactional() {
        return (this.value & 2) != 0;
    }

    public boolean isStoreAndForward() {
        return (this.value & 4) != 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GenerateType [");
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateType)) {
            return false;
        }
        GenerateType b = (GenerateType)obj;
        return this.value == b.value;
    }
}

