/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.smpp;

import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.impl.DefaultSmppSession;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javolution.text.TextBuilder;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.restcomm.smpp.Esme;
import org.restcomm.smpp.EsmeCluster;
import org.restcomm.smpp.EsmeMBean;
import org.restcomm.smpp.EsmeManagementMBean;
import org.restcomm.smpp.SmppClientManagement;
import org.restcomm.smpp.SmppInterfaceVersionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EsmeManagement
implements EsmeManagementMBean {
    private static final Logger logger = Logger.getLogger(EsmeManagement.class);
    private static final String ESME_LIST = "esmeList";
    private static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private static final XMLBinding binding = new XMLBinding();
    private static final String PERSIST_FILE_NAME = "esme.xml";
    private final String name;
    private String persistDir = null;
    protected FastList<Esme> esmes = new FastList();
    protected FastMap<String, Long> esmesServer = new FastMap();
    protected FastMap<String, EsmeCluster> esmeClusters = new FastMap();
    private final TextBuilder persistFile = TextBuilder.newInstance();
    private SmppClientManagement smppClient = null;
    private MBeanServer mbeanServer = null;
    private Timer timer;
    private TimerTask timerTask;
    private static EsmeManagement instance = null;

    protected EsmeManagement(String name) {
        this.name = name;
        binding.setClassAttribute(CLASS_ATTRIBUTE);
        binding.setAlias(Esme.class, "esme");
    }

    protected static EsmeManagement getInstance(String name) {
        if (instance == null) {
            instance = new EsmeManagement(name);
        }
        return instance;
    }

    protected static void setInstance(EsmeManagement instance) {
        EsmeManagement.instance = instance;
    }

    public static EsmeManagement getInstance() {
        return instance;
    }

    public String getName() {
        return this.name;
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    protected void setSmppClient(SmppClientManagement smppClient) {
        this.smppClient = smppClient;
    }

    @Override
    public FastList<Esme> getEsmes() {
        return this.esmes;
    }

    @Override
    public Esme getEsmeByName(String esmeName) {
        FastList.Node n = this.esmes.head();
        FastList.Node end = this.esmes.tail();
        while ((n = n.getNext()) != end) {
            Esme esme = (Esme)n.getValue();
            if (!esme.getName().equals(esmeName)) continue;
            return esme;
        }
        return null;
    }

    @Override
    public Esme getEsmeByClusterName(String esmeClusterName) {
        EsmeCluster esmeCluster = (EsmeCluster)this.esmeClusters.get((Object)esmeClusterName);
        if (esmeCluster != null) {
            return esmeCluster.getNextEsme();
        }
        return null;
    }

    protected Esme getEsmeByPrimaryKey(String SystemId, String host, int port, SmppBindType smppBindType) {
        FastList.Node n = this.esmes.head();
        FastList.Node end = this.esmes.tail();
        while ((n = n.getNext()) != end) {
            Esme esme = (Esme)n.getValue();
            if (!esme.getSystemId().equals(SystemId) || esme.getSmppBindType() != smppBindType) continue;
            if (esme.getHost().equals(host) && esme.getPort() == port) {
                return esme;
            }
            if (esme.getHost().equals(host) && esme.getPort() == -1 && esme.getStateName().equals(SmppSession.STATES[5])) {
                return esme;
            }
            if (esme.getHost().equals("-1") && esme.getPort() == port && esme.getStateName().equals(SmppSession.STATES[5])) {
                return esme;
            }
            if (!esme.getHost().equals("-1") || esme.getPort() != -1 || !esme.getStateName().equals(SmppSession.STATES[5])) continue;
            return esme;
        }
        return null;
    }

    @Override
    public Esme createEsme(String name, String systemId, String password, String host, int port, boolean chargingEnabled, String smppBindType, String systemType, String smppIntVersion, byte ton, byte npi, String address, String smppSessionType, int windowSize, long connectTimeout, long requestExpiryTimeout, long clientBindTimeout, long windowMonitorInterval, long windowWaitTimeout, String clusterName, boolean countersEnabled, int enquireLinkDelay, int enquireLinkDelayServer, long linkDropServer, int sourceTon, int sourceNpi, String sourceAddressRange, int routingTon, int routingNpi, String routingAddressRange, int networkId, boolean splitLongMessages, long rateLimitPerSecond, long rateLimitPerMinute, long rateLimitPerHour, long rateLimitPerDay, int nationalLanguageSingleShift, int nationalLanguageLockingShift, int destAddrSendLimit, int minMessageLength, int maxMessageLength) throws Exception {
        SmppBindType smppBindTypeOb = SmppBindType.valueOf((String)smppBindType);
        if (smppBindTypeOb == null) {
            throw new Exception("SmppBindType must be either of TRANSCEIVER, TRANSMITTER or RECEIVER. Passed is " + smppBindType);
        }
        SmppSession.Type smppSessionTypeObj = SmppSession.Type.valueOf((String)smppSessionType);
        if (smppSessionTypeObj == null) {
            throw new Exception("SmppSession.Type must be either of SERVER or CLIENT. Passed is " + smppSessionType);
        }
        SmppInterfaceVersionType smppInterfaceVersionTypeObj = SmppInterfaceVersionType.getInterfaceVersionType(smppIntVersion);
        if (smppInterfaceVersionTypeObj == null) {
            smppInterfaceVersionTypeObj = SmppInterfaceVersionType.SMPP34;
        }
        if (smppSessionTypeObj == SmppSession.Type.CLIENT) {
            if (port < 1) {
                throw new Exception("Creation of EMSE failed. Port cannot be less than 0 for CLIENT Sessions");
            }
            if (host == null || host.equals("-1")) {
                throw new Exception("Creation of EMSE failed. Host cannot be anonymous (-1) for CLIENT Sessions");
            }
        }
        FastList.Node n = this.esmes.head();
        FastList.Node end = this.esmes.tail();
        while ((n = n.getNext()) != end) {
            Esme esme = (Esme)n.getValue();
            if (!esme.getName().equals(name)) continue;
            throw new Exception(String.format("Creation of EMSE failed. Other ESME with name=%s already exist", name));
        }
        EsmeCluster esmeCluster = (EsmeCluster)this.esmeClusters.get((Object)clusterName);
        if (esmeCluster != null && esmeCluster.getNetworkId() != networkId) {
            throw new Exception(String.format("Creation of EMSE failed. NetworkId of the ESME cluster is %d and not equal inserted NetworkId for a new ESME %d", esmeCluster.getNetworkId(), networkId));
        }
        if (clusterName == null) {
            clusterName = name;
        }
        Esme esme = new Esme(name, systemId, password, host, port, chargingEnabled, systemType, smppInterfaceVersionTypeObj, ton, npi, address, smppBindTypeOb, smppSessionTypeObj, windowSize, connectTimeout, requestExpiryTimeout, clientBindTimeout, windowMonitorInterval, windowWaitTimeout, clusterName, countersEnabled, enquireLinkDelay, enquireLinkDelayServer, linkDropServer, sourceTon, sourceNpi, sourceAddressRange, routingTon, routingNpi, routingAddressRange, networkId, splitLongMessages, rateLimitPerSecond, rateLimitPerMinute, rateLimitPerHour, rateLimitPerDay, nationalLanguageSingleShift, nationalLanguageLockingShift, destAddrSendLimit, minMessageLength, maxMessageLength);
        esme.esmeManagement = this;
        this.esmes.add((Object)esme);
        if (esmeCluster == null) {
            esmeCluster = new EsmeCluster(clusterName, networkId);
            this.esmeClusters.put((Object)clusterName, (Object)esmeCluster);
        }
        esmeCluster.addEsme(esme);
        this.store();
        this.registerEsmeMbean(esme);
        return esme;
    }

    @Override
    public Esme destroyEsme(String esmeName) throws Exception {
        Esme esme = this.getEsmeByName(esmeName);
        if (esme == null) {
            throw new Exception(String.format("No Esme found with given name %s", esmeName));
        }
        if (esme.isStarted()) {
            throw new Exception(String.format("Cannot remove ESME. Please stop ESME before removing", new Object[0]));
        }
        this.esmes.remove((Object)esme);
        EsmeCluster esmeCluster = (EsmeCluster)this.esmeClusters.get((Object)esme.getClusterName());
        esmeCluster.removeEsme(esme);
        if (!esmeCluster.hasMoreEsmes()) {
            this.esmeClusters.remove((Object)esme.getClusterName());
        }
        this.store();
        this.unregisterEsmeMbean(esme.getName());
        return esme;
    }

    @Override
    public void startEsme(String esmeName) throws Exception {
        Esme esme = this.getEsmeByName(esmeName);
        if (esme == null) {
            throw new Exception(String.format("No Esme found with given name %s", esmeName));
        }
        if (esme.isStarted()) {
            throw new Exception(String.format("Esme with given name %s is already started", esmeName));
        }
        esme.setStarted(true);
        this.store();
        if (esme.getSmppSessionType().equals((Object)SmppSession.Type.CLIENT)) {
            this.smppClient.startSmppClientSession(esme);
        }
    }

    @Override
    public void stopEsme(String esmeName) throws Exception {
        Esme esme = this.getEsmeByName(esmeName);
        if (esme == null) {
            throw new Exception(String.format("No Esme found with given name %s", esmeName));
        }
        esme.setStarted(false);
        if (esme.getLinkDropServerEnabled()) {
            esme.resetLinkRecvMessage();
        }
        this.store();
        this.stopWrappedSession(esme);
    }

    private void stopWrappedSession(Esme esme) {
        if (esme.getSmppSessionType().equals((Object)SmppSession.Type.SERVER)) {
            DefaultSmppSession smppSession = esme.getSmppSession();
            if (smppSession != null) {
                try {
                    smppSession.close();
                }
                catch (Exception e) {
                    logger.error((Object)String.format("Failed to close smpp session for %s.", smppSession.getConfiguration().getName()));
                }
                smppSession.destroy();
            }
        } else if (this.smppClient != null) {
            this.smppClient.stopSmppClientSession(esme);
        }
    }

    public void start() throws Exception {
        try {
            if (this.mbeanServer == null) {
                this.mbeanServer = MBeanServerLocator.locateJBoss();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty("smsc.persist.dir", System.getProperty("user.dir"))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
        logger.info((Object)String.format("Loading ESME configuration from %s", this.persistFile.toString()));
        try {
            this.load();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)String.format("Failed to load the ESME configuration file. \n%s", e.getMessage()));
        }
        FastList.Node n = this.esmes.head();
        FastList.Node end = this.esmes.tail();
        while ((n = n.getNext()) != end) {
            Esme esme = (Esme)n.getValue();
            this.registerEsmeMbean(esme);
        }
        this.clearMessageClearTimer();
        this.timer = new Timer();
        this.timerTask = new MessageCleanerTimerTask();
        this.timer.scheduleAtFixedRate(this.timerTask, 0L, 1000L);
    }

    public void stop() throws Exception {
        this.clearMessageClearTimer();
        this.store();
        FastList.Node n = this.esmes.head();
        FastList.Node end = this.esmes.tail();
        while ((n = n.getNext()) != end) {
            Esme esme = (Esme)n.getValue();
            this.stopWrappedSession(esme);
            this.unregisterEsmeMbean(esme.getName());
        }
    }

    private void clearMessageClearTimer() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            writer.write(this.esmes, ESME_LIST, FastList.class);
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error while persisting the Rule state in file", (Throwable)e);
        }
    }

    public void load() throws FileNotFoundException {
        if (this.persistDir != null) {
            TextBuilder oldFileName = new TextBuilder();
            oldFileName.append(this.persistDir).append(File.separator).append("SmscManagement").append("_").append(PERSIST_FILE_NAME);
            Path oldPath = FileSystems.getDefault().getPath(oldFileName.toString(), new String[0]);
            Path newPath = FileSystems.getDefault().getPath(this.persistFile.toString(), new String[0]);
            if (Files.exists(oldPath, new LinkOption[0]) && Files.notExists(newPath, new LinkOption[0])) {
                try {
                    Files.move(oldPath, newPath, new CopyOption[0]);
                }
                catch (IOException e) {
                    logger.warn((Object)"Exception when trying to rename old config file", (Throwable)e);
                }
            }
        }
        XMLObjectReader reader = null;
        try {
            reader = XMLObjectReader.newInstance((InputStream)new FileInputStream(this.persistFile.toString()));
            reader.setBinding(binding);
            this.esmes = (FastList)reader.read(ESME_LIST, FastList.class);
            FastList.Node n = this.esmes.head();
            FastList.Node end = this.esmes.tail();
            while ((n = n.getNext()) != end) {
                Esme esme = (Esme)n.getValue();
                esme.esmeManagement = this;
                String esmeClusterName = esme.getClusterName();
                EsmeCluster esmeCluster = (EsmeCluster)this.esmeClusters.get((Object)esmeClusterName);
                if (esmeCluster == null) {
                    esmeCluster = new EsmeCluster(esmeClusterName, esme.getNetworkId());
                    this.esmeClusters.put((Object)esmeClusterName, (Object)esmeCluster);
                } else {
                    esme.setNetworkId(esmeCluster.getNetworkId());
                }
                esmeCluster.addEsme(esme);
            }
            reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    private void registerEsmeMbean(Esme esme) {
        try {
            ObjectName esmeObjNname = new ObjectName("org.restcomm.smpp:layer=Esme,name=" + esme.getName());
            StandardMBean esmeMxBean = new StandardMBean(esme, EsmeMBean.class, true);
            if (this.mbeanServer != null) {
                this.mbeanServer.registerMBean(esmeMxBean, esmeObjNname);
            }
        }
        catch (InstanceAlreadyExistsException e) {
            logger.error((Object)String.format("Error while registering MBean for ESME %s", esme.getName()), (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            logger.error((Object)String.format("Error while registering MBean for ESME %s", esme.getName()), (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            logger.error((Object)String.format("Error while registering MBean for ESME %s", esme.getName()), (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)String.format("Error while registering MBean for ESME %s", esme.getName()), (Throwable)e);
        }
    }

    private void unregisterEsmeMbean(String esmeName) {
        try {
            ObjectName esmeObjNname = new ObjectName("org.restcomm.smpp:layer=Esme,name=" + esmeName);
            if (this.mbeanServer != null) {
                this.mbeanServer.unregisterMBean(esmeObjNname);
            }
        }
        catch (MBeanRegistrationException e) {
            logger.error((Object)String.format("Error while unregistering MBean for ESME %s", esmeName), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            logger.error((Object)String.format("Error while unregistering MBean for ESME %s", esmeName), (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)String.format("Error while unregistering MBean for ESME %s", esmeName), (Throwable)e);
        }
    }

    private class MessageCleanerTimerTask
    extends TimerTask {
        private int lastDay = -1;
        private int lastHour = -1;
        private int lastMinute = -1;

        private MessageCleanerTimerTask() {
        }

        public void run() {
            boolean needDay = false;
            boolean needHour = false;
            boolean needMinute = false;
            Date tm = new Date();
            if (this.lastDay != tm.getDay()) {
                this.lastDay = tm.getDay();
                needDay = true;
            }
            if (this.lastHour != tm.getHours()) {
                this.lastHour = tm.getHours();
                needHour = true;
            }
            if (this.lastMinute != tm.getMinutes()) {
                this.lastMinute = tm.getMinutes();
                needMinute = true;
            }
            FastList.Node n = EsmeManagement.this.esmes.head();
            FastList.Node end = EsmeManagement.this.esmes.tail();
            while ((n = n.getNext()) != end) {
                Esme esme = (Esme)n.getValue();
                if (needDay) {
                    esme.clearDayMsgCounter();
                    continue;
                }
                if (needHour) {
                    esme.clearHourMsgCounter();
                    continue;
                }
                if (needMinute) {
                    esme.clearMinuteMsgCounter();
                    continue;
                }
                esme.clearSecondMsgCounter();
            }
        }
    }
}

