/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.smpp;

import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.SmppSession;
import javolution.util.FastList;
import org.restcomm.smpp.Esme;

public class EsmeCluster {
    private final String clusterName;
    private final FastList<Esme> esmes = new FastList();
    private final int networkId;
    private final FastList<Esme> esmesToSendPdu = new FastList();
    private volatile int index = 0;

    protected EsmeCluster(String clusterName, int networkId) {
        this.clusterName = clusterName;
        this.networkId = networkId;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEsme(Esme esme) {
        FastList<Esme> fastList = this.esmes;
        synchronized (fastList) {
            this.esmes.add((Object)esme);
        }
        fastList = this.esmesToSendPdu;
        synchronized (fastList) {
            if (esme.getSmppBindType() == SmppBindType.TRANSCEIVER || esme.getSmppBindType() == SmppBindType.RECEIVER && esme.getSmppSessionType() == SmppSession.Type.SERVER || esme.getSmppBindType() == SmppBindType.TRANSMITTER && esme.getSmppSessionType() == SmppSession.Type.CLIENT) {
                this.esmesToSendPdu.add((Object)esme);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEsme(Esme esme) {
        FastList<Esme> fastList = this.esmes;
        synchronized (fastList) {
            this.esmes.remove((Object)esme);
        }
        fastList = this.esmesToSendPdu;
        synchronized (fastList) {
            this.esmesToSendPdu.remove((Object)esme);
        }
    }

    synchronized Esme getNextEsme() {
        for (int i = 0; i < this.esmesToSendPdu.size(); ++i) {
            Esme esme;
            ++this.index;
            if (this.index >= this.esmesToSendPdu.size()) {
                this.index = 0;
            }
            if (!(esme = (Esme)this.esmesToSendPdu.get(this.index)).isBound()) continue;
            return esme;
        }
        return null;
    }

    boolean hasMoreEsmes() {
        return this.esmes.size() > 0;
    }
}

