/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.smpp;

import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.impl.DefaultSmppSession;
import com.cloudhopper.smpp.type.Address;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.restcomm.smpp.CheckMessageLimitResult;
import org.restcomm.smpp.EsmeMBean;
import org.restcomm.smpp.EsmeManagement;
import org.restcomm.smpp.SmppInterfaceVersionType;
import org.restcomm.smpp.SslConfigurationWrapper;

public class Esme
extends SslConfigurationWrapper
implements XMLSerializable,
EsmeMBean {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Esme.class);
    private static final String ESME_NAME = "name";
    private static final String ESME_CLUSTER_NAME = "clusterName";
    private static final String ESME_SYSTEM_ID = "systemId";
    private static final String ESME_PASSWORD = "password";
    private static final String REMOTE_HOST_IP = "host";
    private static final String REMOTE_HOST_PORT = "port";
    private static final String NETWORK_ID = "networkId";
    private static final String SPLIT_LONG_MESSAGES = "splitLongMessages";
    private static final String SMPP_BIND_TYPE = "smppBindType";
    private static final String SMPP_SESSION_TYPE = "smppSessionType";
    private static final String ESME_SYSTEM_TYPE = "systemType";
    private static final String ESME_INTERFACE_VERSION = "smppVersion";
    private static final String ESME_TON = "ton";
    private static final String ESME_NPI = "npi";
    private static final String ESME_ADDRESS_RANGE = "addressRange";
    private static final String SOURCE_TON = "sourceTon";
    private static final String SOURCE_NPI = "sourceNpi";
    private static final String SOURCE_ADDRESS_RANGE = "sourceAddressRange";
    private static final String ROUTING_TON = "routingTon";
    private static final String ROUTING_NPI = "routingNpi";
    private static final String ROUTING_ADDRESS_RANGE = "routingAddressRange";
    private static final String CHARGING_ENABLED = "chargingEnabled";
    private static final String WINDOW_SIZE = "windowSize";
    private static final String CONNECT_TIMEOUT = "connectTimeout";
    private static final String REQUEST_EXPIRY_TIMEOUT = "requestExpiryTimeout";
    private static final String CLIENT_BIND_TIMEOUT = "clientBindTimeout";
    private static final String WINDOW_MONITOR_INTERVAL = "windowMonitorInterval";
    private static final String WINDOW_WAIT_TIMEOUT = "windowWaitTimeout";
    private static final String ENQUIRE_LINK_DELAY = "enquireLinkDelay";
    private static final String ENQUIRE_LINK_DELAY_SERVER = "enquireLinkDelayServer";
    private static final String LINK_DROP_SERVER = "linkDropServer";
    private static final String COUNTERS_ENABLED = "countersEnabled";
    private static final String RATE_LIMIT_PER_SECOND = "rateLimitPerSecond";
    private static final String RATE_LIMIT_PER_MINUTE = "rateLimitPerMinute";
    private static final String RATE_LIMIT_PER_HOUR = "rateLimitPerHour";
    private static final String RATE_LIMIT_PER_DAY = "rateLimitPerDay";
    private static final String NATIONAL_LANGUAGE_SINGLE_SHIFT = "nationalLanguageSingleShift";
    private static final String NATIONAL_LANGUAGE_LOCKING_SHIFT = "nationalLanguageLockingShift";
    private static final String DEST_ADDR_SEND_LIMIT = "destAddrSendLimit";
    private static final String MIN_MESSAGE_LENGTH = "minMessageLength";
    private static final String MAX_MESSAGE_LENGTH = "maxMessageLength";
    private static final String STARTED = "started";
    private String name;
    private String clusterName;
    private String systemId;
    private String password;
    private String host;
    private int port;
    private String systemType;
    private SmppInterfaceVersionType smppVersion = null;
    private int networkId;
    private boolean splitLongMessages;
    private int esmeTon = -1;
    private int esmeNpi = -1;
    private String esmeAddressRange = null;
    private int sourceTon = -1;
    private int sourceNpi = -1;
    private String sourceAddressRange = "^[0-9a-zA-Z]*";
    private Pattern sourceAddressRangePattern = null;
    private int routingTon;
    private int routingNpi;
    private String routingAddressRange;
    private Pattern routingAddressRangePattern;
    private SmppBindType smppBindType;
    private boolean chargingEnabled = false;
    private boolean countersEnabled = true;
    private int enquireLinkDelay = 30000;
    private int enquireLinkDelayServer = 0;
    private long linkDropServer = 0L;
    private boolean linkRecvMessCheck = false;
    private boolean linkStartFirstTime = false;
    private SmppSession.Type smppSessionType = SmppSession.Type.SERVER;
    private int nationalLanguageSingleShift = -1;
    private int nationalLanguageLockingShift = -1;
    private int destAddrSendLimit = 0;
    private int minMessageLength = -1;
    private int maxMessageLength = -1;
    private int windowSize;
    private long connectTimeout;
    private long clientBindTimeout;
    private long requestExpiryTimeout;
    private long windowMonitorInterval;
    private long windowWaitTimeout;
    private long rateLimitPerSecond = 0L;
    private long rateLimitPerMinute = 0L;
    private long rateLimitPerHour = 0L;
    private long rateLimitPerDay = 0L;
    private AtomicLong receivedMsgPerSecond = new AtomicLong();
    private AtomicLong receivedMsgPerMinute = new AtomicLong();
    private AtomicLong receivedMsgPerHour = new AtomicLong();
    private AtomicLong receivedMsgPerDay = new AtomicLong();
    private AtomicLong extraMsgPerSecond = new AtomicLong();
    private AtomicLong extraMsgPerMinute = new AtomicLong();
    private AtomicLong extraMsgPerHour = new AtomicLong();
    private AtomicLong extraMsgPerDay = new AtomicLong();
    protected transient EsmeManagement esmeManagement = null;
    private boolean started = false;
    private boolean serverBound = false;
    private int enquireLinkFailCnt = 0;
    private int rxEnquireLinkCounter = -1;
    private int rxDlrRespCounter = -1;
    private int rxDataSmRespCounter = -1;
    private int rxSubmitSmRespCount = -1;
    private String state = SmppSession.STATES[5];
    private transient DefaultSmppSession defaultSmppSession = null;
    protected static final XMLFormat<Esme> ESME_XML = new XMLFormat<Esme>(Esme.class){

        public void read(XMLFormat.InputElement xml, Esme esme) throws XMLStreamException {
            esme.name = xml.getAttribute(Esme.ESME_NAME, "");
            esme.clusterName = xml.getAttribute(Esme.ESME_CLUSTER_NAME, "");
            esme.systemId = xml.getAttribute(Esme.ESME_SYSTEM_ID, "");
            esme.password = xml.getAttribute(Esme.ESME_PASSWORD, null);
            esme.host = xml.getAttribute(Esme.REMOTE_HOST_IP, "");
            esme.port = xml.getAttribute(Esme.REMOTE_HOST_PORT, -1);
            esme.networkId = xml.getAttribute(Esme.NETWORK_ID, 0);
            esme.splitLongMessages = xml.getAttribute(Esme.SPLIT_LONG_MESSAGES, false);
            esme.rateLimitPerSecond = xml.getAttribute(Esme.RATE_LIMIT_PER_SECOND, 0L);
            esme.rateLimitPerMinute = xml.getAttribute(Esme.RATE_LIMIT_PER_MINUTE, 0L);
            esme.rateLimitPerHour = xml.getAttribute(Esme.RATE_LIMIT_PER_HOUR, 0L);
            esme.rateLimitPerDay = xml.getAttribute(Esme.RATE_LIMIT_PER_DAY, 0L);
            String smppBindTypeStr = xml.getAttribute(Esme.SMPP_BIND_TYPE, "TRANSCEIVER");
            if (SmppBindType.TRANSCEIVER.toString().equals(smppBindTypeStr)) {
                esme.smppBindType = SmppBindType.TRANSCEIVER;
            } else if (SmppBindType.TRANSMITTER.toString().equals(smppBindTypeStr)) {
                esme.smppBindType = SmppBindType.TRANSMITTER;
            } else if (SmppBindType.RECEIVER.toString().equals(smppBindTypeStr)) {
                esme.smppBindType = SmppBindType.RECEIVER;
            }
            String smppSessionTypeStr = xml.getAttribute(Esme.SMPP_SESSION_TYPE, "SERVER");
            esme.smppSessionType = SmppSession.Type.valueOf((String)smppSessionTypeStr);
            esme.started = xml.getAttribute(Esme.STARTED, false);
            esme.systemType = xml.getAttribute(Esme.ESME_SYSTEM_TYPE, "");
            esme.smppVersion = SmppInterfaceVersionType.getInterfaceVersionType(xml.getAttribute(Esme.ESME_INTERFACE_VERSION, ""));
            esme.esmeTon = xml.getAttribute(Esme.ESME_TON, (byte)0);
            esme.esmeNpi = xml.getAttribute(Esme.ESME_NPI, (byte)0);
            esme.esmeAddressRange = xml.getAttribute(Esme.ESME_ADDRESS_RANGE, null);
            esme.windowSize = xml.getAttribute(Esme.WINDOW_SIZE, 0);
            esme.connectTimeout = xml.getAttribute(Esme.CONNECT_TIMEOUT, 0L);
            esme.requestExpiryTimeout = xml.getAttribute(Esme.REQUEST_EXPIRY_TIMEOUT, 0L);
            esme.clientBindTimeout = xml.getAttribute(Esme.CLIENT_BIND_TIMEOUT, 5000L);
            esme.windowMonitorInterval = xml.getAttribute(Esme.WINDOW_MONITOR_INTERVAL, 0L);
            esme.windowWaitTimeout = xml.getAttribute(Esme.WINDOW_WAIT_TIMEOUT, 0L);
            esme.countersEnabled = xml.getAttribute(Esme.COUNTERS_ENABLED, true);
            esme.enquireLinkDelay = xml.getAttribute(Esme.ENQUIRE_LINK_DELAY, 30000);
            esme.enquireLinkDelayServer = xml.getAttribute(Esme.ENQUIRE_LINK_DELAY_SERVER, 0);
            esme.linkDropServer = xml.getAttribute(Esme.LINK_DROP_SERVER, 0L);
            esme.chargingEnabled = xml.getAttribute(Esme.CHARGING_ENABLED, false);
            esme.sourceTon = xml.getAttribute(Esme.SOURCE_TON, -1);
            esme.sourceNpi = xml.getAttribute(Esme.SOURCE_NPI, -1);
            esme.sourceAddressRange = xml.getAttribute(Esme.SOURCE_ADDRESS_RANGE, "^[0-9a-zA-Z]*");
            esme.sourceAddressRangePattern = Pattern.compile(esme.sourceAddressRange);
            esme.routingTon = xml.getAttribute(Esme.ROUTING_TON, -1);
            esme.routingNpi = xml.getAttribute(Esme.ROUTING_NPI, -1);
            esme.routingAddressRange = xml.getAttribute(Esme.ROUTING_ADDRESS_RANGE, esme.esmeAddressRange);
            if (esme.routingAddressRange != null) {
                esme.routingAddressRangePattern = Pattern.compile(esme.routingAddressRange);
            }
            esme.nationalLanguageSingleShift = xml.getAttribute(Esme.NATIONAL_LANGUAGE_SINGLE_SHIFT, -1);
            esme.nationalLanguageLockingShift = xml.getAttribute(Esme.NATIONAL_LANGUAGE_LOCKING_SHIFT, -1);
            esme.destAddrSendLimit = xml.getAttribute(Esme.DEST_ADDR_SEND_LIMIT, 0);
            esme.minMessageLength = xml.getAttribute(Esme.MIN_MESSAGE_LENGTH, -1);
            esme.maxMessageLength = xml.getAttribute(Esme.MAX_MESSAGE_LENGTH, -1);
            esme.useSsl = xml.getAttribute("useSsl", false);
            esme.wrappedSslConfig.setCertAlias(xml.getAttribute("certAlias", null));
            esme.wrappedSslConfig.setCrlPath(xml.getAttribute("crlPath", null));
            esme.wrappedSslConfig.setKeyManagerFactoryAlgorithm(xml.getAttribute("keyManagerFactoryAlgorithm", "SunX509"));
            esme.wrappedSslConfig.setKeyManagerPassword(xml.getAttribute("keyManagerPassword", null));
            esme.wrappedSslConfig.setKeyStorePassword(xml.getAttribute("keyStorePassword", null));
            esme.wrappedSslConfig.setKeyStoreProvider(xml.getAttribute("keyStoreProvider", null));
            esme.wrappedSslConfig.setKeyStorePath(xml.getAttribute("keyStorePath", null));
            esme.wrappedSslConfig.setKeyStoreType(xml.getAttribute("keyStoreType", "JKS"));
            esme.wrappedSslConfig.setMaxCertPathLength(xml.getAttribute("maxCertPathLength", -1));
            esme.wrappedSslConfig.setNeedClientAuth(xml.getAttribute("needClientAuth", false));
            esme.wrappedSslConfig.setOcspResponderURL(xml.getAttribute("ocspResponderURL", null));
            esme.wrappedSslConfig.setProtocol(xml.getAttribute("protocol", "TLS"));
            esme.wrappedSslConfig.setProvider(xml.getAttribute("provider", null));
            esme.wrappedSslConfig.setSecureRandomAlgorithm(xml.getAttribute("secureRandomAlgorithm", null));
            esme.wrappedSslConfig.setSslSessionCacheSize(xml.getAttribute("sslSessionCacheSize", 0));
            esme.wrappedSslConfig.setSslSessionTimeout(xml.getAttribute("sslSessionTimeout", 0));
            esme.wrappedSslConfig.setTrustManagerFactoryAlgorithm(xml.getAttribute("trustManagerFactoryAlgorithm", "PKIX"));
            esme.wrappedSslConfig.setTrustStorePassword(xml.getAttribute("trustStorePassword", null));
            esme.wrappedSslConfig.setTrustStorePath(xml.getAttribute("trustStorePath", null));
            esme.wrappedSslConfig.setTrustStoreProvider(xml.getAttribute("trustStoreProvider", null));
            esme.wrappedSslConfig.setTrustStoreType(xml.getAttribute("trustStoreType", "JKS"));
            esme.wrappedSslConfig.setWantClientAuth(xml.getAttribute("wantClientAuth", false));
            esme.wrappedSslConfig.setAllowRenegotiate(xml.getAttribute("allowRenegotiate", true));
            esme.wrappedSslConfig.setEnableCRLDP(xml.getAttribute("enableCRLDP", false));
            esme.wrappedSslConfig.setSessionCachingEnabled(xml.getAttribute("sessionCachingEnabled", true));
            esme.wrappedSslConfig.setTrustAll(xml.getAttribute("trustAll", true));
            esme.wrappedSslConfig.setValidateCerts(xml.getAttribute("validateCerts", false));
            esme.wrappedSslConfig.setValidatePeerCerts(xml.getAttribute("validatePeerCerts", false));
        }

        public void write(Esme esme, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(Esme.ESME_NAME, esme.name);
            xml.setAttribute(Esme.ESME_CLUSTER_NAME, esme.clusterName);
            xml.setAttribute(Esme.ESME_SYSTEM_ID, esme.systemId);
            xml.setAttribute(Esme.ESME_PASSWORD, esme.password);
            xml.setAttribute(Esme.REMOTE_HOST_IP, esme.host);
            xml.setAttribute(Esme.REMOTE_HOST_PORT, esme.port);
            xml.setAttribute(Esme.NETWORK_ID, esme.networkId);
            xml.setAttribute(Esme.SPLIT_LONG_MESSAGES, esme.splitLongMessages);
            xml.setAttribute(Esme.RATE_LIMIT_PER_SECOND, esme.rateLimitPerSecond);
            xml.setAttribute(Esme.RATE_LIMIT_PER_MINUTE, esme.rateLimitPerMinute);
            xml.setAttribute(Esme.RATE_LIMIT_PER_HOUR, esme.rateLimitPerHour);
            xml.setAttribute(Esme.RATE_LIMIT_PER_DAY, esme.rateLimitPerDay);
            xml.setAttribute(Esme.SMPP_BIND_TYPE, esme.smppBindType.toString());
            xml.setAttribute(Esme.SMPP_SESSION_TYPE, esme.smppSessionType.toString());
            xml.setAttribute(Esme.STARTED, esme.started);
            xml.setAttribute(Esme.ESME_INTERFACE_VERSION, esme.smppVersion.getType());
            if (esme.systemType != null) {
                xml.setAttribute(Esme.ESME_SYSTEM_TYPE, esme.systemType);
            }
            xml.setAttribute(Esme.ESME_TON, esme.esmeTon);
            xml.setAttribute(Esme.ESME_NPI, esme.esmeNpi);
            xml.setAttribute(Esme.ESME_ADDRESS_RANGE, esme.esmeAddressRange);
            xml.setAttribute(Esme.NATIONAL_LANGUAGE_SINGLE_SHIFT, esme.nationalLanguageSingleShift);
            xml.setAttribute(Esme.NATIONAL_LANGUAGE_LOCKING_SHIFT, esme.nationalLanguageLockingShift);
            xml.setAttribute(Esme.DEST_ADDR_SEND_LIMIT, esme.destAddrSendLimit);
            xml.setAttribute(Esme.MIN_MESSAGE_LENGTH, esme.minMessageLength);
            xml.setAttribute(Esme.MAX_MESSAGE_LENGTH, esme.maxMessageLength);
            xml.setAttribute(Esme.WINDOW_SIZE, esme.windowSize);
            xml.setAttribute(Esme.CONNECT_TIMEOUT, esme.connectTimeout);
            xml.setAttribute(Esme.REQUEST_EXPIRY_TIMEOUT, esme.requestExpiryTimeout);
            xml.setAttribute(Esme.CLIENT_BIND_TIMEOUT, esme.clientBindTimeout);
            xml.setAttribute(Esme.WINDOW_MONITOR_INTERVAL, esme.windowMonitorInterval);
            xml.setAttribute(Esme.WINDOW_WAIT_TIMEOUT, esme.windowWaitTimeout);
            xml.setAttribute(Esme.COUNTERS_ENABLED, esme.countersEnabled);
            xml.setAttribute(Esme.ENQUIRE_LINK_DELAY, esme.enquireLinkDelay);
            xml.setAttribute(Esme.ENQUIRE_LINK_DELAY_SERVER, esme.enquireLinkDelayServer);
            xml.setAttribute(Esme.LINK_DROP_SERVER, esme.linkDropServer);
            xml.setAttribute(Esme.CHARGING_ENABLED, esme.chargingEnabled);
            xml.setAttribute(Esme.SOURCE_TON, esme.sourceTon);
            xml.setAttribute(Esme.SOURCE_NPI, esme.sourceNpi);
            xml.setAttribute(Esme.SOURCE_ADDRESS_RANGE, esme.sourceAddressRange);
            xml.setAttribute(Esme.ROUTING_TON, esme.routingTon);
            xml.setAttribute(Esme.ROUTING_NPI, esme.routingNpi);
            xml.setAttribute(Esme.ROUTING_ADDRESS_RANGE, esme.routingAddressRange);
            xml.setAttribute("useSsl", esme.useSsl);
            xml.setAttribute("certAlias", esme.wrappedSslConfig.getCertAlias());
            xml.setAttribute("crlPath", esme.wrappedSslConfig.getCrlPath());
            xml.setAttribute("keyManagerFactoryAlgorithm", esme.wrappedSslConfig.getKeyManagerFactoryAlgorithm());
            xml.setAttribute("keyManagerPassword", esme.wrappedSslConfig.getKeyManagerPassword());
            xml.setAttribute("keyStorePassword", esme.wrappedSslConfig.getKeyStorePassword());
            xml.setAttribute("keyStoreProvider", esme.wrappedSslConfig.getKeyStoreProvider());
            xml.setAttribute("keyStorePath", esme.wrappedSslConfig.getKeyStorePath());
            xml.setAttribute("keyStoreType", esme.wrappedSslConfig.getKeyStoreType());
            xml.setAttribute("maxCertPathLength", esme.wrappedSslConfig.getMaxCertPathLength());
            xml.setAttribute("needClientAuth", esme.wrappedSslConfig.getNeedClientAuth());
            xml.setAttribute("ocspResponderURL", esme.wrappedSslConfig.getOcspResponderURL());
            xml.setAttribute("protocol", esme.wrappedSslConfig.getProtocol());
            xml.setAttribute("provider", esme.wrappedSslConfig.getProvider());
            xml.setAttribute("secureRandomAlgorithm", esme.wrappedSslConfig.getSecureRandomAlgorithm());
            xml.setAttribute("sslSessionCacheSize", esme.wrappedSslConfig.getSslSessionCacheSize());
            xml.setAttribute("sslSessionTimeout", esme.wrappedSslConfig.getSslSessionTimeout());
            xml.setAttribute("trustManagerFactoryAlgorithm", esme.wrappedSslConfig.getTrustManagerFactoryAlgorithm());
            xml.setAttribute("trustStorePassword", esme.wrappedSslConfig.getTrustStorePassword());
            xml.setAttribute("trustStorePath", esme.wrappedSslConfig.getTrustStorePath());
            xml.setAttribute("trustStoreProvider", esme.wrappedSslConfig.getTrustStoreProvider());
            xml.setAttribute("trustStoreType", esme.wrappedSslConfig.getTrustStoreType());
            xml.setAttribute("wantClientAuth", esme.wrappedSslConfig.getWantClientAuth());
            xml.setAttribute("allowRenegotiate", esme.wrappedSslConfig.isAllowRenegotiate());
            xml.setAttribute("enableCRLDP", esme.wrappedSslConfig.isEnableCRLDP());
            xml.setAttribute("sessionCachingEnabled", esme.wrappedSslConfig.isSessionCachingEnabled());
            xml.setAttribute("trustAll", esme.wrappedSslConfig.isTrustAll());
            xml.setAttribute("validateCerts", esme.wrappedSslConfig.isValidateCerts());
            xml.setAttribute("validatePeerCerts", esme.wrappedSslConfig.isValidatePeerCerts());
        }
    };

    public Esme() {
    }

    public Esme(String name, String systemId, String password, String host, int port, boolean chargingEnabled, String systemType, SmppInterfaceVersionType smppVersion, int esmeTon, int esmeNpi, String esmeAddressRange, SmppBindType smppBindType, SmppSession.Type smppSessionType, int windowSize, long connectTimeout, long requestExpiryTimeout, long clientBindTimeout, long windowMonitorInterval, long windowWaitTimeout, String clusterName, boolean countersEnabled, int enquireLinkDelay, int enquireLinkDelayServer, long linkDropServer, int sourceTon, int sourceNpi, String sourceAddressRange, int routingTon, int routingNpi, String routingAddressRange, int networkId, boolean splitLongMessages, long rateLimitPerSecond, long rateLimitPerMinute, long rateLimitPerHour, long rateLimitPerDay, int nationalLanguageSingleShift, int nationalLanguageLockingShift, int destAddrSendLimit, int minMessageLength, int maxMessageLength) {
        this.name = name;
        this.systemId = systemId;
        this.password = password;
        this.host = host;
        this.port = port;
        this.chargingEnabled = chargingEnabled;
        this.systemType = systemType;
        this.smppVersion = smppVersion;
        this.esmeTon = esmeTon;
        this.esmeNpi = esmeNpi;
        this.esmeAddressRange = esmeAddressRange;
        this.smppBindType = smppBindType;
        this.smppSessionType = smppSessionType;
        this.windowSize = windowSize;
        this.connectTimeout = connectTimeout;
        this.requestExpiryTimeout = requestExpiryTimeout;
        this.clientBindTimeout = clientBindTimeout;
        this.windowMonitorInterval = windowMonitorInterval;
        this.windowWaitTimeout = windowWaitTimeout;
        this.clusterName = clusterName;
        this.countersEnabled = countersEnabled;
        this.enquireLinkDelay = enquireLinkDelay;
        this.enquireLinkDelayServer = enquireLinkDelayServer;
        this.linkDropServer = linkDropServer;
        this.sourceTon = sourceTon;
        this.sourceNpi = sourceNpi;
        this.sourceAddressRange = sourceAddressRange;
        if (this.sourceAddressRange != null) {
            this.sourceAddressRangePattern = Pattern.compile(this.sourceAddressRange);
        }
        this.routingTon = routingTon;
        this.routingNpi = routingNpi;
        this.routingAddressRange = routingAddressRange;
        if (this.routingAddressRange != null) {
            this.routingAddressRangePattern = Pattern.compile(this.routingAddressRange);
        }
        this.networkId = networkId;
        this.splitLongMessages = splitLongMessages;
        this.rateLimitPerSecond = rateLimitPerSecond;
        this.rateLimitPerMinute = rateLimitPerMinute;
        this.rateLimitPerHour = rateLimitPerHour;
        this.rateLimitPerDay = rateLimitPerDay;
        this.nationalLanguageSingleShift = nationalLanguageSingleShift;
        this.nationalLanguageLockingShift = nationalLanguageLockingShift;
        this.destAddrSendLimit = destAddrSendLimit;
        this.minMessageLength = minMessageLength;
        this.maxMessageLength = maxMessageLength;
    }

    public String getName() {
        return this.name;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    protected void setClusterName(String clusterName) {
        this.clusterName = clusterName;
        this.store();
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
        this.store();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.store();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.store();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.store();
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(int networkId) {
        this.networkId = networkId;
        this.store();
    }

    public boolean getSplitLongMessages() {
        return this.splitLongMessages;
    }

    public void setSplitLongMessages(boolean splitLongMessages) {
        this.splitLongMessages = splitLongMessages;
        this.store();
    }

    public SmppBindType getSmppBindType() {
        return this.smppBindType;
    }

    protected void setSmppBindType(SmppBindType smppBindType) {
        this.smppBindType = smppBindType;
        this.store();
    }

    public String getSystemType() {
        return this.systemType;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
        this.store();
    }

    public SmppInterfaceVersionType getSmppVersion() {
        return this.smppVersion;
    }

    public void setSmppVersion(SmppInterfaceVersionType smppVersion) {
        this.smppVersion = smppVersion;
        this.store();
    }

    public int getSourceTon() {
        return this.sourceTon;
    }

    public void setSourceTon(int sourceTon) {
        this.sourceTon = sourceTon;
        this.store();
    }

    public int getSourceNpi() {
        return this.sourceNpi;
    }

    public void setSourceNpi(int sourceNpi) {
        this.sourceNpi = sourceNpi;
        this.store();
    }

    public String getSourceAddressRange() {
        return this.sourceAddressRange;
    }

    public void setSourceAddressRange(String sourceAddressRange) {
        this.sourceAddressRange = sourceAddressRange;
        if (this.sourceAddressRange != null) {
            this.sourceAddressRangePattern = Pattern.compile(this.sourceAddressRange);
        }
        this.store();
    }

    public int getRoutingTon() {
        return this.routingTon;
    }

    public void setRoutingTon(int routingTon) {
        this.routingTon = routingTon;
        this.store();
    }

    public int getRoutingNpi() {
        return this.routingNpi;
    }

    public void setRoutingNpi(int routingNpi) {
        this.routingNpi = routingNpi;
        this.store();
    }

    public String getRoutingAddressRange() {
        return this.routingAddressRange;
    }

    public void setRoutingAddressRange(String routingAddressRange) {
        this.routingAddressRange = routingAddressRange;
        if (this.routingAddressRange != null) {
            this.routingAddressRangePattern = Pattern.compile(this.routingAddressRange);
        }
        this.store();
    }

    public int getEsmeTon() {
        return this.esmeTon;
    }

    public void setEsmeTon(int esmeTon) {
        this.esmeTon = esmeTon;
        this.store();
    }

    public int getEsmeNpi() {
        return this.esmeNpi;
    }

    public void setEsmeNpi(int esmeNpi) {
        this.esmeNpi = esmeNpi;
        this.store();
    }

    public String getEsmeAddressRange() {
        return this.esmeAddressRange;
    }

    public void setEsmeAddressRange(String esmeAddressRange) {
        this.esmeAddressRange = esmeAddressRange;
        this.store();
    }

    public SmppSession.Type getSmppSessionType() {
        return this.smppSessionType;
    }

    public void setSmppSessionType(SmppSession.Type smppSessionType) {
        this.smppSessionType = smppSessionType;
        this.store();
    }

    public int getNationalLanguageSingleShift() {
        return this.nationalLanguageSingleShift;
    }

    public void setNationalLanguageSingleShift(int nationalLanguageSingleShift) {
        this.nationalLanguageSingleShift = nationalLanguageSingleShift;
        this.store();
    }

    public int getDestAddrSendLimit() {
        return this.destAddrSendLimit;
    }

    public void setDestAddrSendLimit(int destAddrSendLimit) {
        this.destAddrSendLimit = destAddrSendLimit;
        this.store();
    }

    public int getMinMessageLength() {
        return this.minMessageLength;
    }

    public void setMinMessageLength(int minMessageLength) {
        this.minMessageLength = minMessageLength;
        this.store();
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public void setMaxMessageLength(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
        this.store();
    }

    public int getNationalLanguageLockingShift() {
        return this.nationalLanguageLockingShift;
    }

    public void setNationalLanguageLockingShift(int nationalLanguageLockingShift) {
        this.nationalLanguageLockingShift = nationalLanguageLockingShift;
        this.store();
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
        this.store();
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        this.store();
    }

    public long getRequestExpiryTimeout() {
        return this.requestExpiryTimeout;
    }

    public void setRequestExpiryTimeout(long requestExpiryTimeout) {
        this.requestExpiryTimeout = requestExpiryTimeout;
        this.store();
    }

    public long getClientBindTimeout() {
        return this.clientBindTimeout;
    }

    public void setClientBindTimeout(long clientBindTimeout) {
        this.clientBindTimeout = clientBindTimeout;
        this.store();
    }

    public long getWindowMonitorInterval() {
        return this.windowMonitorInterval;
    }

    public void setWindowMonitorInterval(long windowMonitorInterval) {
        this.windowMonitorInterval = windowMonitorInterval;
        this.store();
    }

    public long getWindowWaitTimeout() {
        return this.windowWaitTimeout;
    }

    public void setWindowWaitTimeout(long windowWaitTimeout) {
        this.windowWaitTimeout = windowWaitTimeout;
        this.store();
    }

    public long getRateLimitPerSecond() {
        return this.rateLimitPerSecond;
    }

    public void setRateLimitPerSecond(long value) {
        this.rateLimitPerSecond = value;
        this.store();
    }

    public long getRateLimitPerMinute() {
        return this.rateLimitPerMinute;
    }

    public void setRateLimitPerMinute(long value) {
        this.rateLimitPerMinute = value;
        this.store();
    }

    public long getRateLimitPerHour() {
        return this.rateLimitPerHour;
    }

    public void setRateLimitPerHour(long value) {
        this.rateLimitPerHour = value;
        this.store();
    }

    public long getRateLimitPerDay() {
        return this.rateLimitPerDay;
    }

    public void setRateLimitPerDay(long value) {
        this.rateLimitPerDay = value;
        this.store();
    }

    public boolean isStarted() {
        return this.started;
    }

    protected void setStarted(boolean started) {
        this.started = started;
        if (started) {
            this.clearDayMsgCounter();
        }
    }

    public boolean isServerBound() {
        return this.serverBound;
    }

    protected void setServerBound(boolean serverBound) {
        this.serverBound = serverBound;
    }

    public DefaultSmppSession getSmppSession() {
        return this.defaultSmppSession;
    }

    public void setSmppSession(DefaultSmppSession smppSession) {
        this.defaultSmppSession = smppSession;
    }

    public int getEnquireLinkDelay() {
        return this.enquireLinkDelay;
    }

    public void setEnquireLinkDelay(int enquireLinkDelay) {
        this.enquireLinkDelay = enquireLinkDelay;
        this.store();
    }

    public int getEnquireLinkDelayServer() {
        return this.enquireLinkDelayServer;
    }

    public void setEnquireLinkDelayServer(int enquireLinkDelayServer) {
        this.enquireLinkDelayServer = enquireLinkDelayServer;
        this.store();
    }

    public long getLinkDropServer() {
        return this.linkDropServer;
    }

    public void setLinkDropServer(long linkDropServer) {
        this.linkDropServer = linkDropServer;
        this.store();
    }

    public boolean isCountersEnabled() {
        return this.countersEnabled;
    }

    public void setCountersEnabled(boolean countersEnabled) {
        this.countersEnabled = countersEnabled;
        this.store();
    }

    public boolean isChargingEnabled() {
        return this.chargingEnabled;
    }

    public void setChargingEnabled(boolean chargingEnabled) {
        this.chargingEnabled = chargingEnabled;
        this.store();
    }

    public boolean isSourceAddressMatching(Address sourceAddress) {
        if (this.sourceTon != -1 && this.sourceTon != sourceAddress.getTon()) {
            return false;
        }
        if (this.sourceNpi != -1 && this.sourceNpi != sourceAddress.getNpi()) {
            return false;
        }
        Matcher m = this.sourceAddressRangePattern.matcher(sourceAddress.getAddress());
        return m.matches();
    }

    public boolean isRoutingAddressMatching(int destTon, int destNpi, String destAddress) {
        if (this.routingTon != -1 && this.routingTon != destTon) {
            return false;
        }
        if (this.routingNpi != -1 && this.routingNpi != destNpi) {
            return false;
        }
        Matcher m = this.routingAddressRangePattern.matcher(destAddress);
        return m.matches();
    }

    public int getEnquireLinkFail() {
        return this.enquireLinkFailCnt;
    }

    public void resetEnquireLinkFail() {
        this.enquireLinkFailCnt = 0;
    }

    public void incEnquireLinkFail() {
        ++this.enquireLinkFailCnt;
    }

    public boolean getEnquireClientEnabled() {
        return this.enquireLinkDelay > 0;
    }

    public boolean getEnquireServerEnabled() {
        return this.enquireLinkDelayServer > 0;
    }

    public boolean getLinkDropServerEnabled() {
        return !this.getEnquireServerEnabled() && this.linkDropServer > 0L;
    }

    public boolean checkLinkRecvMessage() {
        int currentEnqLinkCounter = this.defaultSmppSession.getCounters().getRxEnquireLink().getRequest();
        int currentDlrRespCounter = this.defaultSmppSession.getCounters().getTxDeliverSM().getResponse();
        int currentDataSmRespCounter = this.defaultSmppSession.getCounters().getTxDataSM().getResponse();
        int currentSubmitSmRespCounter = this.defaultSmppSession.getCounters().getTxSubmitSM().getResponse();
        if (this.rxEnquireLinkCounter < currentEnqLinkCounter || this.rxSubmitSmRespCount < currentSubmitSmRespCounter || this.rxDlrRespCounter < currentDlrRespCounter || this.rxDataSmRespCounter < currentDataSmRespCounter) {
            this.linkRecvMessCheck = true;
        }
        this.rxEnquireLinkCounter = currentEnqLinkCounter;
        this.rxDlrRespCounter = currentDlrRespCounter;
        this.rxDataSmRespCounter = currentDataSmRespCounter;
        this.rxSubmitSmRespCount = currentSubmitSmRespCounter;
        return this.linkRecvMessCheck;
    }

    public void resetLinkRecvMessage() {
        this.rxEnquireLinkCounter = -1;
        this.rxDlrRespCounter = -1;
        this.rxDataSmRespCounter = -1;
        this.rxSubmitSmRespCount = -1;
    }

    public void setLinkRecvMessage(boolean recveivedMessage) {
        this.linkRecvMessCheck = recveivedMessage;
    }

    public boolean getLinkStartFirstTime() {
        return this.linkStartFirstTime;
    }

    public void setLinkStartFirstTime(boolean linkStarted) {
        this.linkStartFirstTime = linkStarted;
    }

    public void show(StringBuffer sb) {
        sb.append("ESME name=").append(this.name).append(" systemId=").append(this.systemId).append(" state=").append(this.getStateName()).append(" password=").append(this.password).append(" host=").append(this.host).append(" port=").append(this.port).append(" networkId=").append(this.networkId).append(" chargingEnabled=").append(this.chargingEnabled).append(" bindType=").append(this.smppBindType).append(" systemType=").append(this.systemType).append(" smppInterfaceVersion=").append((Object)this.smppVersion).append(" ton=").append(this.esmeTon).append(" npi=").append(this.esmeNpi).append(" address=").append(this.esmeAddressRange).append(" clusterName=").append(this.clusterName).append(" sourceTon=").append(this.sourceTon).append(" sourceNpi=").append(this.sourceNpi).append(" sourceAddress=").append(this.sourceAddressRange).append(" routingTon=").append(this.routingTon).append(" routingNpi=").append(this.routingNpi).append(" routingAddress=").append(this.routingAddressRange).append(" rateLimitPerSecond=").append(this.rateLimitPerSecond).append(" rateLimitPerMinute=").append(this.rateLimitPerMinute).append(" rateLimitPerHour=").append(this.rateLimitPerHour).append(" rateLimitPerDay=").append(this.rateLimitPerDay).append(" secondReceivedMsgCount=").append(this.getSecondReceivedMsgCount()).append(" minuteReceivedMsgCount=").append(this.getMinuteReceivedMsgCount()).append(" hourReceivedMsgCount=").append(this.getHourReceivedMsgCount()).append(" dayReceivedMsgCount=").append(this.getDayReceivedMsgCount()).append(" nationalLanguageSingleShift=").append(this.getNationalLanguageSingleShift()).append(" nationalLanguageLockingShift=").append(this.getNationalLanguageLockingShift()).append(" destAddrSendLimit=").append(this.destAddrSendLimit).append(" minMessageLength=").append(this.getMinMessageLength()).append(" maxMessageLength=").append(this.getMaxMessageLength()).append(" split-long-messages=").append(this.splitLongMessages);
        sb.append("\n");
    }

    public void close() {
        if (this.defaultSmppSession != null) {
            try {
                this.defaultSmppSession.close();
            }
            catch (Exception e) {
                logger.error((Object)String.format("Failed to close smpp session for %s.", this.defaultSmppSession.getConfiguration().getName()));
            }
        }
    }

    public void close(long arg0) {
        if (this.defaultSmppSession != null) {
            try {
                this.defaultSmppSession.close(arg0);
            }
            catch (Exception e) {
                logger.error((Object)String.format("Failed to close smpp session for %s.", this.defaultSmppSession.getConfiguration().getName()));
            }
        }
    }

    public void destroy() {
        if (this.defaultSmppSession != null) {
            this.defaultSmppSession.destroy();
        }
    }

    public void disableLogBytes() {
        if (this.defaultSmppSession != null) {
            this.defaultSmppSession.disableLogBytes();
        }
    }

    public void disableLogPdu() {
        if (this.defaultSmppSession != null) {
            this.defaultSmppSession.disableLogPdu();
        }
    }

    public String[] dumpWindow() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.dumpWindow();
        }
        return null;
    }

    public void enableLogBytes() {
        if (this.defaultSmppSession != null) {
            this.defaultSmppSession.enableLogBytes();
        }
    }

    public void enableLogPdu() {
        if (this.defaultSmppSession != null) {
            this.defaultSmppSession.enableLogPdu();
        }
    }

    public String getBindTypeName() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getBindTypeName();
        }
        return this.smppBindType.toString();
    }

    public String getBoundDuration() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getBoundDuration();
        }
        return null;
    }

    public String getInterfaceVersionName() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getInterfaceVersionName();
        }
        return this.smppVersion.getType();
    }

    public String getLocalAddressAndPort() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getLocalAddressAndPort();
        }
        return null;
    }

    public String getLocalTypeName() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getLocalTypeName();
        }
        return this.smppSessionType.toString();
    }

    public int getMaxWindowSize() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getMaxWindowSize();
        }
        return 0;
    }

    public int getNextSequenceNumber() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getNextSequenceNumber();
        }
        return 0;
    }

    public String getRemoteAddressAndPort() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getRemoteAddressAndPort();
        }
        return null;
    }

    public String getRemoteTypeName() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getRemoteTypeName();
        }
        if (this.smppSessionType == SmppSession.Type.SERVER) {
            return SmppSession.Type.CLIENT.toString();
        }
        return SmppSession.Type.SERVER.toString();
    }

    public String getRxDataSMCounter() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getRxDataSMCounter();
        }
        return null;
    }

    public String getRxDeliverSMCounter() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getRxDeliverSMCounter();
        }
        return null;
    }

    public String getRxEnquireLinkCounter() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getRxEnquireLinkCounter();
        }
        return null;
    }

    public String getRxSubmitSMCounter() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getRxSubmitSMCounter();
        }
        return null;
    }

    public String getStateName() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getStateName();
        }
        return this.state;
    }

    protected void setStateName(String name) {
        this.state = name;
    }

    public String getTxDataSMCounter() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getTxDataSMCounter();
        }
        return null;
    }

    public String getTxDeliverSMCounter() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getTxDeliverSMCounter();
        }
        return null;
    }

    public String getTxEnquireLinkCounter() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getTxEnquireLinkCounter();
        }
        return null;
    }

    public String getTxSubmitSMCounter() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getTxSubmitSMCounter();
        }
        return null;
    }

    public String getRxDataSMCounterAndReset() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getRxDataSMCounterAndReset();
        }
        return null;
    }

    public String getRxDeliverSMCounterAndReset() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getRxDeliverSMCounterAndReset();
        }
        return null;
    }

    public String getRxEnquireLinkCounterAndReset() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getRxEnquireLinkCounterAndReset();
        }
        return null;
    }

    public String getRxSubmitSMCounterAndReset() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getRxSubmitSMCounterAndReset();
        }
        return null;
    }

    public String getTxDataSMCounterAndReset() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getTxDataSMCounterAndReset();
        }
        return null;
    }

    public String getTxDeliverSMCounterAndReset() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getTxDeliverSMCounterAndReset();
        }
        return null;
    }

    public String getTxEnquireLinkCounterAndReset() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getTxEnquireLinkCounterAndReset();
        }
        return null;
    }

    public String getTxSubmitSMCounterAndReset() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.getTxSubmitSMCounterAndReset();
        }
        return null;
    }

    public boolean isBinding() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.isBinding();
        }
        return false;
    }

    public boolean isBound() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.isBound();
        }
        return false;
    }

    public boolean isClosed() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.isClosed();
        }
        return true;
    }

    public boolean isOpen() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.isOpen();
        }
        return false;
    }

    public boolean isUnbinding() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.isUnbinding();
        }
        return false;
    }

    public boolean isWindowMonitorEnabled() {
        if (this.defaultSmppSession != null) {
            return this.defaultSmppSession.isWindowMonitorEnabled();
        }
        return false;
    }

    public void resetCounters() {
        if (this.defaultSmppSession != null) {
            this.defaultSmppSession.resetCounters();
        }
        this.rxEnquireLinkCounter = 0;
    }

    public void unbind(long arg0) {
        if (this.defaultSmppSession != null) {
            try {
                this.defaultSmppSession.unbind(arg0);
            }
            catch (Exception e) {
                logger.error((Object)String.format("Failed to unbind smpp session for %s.", this.defaultSmppSession.getConfiguration().getName()));
            }
        }
    }

    public CheckMessageLimitResult onMessageReceived(int count) {
        this.linkRecvMessCheck = true;
        long cntSecond = this.receivedMsgPerSecond.addAndGet(count);
        if (this.rateLimitPerSecond > 0L && cntSecond > this.rateLimitPerSecond) {
            this.receivedMsgPerSecond.addAndGet(-count);
            if (this.extraMsgPerSecond.addAndGet(1L) == 1L) {
                return new CheckMessageLimitResult(CheckMessageLimitResult.Result.firstFault, "RateLimitPerSecond is exceeded for ESME=" + this.name, CheckMessageLimitResult.Domain.perSecond);
            }
            return new CheckMessageLimitResult(CheckMessageLimitResult.Result.nextFault, "RateLimitPerSecond is exceeded for ESME=" + this.name, CheckMessageLimitResult.Domain.perSecond);
        }
        long cntMinute = this.receivedMsgPerMinute.addAndGet(count);
        if (this.rateLimitPerMinute > 0L && cntMinute > this.rateLimitPerMinute) {
            this.receivedMsgPerMinute.addAndGet(-count);
            if (this.extraMsgPerMinute.addAndGet(1L) == 1L) {
                return new CheckMessageLimitResult(CheckMessageLimitResult.Result.firstFault, "RateLimitPerMinute is exceeded for ESME=" + this.name, CheckMessageLimitResult.Domain.perMinute);
            }
            return new CheckMessageLimitResult(CheckMessageLimitResult.Result.nextFault, "RateLimitPerMinute is exceeded for ESME=" + this.name, CheckMessageLimitResult.Domain.perMinute);
        }
        long cntHour = this.receivedMsgPerHour.addAndGet(count);
        if (this.rateLimitPerHour > 0L && cntHour > this.rateLimitPerHour) {
            this.receivedMsgPerHour.addAndGet(-count);
            if (this.extraMsgPerHour.addAndGet(1L) == 1L) {
                return new CheckMessageLimitResult(CheckMessageLimitResult.Result.firstFault, "RateLimitPerHour is exceeded for ESME=" + this.name, CheckMessageLimitResult.Domain.perHour);
            }
            return new CheckMessageLimitResult(CheckMessageLimitResult.Result.nextFault, "RateLimitPerHour is exceeded for ESME=" + this.name, CheckMessageLimitResult.Domain.perHour);
        }
        long cntDay = this.receivedMsgPerDay.addAndGet(count);
        if (this.rateLimitPerDay > 0L && cntDay > this.rateLimitPerDay) {
            this.receivedMsgPerDay.addAndGet(-count);
            if (this.extraMsgPerDay.addAndGet(1L) == 1L) {
                return new CheckMessageLimitResult(CheckMessageLimitResult.Result.firstFault, "RateLimitPerDay is exceeded for ESME=" + this.name, CheckMessageLimitResult.Domain.perDay);
            }
            return new CheckMessageLimitResult(CheckMessageLimitResult.Result.nextFault, "RateLimitPerDay is exceeded for ESME=" + this.name, CheckMessageLimitResult.Domain.perDay);
        }
        return new CheckMessageLimitResult(CheckMessageLimitResult.Result.ok, null, null);
    }

    public void clearSecondMsgCounter() {
        this.receivedMsgPerSecond.set(0L);
        this.extraMsgPerSecond.set(0L);
    }

    public void clearMinuteMsgCounter() {
        this.receivedMsgPerSecond.set(0L);
        this.receivedMsgPerMinute.set(0L);
        this.extraMsgPerSecond.set(0L);
        this.extraMsgPerMinute.set(0L);
    }

    public void clearHourMsgCounter() {
        this.receivedMsgPerSecond.set(0L);
        this.receivedMsgPerMinute.set(0L);
        this.receivedMsgPerHour.set(0L);
        this.extraMsgPerSecond.set(0L);
        this.extraMsgPerMinute.set(0L);
        this.extraMsgPerHour.set(0L);
    }

    public void clearDayMsgCounter() {
        this.receivedMsgPerSecond.set(0L);
        this.receivedMsgPerMinute.set(0L);
        this.receivedMsgPerHour.set(0L);
        this.receivedMsgPerDay.set(0L);
        this.extraMsgPerSecond.set(0L);
        this.extraMsgPerMinute.set(0L);
        this.extraMsgPerHour.set(0L);
        this.extraMsgPerDay.set(0L);
    }

    public long getSecondReceivedMsgCount() {
        return this.receivedMsgPerSecond.get();
    }

    public long getMinuteReceivedMsgCount() {
        return this.receivedMsgPerMinute.get();
    }

    public long getHourReceivedMsgCount() {
        return this.receivedMsgPerHour.get();
    }

    public long getDayReceivedMsgCount() {
        return this.receivedMsgPerDay.get();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Esme other = (Esme)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public void store() {
        this.esmeManagement.store();
    }
}

