/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.smpp;

import com.cloudhopper.commons.util.windowing.Window;
import com.cloudhopper.commons.util.windowing.WindowFuture;
import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.SmppServerHandler;
import com.cloudhopper.smpp.SmppServerSession;
import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.impl.DefaultSmppSession;
import com.cloudhopper.smpp.pdu.BaseBind;
import com.cloudhopper.smpp.pdu.BaseBindResp;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.type.Address;
import com.cloudhopper.smpp.type.SmppProcessingException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.restcomm.smpp.Esme;
import org.restcomm.smpp.EsmeManagement;
import org.restcomm.smpp.SmppManagement;
import org.restcomm.smpp.SmppServerOpsThread;
import org.restcomm.smpp.SmppSessionHandlerInterface;

public class DefaultSmppServerHandler
implements SmppServerHandler {
    private static final Logger logger = Logger.getLogger(DefaultSmppServerHandler.class);
    private final SmppSessionHandlerInterface smppSessionHandlerInterface;
    private final EsmeManagement esmeManagement;
    private final SmppServerOpsThread smppServerOpsThread;

    public DefaultSmppServerHandler(EsmeManagement esmeManagement, SmppServerOpsThread smppServerOpsThread, SmppSessionHandlerInterface smppSessionHandlerInterface) {
        this.esmeManagement = esmeManagement;
        this.smppServerOpsThread = smppServerOpsThread;
        this.smppSessionHandlerInterface = smppSessionHandlerInterface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionBindRequested(Long sessionId, SmppSessionConfiguration sessionConfiguration, BaseBind bindRequest) throws SmppProcessingException {
        DefaultSmppServerHandler defaultSmppServerHandler = this;
        synchronized (defaultSmppServerHandler) {
            if (this.smppSessionHandlerInterface == null) {
                logger.error((Object)"Received BIND request but no SmppSessionHandlerInterface registered yet! Will close SmppServerSession");
                throw new SmppProcessingException(13);
            }
            SmppBindType smppBindType = this.getSmppBindType(bindRequest.getCommandId());
            Esme esme = this.esmeManagement.getEsmeByPrimaryKey(bindRequest.getSystemId(), sessionConfiguration.getHost(), sessionConfiguration.getPort(), smppBindType);
            if (esme == null) {
                logger.error((Object)String.format("Received BIND request but no ESME configured for SystemId=%s Host=%s Port=%d SmppBindType=%s", bindRequest.getSystemId(), sessionConfiguration.getHost(), sessionConfiguration.getPort(), smppBindType));
                throw new SmppProcessingException(15);
            }
            if (!esme.isStarted()) {
                logger.error((Object)String.format("Received BIND request but ESME is not yet started for name %s", esme.getName()));
                throw new SmppProcessingException(13);
            }
            if (!esme.getStateName().equals(SmppSession.STATES[5])) {
                logger.error((Object)String.format("Received BIND request but ESME Already in Bound State Name=%s SystemId=%s Host=%s Port=%d", esme.getName(), bindRequest.getSystemId(), esme.getHost(), esme.getPort()));
                throw new SmppProcessingException(5);
            }
            if (esme.getPassword() != null && !esme.getPassword().equals(bindRequest.getPassword())) {
                logger.error((Object)String.format("Received BIND request with password=%s but password set for ESME=%s for SystemId=%s", bindRequest.getPassword(), esme.getPassword(), bindRequest.getSystemId()));
                throw new SmppProcessingException(14);
            }
            Address bindRequestAddressRange = bindRequest.getAddressRange();
            if (esme.getEsmeTon() != -1 && esme.getEsmeTon() != bindRequestAddressRange.getTon()) {
                logger.error((Object)String.format("Received BIND request with TON=%d but configured TON=%d", bindRequestAddressRange.getTon(), esme.getEsmeTon()));
                throw new SmppProcessingException(4);
            }
            if (esme.getEsmeNpi() != -1 && esme.getEsmeNpi() != bindRequestAddressRange.getNpi()) {
                logger.error((Object)String.format("Received BIND request with NPI=%d but configured NPI=%d", bindRequestAddressRange.getNpi(), esme.getEsmeNpi()));
                throw new SmppProcessingException(4);
            }
            if (bindRequestAddressRange.getAddress() == null || bindRequestAddressRange.getAddress() == "") {
                bindRequestAddressRange.setAddress(esme.getEsmeAddressRange());
            } else if (!bindRequestAddressRange.getAddress().equals(esme.getEsmeAddressRange())) {
                logger.error((Object)String.format("Received BIND request with Address_Range=%s but configured Address_Range=%s", bindRequestAddressRange.getAddress(), esme.getEsmeAddressRange()));
                throw new SmppProcessingException(4);
            }
            sessionConfiguration.setAddressRange(bindRequestAddressRange);
            sessionConfiguration.setCountersEnabled(esme.isCountersEnabled());
            sessionConfiguration.setName(esme.getName());
            sessionConfiguration.setWriteTimeout(SmppManagement.getInstance().getSmppServerManagement().getWriteTimeout());
            esme.setStateName(SmppSession.STATES[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionCreated(Long sessionId, SmppServerSession session, BaseBindResp preparedBindResponse) throws SmppProcessingException {
        DefaultSmppServerHandler defaultSmppServerHandler = this;
        synchronized (defaultSmppServerHandler) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("Session created: Name=%s SystemId=%s", session.getConfiguration().getName(), session.getConfiguration().getSystemId()));
            }
            if (this.smppSessionHandlerInterface == null) {
                logger.error((Object)"No SmppSessionHandlerInterface registered yet! Will close SmppServerSession");
                throw new SmppProcessingException(13);
            }
            SmppSessionConfiguration sessionConfiguration = session.getConfiguration();
            Esme esme = this.esmeManagement.getEsmeByName(sessionConfiguration.getName());
            if (esme == null) {
                logger.error((Object)String.format("No ESME for Name=%s SystemId=%s Host=%s Port=%d SmppBindType=%s", sessionConfiguration.getSystemId(), sessionConfiguration.getHost(), sessionConfiguration.getPort(), sessionConfiguration.getType()));
                throw new SmppProcessingException(13);
            }
            esme.setSmppSession((DefaultSmppSession)session);
            if (!logger.isDebugEnabled()) {
                session.getConfiguration().getLoggingOptions().setLogBytes(false);
                session.getConfiguration().getLoggingOptions().setLogPdu(false);
            }
            SmppSessionHandler smppSessionHandler = this.smppSessionHandlerInterface.createNewSmppSessionHandler(esme);
            session.serverReady(smppSessionHandler);
            esme.setServerBound(true);
            esme.setLinkStartFirstTime(true);
            this.smppServerOpsThread.scheduleList(esme.getName(), 0L);
        }
    }

    public void sessionDestroyed(Long sessionId, SmppServerSession session) {
        this.sessionDestroyed((SmppSession)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(SmppSession session) {
        DefaultSmppServerHandler defaultSmppServerHandler = this;
        synchronized (defaultSmppServerHandler) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)String.format("Session destroyed: %s", session.getConfiguration().getSystemId()));
            }
            if (session.hasCounters()) {
                logger.info((Object)String.format("final session rx-submitSM: %s", session.getCounters().getRxSubmitSM()));
            }
            String esmeName = session.getConfiguration().getName();
            Esme esmeServer = this.esmeManagement.getEsmeByName(esmeName);
            esmeServer.setServerBound(false);
            esmeServer.resetEnquireLinkFail();
            this.smppServerOpsThread.removeEnquireList(esmeName);
            this.smppSessionHandlerInterface.destroySmppSessionHandler(esmeServer);
            DefaultSmppSession defaultSession = (DefaultSmppSession)session;
            Window wind = defaultSession.getSendWindow();
            Map futures = wind.createSortedSnapshot();
            for (WindowFuture future : futures.values()) {
                logger.warn((Object)("Firing of onPduRequestTimeout from DefaultSmppServerHandler.sessionDestroyed(): " + ((PduRequest)future.getRequest()).toString()));
                defaultSession.expired(future);
            }
            session.destroy();
        }
    }

    private SmppBindType getSmppBindType(int commandId) {
        switch (commandId) {
            case 1: {
                return SmppBindType.RECEIVER;
            }
            case 2: {
                return SmppBindType.TRANSMITTER;
            }
            case 9: {
                return SmppBindType.TRANSCEIVER;
            }
        }
        return null;
    }
}

