/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.log;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.concurrent.Callable;
import org.rapidoid.RapidoidThing;
import org.rapidoid.event.Event;
import org.rapidoid.event.Fire;
import org.rapidoid.log.GlobalCfg;
import org.rapidoid.log.LogLevel;
import org.rapidoid.log.LogOptions;
import org.rapidoid.log.LogStats;
import org.rapidoid.u.U;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;

public class Log
extends RapidoidThing {
    public static final LogLevel LEVEL_TRACE = LogLevel.TRACE;
    public static final LogLevel LEVEL_DEBUG = LogLevel.DEBUG;
    public static final LogLevel LEVEL_INFO = LogLevel.INFO;
    public static final LogLevel LEVEL_WARN = LogLevel.WARN;
    public static final LogLevel LEVEL_ERROR = LogLevel.ERROR;
    public static final LogLevel LEVEL_FATAL = LogLevel.FATAL;
    public static final LogLevel LEVEL_NO_LOGS = LogLevel.NO_LOGS;
    protected static volatile LogLevel LOG_LEVEL = LEVEL_INFO;
    private static final LogOptions options = new LogOptions();

    private Log() {
    }

    public static synchronized void args(String ... args) {
        for (String arg : args) {
            for (LogLevel level : LogLevel.values()) {
                if (!arg.equalsIgnoreCase(level.name())) continue;
                Log.setLogLevel(level);
            }
        }
    }

    public static synchronized void reset() {
        Log.setLogLevel(GlobalCfg.quiet() ? LogLevel.ERROR : LogLevel.INFO);
        LogStats.reset();
    }

    public static synchronized void setLogLevel(LogLevel logLevel) {
        if (LOG_LEVEL != logLevel) {
            Log.info("Changing log level", "from", (Object)LOG_LEVEL, "to", (Object)logLevel);
        }
        LOG_LEVEL = logLevel;
    }

    public static synchronized LogLevel getLogLevel() {
        return LOG_LEVEL;
    }

    public static void debugging() {
        Log.setLogLevel(LEVEL_DEBUG);
    }

    public static LogOptions options() {
        return options;
    }

    public static boolean hasErrors() {
        return LogStats.hasErrors();
    }

    private static String getCallingClass() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        for (int i = 2; i < trace.length; ++i) {
            String cls = trace[i].getClassName();
            if (cls.startsWith(Log.class.getCanonicalName()) || cls.startsWith("org.rapidoid.util.UTILS")) continue;
            return cls;
        }
        return Log.class.getCanonicalName();
    }

    private static void formatLogMsg(Appendable out, String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6, String key7, Object value7, int paramsN) {
        try {
            boolean bold = msg.startsWith("!");
            if (bold) {
                msg = msg.substring(1);
            }
            Log.appendFancy(out, msg, bold);
            switch (paramsN) {
                case 0: {
                    break;
                }
                case 1: {
                    Log.printKeyValue(out, key1, value1);
                    break;
                }
                case 2: {
                    Log.printKeyValue(out, key1, value1);
                    Log.printKeyValue(out, key2, value2);
                    break;
                }
                case 3: {
                    Log.printKeyValue(out, key1, value1);
                    Log.printKeyValue(out, key2, value2);
                    Log.printKeyValue(out, key3, value3);
                    break;
                }
                case 4: {
                    Log.printKeyValue(out, key1, value1);
                    Log.printKeyValue(out, key2, value2);
                    Log.printKeyValue(out, key3, value3);
                    Log.printKeyValue(out, key4, value4);
                    break;
                }
                case 5: {
                    Log.printKeyValue(out, key1, value1);
                    Log.printKeyValue(out, key2, value2);
                    Log.printKeyValue(out, key3, value3);
                    Log.printKeyValue(out, key4, value4);
                    Log.printKeyValue(out, key5, value5);
                    break;
                }
                case 6: {
                    Log.printKeyValue(out, key1, value1);
                    Log.printKeyValue(out, key2, value2);
                    Log.printKeyValue(out, key3, value3);
                    Log.printKeyValue(out, key4, value4);
                    Log.printKeyValue(out, key5, value5);
                    Log.printKeyValue(out, key6, value6);
                    break;
                }
                case 7: {
                    Log.printKeyValue(out, key1, value1);
                    Log.printKeyValue(out, key2, value2);
                    Log.printKeyValue(out, key3, value3);
                    Log.printKeyValue(out, key4, value4);
                    Log.printKeyValue(out, key5, value5);
                    Log.printKeyValue(out, key6, value6);
                    Log.printKeyValue(out, key7, value7);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot render log message!", e);
        }
    }

    private static void printKeyValue(Appendable out, String key, Object value) throws IOException {
        boolean bold = key.startsWith("!");
        if (bold) {
            key = key.substring(1);
        }
        if ((key.equalsIgnoreCase("password") || key.endsWith("password")) && value instanceof String && U.notEmpty((String)value)) {
            value = "*****";
        }
        out.append(" | ");
        out.append(key);
        out.append(" = ");
        Log.appendFancy(out, value, bold);
        if (value instanceof Throwable) {
            Throwable err = (Throwable)value;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            err.printStackTrace(new PrintStream(stream));
            out.append("\n");
            out.append(stream.toString());
        }
    }

    private static void appendFancy(Appendable out, Object value, boolean bold) throws IOException {
        boolean withStyle = options.fancy();
        if (bold && withStyle) {
            out.append("\u001b[1m");
        }
        out.append(Log.printable(value));
        if (bold && withStyle) {
            out.append("\u001b[0m");
        }
    }

    private static String printable(Object value) {
        return U.str(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(String topic, LogLevel level, String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6, String key7, Object value7, int paramsN) {
        Logger logger;
        if (U.compare(level, LEVEL_ERROR) >= 0) {
            LogStats.hasErrors(true);
        }
        boolean visible = Log.isEnabled(level);
        Event ev = level.event();
        switch (paramsN) {
            case 0: {
                Fire.event(ev, "_", msg, "_visible", visible);
                break;
            }
            case 1: {
                Fire.event(ev, "_", msg, "_visible", visible, key1, value1);
                break;
            }
            case 2: {
                Fire.event(ev, "_", msg, "_visible", visible, key1, value1, key2, value2);
                break;
            }
            case 3: {
                Fire.event(ev, "_", msg, "_visible", visible, key1, value1, key2, value2, key3, value3);
                break;
            }
            case 4: {
                Fire.event(ev, "_", msg, "_visible", visible, key1, value1, key2, value2, key3, value3, key4, value4);
                break;
            }
            case 5: {
                Fire.event(ev, "_", msg, "_visible", visible, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5);
                break;
            }
            case 6: {
                Fire.event(ev, "_", msg, "_visible", visible, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6);
                break;
            }
            case 7: {
                Fire.event(ev, "_", msg, "_visible", visible, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, key7, value7);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (!visible) {
            return;
        }
        if (topic == null && options.inferCaller()) {
            topic = Log.getCallingClass();
        }
        if ((logger = Log.logger()) == null || logger instanceof NOPLogger) {
            StringBuilder sb = new StringBuilder();
            if (options.prefix() != null) {
                sb.append(options.prefix());
            }
            sb.append(level.name());
            if (options.showDateTime()) {
                sb.append(" | ");
                sb.append(Log.options().dateTimeFormat().format(new Date()));
            }
            if (options.showThread()) {
                sb.append(" | ");
                sb.append(Thread.currentThread().getName());
            }
            if (topic != null) {
                sb.append(" | ");
                sb.append(topic);
            }
            sb.append(" | ");
            Log.formatLogMsg(sb, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, key7, value7, paramsN);
            PrintStream printStream = System.out;
            synchronized (printStream) {
                System.out.println(sb.toString());
            }
            return;
        }
        switch (level) {
            case TRACE: {
                if (!logger.isTraceEnabled()) break;
                StringBuilder sb = new StringBuilder();
                Log.formatLogMsg(sb, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, key7, value7, paramsN);
                logger.trace(sb.toString());
                break;
            }
            case DEBUG: {
                if (!logger.isDebugEnabled()) break;
                StringBuilder sb = new StringBuilder();
                Log.formatLogMsg(sb, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, key7, value7, paramsN);
                logger.debug(sb.toString());
                break;
            }
            case INFO: {
                if (!logger.isInfoEnabled()) break;
                StringBuilder sb = new StringBuilder();
                Log.formatLogMsg(sb, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, key7, value7, paramsN);
                logger.info(sb.toString());
                break;
            }
            case WARN: {
                if (!logger.isWarnEnabled()) break;
                StringBuilder sb = new StringBuilder();
                Log.formatLogMsg(sb, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, key7, value7, paramsN);
                logger.warn(sb.toString());
                break;
            }
            case ERROR: 
            case FATAL: {
                if (!logger.isErrorEnabled()) break;
                StringBuilder sb = new StringBuilder();
                Log.formatLogMsg(sb, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, key7, value7, paramsN);
                logger.error(sb.toString());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Logger logger() {
        if (options.loggerFactory() == null) {
            Class<Log> clazz = Log.class;
            // MONITORENTER : org.rapidoid.log.Log.class
            if (options.loggerFactory() == null) {
                options.loggerFactory(Log.createLoggerFactory());
            }
            // MONITOREXIT : clazz
        }
        try {
            return options.loggerFactory().call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Callable<Logger> createLoggerFactory() {
        if (!Log.hasClass("org.rapidoid.log.slf4j.RapidoidLoggerFactory") && Log.hasClass("org.slf4j.LoggerFactory") && Log.hasClass("org.slf4j.impl.StaticLoggerBinder")) {
            return Log.createSlf4jLoggerFactory();
        }
        return Log.createNullLoggerFactory();
    }

    private static boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static Callable<Logger> createSlf4jLoggerFactory() {
        return new Callable<Logger>(){

            @Override
            public Logger call() throws Exception {
                return LoggerFactory.getLogger((String)Log.getCallingClass());
            }
        };
    }

    private static Callable<Logger> createNullLoggerFactory() {
        return new Callable<Logger>(){

            @Override
            public Logger call() throws Exception {
                return null;
            }
        };
    }

    public static boolean isTraceEnabled() {
        return Log.isEnabled(LEVEL_TRACE);
    }

    public static boolean isDebugEnabled() {
        return Log.isEnabled(LEVEL_DEBUG);
    }

    public static boolean isInfoEnabled() {
        return Log.isEnabled(LEVEL_INFO);
    }

    public static boolean isWarnEnabled() {
        return Log.isEnabled(LEVEL_WARN);
    }

    public static boolean isErrorEnabled() {
        return Log.isEnabled(LEVEL_ERROR);
    }

    public static boolean isFatalEnabled() {
        return Log.isEnabled(LEVEL_FATAL);
    }

    public static boolean isEnabled(LogLevel level) {
        return level.ordinal() >= LOG_LEVEL.ordinal();
    }

    public static boolean isEnabled(String topic, LogLevel level) {
        return level.ordinal() >= LOG_LEVEL.ordinal();
    }

    public static void log(String topic, LogLevel level, String msg) {
        Log.log(topic, level, msg, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0);
    }

    public static void log(String topic, LogLevel level, String msg, String key, Object value) {
        Log.log(topic, level, msg, key, value, null, null, null, null, null, null, null, null, null, null, null, null, 1);
    }

    public static void log(String topic, LogLevel level, String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(topic, level, msg, key1, value1, key2, value2, null, null, null, null, null, null, null, null, null, null, 2);
    }

    public static void log(String topic, LogLevel level, String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(topic, level, msg, key1, value1, key2, value2, key3, value3, null, null, null, null, null, null, null, null, 3);
    }

    public static void log(String topic, LogLevel level, String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        Log.log(topic, level, msg, key1, value1, key2, value2, key3, value3, key4, value4, null, null, null, null, null, null, 4);
    }

    public static void log(String topic, LogLevel level, String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5) {
        Log.log(topic, level, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, null, null, null, null, 5);
    }

    public static void log(String topic, LogLevel level, String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6) {
        Log.log(topic, level, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, null, null, 6);
    }

    public static void log(String topic, LogLevel level, String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6, String key7, Object value7) {
        Log.log(topic, level, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, key7, value7, 7);
    }

    public static void log(String topic, LogLevel level, String msg, Throwable err) {
        if (Log.isEnabled(level)) {
            Log.log(topic, level, msg, "message", err.getMessage());
            err.printStackTrace();
        }
    }

    public static void trace(String msg) {
        Log.log(null, LEVEL_TRACE, msg, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0);
    }

    public static void trace(String msg, String key, Object value) {
        Log.log(null, LEVEL_TRACE, msg, key, value, null, null, null, null, null, null, null, null, null, null, null, null, 1);
    }

    public static void trace(String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(null, LEVEL_TRACE, msg, key1, value1, key2, value2, null, null, null, null, null, null, null, null, null, null, 2);
    }

    public static void trace(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(null, LEVEL_TRACE, msg, key1, value1, key2, value2, key3, value3, null, null, null, null, null, null, null, null, 3);
    }

    public static void trace(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        Log.log(null, LEVEL_TRACE, msg, key1, value1, key2, value2, key3, value3, key4, value4, null, null, null, null, null, null, 4);
    }

    public static void trace(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5) {
        Log.log(null, LEVEL_TRACE, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, null, null, null, null, 5);
    }

    public static void trace(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6) {
        Log.log(null, LEVEL_TRACE, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, null, null, 6);
    }

    public static void trace(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6, String key7, Object value7) {
        Log.log(null, LEVEL_TRACE, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, key7, value7, 7);
    }

    public static void trace(String msg, Throwable err) {
        if (Log.isTraceEnabled()) {
            Log.trace(msg, "message", err.getMessage());
            err.printStackTrace();
        }
    }

    public static void debug(String msg) {
        Log.log(null, LEVEL_DEBUG, msg, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0);
    }

    public static void debug(String msg, String key, Object value) {
        Log.log(null, LEVEL_DEBUG, msg, key, value, null, null, null, null, null, null, null, null, null, null, null, null, 1);
    }

    public static void debug(String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(null, LEVEL_DEBUG, msg, key1, value1, key2, value2, null, null, null, null, null, null, null, null, null, null, 2);
    }

    public static void debug(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(null, LEVEL_DEBUG, msg, key1, value1, key2, value2, key3, value3, null, null, null, null, null, null, null, null, 3);
    }

    public static void debug(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        Log.log(null, LEVEL_DEBUG, msg, key1, value1, key2, value2, key3, value3, key4, value4, null, null, null, null, null, null, 4);
    }

    public static void debug(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5) {
        Log.log(null, LEVEL_DEBUG, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, null, null, null, null, 5);
    }

    public static void debug(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6) {
        Log.log(null, LEVEL_DEBUG, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, null, null, 6);
    }

    public static void debug(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6, String key7, Object value7) {
        Log.log(null, LEVEL_DEBUG, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, key7, value7, 7);
    }

    public static void debug(String msg, Throwable err) {
        if (Log.isDebugEnabled()) {
            Log.debug(msg, "message", err.getMessage());
            err.printStackTrace();
        }
    }

    public static void info(String msg) {
        Log.log(null, LEVEL_INFO, msg, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0);
    }

    public static void info(String msg, String key, Object value) {
        Log.log(null, LEVEL_INFO, msg, key, value, null, null, null, null, null, null, null, null, null, null, null, null, 1);
    }

    public static void info(String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(null, LEVEL_INFO, msg, key1, value1, key2, value2, null, null, null, null, null, null, null, null, null, null, 2);
    }

    public static void info(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(null, LEVEL_INFO, msg, key1, value1, key2, value2, key3, value3, null, null, null, null, null, null, null, null, 3);
    }

    public static void info(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        Log.log(null, LEVEL_INFO, msg, key1, value1, key2, value2, key3, value3, key4, value4, null, null, null, null, null, null, 4);
    }

    public static void info(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5) {
        Log.log(null, LEVEL_INFO, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, null, null, null, null, 5);
    }

    public static void info(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6) {
        Log.log(null, LEVEL_INFO, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, null, null, 6);
    }

    public static void info(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6, String key7, Object value7) {
        Log.log(null, LEVEL_INFO, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, key7, value7, 7);
    }

    public static void info(String msg, Throwable err) {
        if (Log.isInfoEnabled()) {
            Log.info(msg, "message", err.getMessage());
            err.printStackTrace();
        }
    }

    public static void warn(String msg) {
        Log.log(null, LEVEL_WARN, msg, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0);
    }

    public static void warn(String msg, String key, Object value) {
        Log.log(null, LEVEL_WARN, msg, key, value, null, null, null, null, null, null, null, null, null, null, null, null, 1);
    }

    public static void warn(String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(null, LEVEL_WARN, msg, key1, value1, key2, value2, null, null, null, null, null, null, null, null, null, null, 2);
    }

    public static void warn(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(null, LEVEL_WARN, msg, key1, value1, key2, value2, key3, value3, null, null, null, null, null, null, null, null, 3);
    }

    public static void warn(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        Log.log(null, LEVEL_WARN, msg, key1, value1, key2, value2, key3, value3, key4, value4, null, null, null, null, null, null, 4);
    }

    public static void warn(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5) {
        Log.log(null, LEVEL_WARN, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, null, null, null, null, 5);
    }

    public static void warn(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6) {
        Log.log(null, LEVEL_WARN, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, null, null, 6);
    }

    public static void warn(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6, String key7, Object value7) {
        Log.log(null, LEVEL_WARN, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, key7, value7, 7);
    }

    public static void warn(String msg, Throwable err) {
        if (Log.isWarnEnabled()) {
            Log.warn(msg, "message", err.getMessage());
            err.printStackTrace();
        }
    }

    public static void error(String msg) {
        Log.log(null, LEVEL_ERROR, msg, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0);
    }

    public static void error(String msg, String key, Object value) {
        Log.log(null, LEVEL_ERROR, msg, key, value, null, null, null, null, null, null, null, null, null, null, null, null, 1);
    }

    public static void error(String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(null, LEVEL_ERROR, msg, key1, value1, key2, value2, null, null, null, null, null, null, null, null, null, null, 2);
    }

    public static void error(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(null, LEVEL_ERROR, msg, key1, value1, key2, value2, key3, value3, null, null, null, null, null, null, null, null, 3);
    }

    public static void error(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        Log.log(null, LEVEL_ERROR, msg, key1, value1, key2, value2, key3, value3, key4, value4, null, null, null, null, null, null, 4);
    }

    public static void error(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5) {
        Log.log(null, LEVEL_ERROR, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, null, null, null, null, 5);
    }

    public static void error(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6) {
        Log.log(null, LEVEL_ERROR, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, null, null, 6);
    }

    public static void error(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6, String key7, Object value7) {
        Log.log(null, LEVEL_ERROR, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, key7, value7, 7);
    }

    public static void error(String msg, Throwable err) {
        if (Log.isErrorEnabled()) {
            Log.error(msg, "type", err.getClass().getName(), "message", err.getMessage());
            err.printStackTrace();
        }
    }

    public static void fatal(String msg) {
        Log.log(null, LEVEL_FATAL, msg, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 0);
    }

    public static void fatal(String msg, String key, Object value) {
        Log.log(null, LEVEL_FATAL, msg, key, value, null, null, null, null, null, null, null, null, null, null, null, null, 1);
    }

    public static void fatal(String msg, String key1, Object value1, String key2, Object value2) {
        Log.log(null, LEVEL_FATAL, msg, key1, value1, key2, value2, null, null, null, null, null, null, null, null, null, null, 2);
    }

    public static void fatal(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3) {
        Log.log(null, LEVEL_FATAL, msg, key1, value1, key2, value2, key3, value3, null, null, null, null, null, null, null, null, 3);
    }

    public static void fatal(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4) {
        Log.log(null, LEVEL_FATAL, msg, key1, value1, key2, value2, key3, value3, key4, value4, null, null, null, null, null, null, 4);
    }

    public static void fatal(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5) {
        Log.log(null, LEVEL_FATAL, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, null, null, null, null, 5);
    }

    public static void fatal(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6) {
        Log.log(null, LEVEL_FATAL, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, null, null, 6);
    }

    public static void fatal(String msg, String key1, Object value1, String key2, Object value2, String key3, Object value3, String key4, Object value4, String key5, Object value5, String key6, Object value6, String key7, Object value7) {
        Log.log(null, LEVEL_FATAL, msg, key1, value1, key2, value2, key3, value3, key4, value4, key5, value5, key6, value6, key7, value7, 7);
    }

    public static void fatal(String msg, Throwable err) {
        if (Log.isFatalEnabled()) {
            Log.fatal(msg, "message", err.getMessage());
            err.printStackTrace();
        }
    }
}

