/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.tooltip;

import java.io.IOException;
import java.io.Writer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.expression.SearchExpressionFacade;
import org.primefaces.extensions.component.tooltip.Tooltip;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.EscapeUtils;
import org.primefaces.util.FastStringWriter;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class TooltipRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        boolean hasText;
        Tooltip tooltip = (Tooltip)component;
        String clientId = tooltip.getClientId(context);
        String header = tooltip.getHeader();
        String styleClass = tooltip.getStyleClass();
        boolean global = tooltip.isGlobal();
        boolean shared = tooltip.isShared();
        boolean autoShow = tooltip.isAutoShow();
        boolean mouseTracking = tooltip.isMouseTracking();
        String target = null;
        if (!global || tooltip.getFor() != null) {
            target = SearchExpressionFacade.resolveClientIds((FacesContext)context, (UIComponent)tooltip, (String)tooltip.getFor());
        }
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtTooltip", tooltip.resolveWidgetVar(), clientId);
        wb.attr("global", Boolean.valueOf(global));
        wb.attr("shared", Boolean.valueOf(shared));
        wb.attr("autoShow", Boolean.valueOf(autoShow));
        if (target == null) {
            wb.nativeAttr("forTarget", null);
        } else {
            wb.attr("forTarget", target);
        }
        ResponseWriter writer = context.getResponseWriter();
        wb.append(",content: {");
        String text = null;
        if (tooltip.getChildCount() > 0) {
            FastStringWriter fsw = new FastStringWriter();
            ResponseWriter clonedWriter = writer.cloneWithWriter((Writer)fsw);
            context.setResponseWriter(clonedWriter);
            this.renderChildren(context, (UIComponent)tooltip);
            context.setResponseWriter(writer);
            text = fsw.toString();
        } else {
            String valueToRender = ComponentUtils.getValueToRender((FacesContext)context, (UIComponent)tooltip);
            if (valueToRender != null) {
                text = valueToRender;
            }
        }
        boolean bl = hasText = !global && !LangUtils.isValueBlank((String)text);
        if (hasText) {
            wb.append("text: \"" + EscapeUtils.forJavaScript((String)text) + "\"");
        }
        if (!LangUtils.isValueBlank((String)header)) {
            String headerValue = "";
            if (hasText) {
                headerValue = ",";
            }
            headerValue = headerValue + "title: \"" + EscapeUtils.forJavaScript((String)header) + "\"";
            wb.append(headerValue);
        }
        wb.append("}");
        boolean isStyled = !LangUtils.isValueBlank((String)styleClass);
        wb.append(",style: {");
        wb.append("widget:" + !isStyled);
        if (isStyled) {
            wb.append(",classes:'" + styleClass + "'");
        }
        wb.append("}");
        if (mouseTracking) {
            wb.append(",hide:{fixed:true}");
        } else if (shared && !global) {
            wb.append(",show:{target:PrimeFaces.expressions.SearchExpressionFacade.resolveComponentsAsSelector('" + target + "'),delay:" + tooltip.getShowDelay() + ",effect:function(){$(this)." + tooltip.getShowEffect() + "(" + tooltip.getShowEffectLength() + ");}}");
            wb.append(",hide:{target:PrimeFaces.expressions.SearchExpressionFacade.resolveComponentsAsSelector('" + target + "'),delay:" + tooltip.getHideDelay() + ",fixed:" + tooltip.isFixed() + ",effect:function(){$(this)." + tooltip.getHideEffect() + "(" + tooltip.getHideEffectLength() + ");}}");
        } else if (autoShow) {
            wb.append(",show:{when:false,ready:true}");
            wb.append(",hide:false");
        } else {
            wb.append(",show:{event:'" + tooltip.getShowEvent() + "',delay:" + tooltip.getShowDelay() + ",effect:function(){$(this)." + tooltip.getShowEffect() + "(" + tooltip.getShowEffectLength() + ");}}");
            wb.append(",hide:{event:'" + tooltip.getHideEvent() + "',delay:" + tooltip.getHideDelay() + ",fixed:" + tooltip.isFixed() + ",effect:function(){$(this)." + tooltip.getHideEffect() + "(" + tooltip.getHideEffectLength() + ");}}");
        }
        wb.append(",position: {");
        wb.append("at:'" + tooltip.getAtPosition() + "'");
        wb.append(",my:'" + tooltip.getMyPosition() + "'");
        wb.append(",adjust:{x:" + tooltip.getAdjustX() + ",y:" + tooltip.getAdjustY() + "}");
        wb.append(",viewport:$(window)");
        if (mouseTracking) {
            wb.append(",target:'mouse'");
        } else if (shared && !global) {
            wb.append(",target:'event'");
            wb.append(",effect:false");
        }
        wb.append("}");
        wb.finish();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

