/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.letteravatar;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;
import javax.faces.render.Renderer;
import org.primefaces.extensions.component.letteravatar.LetterAvatar;

@FacesRenderer(componentFamily="org.primefaces.extensions.component", rendererType="org.primefaces.extensions.component.LetterAvatarRenderer")
public class LetterAvatarRenderer
extends Renderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException("No context defined!");
        }
        LetterAvatar letterAvatar = (LetterAvatar)component;
        this.encodeMarkup(context, letterAvatar);
    }

    public void encodeMarkup(FacesContext context, LetterAvatar letterAvatar) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Integer width = letterAvatar.getWidth();
        Integer height = letterAvatar.getHeight();
        String avatar = letterAvatar.getValue();
        Boolean rounded = letterAvatar.isRounded();
        String clientId = letterAvatar.getClientId(context);
        String style = letterAvatar.getStyle();
        String styleClass = letterAvatar.getStyleClass();
        styleClass = styleClass == null ? "ui-letteravatar" : "ui-letteravatar " + styleClass;
        writer.startElement("img", (UIComponent)letterAvatar);
        writer.writeAttribute("id", (Object)clientId, null);
        if (rounded.booleanValue()) {
            styleClass = styleClass + " " + "ui-letteravatar-rounded";
        }
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.writeAttribute("width", (Object)width, null);
        writer.writeAttribute("height", (Object)height, null);
        writer.writeAttribute("avatar", (Object)avatar, null);
        writer.endElement("img");
    }
}

