/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.inputphone;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.commons.lang3.StringUtils;
import org.primefaces.extensions.component.inputphone.InputPhone;
import org.primefaces.extensions.util.MessageFactory;
import org.primefaces.json.JSONArray;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.WidgetBuilder;

public class InputPhoneRenderer
extends InputRenderer {
    private static final String MESSAGE_INVALID_VALUE_KEY = "primefaces.extensions.inputphone.INVALID";

    public void decode(FacesContext context, UIComponent component) {
        InputPhone inputPhone = (InputPhone)component;
        if (!this.shouldDecode((UIInput)inputPhone)) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)inputPhone);
        String inputId = inputPhone.getClientId(context) + "_input";
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(inputId);
        if (submittedValue != null) {
            inputPhone.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        InputPhone inputPhone = (InputPhone)component;
        Object value = inputPhone.getValue();
        String valueToRender = ComponentUtils.getValueToRender((FacesContext)context, (UIComponent)inputPhone, (Object)value);
        if (valueToRender == null) {
            valueToRender = "";
        }
        this.encodeMarkup(context, inputPhone, valueToRender);
        this.encodeScript(context, inputPhone);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        String value = (String)submittedValue;
        if (LangUtils.isValueBlank((String)value)) {
            return null;
        }
        InputPhone inputPhone = (InputPhone)component;
        Converter converter = inputPhone.getConverter();
        if (converter != null) {
            return converter.getAsObject(context, (UIComponent)inputPhone, value);
        }
        String country = (String)context.getExternalContext().getRequestParameterMap().get(inputPhone.getClientId() + "_iso2");
        if (country == null || "auto".equals(country)) {
            country = "";
        }
        try {
            PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
            Phonenumber.PhoneNumber phoneNumber = phoneNumberUtil.parse((CharSequence)value, country.toUpperCase());
            if (!phoneNumberUtil.isValidNumber(phoneNumber)) {
                throw this.getInvalidValueConverterException();
            }
            return value;
        }
        catch (NumberParseException e) {
            throw this.getInvalidValueConverterException();
        }
    }

    protected ConverterException getInvalidValueConverterException() {
        return new ConverterException(MessageFactory.getMessage(MESSAGE_INVALID_VALUE_KEY, FacesMessage.SEVERITY_ERROR, new Object[0]));
    }

    protected void encodeMarkup(FacesContext context, InputPhone inputPhone, String valueToRender) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = inputPhone.getClientId(context);
        String styleClass = inputPhone.getStyleClass();
        styleClass = styleClass == null ? "ui-inputphone ui-widget" : "ui-inputphone ui-widget " + styleClass;
        writer.startElement("span", (UIComponent)inputPhone);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (inputPhone.getStyle() != null) {
            writer.writeAttribute("style", (Object)inputPhone.getStyle(), "style");
        }
        this.encodeInput(context, inputPhone, clientId, valueToRender);
        this.encodeHiddenInput(context, inputPhone, clientId);
        writer.endElement("span");
    }

    protected void encodeInput(FacesContext context, InputPhone inputPhone, String clientId, String valueToRender) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String inputId = clientId + "_input";
        String inputStyle = inputPhone.getInputStyle();
        String inputStyleClass = inputPhone.getInputStyleClass();
        String styleClass = "ui-inputfield ui-inputtext ui-widget ui-state-default ui-corner-all";
        styleClass = inputPhone.isValid() ? styleClass : styleClass + " ui-state-error";
        String string = styleClass = !inputPhone.isDisabled() ? styleClass : styleClass + " ui-state-disabled";
        if (!this.isValueBlank(inputStyleClass)) {
            styleClass = styleClass + " " + inputStyleClass;
        }
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)inputPhone.getType(), null);
        writer.writeAttribute("value", (Object)valueToRender, null);
        if (!this.isValueBlank(inputStyle)) {
            writer.writeAttribute("style", (Object)inputStyle, null);
        }
        writer.writeAttribute("class", (Object)styleClass, null);
        this.renderAccessibilityAttributes(context, (UIInput)inputPhone);
        this.renderPassThruAttributes(context, (UIComponent)inputPhone, HTML.INPUT_TEXT_ATTRS_WITHOUT_EVENTS);
        this.renderDomEvents(context, (UIComponent)inputPhone, HTML.INPUT_TEXT_EVENTS);
        this.renderValidationMetadata(context, (EditableValueHolder)inputPhone);
        writer.endElement("input");
    }

    protected void encodeHiddenInput(FacesContext context, InputPhone inputPhone, String clientId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)(clientId + "_iso2"), null);
        writer.writeAttribute("name", (Object)(clientId + "_iso2"), null);
        writer.writeAttribute("value", (Object)inputPhone.getInitialCountry(), null);
        writer.endElement("input");
    }

    protected void encodeScript(FacesContext context, InputPhone inputPhone) throws IOException {
        String clientId = inputPhone.getClientId(context);
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtInputPhone", inputPhone.resolveWidgetVar(), clientId);
        if (!inputPhone.isAllowDropdown()) {
            wb.attr("allowDropdown", Boolean.valueOf(inputPhone.isAllowDropdown()));
        }
        if (!inputPhone.isAutoHideDialCode()) {
            wb.attr("autoHideDialCode", Boolean.valueOf(inputPhone.isAutoHideDialCode()));
        }
        if (inputPhone.getAutoPlaceholderEnum() != InputPhone.AutoPlaceholder.polite) {
            wb.attr("autoPlaceholder", inputPhone.getAutoPlaceholder());
        }
        this.encodeCountries(wb, "excludeCountries", inputPhone.getExcludeCountries());
        if (!inputPhone.isFormatOnDisplay()) {
            wb.attr("formatOnDisplay", Boolean.valueOf(inputPhone.isFormatOnDisplay()));
        }
        if (StringUtils.isNotEmpty((CharSequence)inputPhone.getInitialCountry())) {
            wb.attr("initialCountry", inputPhone.getInitialCountry());
        }
        if ("auto".equals(inputPhone.getInitialCountry())) {
            if (inputPhone.getGeoIpLookup() == null) {
                throw new FacesException("InputPhone geoIpLookup property is required when initialCountry is 'auto'.");
            }
            wb.nativeAttr("geoIpLookup", inputPhone.getGeoIpLookup());
        }
        if (!inputPhone.isNationalMode()) {
            wb.attr("nationalMode", Boolean.valueOf(inputPhone.isNationalMode()));
        }
        this.encodeCountries(wb, "onlyCountries", inputPhone.getOnlyCountries());
        if (inputPhone.getPlaceholderNumberTypeEnum() != InputPhone.PlaceholderNumberType.mobile) {
            wb.attr("placeholderNumberType", inputPhone.getPlaceholderNumberType().toUpperCase());
        }
        this.encodeCountries(wb, "preferredCountries", inputPhone.getPreferredCountries());
        if (inputPhone.isSeparateDialCode()) {
            wb.attr("separateDialCode", Boolean.valueOf(inputPhone.isSeparateDialCode()));
        }
        if (inputPhone.isUtilsScriptRequired()) {
            wb.attr("utilsScript", context.getApplication().getResourceHandler().createResource("inputphone/utils.js", "primefaces-extensions").getRequestPath());
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)inputPhone);
        wb.finish();
    }

    private void encodeCountries(WidgetBuilder wb, String attribute, Object value) throws IOException {
        Collection<String> countries = this.toCollection(value);
        if (countries != null && !countries.isEmpty()) {
            wb.nativeAttr(attribute, new JSONArray(countries).toString());
        }
    }

    private Collection<String> toCollection(Object object) {
        if (String.class.isInstance(object)) {
            String string = ((String)object).replaceAll(" ", "").toLowerCase();
            return Arrays.asList(string.split(","));
        }
        return (Collection)object;
    }
}

