/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.component.fab;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.extensions.component.fab.FloatingActionButton;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.util.WidgetBuilder;

public class FloatingActionButtonRenderer
extends BaseMenuRenderer {
    protected void encodeMarkup(FacesContext context, AbstractMenu menu) throws IOException {
        FloatingActionButton fab = (FloatingActionButton)menu;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = fab.getClientId(context);
        String styleClass = fab.getStyleClass();
        styleClass = styleClass == null ? "ui-fab ui-widget" : "ui-fab ui-widget " + styleClass;
        writer.startElement("span", (UIComponent)fab);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        this.encodeMainButton(context, writer, fab);
        this.encodeMenu(context, writer, fab);
        writer.endElement("span");
    }

    protected void encodeMainButton(FacesContext context, ResponseWriter writer, FloatingActionButton fab) throws IOException {
        writer.startElement("span", (UIComponent)fab);
        String classes = "ui-fab-main ui-button";
        if (fab.getIconActive() != null) {
            classes = classes + " ui-fab-double";
        }
        writer.writeAttribute("class", (Object)classes, "styleClass");
        if (fab.getStyle() != null) {
            writer.writeAttribute("style", (Object)fab.getStyle(), "style");
        }
        writer.startElement("span", (UIComponent)fab);
        writer.writeAttribute("class", (Object)("ui-icon ui-icon-0 " + fab.getIcon()), "icon");
        writer.endElement("span");
        if (fab.getIconActive() != null) {
            writer.startElement("span", (UIComponent)fab);
            writer.writeAttribute("class", (Object)("ui-icon ui-icon-1 " + fab.getIconActive()), "icon");
            writer.endElement("span");
        }
        writer.endElement("span");
    }

    protected void encodeMenu(FacesContext context, ResponseWriter writer, FloatingActionButton fab) throws IOException {
        writer.startElement("ul", (UIComponent)fab);
        for (MenuElement child : fab.getElements()) {
            if (!child.isRendered() || !(child instanceof MenuItem)) continue;
            this.encodeMenuItem(context, writer, fab, (MenuItem)child);
        }
        writer.endElement("ul");
    }

    protected void encodeMenuItem(FacesContext context, ResponseWriter writer, FloatingActionButton fab, MenuItem menuItem) throws IOException {
        writer.startElement("li", (UIComponent)fab);
        writer.writeAttribute("role", (Object)"menuitem", null);
        writer.writeAttribute("class", (Object)"ui-button", null);
        if (menuItem.getStyle() != null) {
            writer.writeAttribute("style", (Object)menuItem.getStyle(), null);
            menuItem.setStyleClass(null);
        }
        if (!menuItem.isDisabled()) {
            this.encodeMenuItem(context, fab, menuItem, fab.getTabindex());
        }
        writer.endElement("li");
    }

    protected void encodeScript(FacesContext context, AbstractMenu menu) throws IOException {
        FloatingActionButton fab = (FloatingActionButton)menu;
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("ExtFAB", fab.resolveWidgetVar(), fab.getClientId(context));
        wb.finish();
    }
}

