/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.behavior.javascript;

import java.util.Collection;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.render.ClientBehaviorRenderer;
import org.primefaces.component.api.ClientBehaviorRenderingMode;
import org.primefaces.extensions.behavior.javascript.JavascriptBehavior;

public class JavascriptBehaviorRenderer
extends ClientBehaviorRenderer {
    public String getScript(ClientBehaviorContext behaviorContext, ClientBehavior behavior) {
        JavascriptBehavior javascriptBehavior = (JavascriptBehavior)behavior;
        if (javascriptBehavior.isDisabled()) {
            return null;
        }
        FacesContext context = behaviorContext.getFacesContext();
        UIComponent component = behaviorContext.getComponent();
        String source = behaviorContext.getSourceId();
        if (source == null) {
            source = component.getClientId(context);
        }
        StringBuilder script = new StringBuilder();
        script.append("PrimeFacesExt.behavior.Javascript({");
        script.append("source:'").append(source).append("'");
        script.append(",event:'").append(behaviorContext.getEventName()).append("'");
        script.append(",execute:function(source,event,params,ext){");
        script.append(javascriptBehavior.getExecute()).append(";}");
        boolean paramWritten = false;
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)child;
            if (paramWritten) {
                script.append(",");
            } else {
                paramWritten = true;
                script.append(",params:{");
            }
            script.append("'");
            script.append(parameter.getName()).append("':'").append(parameter.getValue());
            script.append("'");
        }
        if (paramWritten) {
            script.append("}");
        }
        ClientBehaviorRenderingMode renderingMode = null;
        Collection behaviorParameters = behaviorContext.getParameters();
        if (behaviorParameters != null && !behaviorParameters.isEmpty()) {
            for (ClientBehaviorContext.Parameter behaviorParameter : behaviorParameters) {
                if (behaviorParameter.getValue() == null || !(behaviorParameter.getValue() instanceof ClientBehaviorRenderingMode)) continue;
                renderingMode = (ClientBehaviorRenderingMode)behaviorParameter.getValue();
                break;
            }
        }
        if (ClientBehaviorRenderingMode.UNOBSTRUSIVE.equals(renderingMode)) {
            script.append("},ext);");
        } else {
            script.append("});");
        }
        return script.toString();
    }
}

