/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.ReferenceCountUtil;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.ByteStringBuilder;
import org.reactivestreams.Processor;
import play.api.http.websocket.BinaryMessage;
import play.api.http.websocket.CloseMessage;
import play.api.http.websocket.Message;
import play.api.http.websocket.PingMessage;
import play.api.http.websocket.PongMessage;
import play.api.http.websocket.TextMessage;
import play.core.server.common.WebSocketFlowHandler;
import play.core.server.common.WebSocketFlowHandler$;
import play.core.server.netty.SynchronousMappedStreams$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;

public final class WebSocketHandler$ {
    public static final WebSocketHandler$ MODULE$ = new WebSocketHandler$();

    public Processor<WebSocketFrame, WebSocketFrame> messageFlowToFrameProcessor(Flow<Message, Message, ?> flow, int bufferLimit, String wsKeepAliveMode, Duration wsKeepAliveMaxIdle, Materializer mat) {
        return SynchronousMappedStreams$.MODULE$.transform((Processor)WebSocketFlowHandler$.MODULE$.webSocketProtocol(bufferLimit, wsKeepAliveMode, wsKeepAliveMaxIdle).join(flow).toProcessor().run(mat), (Function1 & Serializable)frame -> MODULE$.frameToMessage((WebSocketFrame)frame), (Function1 & Serializable)message -> MODULE$.messageToFrame((Message)message));
    }

    private WebSocketFlowHandler.RawMessage frameToMessage(WebSocketFrame frame) {
        Enumeration.Value value;
        ByteStringBuilder builder = ByteString$.MODULE$.newBuilder();
        frame.content().readBytes(builder.asOutputStream(), frame.content().readableBytes());
        ByteString bytes = builder.result();
        ReferenceCountUtil.release((Object)frame);
        WebSocketFrame webSocketFrame = frame;
        if (webSocketFrame instanceof TextWebSocketFrame) {
            value = WebSocketFlowHandler.MessageType$.MODULE$.Text();
        } else if (webSocketFrame instanceof BinaryWebSocketFrame) {
            value = WebSocketFlowHandler.MessageType$.MODULE$.Binary();
        } else if (webSocketFrame instanceof CloseWebSocketFrame) {
            value = WebSocketFlowHandler.MessageType$.MODULE$.Close();
        } else if (webSocketFrame instanceof PingWebSocketFrame) {
            value = WebSocketFlowHandler.MessageType$.MODULE$.Ping();
        } else if (webSocketFrame instanceof PongWebSocketFrame) {
            value = WebSocketFlowHandler.MessageType$.MODULE$.Pong();
        } else if (webSocketFrame instanceof ContinuationWebSocketFrame) {
            value = WebSocketFlowHandler.MessageType$.MODULE$.Continuation();
        } else {
            throw new MatchError((Object)webSocketFrame);
        }
        Enumeration.Value messageType = value;
        return new WebSocketFlowHandler.RawMessage(messageType, bytes, frame.isFinalFragment(), WebSocketFlowHandler.RawMessage$.MODULE$.apply$default$4());
    }

    private WebSocketFrame messageToFrame(Message message) {
        Option option;
        boolean bl = false;
        CloseMessage closeMessage = null;
        Message message2 = message;
        if (message2 instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message2;
            String data = textMessage.data();
            return new TextWebSocketFrame(data);
        }
        if (message2 instanceof BinaryMessage) {
            BinaryMessage binaryMessage = (BinaryMessage)message2;
            ByteString data = binaryMessage.data();
            return new BinaryWebSocketFrame(WebSocketHandler$.byteStringToByteBuf$1(data));
        }
        if (message2 instanceof PingMessage) {
            PingMessage pingMessage = (PingMessage)message2;
            ByteString data = pingMessage.data();
            return new PingWebSocketFrame(WebSocketHandler$.byteStringToByteBuf$1(data));
        }
        if (message2 instanceof PongMessage) {
            PongMessage pongMessage = (PongMessage)message2;
            ByteString data = pongMessage.data();
            return new PongWebSocketFrame(WebSocketHandler$.byteStringToByteBuf$1(data));
        }
        if (message2 instanceof CloseMessage) {
            bl = true;
            closeMessage = (CloseMessage)message2;
            Option option2 = closeMessage.statusCode();
            String reason = closeMessage.reason();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                int statusCode = BoxesRunTime.unboxToInt((Object)some.value());
                return new CloseWebSocketFrame(statusCode, reason);
            }
        }
        if (bl && None$.MODULE$.equals(option = closeMessage.statusCode())) {
            return new CloseWebSocketFrame();
        }
        throw new MatchError((Object)message2);
    }

    private static final ByteBuf byteStringToByteBuf$1(ByteString bytes) {
        if (bytes.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        return Unpooled.wrappedBuffer((ByteBuffer)bytes.asByteBuffer());
    }

    private WebSocketHandler$() {
    }
}

