/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.report.html;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import org.pitest.coverage.ClassLines;
import org.pitest.coverage.ReportCoverage;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.mutationtest.SourceLocator;
import org.pitest.mutationtest.report.html.AnnotatedLineFactory;
import org.pitest.mutationtest.report.html.Line;
import org.pitest.mutationtest.report.html.MutationResultList;
import org.pitest.mutationtest.report.html.MutationTestSummaryData;
import org.pitest.mutationtest.report.html.MutationTotals;
import org.pitest.mutationtest.report.html.PackageSummaryData;
import org.pitest.mutationtest.report.html.PackageSummaryMap;
import org.pitest.mutationtest.report.html.SourceFile;
import org.pitest.reloc.antlr.stringtemplate.StringTemplate;
import org.pitest.reloc.antlr.stringtemplate.StringTemplateGroup;
import org.pitest.util.FileUtil;
import org.pitest.util.IsolationUtils;
import org.pitest.util.Log;
import org.pitest.util.ResultOutputStrategy;

public class MutationHtmlReportListener
implements MutationResultListener {
    private final ResultOutputStrategy outputStrategy;
    private final Collection<SourceLocator> sourceRoots;
    private final PackageSummaryMap packageSummaryData = new PackageSummaryMap();
    private final ReportCoverage coverage;
    private final Set<String> mutatorNames;
    private final String css;
    private final Charset outputCharset;

    public MutationHtmlReportListener(Charset outputCharset, ReportCoverage coverage, ResultOutputStrategy outputStrategy, Collection<String> mutatorNames, SourceLocator ... locators) {
        this.outputCharset = outputCharset;
        this.coverage = coverage;
        this.outputStrategy = outputStrategy;
        this.sourceRoots = new HashSet<SourceLocator>(Arrays.asList(locators));
        this.mutatorNames = new HashSet<String>(mutatorNames);
        this.css = this.loadCss();
    }

    private String loadCss() {
        try {
            return FileUtil.readToString((InputStream)IsolationUtils.getContextClassLoader().getResourceAsStream("templates/mutation/style.css"));
        }
        catch (IOException e) {
            Log.getLogger().log(Level.SEVERE, "Error while loading css", e);
            return "";
        }
    }

    private void generateAnnotatedSourceFile(MutationTestSummaryData mutationMetaData) {
        String fileName = mutationMetaData.getPackageName() + File.separator + mutationMetaData.getFileName() + ".html";
        try (Writer writer = this.outputStrategy.createWriterForFile(fileName);){
            StringTemplateGroup group = new StringTemplateGroup("mutation_test");
            StringTemplate st = group.getInstanceOf("templates/mutation/mutation_report");
            st.setAttribute("css", this.css);
            st.setAttribute("tests", mutationMetaData.getTests());
            st.setAttribute("mutators", mutationMetaData.getMutators());
            SourceFile sourceFile = this.createAnnotatedSourceFile(mutationMetaData);
            st.setAttribute("sourceFile", sourceFile);
            st.setAttribute("mutatedClasses", mutationMetaData.getMutatedClasses());
            st.setAttribute("outputCharset", this.outputCharset);
            writer.write(st.toString());
        }
        catch (IOException ex) {
            Log.getLogger().log(Level.WARNING, "Error while writing report", ex);
        }
    }

    private PackageSummaryData collectPackageSummaries(ClassMutationResults mutationMetaData) {
        String packageName = mutationMetaData.getPackageName();
        return this.packageSummaryData.update(packageName, this.createSummaryData(this.coverage, mutationMetaData));
    }

    public MutationTestSummaryData createSummaryData(ReportCoverage coverage, ClassMutationResults data) {
        List<ClassLines> lines = Arrays.asList(this.coverage.getCodeLinesForClass(data.getMutatedClass()));
        return new MutationTestSummaryData(data.getFileName(), data.getMutations(), this.mutatorNames, lines, coverage.getCoveredLines(data.getMutatedClass()).size());
    }

    private SourceFile createAnnotatedSourceFile(MutationTestSummaryData mutationMetaData) throws IOException {
        String fileName = mutationMetaData.getFileName();
        String packageName = mutationMetaData.getPackageName();
        MutationResultList mutationsForThisFile = mutationMetaData.getResults();
        List<Line> lines = this.createAnnotatedSourceCodeLines(fileName, packageName, mutationsForThisFile);
        return new SourceFile(fileName, lines, mutationsForThisFile.groupMutationsByLine());
    }

    private List<Line> createAnnotatedSourceCodeLines(String sourceFile, String packageName, MutationResultList mutationsForThisFile) throws IOException {
        Collection classes = this.coverage.getClassesForFile(sourceFile, packageName);
        Optional<Reader> reader = this.findSourceFile(this.classInfoToNames(classes), sourceFile);
        if (reader.isPresent()) {
            AnnotatedLineFactory alf = new AnnotatedLineFactory(mutationsForThisFile.list(), this.coverage, classes);
            return alf.convert(reader.get());
        }
        return Collections.emptyList();
    }

    private Collection<String> classInfoToNames(Collection<ClassLines> classes) {
        return FCollection.map(classes, this.classInfoToJavaName());
    }

    private Function<ClassLines, String> classInfoToJavaName() {
        return a -> a.name().asJavaName();
    }

    private Optional<Reader> findSourceFile(Collection<String> classes, String fileName) {
        for (SourceLocator each : this.sourceRoots) {
            Optional maybe = each.locate(classes, fileName);
            if (!maybe.isPresent()) continue;
            return maybe;
        }
        return Optional.empty();
    }

    public void onRunEnd() {
        this.createIndexPages();
        this.createCssFile();
    }

    private void createCssFile() {
        Writer cssWriter = this.outputStrategy.createWriterForFile("style.css");
        try {
            cssWriter.write(this.css);
            cssWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createIndexPages() {
        StringTemplateGroup group = new StringTemplateGroup("mutation_test");
        StringTemplate st = group.getInstanceOf("templates/mutation/mutation_package_index");
        Writer writer = this.outputStrategy.createWriterForFile("index.html");
        MutationTotals totals = new MutationTotals();
        ArrayList<PackageSummaryData> psd = new ArrayList<PackageSummaryData>(this.packageSummaryData.values());
        Collections.sort(psd);
        for (PackageSummaryData psData : psd) {
            totals.add(psData.getTotals());
            this.createPackageIndexPage(psData);
        }
        st.setAttribute("totals", totals);
        st.setAttribute("packageSummaries", psd);
        st.setAttribute("outputCharset", this.outputCharset);
        try {
            writer.write(st.toString());
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createPackageIndexPage(PackageSummaryData psData) {
        StringTemplateGroup group = new StringTemplateGroup("mutation_test");
        StringTemplate st = group.getInstanceOf("templates/mutation/package_index");
        Writer writer = this.outputStrategy.createWriterForFile(psData.getPackageDirectory() + File.separator + "index.html");
        st.setAttribute("packageData", psData);
        st.setAttribute("outputCharset", this.outputCharset);
        try {
            writer.write(st.toString());
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void runStart() {
    }

    public void runEnd() {
        this.createIndexPages();
        this.createCssFile();
    }

    public void handleMutationResult(ClassMutationResults metaData) {
        PackageSummaryData packageData = this.collectPackageSummaries(metaData);
        this.generateAnnotatedSourceFile(packageData.getForSourceFile(metaData.getFileName()));
    }
}

