/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.commandline;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.plugin.ClientClasspathPlugin;
import org.pitest.util.PitError;

public class PluginFilter
implements Predicate<String> {
    private final Set<String> includedClassPathElement = new HashSet<String>();

    public PluginFilter(PluginServices plugin) {
        FCollection.mapTo((Iterable)plugin.findClientClasspathPlugins(), PluginFilter.classToLocation(), this.includedClassPathElement);
    }

    private static Function<ClientClasspathPlugin, String> classToLocation() {
        return new Function<ClientClasspathPlugin, String>(){

            @Override
            public String apply(ClientClasspathPlugin a) {
                try {
                    return new File(a.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getCanonicalPath();
                }
                catch (IOException | URISyntaxException ex) {
                    throw this.createPitErrorForExceptionOnClass(ex, a);
                }
            }

            private PitError createPitErrorForExceptionOnClass(Exception ex, ClientClasspathPlugin clazz) {
                return new PitError("Error getting location of class " + String.valueOf(clazz), (Throwable)ex);
            }
        };
    }

    @Override
    public boolean test(String a) {
        return this.includedClassPathElement.contains(a);
    }
}

