/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.util;

import java.time.ZoneOffset;
import java.util.regex.Matcher;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.util.PropertyMapHelpersKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\f\u0010\u0014\u001a\u00020\u0013*\u00020\nH\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0018\u0010\b\u001a\u00020\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0018\u0010\r\u001a\u00020\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\"\u0018\u0010\u000f\u001a\u00020\t*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\u00a8\u0006\u0015"}, d2={"DATE_PATTERN_REGEX", "Lkotlin/text/Regex;", "getDATE_PATTERN_REGEX", "()Lkotlin/text/Regex;", "genericTimeRegex", "getGenericTimeRegex", "timeWithoutTimeZoneRegex", "getTimeWithoutTimeZoneRegex", "hour", "", "Ljava/time/ZoneOffset;", "getHour", "(Ljava/time/ZoneOffset;)I", "minute", "getMinute", "totalMinutes", "getTotalMinutes", "getPrecisionFromTimeString", "timeString", "", "getOffsetHHmm", "partiql-lang"})
public final class TimeExtensionsKt {
    @NotNull
    private static final Regex timeWithoutTimeZoneRegex = new Regex("\\d\\d:\\d\\d:\\d\\d(\\.\\d*)?");
    @NotNull
    private static final Regex genericTimeRegex = new Regex("\\d\\d:\\d\\d:\\d\\d(\\.\\d*)?([+|-]\\d\\d:\\d\\d)?");
    @NotNull
    private static final Regex DATE_PATTERN_REGEX = new Regex("\\d\\d\\d\\d-\\d\\d-\\d\\d");

    @NotNull
    public static final Regex getTimeWithoutTimeZoneRegex() {
        return timeWithoutTimeZoneRegex;
    }

    @NotNull
    public static final Regex getGenericTimeRegex() {
        return genericTimeRegex;
    }

    @NotNull
    public static final Regex getDATE_PATTERN_REGEX() {
        return DATE_PATTERN_REGEX;
    }

    @NotNull
    public static final String getOffsetHHmm(@NotNull ZoneOffset $this$getOffsetHHmm) {
        Intrinsics.checkNotNullParameter((Object)$this$getOffsetHHmm, (String)"$this$getOffsetHHmm");
        int n = TimeExtensionsKt.getHour($this$getOffsetHHmm);
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder().append($this$getOffsetHHmm.getTotalSeconds() >= 0 ? "+" : "-").append(StringsKt.padStart((String)String.valueOf(Math.abs(n)), (int)2, (char)'0')).append(":");
        n = TimeExtensionsKt.getMinute($this$getOffsetHHmm);
        bl = false;
        return stringBuilder.append(StringsKt.padStart((String)String.valueOf(Math.abs(n)), (int)2, (char)'0')).toString();
    }

    public static final int getHour(@NotNull ZoneOffset $this$hour) {
        Intrinsics.checkNotNullParameter((Object)$this$hour, (String)"$this$hour");
        return $this$hour.getTotalSeconds() / 3600;
    }

    public static final int getMinute(@NotNull ZoneOffset $this$minute) {
        Intrinsics.checkNotNullParameter((Object)$this$minute, (String)"$this$minute");
        return $this$minute.getTotalSeconds() / 60 % 60;
    }

    public static final int getTotalMinutes(@NotNull ZoneOffset $this$totalMinutes) {
        Intrinsics.checkNotNullParameter((Object)$this$totalMinutes, (String)"$this$totalMinutes");
        return $this$totalMinutes.getTotalSeconds() / 60;
    }

    public static final int getPrecisionFromTimeString(@NotNull String timeString) {
        String fraction;
        Intrinsics.checkNotNullParameter((Object)timeString, (String)"timeString");
        Matcher matcher = genericTimeRegex.toPattern().matcher(timeString);
        if (!matcher.find()) {
            Void void_ = ExceptionsKt.err("Time string does not match the format 'HH:MM:SS[.ddd....][+|-HH:MM]'", ErrorCode.PARSE_INVALID_TIME_STRING, PropertyMapHelpersKt.propertyValueMapOf(new Pair[0]), false);
            throw new KotlinNothingValueException();
        }
        String string = matcher.group(1);
        String string2 = fraction = string != null ? StringsKt.removePrefix((String)string, (CharSequence)".") : null;
        return string2 != null ? string2.length() : 0;
    }
}

