/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.util;

import com.amazon.ion.Decimal;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazon.ion.ValueFactory;
import com.amazon.ion.system.IonSystemBuilder;
import com.amazon.ionelement.api.ElementLoader;
import com.amazon.ionelement.api.Ion;
import com.amazon.ionelement.api.IonElement;
import com.amazon.ionelement.api.IonUtils;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.errors.Property;
import org.partiql.lang.errors.PropertyValueMap;
import org.partiql.lang.syntax.LexerConstantsKt;
import org.partiql.lang.syntax.ParserException;
import org.partiql.lang.syntax.TokenType;
import org.partiql.lang.syntax.antlr.PartiQLParser;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a4\u0010\t\u001a\u00020\n*\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u001a4\u0010\t\u001a\u00020\n*\u0004\u0018\u00010\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u001a\f\u0010\u0014\u001a\u00020\f*\u00020\u0015H\u0000\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"ion", "Lcom/amazon/ion/IonSystem;", "kotlin.jvm.PlatformType", "getIonElement", "Lcom/amazon/ionelement/api/IonElement;", "token", "Lorg/antlr/v4/runtime/Token;", "getIonValue", "Lcom/amazon/ion/IonValue;", "error", "Lorg/partiql/lang/syntax/ParserException;", "message", "", "errorCode", "Lorg/partiql/lang/errors/ErrorCode;", "errorContext", "Lorg/partiql/lang/errors/PropertyValueMap;", "cause", "", "Lorg/antlr/v4/runtime/tree/TerminalNode;", "getAntlrDisplayString", "", "partiql-lang"})
public final class AntlrUtilitiesKt {
    private static final IonSystem ion = IonSystemBuilder.standard().build();

    @NotNull
    public static final ParserException error(@Nullable TerminalNode $this$error, @NotNull String message, @NotNull ErrorCode errorCode, @NotNull PropertyValueMap errorContext, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        Intrinsics.checkNotNullParameter((Object)errorContext, (String)"errorContext");
        TerminalNode terminalNode = $this$error;
        return terminalNode == null ? new ParserException(null, errorCode, errorContext, cause, 1, null) : AntlrUtilitiesKt.error($this$error.getSymbol(), message, errorCode, errorContext, cause);
    }

    public static /* synthetic */ ParserException error$default(TerminalNode terminalNode, String string, ErrorCode errorCode, PropertyValueMap propertyValueMap, Throwable throwable, int n, Object object) {
        if ((n & 4) != 0) {
            propertyValueMap = new PropertyValueMap(null, 1, null);
        }
        if ((n & 8) != 0) {
            throwable = null;
        }
        return AntlrUtilitiesKt.error(terminalNode, string, errorCode, propertyValueMap, throwable);
    }

    @NotNull
    public static final ParserException error(@Nullable Token $this$error, @NotNull String message, @NotNull ErrorCode errorCode, @NotNull PropertyValueMap errorContext, @Nullable Throwable cause) {
        ParserException parserException;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        Intrinsics.checkNotNullParameter((Object)errorContext, (String)"errorContext");
        Token token = $this$error;
        if (token == null) {
            parserException = new ParserException(null, errorCode, errorContext, cause, 1, null);
        } else {
            errorContext.set(Property.LINE_NUMBER, (long)$this$error.getLine());
            errorContext.set(Property.COLUMN_NUMBER, (long)$this$error.getCharPositionInLine() + 1L);
            errorContext.set(Property.TOKEN_DESCRIPTION, AntlrUtilitiesKt.getAntlrDisplayString($this$error.getType()));
            errorContext.set(Property.TOKEN_VALUE, AntlrUtilitiesKt.getIonValue($this$error));
            parserException = new ParserException(message, errorCode, errorContext, cause);
        }
        return parserException;
    }

    public static /* synthetic */ ParserException error$default(Token token, String string, ErrorCode errorCode, PropertyValueMap propertyValueMap, Throwable throwable, int n, Object object) {
        if ((n & 4) != 0) {
            propertyValueMap = new PropertyValueMap(null, 1, null);
        }
        if ((n & 8) != 0) {
            throwable = null;
        }
        return AntlrUtilitiesKt.error(token, string, errorCode, propertyValueMap, throwable);
    }

    @NotNull
    public static final IonValue getIonValue(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        IonElement ionElement = AntlrUtilitiesKt.getIonElement(token);
        IonSystem ionSystem = ion;
        Intrinsics.checkNotNullExpressionValue((Object)ionSystem, (String)"ion");
        return IonUtils.toIonValue((IonElement)ionElement, (ValueFactory)((ValueFactory)ionSystem));
    }

    @NotNull
    public static final IonElement getIonElement(@NotNull Token token) {
        IonElement ionElement;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        int type2 = token.getType();
        String text = token.getText();
        if (type2 == -1) {
            ionElement = (IonElement)Ion.ionSymbol$default((String)"EOF", null, null, (int)6, null);
        } else {
            String string = text;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
            CharSequence charSequence = string;
            boolean bl = false;
            String string2 = charSequence;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            if (LexerConstantsKt.ALL_OPERATORS.contains(string3)) {
                charSequence = text;
                bl = false;
                String string4 = ((String)charSequence).toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                ionElement = (IonElement)Ion.ionSymbol$default((String)string4, null, null, (int)6, null);
            } else if (type2 == 305) {
                ionElement = (IonElement)ElementLoader.loadSingleElement$default((String)StringsKt.trimEnd((String)StringsKt.trimStart((String)text, (char[])new char[]{'`'}), (char[])new char[]{'`'}), null, (int)2, null);
            } else if (type2 == 207) {
                ionElement = (IonElement)Ion.ionBool$default((boolean)true, null, null, (int)6, null);
            } else if (type2 == 87) {
                ionElement = (IonElement)Ion.ionBool$default((boolean)false, null, null, (int)6, null);
            } else if (type2 == 140) {
                ionElement = Ion.ionNull$default(null, null, null, (int)7, null);
            } else if (type2 == 141) {
                ionElement = (IonElement)Ion.ionSymbol$default((String)"nulls", null, null, (int)6, null);
            } else if (type2 == 235) {
                ionElement = Ion.ionNull$default(null, null, null, (int)7, null);
            } else if (type2 == 296) {
                ionElement = (IonElement)Ion.ionString$default((String)StringsKt.replace$default((String)StringsKt.trim((String)text, (char[])new char[]{'\''}), (String)"''", (String)"'", (boolean)false, (int)4, null), null, null, (int)6, null);
            } else if (type2 == 297) {
                ionElement = (IonElement)Ion.ionInt$default((BigInteger)new BigInteger(text, 10), null, null, (int)6, null);
            } else if (type2 == 298) {
                try {
                    Decimal decimal = Decimal.valueOf((String)text);
                    Intrinsics.checkNotNullExpressionValue((Object)decimal, (String)"Decimal.valueOf(text)");
                    charSequence = Ion.ionDecimal$default((Decimal)decimal, null, null, (int)6, null);
                }
                catch (NumberFormatException e) {
                    String string5 = e.getLocalizedMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"e.localizedMessage");
                    throw (Throwable)AntlrUtilitiesKt.error$default(token, string5, ErrorCode.PARSE_EXPECTED_NUMBER, null, (Throwable)e, 4, null);
                }
                ionElement = (IonElement)charSequence;
            } else if (type2 == 300) {
                ionElement = (IonElement)Ion.ionSymbol$default((String)StringsKt.replace$default((String)StringsKt.trim((String)text, (char[])new char[]{'\"'}), (String)"\"\"", (String)"\"", (boolean)false, (int)4, null), null, null, (int)6, null);
            } else {
                charSequence = text;
                bl = false;
                String string6 = ((String)charSequence).toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
                charSequence = string6;
                CharSequence charSequence2 = "\\s+";
                int n = 0;
                charSequence2 = new Regex(charSequence2);
                n = 0;
                int n2 = 0;
                if (LexerConstantsKt.MULTI_LEXEME_TOKEN_MAP.containsKey(charSequence2.split(charSequence, n))) {
                    charSequence2 = text;
                    n = 0;
                    String string7 = charSequence2.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
                    charSequence2 = string7;
                    String string8 = "\\s+";
                    n2 = 0;
                    string8 = new Regex(string8);
                    n2 = 0;
                    boolean bl2 = false;
                    Pair<String, TokenType> pair = LexerConstantsKt.MULTI_LEXEME_TOKEN_MAP.get(string8.split(charSequence2, n2));
                    Intrinsics.checkNotNull(pair);
                    Pair<String, TokenType> pair2 = pair;
                    ionElement = (IonElement)Ion.ionSymbol$default((String)((String)pair2.getFirst()), null, null, (int)6, null);
                } else {
                    charSequence = text;
                    boolean bl3 = false;
                    String string9 = ((String)charSequence).toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).toLowerCase()");
                    if (LexerConstantsKt.KEYWORDS.contains(string9)) {
                        charSequence = text;
                        bl3 = false;
                        String string10 = ((String)charSequence).toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.String).toLowerCase()");
                        String string11 = LexerConstantsKt.TYPE_ALIASES.get(string10);
                        if (string11 == null) {
                            charSequence = text;
                            bl3 = false;
                            String string12 = ((String)charSequence).toLowerCase();
                            string11 = string12;
                            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"(this as java.lang.String).toLowerCase()");
                        }
                        ionElement = (IonElement)Ion.ionSymbol$default((String)string11, null, null, (int)6, null);
                    } else {
                        ionElement = (IonElement)Ion.ionSymbol$default((String)text, null, null, (int)6, null);
                    }
                }
            }
        }
        return ionElement;
    }

    @NotNull
    public static final String getAntlrDisplayString(int $this$getAntlrDisplayString) {
        String string = PartiQLParser.VOCABULARY.getSymbolicName($this$getAntlrDisplayString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PartiQLParser.VOCABULARY.getSymbolicName(this)");
        return string;
    }
}

