/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.types;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.ast.passes.inference.StaticTypeExtensionsKt;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.ExprValueType;
import org.partiql.lang.eval.OrderedBindNames;
import org.partiql.lang.eval.time.Time;
import org.partiql.lang.types.StaticTypeUtils$WhenMappings;
import org.partiql.types.AnyOfType;
import org.partiql.types.AnyType;
import org.partiql.types.BagType;
import org.partiql.types.BlobType;
import org.partiql.types.BoolType;
import org.partiql.types.ClobType;
import org.partiql.types.CollectionType;
import org.partiql.types.DateType;
import org.partiql.types.DecimalType;
import org.partiql.types.FloatType;
import org.partiql.types.GraphType;
import org.partiql.types.IntType;
import org.partiql.types.ListType;
import org.partiql.types.MissingType;
import org.partiql.types.NullType;
import org.partiql.types.SexpType;
import org.partiql.types.SingleType;
import org.partiql.types.StaticType;
import org.partiql.types.StringType;
import org.partiql.types.StructType;
import org.partiql.types.SymbolType;
import org.partiql.types.TimeType;
import org.partiql.types.TimestampType;
import org.partiql.types.TupleConstraint;
import org.partiql.types.UnsupportedTypeCheckException;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\n\u001a\u00020\u0006H\u0007J\u0018\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0006H\u0007J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0006H\u0007J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\tH\u0007J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0014\u0010\u001a\u001a\u00020\u0004*\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0011\u0010\u001c\u001a\u00020\u0004*\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u001d\u00a8\u0006\u001e"}, d2={"Lorg/partiql/lang/types/StaticTypeUtils;", "", "()V", "areStaticTypesComparable", "", "lhs", "Lorg/partiql/types/StaticType;", "rhs", "getRuntimeType", "Lorg/partiql/lang/eval/ExprValueType;", "type", "Lorg/partiql/types/SingleType;", "getTypeDomain", "", "isInstance", "value", "Lorg/partiql/lang/eval/ExprValue;", "isSubTypeOf", "child", "parent", "staticTypeFromExprValue", "staticTypeFromExprValueType", "exprValueType", "stringLengthConstraintMatches", "constraint", "Lorg/partiql/types/StringType$StringLengthConstraint;", "isInstanceOf", "Lorg/partiql/types/StructType;", "isOptional", "isOptional$partiql_lang", "partiql-lang"})
public final class StaticTypeUtils {
    @NotNull
    public static final StaticTypeUtils INSTANCE;

    @JvmStatic
    public static final boolean isInstance(@NotNull ExprValue value, @NotNull StaticType type2) throws UnsupportedTypeCheckException {
        boolean bl;
        block37: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            StaticType staticType = type2;
            if (staticType instanceof AnyType) {
                bl = true;
            } else if (staticType instanceof CollectionType) {
                if (value.getType() != StaticTypeUtils.getRuntimeType((SingleType)type2)) {
                    bl = false;
                } else {
                    StaticType staticType2 = ((CollectionType)type2).getElementType();
                    if (Intrinsics.areEqual((Object)staticType2, (Object)StaticType.ANY)) {
                        bl = true;
                    } else {
                        Iterable $this$all$iv = value;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                ExprValue it = (ExprValue)element$iv;
                                boolean bl2 = false;
                                if (StaticTypeUtils.isInstance(it, ((CollectionType)type2).getElementType())) continue;
                                bl = false;
                                break block37;
                            }
                            bl = true;
                        }
                    }
                }
            } else if (staticType instanceof IntType) {
                if (value.getType() != ExprValueType.INT) {
                    bl = false;
                } else {
                    long longValue = ExprValueExtensionsKt.numberValue(value).longValue();
                    bl = ((IntType)type2).getRangeConstraint().getValidRange().contains(longValue);
                }
            } else if (staticType instanceof DecimalType) {
                switch (StaticTypeUtils$WhenMappings.$EnumSwitchMapping$0[value.getType().ordinal()]) {
                    case 1: {
                        Number number = value.getScalar().numberValue();
                        if (number == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.math.BigDecimal");
                        }
                        bl = ((DecimalType)type2).getPrecisionScaleConstraint().matches((BigDecimal)number);
                        break;
                    }
                    default: {
                        bl = false;
                        break;
                    }
                }
            } else if (staticType instanceof NullType) {
                bl = value.getType() == ExprValueType.NULL || value.getType() == ExprValueType.MISSING;
            } else if (staticType instanceof StringType) {
                switch (StaticTypeUtils$WhenMappings.$EnumSwitchMapping$1[value.getType().ordinal()]) {
                    case 1: {
                        bl = StaticTypeUtils.stringLengthConstraintMatches(((StringType)type2).getLengthConstraint(), value);
                        break;
                    }
                    default: {
                        bl = false;
                        break;
                    }
                }
            } else if (staticType instanceof StructType) {
                bl = INSTANCE.isInstanceOf((StructType)type2, value);
            } else if (staticType instanceof SingleType) {
                bl = value.getType() == StaticTypeUtils.getRuntimeType((SingleType)type2);
            } else if (staticType instanceof AnyOfType) {
                Iterable $this$any$iv = ((AnyOfType)type2).getTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        StaticType it = (StaticType)element$iv;
                        boolean bl3 = false;
                        if (!StaticTypeUtils.isInstance(value, it)) continue;
                        bl = true;
                        break block37;
                    }
                    bl = false;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Set<ExprValueType> getTypeDomain(@NotNull StaticType type2) {
        Set set2;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        StaticType staticType = type2;
        if (staticType instanceof AnyType) {
            set2 = ArraysKt.toSet((Object[])ExprValueType.values());
        } else if (staticType instanceof SingleType) {
            set2 = SetsKt.setOf((Object)((Object)StaticTypeUtils.getRuntimeType((SingleType)type2)));
        } else if (staticType instanceof AnyOfType) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = ((AnyOfType)type2).getTypes();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                StaticType it = (StaticType)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = StaticTypeUtils.getTypeDomain(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            set2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return set2;
    }

    @JvmStatic
    @NotNull
    public static final ExprValueType getRuntimeType(@NotNull SingleType type2) {
        ExprValueType exprValueType;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        SingleType singleType = type2;
        if (singleType instanceof BlobType) {
            exprValueType = ExprValueType.BLOB;
        } else if (singleType instanceof BoolType) {
            exprValueType = ExprValueType.BOOL;
        } else if (singleType instanceof ClobType) {
            exprValueType = ExprValueType.CLOB;
        } else if (singleType instanceof BagType) {
            exprValueType = ExprValueType.BAG;
        } else if (singleType instanceof ListType) {
            exprValueType = ExprValueType.LIST;
        } else if (singleType instanceof SexpType) {
            exprValueType = ExprValueType.SEXP;
        } else if (singleType instanceof DateType) {
            exprValueType = ExprValueType.DATE;
        } else if (singleType instanceof DecimalType) {
            exprValueType = ExprValueType.DECIMAL;
        } else if (singleType instanceof FloatType) {
            exprValueType = ExprValueType.FLOAT;
        } else if (singleType instanceof IntType) {
            exprValueType = ExprValueType.INT;
        } else if (Intrinsics.areEqual((Object)singleType, (Object)MissingType.INSTANCE)) {
            exprValueType = ExprValueType.MISSING;
        } else if (singleType instanceof NullType) {
            exprValueType = ExprValueType.NULL;
        } else if (singleType instanceof StringType) {
            exprValueType = ExprValueType.STRING;
        } else if (singleType instanceof StructType) {
            exprValueType = ExprValueType.STRUCT;
        } else if (singleType instanceof SymbolType) {
            exprValueType = ExprValueType.SYMBOL;
        } else if (singleType instanceof TimeType) {
            exprValueType = ExprValueType.TIME;
        } else if (singleType instanceof TimestampType) {
            exprValueType = ExprValueType.TIMESTAMP;
        } else if (singleType instanceof GraphType) {
            exprValueType = ExprValueType.GRAPH;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return exprValueType;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean areStaticTypesComparable(@NotNull StaticType lhs, @NotNull StaticType rhs) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)lhs, (String)"lhs");
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        StaticType staticType = lhs;
        if (staticType instanceof SingleType) {
            StaticType it;
            void $this$any$iv;
            Iterator $this$filterTo$iv$iv2;
            if (StaticTypeExtensionsKt.isUnknown(lhs)) return true;
            if (StaticTypeExtensionsKt.isUnknown(rhs)) {
                return true;
            }
            StaticType staticType2 = rhs;
            if (staticType2 instanceof SingleType) {
                if (StaticTypeExtensionsKt.isNumeric(lhs)) {
                    if (StaticTypeExtensionsKt.isNumeric(rhs)) return true;
                }
                if (StaticTypeExtensionsKt.isText(lhs)) {
                    if (StaticTypeExtensionsKt.isText(rhs)) return true;
                }
                if (StaticTypeExtensionsKt.isLob(lhs)) {
                    if (StaticTypeExtensionsKt.isLob(rhs)) return true;
                }
                if (StaticTypeUtils.getRuntimeType((SingleType)lhs) != StaticTypeUtils.getRuntimeType((SingleType)rhs)) return false;
                return true;
            }
            if (staticType2 instanceof AnyType) {
                return true;
            }
            if (!(staticType2 instanceof AnyOfType)) throw new NoWhenBranchMatchedException();
            Iterable $this$filter$iv = rhs.getAllTypes();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                StaticType it2 = (StaticType)element$iv$iv;
                boolean bl = false;
                if (!(!StaticTypeExtensionsKt.isUnknown(it2))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            $this$filterTo$iv$iv2 = $this$any$iv.iterator();
            do {
                if (!$this$filterTo$iv$iv2.hasNext()) return false;
                Object element$iv = $this$filterTo$iv$iv2.next();
                it = (StaticType)element$iv;
                boolean bl = false;
            } while (!StaticTypeUtils.areStaticTypesComparable(lhs, it));
            return true;
        }
        if (staticType instanceof AnyType) {
            return true;
        }
        if (!(staticType instanceof AnyOfType)) throw new NoWhenBranchMatchedException();
        if (StaticTypeExtensionsKt.isUnknown(lhs)) return true;
        if (StaticTypeExtensionsKt.isUnknown(rhs)) {
            return true;
        }
        Iterable $this$filter$iv = lhs.getAllTypes();
        boolean $i$f$filter = false;
        Iterable $this$filterTo$iv$iv2 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            StaticType it = (StaticType)element$iv$iv;
            boolean bl = false;
            if (!(!StaticTypeExtensionsKt.isUnknown(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List typesA = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = rhs.getAllTypes();
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StaticType it = (StaticType)element$iv$iv;
            boolean bl = false;
            if (!(!StaticTypeExtensionsKt.isUnknown(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List typesB = (List)destination$iv$iv2;
        Iterable $this$forEach$iv = typesA;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv.iterator();
        block4: while (true) {
            StaticType tB;
            if (!iterator3.hasNext()) return false;
            Object element$iv = iterator3.next();
            StaticType tA = (StaticType)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = typesB;
            boolean $i$f$forEach2 = false;
            Iterator iterator4 = $this$forEach$iv2.iterator();
            do {
                if (!iterator4.hasNext()) continue block4;
                Object element$iv2 = iterator4.next();
                tB = (StaticType)element$iv2;
                boolean bl2 = false;
            } while (!StaticTypeUtils.areStaticTypesComparable(tA, tB));
            break;
        }
        return true;
    }

    @JvmStatic
    @NotNull
    public static final StaticType staticTypeFromExprValueType(@NotNull ExprValueType exprValueType) {
        StaticType staticType;
        Intrinsics.checkNotNullParameter((Object)((Object)exprValueType), (String)"exprValueType");
        switch (StaticTypeUtils$WhenMappings.$EnumSwitchMapping$2[exprValueType.ordinal()]) {
            case 1: {
                staticType = (StaticType)StaticType.MISSING;
                break;
            }
            case 2: {
                staticType = (StaticType)StaticType.NULL;
                break;
            }
            case 3: {
                staticType = (StaticType)StaticType.BOOL;
                break;
            }
            case 4: {
                staticType = (StaticType)StaticType.INT;
                break;
            }
            case 5: {
                staticType = (StaticType)StaticType.FLOAT;
                break;
            }
            case 6: {
                staticType = (StaticType)StaticType.DECIMAL;
                break;
            }
            case 7: {
                staticType = (StaticType)StaticType.DATE;
                break;
            }
            case 8: {
                staticType = (StaticType)StaticType.TIME;
                break;
            }
            case 9: {
                staticType = (StaticType)StaticType.TIMESTAMP;
                break;
            }
            case 10: {
                staticType = (StaticType)StaticType.SYMBOL;
                break;
            }
            case 11: {
                staticType = (StaticType)StaticType.STRING;
                break;
            }
            case 12: {
                staticType = (StaticType)StaticType.CLOB;
                break;
            }
            case 13: {
                staticType = (StaticType)StaticType.BLOB;
                break;
            }
            case 14: {
                staticType = (StaticType)StaticType.LIST;
                break;
            }
            case 15: {
                staticType = (StaticType)StaticType.SEXP;
                break;
            }
            case 16: {
                staticType = (StaticType)StaticType.STRUCT;
                break;
            }
            case 17: {
                staticType = (StaticType)StaticType.BAG;
                break;
            }
            case 18: {
                staticType = (StaticType)StaticType.GRAPH;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return staticType;
    }

    @JvmStatic
    @NotNull
    public static final StaticType staticTypeFromExprValue(@NotNull ExprValue value) {
        StaticType staticType;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (StaticTypeUtils$WhenMappings.$EnumSwitchMapping$3[value.getType().ordinal()]) {
            case 1: {
                Time timeValue = ExprValueExtensionsKt.timeValue(value);
                staticType = (StaticType)new TimeType(Integer.valueOf(timeValue.getPrecision()), timeValue.getZoneOffset() != null, null, 4, null);
                break;
            }
            default: {
                staticType = StaticTypeUtils.staticTypeFromExprValueType(value.getType());
            }
        }
        return staticType;
    }

    @JvmStatic
    public static final boolean isSubTypeOf(@NotNull StaticType child, @NotNull StaticType parent) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Collection collection = StaticTypeUtils.getTypeDomain(child);
        boolean bl = false;
        return !collection.isEmpty() && StaticTypeUtils.getTypeDomain(parent).containsAll((Collection)StaticTypeUtils.getTypeDomain(child));
    }

    @JvmStatic
    public static final boolean stringLengthConstraintMatches(@NotNull StringType.StringLengthConstraint constraint, @NotNull ExprValue value) {
        Intrinsics.checkNotNullParameter((Object)constraint, (String)"constraint");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        StringType.StringLengthConstraint stringLengthConstraint = constraint;
        if (!Intrinsics.areEqual((Object)stringLengthConstraint, (Object)StringType.StringLengthConstraint.Unconstrained.INSTANCE)) {
            if (stringLengthConstraint instanceof StringType.StringLengthConstraint.Constrained) {
                String str;
                String string = value.getScalar().stringValue();
                if (string == null) {
                    String string2 = "value.scalar.stringValue() unexpectedly returned null";
                    boolean bl = false;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
                String string3 = str = string;
                int n = 0;
                int n2 = str.length();
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                return ((StringType.StringLengthConstraint.Constrained)constraint).getLength().matches(string4.codePointCount(n, n2));
            }
            throw new NoWhenBranchMatchedException();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isInstanceOf(StructType $this$isInstanceOf, ExprValue value) {
        boolean bl;
        if (value.getType() != ExprValueType.STRUCT) {
            bl = false;
        } else if ($this$isInstanceOf.getFields().isEmpty() && !$this$isInstanceOf.getContentClosed()) {
            bl = true;
        } else if ($this$isInstanceOf.getConstraints().contains(TupleConstraint.Ordered.INSTANCE) && value.asFacet(OrderedBindNames.class) == null) {
            bl = false;
        } else {
            boolean bl2 = $this$isInstanceOf.getConstraints().contains(TupleConstraint.Ordered.INSTANCE);
            if (!bl2) {
                Iterator $this$mapTo$iv$iv;
                void $this$map$iv;
                StaticType staticType;
                Object object;
                Object list$iv$iv;
                void $this$groupByTo$iv$iv;
                ExprValue it;
                HashMap hashMap = new HashMap();
                boolean bl3 = false;
                boolean bl4 = false;
                Object map = hashMap;
                boolean bl5 = false;
                Iterable $this$forEach$iv = value;
                boolean $i$f$forEach22 = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object object2;
                    void $this$getOrPut$iv;
                    ExprValue structKey;
                    ExprValue v = (ExprValue)element$iv;
                    boolean bl6 = false;
                    Object object3 = ExprValueExtensionsKt.getName(v);
                    boolean bl7 = false;
                    boolean bl8 = false;
                    it = object3;
                    boolean bl9 = false;
                    Object object4 = it;
                    if (((object4 != null && (object4 = object4.getType()) != null ? ((ExprValueType)((Object)object4)).isText() : false) ? object3 : null) == null) {
                        return false;
                    }
                    structKey = structKey;
                    object3 = (Map)map;
                    String key$iv = ExprValueExtensionsKt.stringValue(structKey);
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl10 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    ((List)object2).add(v);
                }
                HashMap scratchPad = hashMap;
                Object $this$groupBy$iv = $this$isInstanceOf.getFields();
                boolean $i$f$groupBy = false;
                map = $this$groupBy$iv;
                Object destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv2 : $this$groupByTo$iv$iv) {
                    void it2;
                    Object object5;
                    StructType.Field it3 = (StructType.Field)element$iv$iv2;
                    boolean $i$a$-groupBy-StaticTypeUtils$isInstanceOf$consolidatedFields$32 = false;
                    String key$iv$iv = it3.getKey();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl11 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object5 = answer$iv$iv$iv;
                    } else {
                        object5 = value$iv$iv$iv;
                    }
                    list$iv$iv = (List)object5;
                    StructType.Field $i$a$-groupBy-StaticTypeUtils$isInstanceOf$consolidatedFields$32 = (StructType.Field)element$iv$iv2;
                    object = list$iv$iv;
                    boolean bl12 = false;
                    staticType = it2.getValue();
                    object.add(staticType);
                }
                $this$groupBy$iv = destination$iv$iv;
                boolean $i$f$map = false;
                $this$groupByTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator $i$f$forEach22 = $this$mapTo$iv$iv;
                boolean element$iv$iv2 = false;
                list$iv$iv = $i$f$forEach22.entrySet().iterator();
                while (list$iv$iv.hasNext()) {
                    void it4;
                    Map.Entry item$iv$iv;
                    Map.Entry key$iv$iv = item$iv$iv = (Map.Entry)list$iv$iv.next();
                    object = destination$iv$iv;
                    boolean bl13 = false;
                    staticType = new StructType.Field((String)it4.getKey(), StaticType.Companion.unionOf$default((StaticType.Companion)StaticType.Companion, (Set)CollectionsKt.toSet((Iterable)((Iterable)it4.getValue())), null, (int)2, null).flatten());
                    object.add(staticType);
                }
                List consolidatedFields = (List)destination$iv$iv;
                Iterable $this$forEach$iv2 = consolidatedFields;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    boolean bl14;
                    block29: {
                        void fieldName;
                        StructType.Field $dstr$fieldName$fieldType = (StructType.Field)element$iv;
                        boolean bl15 = false;
                        String element$iv$iv2 = $dstr$fieldName$fieldType.component1();
                        StaticType fieldType = $dstr$fieldName$fieldType.component2();
                        List fieldValues = (List)scratchPad.remove(fieldName);
                        if (fieldValues == null) {
                            if (INSTANCE.isOptional$partiql_lang(fieldType)) continue;
                            return false;
                        }
                        Iterable $this$all$iv = fieldValues;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl14 = true;
                        } else {
                            for (Object element$iv2 : $this$all$iv) {
                                it = (ExprValue)element$iv2;
                                boolean bl16 = false;
                                if (StaticTypeUtils.isInstance(it, fieldType)) continue;
                                bl14 = false;
                                break block29;
                            }
                            bl14 = true;
                        }
                    }
                    if (bl14) continue;
                    return false;
                }
                bl = MapsKt.none((Map)scratchPad) ? true : !$this$isInstanceOf.getContentClosed();
            } else if (bl2) {
                StructType.Field $this$mapTo$iv$iv;
                OrderedBindNames orderedBindNames2 = (OrderedBindNames)value.asFacet(OrderedBindNames.class);
                List<String> scratchPad = orderedBindNames2 != null ? orderedBindNames2.getOrderedNames() : null;
                boolean consolidatedFields = false;
                boolean $this$forEach$iv2 = false;
                List<String> orderedNames = scratchPad;
                boolean bl17 = false;
                if (orderedNames == null) {
                    return false;
                }
                Iterable $this$map$iv = $this$isInstanceOf.getFields();
                boolean $i$f$map = false;
                Iterable bl15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    StructType.Field $i$f$all = (StructType.Field)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl18 = false;
                    String string = it.getKey();
                    collection.add(string);
                }
                List fieldNames = (List)destination$iv$iv;
                if (Intrinsics.areEqual((Object)fieldNames, orderedNames) ^ true) {
                    return false;
                }
                Iterable $this$forEachIndexed$iv = $this$isInstanceOf.getFields();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void field2;
                    ExprValue attrValue;
                    int n = index$iv++;
                    boolean bl19 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    $this$mapTo$iv$iv = (StructType.Field)item$iv;
                    int index = n;
                    boolean bl20 = false;
                    if (value.getOrdinalBindings().get(index) == null) {
                        return false;
                    }
                    if (StaticTypeUtils.isInstance(attrValue, field2.getValue())) continue;
                    return false;
                }
                bl = true;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public final boolean isOptional$partiql_lang(@NotNull StaticType $this$isOptional) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)$this$isOptional, (String)"$this$isOptional");
            StaticType staticType = $this$isOptional;
            if (staticType instanceof AnyType || Intrinsics.areEqual((Object)staticType, (Object)MissingType.INSTANCE)) {
                bl = true;
            } else if (staticType instanceof AnyOfType) {
                Iterable $this$any$iv = ((AnyOfType)$this$isOptional).getTypes();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        StaticType it = (StaticType)element$iv;
                        boolean bl2 = false;
                        if (!INSTANCE.isOptional$partiql_lang(it)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private StaticTypeUtils() {
    }

    static {
        StaticTypeUtils staticTypeUtils;
        INSTANCE = staticTypeUtils = new StaticTypeUtils();
    }
}

