/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.planner.validators;

import com.amazon.ionelement.api.AnyElement;
import com.amazon.ionelement.api.IntElement;
import com.amazon.ionelement.api.IntElementSize;
import com.amazon.ionelement.api.TextElement;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.ast.passes.SemanticException;
import org.partiql.lang.domains.PartiqlLogical;
import org.partiql.lang.domains.UtilKt;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.errors.Property;
import org.partiql.lang.errors.PropertyValueMap;
import org.partiql.lang.eval.EvaluationException;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.TypedOpBehavior;
import org.partiql.pig.runtime.LongPrimitive;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bj\u0002`\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0017H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/partiql/lang/planner/validators/PartiqlLogicalValidator;", "Lorg/partiql/lang/domains/PartiqlLogical$Visitor;", "typedOpBehavior", "Lorg/partiql/lang/eval/TypedOpBehavior;", "(Lorg/partiql/lang/eval/TypedOpBehavior;)V", "validateDecimalOrNumericType", "", "scale", "Lorg/partiql/pig/runtime/LongPrimitive;", "precision", "metas", "", "", "", "Lcom/amazon/ionelement/api/MetaContainer;", "visitExprLit", "node", "Lorg/partiql/lang/domains/PartiqlLogical$Expr$Lit;", "visitExprStruct", "Lorg/partiql/lang/domains/PartiqlLogical$Expr$Struct;", "visitTypeDecimalType", "Lorg/partiql/lang/domains/PartiqlLogical$Type$DecimalType;", "visitTypeNumericType", "Lorg/partiql/lang/domains/PartiqlLogical$Type$NumericType;", "partiql-lang"})
public final class PartiqlLogicalValidator
extends PartiqlLogical.Visitor {
    private final TypedOpBehavior typedOpBehavior;

    @Override
    protected void visitExprLit(@NotNull PartiqlLogical.Expr.Lit node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        AnyElement ionValue = node.getValue();
        Map<String, Object> metas = node.getMetas();
        if (node.getValue() instanceof IntElement && ionValue.getIntegerSize() == IntElementSize.BIG_INTEGER) {
            throw (Throwable)new EvaluationException("Int overflow or underflow at compile time", ErrorCode.SEMANTIC_LITERAL_INT_OVERFLOW, ExceptionsKt.errorContextFrom(metas), null, false, 8, null);
        }
    }

    private final void validateDecimalOrNumericType(LongPrimitive scale, LongPrimitive precision, Map<String, ? extends Object> metas) {
        long l;
        if (scale != null && precision != null && this.typedOpBehavior == TypedOpBehavior.HONOR_PARAMETERS && (0L > (l = scale.getValue()) || precision.getValue() < l)) {
            Void void_ = ExceptionsKt.err("Scale " + scale.getValue() + " should be between 0 and precision " + precision.getValue(), ErrorCode.SEMANTIC_INVALID_DECIMAL_ARGUMENTS, ExceptionsKt.errorContextFrom(metas), false);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    protected void visitTypeDecimalType(@NotNull PartiqlLogical.Type.DecimalType node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.validateDecimalOrNumericType(node.getScale(), node.getPrecision(), node.getMetas());
    }

    @Override
    protected void visitTypeNumericType(@NotNull PartiqlLogical.Type.NumericType node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.validateDecimalOrNumericType(node.getScale(), node.getPrecision(), node.getMetas());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void visitExprStruct(@NotNull PartiqlLogical.Expr.Struct node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Iterable $this$forEach$iv = node.getParts();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PartiqlLogical.StructPart part = (PartiqlLogical.StructPart)element$iv;
            boolean bl = false;
            PartiqlLogical.StructPart structPart = part;
            if (structPart instanceof PartiqlLogical.StructPart.StructField) {
                void pvm;
                if (!(((PartiqlLogical.StructPart.StructField)part).getFieldName() instanceof PartiqlLogical.Expr.Missing) && (!(((PartiqlLogical.StructPart.StructField)part).getFieldName() instanceof PartiqlLogical.Expr.Lit) || ((PartiqlLogical.Expr.Lit)((PartiqlLogical.StructPart.StructField)part).getFieldName()).getValue() instanceof TextElement)) continue;
                Object object = ((PartiqlLogical.StructPart.StructField)part).getFieldName();
                String type2 = object instanceof PartiqlLogical.Expr.Lit ? ((PartiqlLogical.Expr.Lit)((PartiqlLogical.StructPart.StructField)part).getFieldName()).getValue().getType().toString() : "MISSING";
                object = UtilKt.addSourceLocation(new PropertyValueMap(null, 1, null), ((PartiqlLogical.StructPart.StructField)part).getFieldName().getMetas());
                boolean bl2 = false;
                boolean bl3 = false;
                Object object2 = object;
                ErrorCode errorCode = ErrorCode.SEMANTIC_NON_TEXT_STRUCT_FIELD_KEY;
                String string = "Found struct part to be of type " + type2;
                boolean bl4 = false;
                pvm.set(Property.ACTUAL_TYPE, type2);
                Unit unit = Unit.INSTANCE;
                DefaultConstructorMarker defaultConstructorMarker = null;
                int n = 8;
                Throwable throwable = null;
                Object object3 = object;
                ErrorCode errorCode2 = errorCode;
                String string2 = string;
                throw (Throwable)new SemanticException(string2, errorCode2, (PropertyValueMap)object3, throwable, n, defaultConstructorMarker);
            }
            if (!(structPart instanceof PartiqlLogical.StructPart.StructFields)) continue;
        }
    }

    public PartiqlLogicalValidator(@NotNull TypedOpBehavior typedOpBehavior) {
        Intrinsics.checkNotNullParameter((Object)((Object)typedOpBehavior), (String)"typedOpBehavior");
        this.typedOpBehavior = typedOpBehavior;
    }
}

