/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.graph.DirSpec;
import org.partiql.lang.graph.EdgeSpec;
import org.partiql.lang.graph.ElemSpec;
import org.partiql.lang.graph.Graph;
import org.partiql.lang.graph.GraphEngine;
import org.partiql.lang.graph.LabelSpec;
import org.partiql.lang.graph.MatchResult;
import org.partiql.lang.graph.MatchSpec;
import org.partiql.lang.graph.NodeSpec;
import org.partiql.lang.graph.StepSpec;
import org.partiql.lang.graph.Stride;
import org.partiql.lang.graph.StrideJoin;
import org.partiql.lang.graph.StrideLeaf;
import org.partiql.lang.graph.StrideResult;
import org.partiql.lang.graph.StrideSpec;
import org.partiql.lang.graph.StrideTree;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nJ\u0014\u0010\u0014\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J(\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\fJ*\u0010 \u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\"0!0\u0016*\u00020\u00062\u0006\u0010$\u001a\u00020%\u00a8\u0006&"}, d2={"Lorg/partiql/lang/graph/GraphEngine;", "", "()V", "evaluate", "Lorg/partiql/lang/graph/MatchResult;", "graph", "Lorg/partiql/lang/graph/Graph;", "matchSpec", "Lorg/partiql/lang/graph/MatchSpec;", "evaluateNodeStride", "Lorg/partiql/lang/graph/StrideResult;", "stride", "Lorg/partiql/lang/graph/StrideSpec;", "evaluatePlan", "plan", "Lorg/partiql/lang/graph/StrideTree;", "evaluateStride", "joinAdjacentStrides", "left", "right", "joinStridesOnBinders", "strides", "", "planStride", "restoreStrideSpec", "strideTree", "stridesJoinable", "Lkotlin/Function2;", "Lorg/partiql/lang/graph/Stride;", "", "leftSpec", "rightSpec", "getMatchingSteps", "Lkotlin/Triple;", "Lorg/partiql/lang/graph/Graph$Node;", "Lorg/partiql/lang/graph/Graph$Edge;", "spec", "Lorg/partiql/lang/graph/StepSpec;", "partiql-lang"})
public final class GraphEngine {
    @NotNull
    public static final GraphEngine INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Triple<Graph.Node, Graph.Edge, Graph.Node>> getMatchingSteps(@NotNull Graph $this$getMatchingSteps, @NotNull StepSpec spec) {
        void dirSpec;
        Intrinsics.checkNotNullParameter((Object)$this$getMatchingSteps, (String)"$this$getMatchingSteps");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        StepSpec stepSpec = spec;
        DirSpec dirSpec2 = stepSpec.component1();
        Triple<LabelSpec, LabelSpec, LabelSpec> tripleSpec = stepSpec.component2();
        List result = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)(dirSpec.getWantUndir() ? $this$getMatchingSteps.scanUndir(tripleSpec) : CollectionsKt.emptyList()), (Iterable)(dirSpec.getWantLeft() && dirSpec.getWantRight() ? $this$getMatchingSteps.scanDirectedBlunt(tripleSpec) : CollectionsKt.emptyList())), (Iterable)(!dirSpec.getWantLeft() && dirSpec.getWantRight() ? $this$getMatchingSteps.scanDirectedStraight(tripleSpec) : CollectionsKt.emptyList())), (Iterable)(dirSpec.getWantLeft() && !dirSpec.getWantRight() ? $this$getMatchingSteps.scanDirectedFlipped(tripleSpec) : CollectionsKt.emptyList()));
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MatchResult evaluate(@NotNull Graph graph, @NotNull MatchSpec matchSpec) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)matchSpec, (String)"matchSpec");
        Iterable $this$map$iv = matchSpec.getStrides();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StrideSpec strideSpec = (StrideSpec)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            StrideResult strideResult = INSTANCE.evaluateStride(graph, (StrideSpec)it);
            collection.add(strideResult);
        }
        List strideResults = (List)destination$iv$iv;
        return this.joinStridesOnBinders(strideResults);
    }

    private final StrideResult evaluateStride(Graph graph, StrideSpec stride) {
        if (stride.getElems().size() == 1) {
            return this.evaluateNodeStride(graph, stride);
        }
        StrideTree plan = this.planStride(stride);
        boolean bl = Intrinsics.areEqual((Object)stride, (Object)this.restoreStrideSpec(plan));
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Bad stride plan, not equivalent to the original stride.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return this.evaluatePlan(graph, plan);
    }

    /*
     * WARNING - void declaration
     */
    private final StrideResult evaluateNodeStride(Graph graph, StrideSpec stride) {
        Collection<Stride> collection;
        Collection destination$iv$iv;
        StrideSpec strideSpec;
        boolean bl = stride.getElems().size() == 1;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ElemSpec node = stride.getElems().get(0);
        if (node instanceof EdgeSpec) {
            String string = "Bug: evaluateNodeStride should not be called on an EdgeSpec";
            bl3 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        if (node instanceof NodeSpec) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = graph.scanNodes(((NodeSpec)node).getLabel());
            strideSpec = stride;
            boolean $i$f$map = false;
            void var6_11 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Graph.Node node2 = (Graph.Node)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                Stride stride2 = new Stride(CollectionsKt.listOf((Object)it));
                collection.add(stride2);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        StrideSpec strideSpec2 = strideSpec;
        return new StrideResult(strideSpec2, list);
    }

    private final StrideTree planStride(StrideSpec stride) {
        boolean bl = stride.getElems().size() >= 3;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        planStride.1 $fun$leafFrom3$1 = planStride.1.INSTANCE;
        planStride.2 $fun$planRightLeaning$2 = planStride.2.INSTANCE;
        return $fun$planRightLeaning$2.invoke(stride.getElems());
    }

    private final StrideSpec restoreStrideSpec(StrideTree strideTree) {
        restoreStrideSpec.1 $fun$restore$1 = restoreStrideSpec.1.INSTANCE;
        return new StrideSpec($fun$restore$1.invoke(strideTree));
    }

    /*
     * WARNING - void declaration
     */
    private final StrideResult evaluatePlan(Graph graph, StrideTree plan) {
        StrideResult strideResult;
        StrideTree strideTree = plan;
        if (strideTree instanceof StrideLeaf) {
            Collection<Stride> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Triple it;
            void $this$filterTo$iv$iv;
            List<ElemSpec> step = ((StrideLeaf)plan).getStride().getElems();
            boolean bl = step.size() == 3;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "A leaf stride in a StrideTree plan must have exactly 3 elements";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            ElemSpec elemSpec = step.get(0);
            if (elemSpec == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.partiql.lang.graph.NodeSpec");
            }
            NodeSpec lft = (NodeSpec)elemSpec;
            ElemSpec elemSpec2 = step.get(1);
            if (elemSpec2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.partiql.lang.graph.EdgeSpec");
            }
            EdgeSpec edg = (EdgeSpec)elemSpec2;
            ElemSpec elemSpec3 = step.get(2);
            if (elemSpec3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.partiql.lang.graph.NodeSpec");
            }
            NodeSpec rgt = (NodeSpec)elemSpec3;
            StepSpec stepSpec = new StepSpec(edg.getDir(), (Triple<? extends LabelSpec, ? extends LabelSpec, ? extends LabelSpec>)new Triple((Object)lft.getLabel(), (Object)edg.getLabel(), (Object)rgt.getLabel()));
            List<Triple<Graph.Node, Graph.Edge, Graph.Node>> triples = this.getMatchingSteps(graph, stepSpec);
            Function1 bindCheck2 = lft.getBinder() != null && rgt.getBinder() != null && Intrinsics.areEqual((Object)lft.getBinder(), (Object)rgt.getBinder()) ? (Function1)evaluatePlan.bindCheck.1.INSTANCE : (Function1)evaluatePlan.bindCheck.2.INSTANCE;
            Iterable $this$filter$iv = triples;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Triple)element$iv$iv;
                boolean bl5 = false;
                if (!((Boolean)bindCheck2.invoke((Object)it)).booleanValue()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List prunedTriples = (List)destination$iv$iv;
            $this$filter$iv = prunedTriples;
            StrideSpec strideSpec = ((StrideLeaf)plan).getStride();
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Triple)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                Stride stride = new Stride(CollectionsKt.listOf((Object[])new Graph.Elem[]{(Graph.Elem)it.getFirst(), (Graph.Elem)it.getSecond(), (Graph.Elem)it.getThird()}));
                collection.add(stride);
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            StrideSpec strideSpec2 = strideSpec;
            strideResult = new StrideResult(strideSpec2, list);
        } else if (strideTree instanceof StrideJoin) {
            strideResult = this.joinAdjacentStrides(this.evaluatePlan(graph, ((StrideJoin)plan).getLeft()), this.evaluatePlan(graph, ((StrideJoin)plan).getRight()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return strideResult;
    }

    @NotNull
    public final StrideResult joinAdjacentStrides(@NotNull StrideResult left, @NotNull StrideResult right) {
        List<ElemSpec> list;
        Intrinsics.checkNotNullParameter((Object)left, (String)"left");
        Intrinsics.checkNotNullParameter((Object)right, (String)"right");
        List<ElemSpec> leftSpec = left.getSpec().getElems();
        List<ElemSpec> rightSpec = right.getSpec().getElems();
        boolean bl = Intrinsics.areEqual((Object)((ElemSpec)CollectionsKt.last(leftSpec)), (Object)((ElemSpec)CollectionsKt.first(rightSpec)));
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        bl = CollectionsKt.first(rightSpec) instanceof NodeSpec;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Collection collection = leftSpec;
        List<ElemSpec> $this$tail$iv = rightSpec;
        boolean $i$f$getTail = false;
        switch ($this$tail$iv.size()) {
            case 0: 
            case 1: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                list = $this$tail$iv.subList(1, $this$tail$iv.size());
            }
        }
        List joinedSpec = CollectionsKt.plus((Collection)collection, (Iterable)list);
        Function2<Stride, Stride, Boolean> joinCondition = this.stridesJoinable(left.getSpec(), right.getSpec());
        bl4 = false;
        List joined = new ArrayList();
        for (Stride lft : left.getResult()) {
            for (Stride rgt : right.getResult()) {
                List<Graph.Elem> list2;
                if (!((Boolean)joinCondition.invoke((Object)lft, (Object)rgt)).booleanValue()) continue;
                Collection collection2 = lft.getElems();
                List<Graph.Elem> $this$tail$iv2 = rgt.getElems();
                boolean $i$f$getTail2 = false;
                switch ($this$tail$iv2.size()) {
                    case 0: 
                    case 1: {
                        list2 = CollectionsKt.emptyList();
                        break;
                    }
                    default: {
                        list2 = $this$tail$iv2.subList(1, $this$tail$iv2.size());
                    }
                }
                joined.add(new Stride(CollectionsKt.plus((Collection)collection2, (Iterable)list2)));
            }
        }
        return new StrideResult(new StrideSpec(joinedSpec), CollectionsKt.toList((Iterable)joined));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Function2<Stride, Stride, Boolean> stridesJoinable(@NotNull StrideSpec leftSpec, @NotNull StrideSpec rightSpec) {
        Intrinsics.checkNotNullParameter((Object)leftSpec, (String)"leftSpec");
        Intrinsics.checkNotNullParameter((Object)rightSpec, (String)"rightSpec");
        boolean bl = false;
        Map joinVars = new LinkedHashMap();
        bl = false;
        for (ElemSpec lftEltSpec : (Iterable)leftSpec.getElems()) {
            void lftIdx;
            if (lftEltSpec.getBinder() != null) {
                String string;
                boolean bl2 = false;
                boolean bl3 = false;
                String lftVar = string;
                boolean bl4 = false;
                if (!joinVars.keySet().contains(lftVar)) {
                    int rgtIdx;
                    block8: {
                        int n;
                        List<ElemSpec> $this$indexOfFirst$iv = rightSpec.getElems();
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        Iterator<ElemSpec> iterator2 = $this$indexOfFirst$iv.iterator();
                        while (iterator2.hasNext()) {
                            boolean bl5;
                            ElemSpec item$iv;
                            ElemSpec rgtElem = item$iv = iterator2.next();
                            boolean bl6 = false;
                            if (rgtElem.getBinder() != null) {
                                String string2;
                                boolean bl7 = false;
                                boolean bl8 = false;
                                String it = string2;
                                boolean bl9 = false;
                                bl5 = Intrinsics.areEqual((Object)it, (Object)lftVar);
                            } else {
                                bl5 = false;
                            }
                            if (bl5) {
                                n = index$iv;
                                break block8;
                            }
                            ++index$iv;
                        }
                        n = rgtIdx = -1;
                    }
                    if (rgtIdx != -1) {
                        joinVars.put(lftVar, TuplesKt.to((Object)((int)lftIdx), (Object)rgtIdx));
                    }
                }
            }
            ++lftIdx;
        }
        List joinPoints = CollectionsKt.plus(joinVars.values(), (Object)new Pair((Object)CollectionsKt.getLastIndex(leftSpec.getElems()), (Object)0));
        return (Function2)new Function2<Stride, Stride, Boolean>(joinPoints){
            final /* synthetic */ List $joinPoints;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull Stride leftStride, @NotNull Stride rightStride) {
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)leftStride, (String)"leftStride");
                    Intrinsics.checkNotNullParameter((Object)rightStride, (String)"rightStride");
                    Iterable $this$all$iv = this.$joinPoints;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            void lft;
                            Pair $dstr$lft$rgt = (Pair)element$iv;
                            boolean bl2 = false;
                            int n = ((Number)$dstr$lft$rgt.component1()).intValue();
                            int rgt = ((Number)$dstr$lft$rgt.component2()).intValue();
                            if (Intrinsics.areEqual((Object)leftStride.getElems().get((int)lft), (Object)rightStride.getElems().get(rgt))) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl;
            }
            {
                this.$joinPoints = list;
                super(2);
            }
        };
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final MatchResult joinStridesOnBinders(@NotNull List<StrideResult> strides) {
        Intrinsics.checkNotNullParameter(strides, (String)"strides");
        switch (strides.size()) {
            case 0: {
                String string = "Bug: should not call joinStridesOnBinders on a zero-length list of stride results.";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            case 1: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void spec;
                Object object = strides.get(0);
                StrideSpec strideSpec = ((StrideResult)object).component1();
                List<Stride> res = ((StrideResult)object).component2();
                object = res;
                List list = CollectionsKt.listOf((Object)spec);
                boolean $i$f$map = false;
                void var6_11 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator2 = $this$mapTo$iv$iv.iterator();
                while (true) {
                    void it;
                    Collection<List> collection;
                    if (!iterator2.hasNext()) {
                        collection = (List)destination$iv$iv;
                        List list2 = collection;
                        List list3 = list;
                        return new MatchResult(list3, list2);
                    }
                    Object item$iv$iv = iterator2.next();
                    Stride stride = (Stride)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    List list4 = CollectionsKt.listOf((Object)it);
                    collection.add(list4);
                }
            }
        }
        String string = "Later: non-trivial join of strides on binders (when there is two or more strides).";
        boolean bl = false;
        throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
    }

    private GraphEngine() {
    }

    static {
        GraphEngine graphEngine;
        INSTANCE = graphEngine = new GraphEngine();
    }
}

