/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.domains.PartiqlAst;
import org.partiql.lang.graph.DirSpec;
import org.partiql.lang.graph.EdgeSpec;
import org.partiql.lang.graph.ElemSpec;
import org.partiql.lang.graph.LabelSpec;
import org.partiql.lang.graph.MatchSpec;
import org.partiql.lang.graph.NodeSpec;
import org.partiql.lang.graph.StrideSpec;
import org.partiql.pig.runtime.SymbolPrimitive;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0004J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u001f\u001a\u00020 \u00a8\u0006!"}, d2={"Lorg/partiql/lang/graph/GpmlTranslator;", "", "()V", "normalizeElemList", "", "Lorg/partiql/lang/graph/ElemSpec;", "elems", "translateDirection", "Lorg/partiql/lang/graph/DirSpec;", "dir", "Lorg/partiql/lang/domains/PartiqlAst$GraphMatchDirection;", "translateEdgePat", "Lorg/partiql/lang/graph/EdgeSpec;", "edge", "Lorg/partiql/lang/domains/PartiqlAst$GraphMatchPatternPart$Edge;", "translateGpmlPattern", "Lorg/partiql/lang/graph/MatchSpec;", "gpml", "Lorg/partiql/lang/domains/PartiqlAst$GpmlPattern;", "translateLabels", "Lorg/partiql/lang/graph/LabelSpec;", "labels", "Lorg/partiql/pig/runtime/SymbolPrimitive;", "translateNodePat", "Lorg/partiql/lang/graph/NodeSpec;", "node", "Lorg/partiql/lang/domains/PartiqlAst$GraphMatchPatternPart$Node;", "translatePartPat", "part", "Lorg/partiql/lang/domains/PartiqlAst$GraphMatchPatternPart;", "translatePathPat", "path", "Lorg/partiql/lang/domains/PartiqlAst$GraphMatchPattern;", "partiql-lang"})
public final class GpmlTranslator {
    @NotNull
    public static final GpmlTranslator INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MatchSpec translateGpmlPattern(@NotNull PartiqlAst.GpmlPattern gpml) {
        Collection<StrideSpec> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)gpml, (String)"gpml");
        if (gpml.getSelector() != null) {
            String string = "Evaluation of GPML selectors is not yet supported";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        Iterable $this$map$iv = gpml.getPatterns();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PartiqlAst.GraphMatchPattern graphMatchPattern = (PartiqlAst.GraphMatchPattern)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            StrideSpec strideSpec = new StrideSpec(INSTANCE.normalizeElemList(INSTANCE.translatePathPat((PartiqlAst.GraphMatchPattern)it)));
            collection.add(strideSpec);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        return new MatchSpec(list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ElemSpec> translatePathPat(@NotNull PartiqlAst.GraphMatchPattern path) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (path.getPrefilter() != null || path.getQuantifier() != null || path.getRestrictor() != null || path.getVariable() != null) {
            String string = "Not yet supported in evaluating a GPML path pattern: prefilters, quantifiers, restrictors, binder variables.";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        Iterable $this$flatMap$iv = path.getParts();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PartiqlAst.GraphMatchPatternPart it = (PartiqlAst.GraphMatchPatternPart)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = INSTANCE.translatePartPat(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<ElemSpec> translatePartPat(@NotNull PartiqlAst.GraphMatchPatternPart part) {
        List<ElemSpec> list;
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        PartiqlAst.GraphMatchPatternPart graphMatchPatternPart = part;
        if (graphMatchPatternPart instanceof PartiqlAst.GraphMatchPatternPart.Node) {
            list = CollectionsKt.listOf((Object)this.translateNodePat((PartiqlAst.GraphMatchPatternPart.Node)part));
        } else if (graphMatchPatternPart instanceof PartiqlAst.GraphMatchPatternPart.Edge) {
            list = CollectionsKt.listOf((Object)this.translateEdgePat((PartiqlAst.GraphMatchPatternPart.Edge)part));
        } else if (graphMatchPatternPart instanceof PartiqlAst.GraphMatchPatternPart.Pattern) {
            list = this.translatePathPat(((PartiqlAst.GraphMatchPatternPart.Pattern)part).getPattern());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @NotNull
    public final NodeSpec translateNodePat(@NotNull PartiqlAst.GraphMatchPatternPart.Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.getPrefilter() != null) {
            String string = "Not yet supported in evaluating a GPML node pattern: prefilter.";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        SymbolPrimitive symbolPrimitive = node.getVariable();
        return new NodeSpec(symbolPrimitive != null ? symbolPrimitive.getText() : null, this.translateLabels(node.getLabel()));
    }

    @NotNull
    public final EdgeSpec translateEdgePat(@NotNull PartiqlAst.GraphMatchPatternPart.Edge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        if (edge.getPrefilter() != null || edge.getQuantifier() != null) {
            String string = "Not yet supported in evaluating a GPML edge pattern: prefilter, quantifier.";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        SymbolPrimitive symbolPrimitive = edge.getVariable();
        return new EdgeSpec(symbolPrimitive != null ? symbolPrimitive.getText() : null, this.translateLabels(edge.getLabel()), this.translateDirection(edge.getDirection()));
    }

    @NotNull
    public final LabelSpec translateLabels(@NotNull List<SymbolPrimitive> labels) {
        LabelSpec labelSpec;
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        switch (labels.size()) {
            case 0: {
                labelSpec = LabelSpec.Whatever.INSTANCE;
                break;
            }
            case 1: {
                labelSpec = new LabelSpec.OneOf(labels.get(0).getText());
                break;
            }
            default: {
                String string = "Not yet supported in evaluating a GPML graph element pattern: multiple/alternating labels";
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
        }
        return labelSpec;
    }

    @NotNull
    public final DirSpec translateDirection(@NotNull PartiqlAst.GraphMatchDirection dir) {
        DirSpec dirSpec;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        PartiqlAst.GraphMatchDirection graphMatchDirection = dir;
        if (graphMatchDirection instanceof PartiqlAst.GraphMatchDirection.EdgeLeft) {
            dirSpec = DirSpec.DirL__;
        } else if (graphMatchDirection instanceof PartiqlAst.GraphMatchDirection.EdgeUndirected) {
            dirSpec = DirSpec.Dir_U_;
        } else if (graphMatchDirection instanceof PartiqlAst.GraphMatchDirection.EdgeRight) {
            dirSpec = DirSpec.Dir__R;
        } else if (graphMatchDirection instanceof PartiqlAst.GraphMatchDirection.EdgeLeftOrUndirected) {
            dirSpec = DirSpec.DirLU_;
        } else if (graphMatchDirection instanceof PartiqlAst.GraphMatchDirection.EdgeUndirectedOrRight) {
            dirSpec = DirSpec.Dir_UR;
        } else if (graphMatchDirection instanceof PartiqlAst.GraphMatchDirection.EdgeLeftOrRight) {
            dirSpec = DirSpec.DirL_R;
        } else if (graphMatchDirection instanceof PartiqlAst.GraphMatchDirection.EdgeLeftOrUndirectedOrRight) {
            dirSpec = DirSpec.DirLUR;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return dirSpec;
    }

    @NotNull
    public final List<ElemSpec> normalizeElemList(@NotNull List<? extends ElemSpec> elems) {
        Intrinsics.checkNotNullParameter(elems, (String)"elems");
        NodeSpec fillerNode = new NodeSpec(null, LabelSpec.Whatever.INSTANCE);
        boolean bl = false;
        List normalized = new ArrayList();
        boolean expectNode = true;
        for (ElemSpec elemSpec : elems) {
            ElemSpec elemSpec2;
            if (expectNode) {
                elemSpec2 = elemSpec;
                if (elemSpec2 instanceof NodeSpec) {
                    normalized.add(elemSpec);
                    expectNode = false;
                    continue;
                }
                if (!(elemSpec2 instanceof EdgeSpec)) continue;
                normalized.add(fillerNode);
                normalized.add(elemSpec);
                continue;
            }
            elemSpec2 = elemSpec;
            if (elemSpec2 instanceof NodeSpec) {
                String string = "Deal with adjacent nodes in a pattern.  Unify? Prohibit?";
                boolean bl2 = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
            if (!(elemSpec2 instanceof EdgeSpec)) continue;
            normalized.add(elemSpec);
            expectNode = true;
        }
        if (expectNode) {
            normalized.add(fillerNode);
        }
        return CollectionsKt.toList((Iterable)normalized);
    }

    private GpmlTranslator() {
    }

    static {
        GpmlTranslator gpmlTranslator;
        INSTANCE = gpmlTranslator = new GpmlTranslator();
    }
}

