/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.visitors;

import com.amazon.ionelement.api.AnyElement;
import com.amazon.ionelement.api.IntElement;
import com.amazon.ionelement.api.IntElementSize;
import com.amazon.ionelement.api.TextElement;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.ast.passes.SemanticException;
import org.partiql.lang.domains.PartiqlAst;
import org.partiql.lang.domains.UtilKt;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.errors.Property;
import org.partiql.lang.errors.PropertyValueMap;
import org.partiql.lang.eval.CompileOptions;
import org.partiql.lang.eval.EvaluationException;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.TypedOpBehavior;
import org.partiql.pig.runtime.LongPrimitive;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0003\u001a\u00020\u0004J4\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u001eH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/partiql/lang/eval/visitors/PartiqlAstSanityValidator;", "Lorg/partiql/lang/domains/PartiqlAst$Visitor;", "()V", "compileOptions", "Lorg/partiql/lang/eval/CompileOptions;", "validate", "", "statement", "Lorg/partiql/lang/domains/PartiqlAst$Statement;", "validateDecimalOrNumericType", "scale", "Lorg/partiql/pig/runtime/LongPrimitive;", "precision", "metas", "", "", "", "Lcom/amazon/ionelement/api/MetaContainer;", "visitExprCallAgg", "node", "Lorg/partiql/lang/domains/PartiqlAst$Expr$CallAgg;", "visitExprLit", "Lorg/partiql/lang/domains/PartiqlAst$Expr$Lit;", "visitExprSelect", "Lorg/partiql/lang/domains/PartiqlAst$Expr$Select;", "visitExprStruct", "Lorg/partiql/lang/domains/PartiqlAst$Expr$Struct;", "visitTypeDecimalType", "Lorg/partiql/lang/domains/PartiqlAst$Type$DecimalType;", "visitTypeNumericType", "Lorg/partiql/lang/domains/PartiqlAst$Type$NumericType;", "partiql-lang"})
public final class PartiqlAstSanityValidator
extends PartiqlAst.Visitor {
    private CompileOptions compileOptions = CompileOptions.Companion.standard();

    public final void validate(@NotNull PartiqlAst.Statement statement, @NotNull CompileOptions compileOptions) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)compileOptions, (String)"compileOptions");
        this.compileOptions = compileOptions;
        this.walkStatement(statement);
    }

    public static /* synthetic */ void validate$default(PartiqlAstSanityValidator partiqlAstSanityValidator, PartiqlAst.Statement statement, CompileOptions compileOptions, int n, Object object) {
        if ((n & 2) != 0) {
            compileOptions = CompileOptions.Companion.standard();
        }
        partiqlAstSanityValidator.validate(statement, compileOptions);
    }

    @Override
    protected void visitExprLit(@NotNull PartiqlAst.Expr.Lit node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        AnyElement ionValue = node.getValue();
        Map<String, Object> metas = node.getMetas();
        if (node.getValue() instanceof IntElement && ionValue.getIntegerSize() == IntElementSize.BIG_INTEGER) {
            throw (Throwable)new EvaluationException("Int overflow or underflow at compile time", ErrorCode.SEMANTIC_LITERAL_INT_OVERFLOW, ExceptionsKt.errorContextFrom(metas), null, false, 8, null);
        }
    }

    private final void validateDecimalOrNumericType(LongPrimitive scale, LongPrimitive precision, Map<String, ? extends Object> metas) {
        if (scale != null && precision != null && this.compileOptions.getTypedOpBehavior() == TypedOpBehavior.HONOR_PARAMETERS) {
            if (precision.getValue() <= 0L) {
                Void void_ = ExceptionsKt.err("Precision " + precision.getValue() + " should be a positive integer", ErrorCode.SEMANTIC_INVALID_DECIMAL_ARGUMENTS, ExceptionsKt.errorContextFrom(metas), false);
                throw new KotlinNothingValueException();
            }
            long l = scale.getValue();
            if (0L > l || precision.getValue() < l) {
                Void void_ = ExceptionsKt.err("Scale " + scale.getValue() + " should be between 0 and precision " + precision.getValue(), ErrorCode.SEMANTIC_INVALID_DECIMAL_ARGUMENTS, ExceptionsKt.errorContextFrom(metas), false);
                throw new KotlinNothingValueException();
            }
        }
    }

    @Override
    protected void visitTypeDecimalType(@NotNull PartiqlAst.Type.DecimalType node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.validateDecimalOrNumericType(node.getScale(), node.getPrecision(), node.getMetas());
    }

    @Override
    protected void visitTypeNumericType(@NotNull PartiqlAst.Type.NumericType node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.validateDecimalOrNumericType(node.getScale(), node.getPrecision(), node.getMetas());
    }

    @Override
    protected void visitExprCallAgg(@NotNull PartiqlAst.Expr.CallAgg node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PartiqlAst.SetQuantifier setQuantifier = node.getSetq();
        Map<String, Object> metas = node.getMetas();
        if (setQuantifier instanceof PartiqlAst.SetQuantifier.Distinct && metas.containsKey("$is_count_star")) {
            Void void_ = ExceptionsKt.err("COUNT(DISTINCT *) is not supported", ErrorCode.EVALUATOR_COUNT_DISTINCT_STAR, ExceptionsKt.errorContextFrom(metas), false);
            throw new KotlinNothingValueException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void visitExprSelect(@NotNull PartiqlAst.Expr.Select node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PartiqlAst.Projection projection = node.getProject();
        PartiqlAst.GroupBy groupBy = node.getGroup();
        PartiqlAst.Expr having2 = node.getHaving();
        Map<String, Object> metas = node.getMetas();
        if (groupBy != null) {
            if (groupBy.getStrategy() instanceof PartiqlAst.GroupingStrategy.GroupPartial) {
                void it;
                PropertyValueMap propertyValueMap = ExceptionsKt.errorContextFrom(metas);
                boolean bl = false;
                boolean bl2 = false;
                PropertyValueMap propertyValueMap2 = propertyValueMap;
                ErrorCode errorCode = ErrorCode.EVALUATOR_FEATURE_NOT_SUPPORTED_YET;
                String string = "GROUP PARTIAL not supported yet";
                boolean bl3 = false;
                it.set(Property.FEATURE_NAME, "GROUP PARTIAL");
                Unit unit = Unit.INSTANCE;
                Void void_ = ExceptionsKt.err(string, errorCode, propertyValueMap, false);
                throw new KotlinNothingValueException();
            }
            PartiqlAst.Projection projection2 = projection;
            if (projection2 instanceof PartiqlAst.Projection.ProjectPivot) {
                void it;
                PropertyValueMap propertyValueMap = ExceptionsKt.errorContextFrom(metas);
                boolean bl = false;
                boolean bl4 = false;
                PropertyValueMap bl3 = propertyValueMap;
                ErrorCode errorCode = ErrorCode.EVALUATOR_FEATURE_NOT_SUPPORTED_YET;
                String string = "PIVOT with GROUP BY not supported yet";
                boolean bl5 = false;
                it.set(Property.FEATURE_NAME, "PIVOT with GROUP BY");
                Unit unit = Unit.INSTANCE;
                Void void_ = ExceptionsKt.err(string, errorCode, propertyValueMap, false);
                throw new KotlinNothingValueException();
            }
            if (projection2 instanceof PartiqlAst.Projection.ProjectValue || projection2 instanceof PartiqlAst.Projection.ProjectList) {
                // empty if block
            }
        }
        if ((groupBy == null || groupBy.getKeyList().getKeys().isEmpty()) && having2 != null) {
            throw (Throwable)new SemanticException("HAVING used without GROUP BY (or grouping expressions)", ErrorCode.SEMANTIC_HAVING_USED_WITHOUT_GROUP_BY, UtilKt.addSourceLocation(new PropertyValueMap(null, 1, null), metas), null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void visitExprStruct(@NotNull PartiqlAst.Expr.Struct node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Iterable $this$forEach$iv = node.getFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void pvm;
            PartiqlAst.ExprPair field2 = (PartiqlAst.ExprPair)element$iv;
            boolean bl = false;
            if (!(field2.getFirst() instanceof PartiqlAst.Expr.Missing) && (!(field2.getFirst() instanceof PartiqlAst.Expr.Lit) || ((PartiqlAst.Expr.Lit)field2.getFirst()).getValue() instanceof TextElement)) continue;
            Object object = field2.getFirst();
            String type2 = object instanceof PartiqlAst.Expr.Lit ? ((PartiqlAst.Expr.Lit)field2.getFirst()).getValue().getType().toString() : "MISSING";
            object = UtilKt.addSourceLocation(new PropertyValueMap(null, 1, null), field2.getFirst().getMetas());
            boolean bl2 = false;
            boolean bl3 = false;
            Object object2 = object;
            ErrorCode errorCode = ErrorCode.SEMANTIC_NON_TEXT_STRUCT_FIELD_KEY;
            String string = "Found struct field to be of type " + type2;
            boolean bl4 = false;
            pvm.set(Property.ACTUAL_TYPE, type2);
            Unit unit = Unit.INSTANCE;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 8;
            Throwable throwable = null;
            Object object3 = object;
            ErrorCode errorCode2 = errorCode;
            String string2 = string;
            throw (Throwable)new SemanticException(string2, errorCode2, (PropertyValueMap)object3, throwable, n, defaultConstructorMarker);
        }
    }
}

