/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins.internal;

import com.amazon.ion.Timestamp;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.builtins.internal.TimestampExtensionsKt$WhenMappings;
import org.partiql.lang.eval.time.Time;
import org.partiql.lang.syntax.DateTimePart;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00102\u0006\u0010\f\u001a\u00020\u0002H\u0000\u001a\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0003H\u0000\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u000bH\u0000\u001a\f\u0010\u0016\u001a\u00020\u0015*\u00020\u000bH\u0000\u001a\u0014\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018*\u00020\u000bH\u0000\" \u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"dateTimePartToPrecision", "", "Lorg/partiql/lang/syntax/DateTimePart;", "Lcom/amazon/ion/Timestamp$Precision;", "getDateTimePartToPrecision", "()Ljava/util/Map;", "precisionOrder", "", "getPrecisionOrder", "()Ljava/util/List;", "adjustPrecisionTo", "Lcom/amazon/ion/Timestamp;", "dateTimePart", "extractedValue", "Ljava/math/BigDecimal;", "Ljava/time/LocalDate;", "Lorg/partiql/lang/eval/time/Time;", "hasSufficientPrecisionFor", "", "requiredPrecision", "hourOffset", "", "minuteOffset", "toOffsetDateTime", "Ljava/time/OffsetDateTime;", "kotlin.jvm.PlatformType", "partiql-lang"})
public final class TimestampExtensionsKt {
    @NotNull
    private static final List<Timestamp.Precision> precisionOrder = CollectionsKt.listOf((Object[])new Timestamp.Precision[]{Timestamp.Precision.YEAR, Timestamp.Precision.MONTH, Timestamp.Precision.DAY, Timestamp.Precision.MINUTE, Timestamp.Precision.SECOND});
    @NotNull
    private static final Map<DateTimePart, Timestamp.Precision> dateTimePartToPrecision = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)DateTimePart.YEAR), (Object)Timestamp.Precision.YEAR), TuplesKt.to((Object)((Object)DateTimePart.MONTH), (Object)Timestamp.Precision.MONTH), TuplesKt.to((Object)((Object)DateTimePart.DAY), (Object)Timestamp.Precision.DAY), TuplesKt.to((Object)((Object)DateTimePart.HOUR), (Object)Timestamp.Precision.MINUTE), TuplesKt.to((Object)((Object)DateTimePart.MINUTE), (Object)Timestamp.Precision.MINUTE), TuplesKt.to((Object)((Object)DateTimePart.SECOND), (Object)Timestamp.Precision.SECOND)});

    @NotNull
    public static final List<Timestamp.Precision> getPrecisionOrder() {
        return precisionOrder;
    }

    @NotNull
    public static final Map<DateTimePart, Timestamp.Precision> getDateTimePartToPrecision() {
        return dateTimePartToPrecision;
    }

    public static final boolean hasSufficientPrecisionFor(@NotNull Timestamp $this$hasSufficientPrecisionFor, @NotNull Timestamp.Precision requiredPrecision) {
        Intrinsics.checkNotNullParameter((Object)$this$hasSufficientPrecisionFor, (String)"$this$hasSufficientPrecisionFor");
        Intrinsics.checkNotNullParameter((Object)requiredPrecision, (String)"requiredPrecision");
        int requiredPrecisionPos = precisionOrder.indexOf(requiredPrecision);
        int precisionPos = precisionOrder.indexOf($this$hasSufficientPrecisionFor.getPrecision());
        return precisionPos >= requiredPrecisionPos;
    }

    @NotNull
    public static final Timestamp adjustPrecisionTo(@NotNull Timestamp $this$adjustPrecisionTo, @NotNull DateTimePart dateTimePart) {
        Timestamp timestamp;
        Intrinsics.checkNotNullParameter((Object)$this$adjustPrecisionTo, (String)"$this$adjustPrecisionTo");
        Intrinsics.checkNotNullParameter((Object)((Object)dateTimePart), (String)"dateTimePart");
        Timestamp.Precision precision = dateTimePartToPrecision.get((Object)dateTimePart);
        Intrinsics.checkNotNull((Object)precision);
        Timestamp.Precision requiredPrecision = precision;
        if (TimestampExtensionsKt.hasSufficientPrecisionFor($this$adjustPrecisionTo, requiredPrecision)) {
            return $this$adjustPrecisionTo;
        }
        switch (TimestampExtensionsKt$WhenMappings.$EnumSwitchMapping$0[requiredPrecision.ordinal()]) {
            case 1: {
                Timestamp timestamp2 = Timestamp.forYear((int)$this$adjustPrecisionTo.getYear());
                timestamp = timestamp2;
                Intrinsics.checkNotNullExpressionValue((Object)timestamp2, (String)"Timestamp.forYear(this.year)");
                break;
            }
            case 2: {
                Timestamp timestamp3 = Timestamp.forMonth((int)$this$adjustPrecisionTo.getYear(), (int)$this$adjustPrecisionTo.getMonth());
                timestamp = timestamp3;
                Intrinsics.checkNotNullExpressionValue((Object)timestamp3, (String)"Timestamp.forMonth(this.year, this.month)");
                break;
            }
            case 3: {
                Timestamp timestamp4 = Timestamp.forDay((int)$this$adjustPrecisionTo.getYear(), (int)$this$adjustPrecisionTo.getMonth(), (int)$this$adjustPrecisionTo.getDay());
                timestamp = timestamp4;
                Intrinsics.checkNotNullExpressionValue((Object)timestamp4, (String)"Timestamp.forDay(this.year, this.month, this.day)");
                break;
            }
            case 4: {
                Timestamp timestamp5 = Timestamp.forSecond((int)$this$adjustPrecisionTo.getYear(), (int)$this$adjustPrecisionTo.getMonth(), (int)$this$adjustPrecisionTo.getDay(), (int)$this$adjustPrecisionTo.getHour(), (int)$this$adjustPrecisionTo.getMinute(), (int)$this$adjustPrecisionTo.getSecond(), (Integer)$this$adjustPrecisionTo.getLocalOffset());
                timestamp = timestamp5;
                Intrinsics.checkNotNullExpressionValue((Object)timestamp5, (String)"Timestamp.forSecond(\n   \u2026his.localOffset\n        )");
                break;
            }
            case 5: {
                Timestamp timestamp6 = Timestamp.forMinute((int)$this$adjustPrecisionTo.getYear(), (int)$this$adjustPrecisionTo.getMonth(), (int)$this$adjustPrecisionTo.getDay(), (int)$this$adjustPrecisionTo.getHour(), (int)$this$adjustPrecisionTo.getMinute(), (Integer)$this$adjustPrecisionTo.getLocalOffset());
                timestamp = timestamp6;
                Intrinsics.checkNotNullExpressionValue((Object)timestamp6, (String)"Timestamp.forMinute(\n   \u2026his.localOffset\n        )");
                break;
            }
            default: {
                StringBuilder stringBuilder = new StringBuilder().append("invalid datetime part for date_add: ");
                String string = dateTimePart.toString();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                Void void_ = ExceptionsKt.errNoContext(stringBuilder.append(string3).toString(), ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_DATE_PART, false);
                throw new KotlinNothingValueException();
            }
        }
        return timestamp;
    }

    public static final OffsetDateTime toOffsetDateTime(@NotNull Timestamp $this$toOffsetDateTime) {
        Intrinsics.checkNotNullParameter((Object)$this$toOffsetDateTime, (String)"$this$toOffsetDateTime");
        Integer n = $this$toOffsetDateTime.getLocalOffset();
        return OffsetDateTime.of($this$toOffsetDateTime.getYear(), $this$toOffsetDateTime.getMonth(), $this$toOffsetDateTime.getDay(), $this$toOffsetDateTime.getHour(), $this$toOffsetDateTime.getMinute(), $this$toOffsetDateTime.getSecond(), 0, ZoneOffset.ofTotalSeconds((n != null ? n : 0) * 60));
    }

    public static final int hourOffset(@NotNull Timestamp $this$hourOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$hourOffset, (String)"$this$hourOffset");
        Integer n = $this$hourOffset.getLocalOffset();
        return (n != null ? n : 0) / 60;
    }

    public static final int minuteOffset(@NotNull Timestamp $this$minuteOffset) {
        Intrinsics.checkNotNullParameter((Object)$this$minuteOffset, (String)"$this$minuteOffset");
        Integer n = $this$minuteOffset.getLocalOffset();
        return (n != null ? n : 0) % 60;
    }

    @NotNull
    public static final BigDecimal extractedValue(@NotNull Timestamp $this$extractedValue, @NotNull DateTimePart dateTimePart) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$extractedValue, (String)"$this$extractedValue");
        Intrinsics.checkNotNullParameter((Object)((Object)dateTimePart), (String)"dateTimePart");
        switch (TimestampExtensionsKt$WhenMappings.$EnumSwitchMapping$1[dateTimePart.ordinal()]) {
            case 1: {
                n = $this$extractedValue.getYear();
                break;
            }
            case 2: {
                n = $this$extractedValue.getMonth();
                break;
            }
            case 3: {
                n = $this$extractedValue.getDay();
                break;
            }
            case 4: {
                n = $this$extractedValue.getHour();
                break;
            }
            case 5: {
                n = $this$extractedValue.getMinute();
                break;
            }
            case 6: {
                n = $this$extractedValue.getSecond();
                break;
            }
            case 7: {
                n = TimestampExtensionsKt.hourOffset($this$extractedValue);
                break;
            }
            case 8: {
                n = TimestampExtensionsKt.minuteOffset($this$extractedValue);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int n2 = n;
        boolean bl = false;
        BigDecimal bigDecimal = BigDecimal.valueOf(n2);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimal.valueOf(this.toLong())");
        return bigDecimal;
    }

    @NotNull
    public static final BigDecimal extractedValue(@NotNull LocalDate $this$extractedValue, @NotNull DateTimePart dateTimePart) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$extractedValue, (String)"$this$extractedValue");
        Intrinsics.checkNotNullParameter((Object)((Object)dateTimePart), (String)"dateTimePart");
        switch (TimestampExtensionsKt$WhenMappings.$EnumSwitchMapping$2[dateTimePart.ordinal()]) {
            case 1: {
                n = $this$extractedValue.getYear();
                break;
            }
            case 2: {
                n = $this$extractedValue.getMonthValue();
                break;
            }
            case 3: {
                n = $this$extractedValue.getDayOfMonth();
                break;
            }
            case 4: 
            case 5: {
                StringBuilder stringBuilder = new StringBuilder().append("Timestamp unit ");
                String string = dateTimePart.name();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                Void void_ = ExceptionsKt.errNoContext(stringBuilder.append(string3).append(" not supported for DATE type").toString(), ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_FUNC_CALL, false);
                throw new KotlinNothingValueException();
            }
            case 6: 
            case 7: 
            case 8: {
                n = 0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int n2 = n;
        boolean bl = false;
        BigDecimal bigDecimal = BigDecimal.valueOf(n2);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimal.valueOf(this.toLong())");
        return bigDecimal;
    }

    @NotNull
    public static final BigDecimal extractedValue(@NotNull Time $this$extractedValue, @NotNull DateTimePart dateTimePart) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)$this$extractedValue, (String)"$this$extractedValue");
        Intrinsics.checkNotNullParameter((Object)((Object)dateTimePart), (String)"dateTimePart");
        switch (TimestampExtensionsKt$WhenMappings.$EnumSwitchMapping$3[dateTimePart.ordinal()]) {
            case 1: {
                int n = $this$extractedValue.getLocalTime().getHour();
                boolean bl = false;
                BigDecimal bigDecimal = BigDecimal.valueOf(n);
                number = bigDecimal;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimal.valueOf(this.toLong())");
                break;
            }
            case 2: {
                int n = $this$extractedValue.getLocalTime().getMinute();
                boolean bl = false;
                BigDecimal bigDecimal = BigDecimal.valueOf(n);
                number = bigDecimal;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimal.valueOf(this.toLong())");
                break;
            }
            case 3: {
                number = $this$extractedValue.getSecondsWithFractionalPart();
                break;
            }
            case 4: {
                boolean bl;
                number = $this$extractedValue.getTimezoneHour();
                if (number != null) {
                    int n = (Integer)number;
                    bl = false;
                    BigDecimal bigDecimal = BigDecimal.valueOf(n);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimal.valueOf(this.toLong())");
                    number = bigDecimal;
                    if (bigDecimal != null) break;
                }
                StringBuilder stringBuilder = new StringBuilder().append("Time unit ");
                String string = dateTimePart.name();
                bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                Void void_ = ExceptionsKt.errNoContext(stringBuilder.append(string3).append(" not supported for TIME type without TIME ZONE").toString(), ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_FUNC_CALL, false);
                throw new KotlinNothingValueException();
            }
            case 5: {
                boolean bl;
                number = $this$extractedValue.getTimezoneMinute();
                if (number != null) {
                    int n = (Integer)number;
                    bl = false;
                    BigDecimal bigDecimal = BigDecimal.valueOf(n);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimal.valueOf(this.toLong())");
                    number = bigDecimal;
                    if (bigDecimal != null) break;
                }
                StringBuilder stringBuilder = new StringBuilder().append("Time unit ");
                String string = dateTimePart.name();
                bl = false;
                String string4 = string;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
                Void void_ = ExceptionsKt.errNoContext(stringBuilder.append(string5).append(" not supported for TIME type without TIME ZONE").toString(), ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_FUNC_CALL, false);
                throw new KotlinNothingValueException();
            }
            case 6: 
            case 7: 
            case 8: {
                StringBuilder stringBuilder = new StringBuilder().append("Time unit ");
                String string = dateTimePart.name();
                boolean bl = false;
                String string6 = string;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).toLowerCase()");
                Void void_ = ExceptionsKt.errNoContext(stringBuilder.append(string7).append(" not supported for TIME type.").toString(), ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_FUNC_CALL, false);
                throw new KotlinNothingValueException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return number;
    }
}

