/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import com.amazon.ion.Timestamp;
import java.math.BigDecimal;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.eval.EvaluationSession;
import org.partiql.lang.eval.ExprFunction;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.types.FunctionSignature;
import org.partiql.types.StaticType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u001e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionUnixTimestamp;", "Lorg/partiql/lang/eval/ExprFunction;", "()V", "millisPerSecond", "Ljava/math/BigDecimal;", "signature", "Lorg/partiql/lang/types/FunctionSignature;", "getSignature", "()Lorg/partiql/lang/types/FunctionSignature;", "callWithOptional", "Lorg/partiql/lang/eval/ExprValue;", "session", "Lorg/partiql/lang/eval/EvaluationSession;", "required", "", "opt", "callWithRequired", "epoch", "timestamp", "Lcom/amazon/ion/Timestamp;", "partiql-lang"})
public final class ExprFunctionUnixTimestamp
implements ExprFunction {
    @NotNull
    private static final FunctionSignature signature;
    private static final BigDecimal millisPerSecond;
    @NotNull
    public static final ExprFunctionUnixTimestamp INSTANCE;

    @Override
    @NotNull
    public FunctionSignature getSignature() {
        return signature;
    }

    private final BigDecimal epoch(Timestamp timestamp) {
        BigDecimal bigDecimal = timestamp.getDecimalMillis().divide(millisPerSecond);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"timestamp.decimalMillis.divide(millisPerSecond)");
        return bigDecimal;
    }

    @Override
    @NotNull
    public ExprValue callWithRequired(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        return ExprValue.Companion.newInt(this.epoch(session.getNow()).longValue());
    }

    @Override
    @NotNull
    public ExprValue callWithOptional(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull ExprValue opt) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        Intrinsics.checkNotNullParameter((Object)opt, (String)"opt");
        Timestamp timestamp = ExprValueExtensionsKt.timestampValue(opt);
        BigDecimal epochTime = this.epoch(timestamp);
        return timestamp.getDecimalSecond().scale() == 0 ? ExprValue.Companion.newInt(epochTime.longValue()) : ExprValue.Companion.newDecimal(epochTime);
    }

    private ExprFunctionUnixTimestamp() {
    }

    static {
        ExprFunctionUnixTimestamp exprFunctionUnixTimestamp;
        INSTANCE = exprFunctionUnixTimestamp = new ExprFunctionUnixTimestamp();
        boolean bl = false;
        signature = new FunctionSignature("unix_timestamp", CollectionsKt.emptyList(), (StaticType)StaticType.TIMESTAMP, StaticType.Companion.unionOf$default((StaticType.Companion)StaticType.Companion, (StaticType[])new StaticType[]{(StaticType)StaticType.INT, (StaticType)StaticType.DECIMAL}, null, (int)2, null), null, 16, null);
        millisPerSecond = new BigDecimal(1000);
    }

    @Override
    @NotNull
    public ExprValue callWithVariadic(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull List<? extends ExprValue> variadic) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        Intrinsics.checkNotNullParameter(variadic, (String)"variadic");
        return ExprFunction.DefaultImpls.callWithVariadic(this, session, required, variadic);
    }
}

