/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.eval.EvaluationSession;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.ExprFunction;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.builtins.ExprFunctionTrim;
import org.partiql.lang.eval.builtins.internal.CodePointExtensionsKt;
import org.partiql.lang.types.FunctionSignature;
import org.partiql.lang.types.VarargFormalParameter;
import org.partiql.types.StaticType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016J,\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016J&\u0010\u000f\u001a\u0018\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionTrim;", "Lorg/partiql/lang/eval/ExprFunction;", "()V", "signature", "Lorg/partiql/lang/types/FunctionSignature;", "getSignature", "()Lorg/partiql/lang/types/FunctionSignature;", "callWithRequired", "Lorg/partiql/lang/eval/ExprValue;", "session", "Lorg/partiql/lang/eval/EvaluationSession;", "required", "", "callWithVariadic", "variadic", "getTrimFnOrNull", "Lkotlin/Function2;", "", "trimSpecification", "trim1Arg", "sourceString", "trim2Arg", "specificationOrToRemove", "trim3Arg", "specification", "toRemove", "partiql-lang"})
public final class ExprFunctionTrim
implements ExprFunction {
    @NotNull
    private static final FunctionSignature signature;
    @NotNull
    public static final ExprFunctionTrim INSTANCE;

    @Override
    @NotNull
    public FunctionSignature getSignature() {
        return signature;
    }

    @Override
    @NotNull
    public ExprValue callWithRequired(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        String result = this.trim1Arg(required.get(0));
        return ExprValue.Companion.newString(result);
    }

    @Override
    @NotNull
    public ExprValue callWithVariadic(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull List<? extends ExprValue> variadic) {
        String string;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        Intrinsics.checkNotNullParameter(variadic, (String)"variadic");
        switch (variadic.size()) {
            case 0: {
                string = this.trim1Arg(required.get(0));
                break;
            }
            case 1: {
                string = this.trim2Arg(required.get(0), variadic.get(0));
                break;
            }
            case 2: {
                string = this.trim3Arg(required.get(0), variadic.get(0), variadic.get(1));
                break;
            }
            default: {
                Void void_ = ExceptionsKt.errNoContext("invalid trim arguments, should be unreachable", ErrorCode.INTERNAL_ERROR, true);
                throw new KotlinNothingValueException();
            }
        }
        String result = string;
        return ExprValue.Companion.newString(result);
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Function2<String, String, String> getTrimFnOrNull(String trimSpecification) {
        Function2 function2;
        block7: {
            String string = trimSpecification;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            string = string3;
            bl = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            switch (string.hashCode()) {
                case 1276059676: {
                    if (!string.equals("trailing")) return null;
                    break block7;
                }
                case 50359046: {
                    if (!string.equals("leading")) return null;
                    break;
                }
                case 3029889: {
                    if (!string.equals("both")) return null;
                    function2 = getTrimFnOrNull.1.INSTANCE;
                    return function2;
                }
            }
            function2 = getTrimFnOrNull.2.INSTANCE;
            return function2;
        }
        function2 = getTrimFnOrNull.3.INSTANCE;
        return function2;
        return null;
    }

    private final String trim1Arg(ExprValue sourceString) {
        return CodePointExtensionsKt.codepointTrim$default(ExprValueExtensionsKt.stringValue(sourceString), null, 2, null);
    }

    private final String trim2Arg(ExprValue specificationOrToRemove, ExprValue sourceString) {
        if (!specificationOrToRemove.getType().isText()) {
            Void void_ = ExceptionsKt.errNoContext("with two arguments trim's first argument must be either the specification or a 'to remove' string", ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_TRIM, false);
            throw new KotlinNothingValueException();
        }
        String arg0 = ExprValueExtensionsKt.stringValue(specificationOrToRemove);
        String arg1 = ExprValueExtensionsKt.stringValue(sourceString);
        Function2<String, String, String> trimFn = this.getTrimFnOrNull(arg0);
        return trimFn == null ? CodePointExtensionsKt.codepointTrim(arg1, arg0) : (String)trimFn.invoke((Object)arg1, null);
    }

    private final String trim3Arg(ExprValue specification, ExprValue toRemove, ExprValue sourceString) {
        String arg0 = ExprValueExtensionsKt.stringValue(specification);
        String arg1 = ExprValueExtensionsKt.stringValue(toRemove);
        String arg2 = ExprValueExtensionsKt.stringValue(sourceString);
        Function2<String, String, String> trimFn = this.getTrimFnOrNull(arg0);
        if (trimFn == null) {
            Void void_ = ExceptionsKt.errNoContext('\'' + arg0 + "' is an unknown trim specification, valid values: BOTH, TRAILING, LEADING", ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_TRIM, false);
            throw new KotlinNothingValueException();
        }
        return (String)trimFn.invoke((Object)arg2, (Object)arg1);
    }

    private ExprFunctionTrim() {
    }

    static {
        ExprFunctionTrim exprFunctionTrim;
        INSTANCE = exprFunctionTrim = new ExprFunctionTrim();
        int n = 0;
        signature = new FunctionSignature("trim", CollectionsKt.listOf((Object)StaticType.TEXT), new VarargFormalParameter((StaticType)StaticType.STRING, new IntRange(n, 2)), (StaticType)StaticType.STRING, null, 16, null);
    }

    @Override
    @NotNull
    public ExprValue callWithOptional(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull ExprValue opt) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        Intrinsics.checkNotNullParameter((Object)opt, (String)"opt");
        return ExprFunction.DefaultImpls.callWithOptional(this, session, required, opt);
    }
}

