/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import com.amazon.ion.Timestamp;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.errors.PropertyValueMap;
import org.partiql.lang.eval.EvaluationException;
import org.partiql.lang.eval.EvaluationSession;
import org.partiql.lang.eval.ExprFunction;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.builtins.internal.TimestampParser;
import org.partiql.lang.types.FunctionSignature;
import org.partiql.types.StaticType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionToTimestamp;", "Lorg/partiql/lang/eval/ExprFunction;", "()V", "signature", "Lorg/partiql/lang/types/FunctionSignature;", "getSignature", "()Lorg/partiql/lang/types/FunctionSignature;", "callWithOptional", "Lorg/partiql/lang/eval/ExprValue;", "session", "Lorg/partiql/lang/eval/EvaluationSession;", "required", "", "opt", "callWithRequired", "partiql-lang"})
public final class ExprFunctionToTimestamp
implements ExprFunction {
    @NotNull
    private static final FunctionSignature signature;
    @NotNull
    public static final ExprFunctionToTimestamp INSTANCE;

    @Override
    @NotNull
    public FunctionSignature getSignature() {
        return signature;
    }

    @Override
    @NotNull
    public ExprValue callWithRequired(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required) {
        Timestamp ts;
        Timestamp timestamp;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        try {
            timestamp = Timestamp.valueOf((CharSequence)ExprValueExtensionsKt.stringValue(required.get(0)));
        }
        catch (IllegalArgumentException ex) {
            throw (Throwable)new EvaluationException("Timestamp was not a valid ion timestamp", ErrorCode.EVALUATOR_ION_TIMESTAMP_PARSE_FAILURE, new PropertyValueMap(null, 1, null), ex, false);
        }
        Timestamp timestamp2 = ts = timestamp;
        Intrinsics.checkNotNullExpressionValue((Object)timestamp2, (String)"ts");
        return ExprValue.Companion.newTimestamp(timestamp2);
    }

    @Override
    @NotNull
    public ExprValue callWithOptional(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull ExprValue opt) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        Intrinsics.checkNotNullParameter((Object)opt, (String)"opt");
        Timestamp ts = TimestampParser.Companion.parseTimestamp(ExprValueExtensionsKt.stringValue(required.get(0)), ExprValueExtensionsKt.stringValue(opt));
        return ExprValue.Companion.newTimestamp(ts);
    }

    private ExprFunctionToTimestamp() {
    }

    static {
        ExprFunctionToTimestamp exprFunctionToTimestamp;
        INSTANCE = exprFunctionToTimestamp = new ExprFunctionToTimestamp();
        signature = new FunctionSignature("to_timestamp", CollectionsKt.listOf((Object)StaticType.STRING), (StaticType)StaticType.STRING, (StaticType)StaticType.TIMESTAMP, null, 16, null);
    }

    @Override
    @NotNull
    public ExprValue callWithVariadic(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull List<? extends ExprValue> variadic) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        Intrinsics.checkNotNullParameter(variadic, (String)"variadic");
        return ExprFunction.DefaultImpls.callWithVariadic(this, session, required, variadic);
    }
}

