/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.eval.EvaluationSession;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.ExprFunction;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.ExprValueType;
import org.partiql.lang.types.FunctionSignature;
import org.partiql.types.SingleType;
import org.partiql.types.StaticType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016J)\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionSubstring;", "Lorg/partiql/lang/eval/ExprFunction;", "()V", "signature", "Lorg/partiql/lang/types/FunctionSignature;", "getSignature", "()Lorg/partiql/lang/types/FunctionSignature;", "callWithOptional", "Lorg/partiql/lang/eval/ExprValue;", "session", "Lorg/partiql/lang/eval/EvaluationSession;", "required", "", "opt", "callWithRequired", "substring", "target", "", "startPosition", "", "quantity", "(Ljava/lang/String;ILjava/lang/Integer;)Lorg/partiql/lang/eval/ExprValue;", "partiql-lang"})
public final class ExprFunctionSubstring
implements ExprFunction {
    @NotNull
    private static final FunctionSignature signature;
    @NotNull
    public static final ExprFunctionSubstring INSTANCE;

    @Override
    @NotNull
    public FunctionSignature getSignature() {
        return signature;
    }

    @Override
    @NotNull
    public ExprValue callWithRequired(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        String target = ExprValueExtensionsKt.stringValue(required.get(0));
        if (required.get(1).getType() != ExprValueType.INT) {
            Void void_ = ExceptionsKt.errNoContext("Function substring with two parameters must be of form substring(<string> FROM <int>)", ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_FUNC_CALL, false);
            throw new KotlinNothingValueException();
        }
        int startPosition = ExprValueExtensionsKt.intValue(required.get(1));
        return ExprFunctionSubstring.substring$default(this, target, startPosition, null, 4, null);
    }

    @Override
    @NotNull
    public ExprValue callWithOptional(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull ExprValue opt) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        Intrinsics.checkNotNullParameter((Object)opt, (String)"opt");
        int quantity = ExprValueExtensionsKt.intValue(opt);
        if (quantity < 0) {
            Void void_ = ExceptionsKt.errNoContext("Argument 3 of substring has to be greater than 0.", ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_FUNC_CALL, false);
            throw new KotlinNothingValueException();
        }
        String target = ExprValueExtensionsKt.stringValue(required.get(0));
        if (required.get(1).getType() != ExprValueType.INT) {
            Void void_ = ExceptionsKt.errNoContext("Regular expression substring (SQL T581) currently not supported", ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_FUNC_CALL, false);
            throw new KotlinNothingValueException();
        }
        int startPosition = ExprValueExtensionsKt.intValue(required.get(1));
        return this.substring(target, startPosition, quantity);
    }

    private final ExprValue substring(String target, int startPosition, Integer quantity) {
        int adjustedStartPosition;
        String string = target;
        int n = 0;
        int n2 = target.length();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        int codePointCount = string2.codePointCount(n, n2);
        if (startPosition > codePointCount) {
            return ExprValue.Companion.newString("");
        }
        Integer n3 = quantity;
        int endPosition = n3 == null ? codePointCount : Integer.min(codePointCount, startPosition + quantity - 1);
        if (endPosition < (adjustedStartPosition = Integer.max(0, startPosition - 1))) {
            return ExprValue.Companion.newString("");
        }
        String string3 = target;
        int n4 = 0;
        int n5 = 0;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        int byteIndexStart = string4.offsetByCodePoints(n4, adjustedStartPosition);
        String string5 = target;
        n5 = 0;
        boolean bl2 = false;
        String string6 = string5;
        if (string6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        int byteIndexEnd = string6.offsetByCodePoints(n5, endPosition);
        string5 = target;
        n5 = 0;
        String string7 = string5;
        if (string7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string8 = string7.substring(byteIndexStart, byteIndexEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return ExprValue.Companion.newString(string8);
    }

    static /* synthetic */ ExprValue substring$default(ExprFunctionSubstring exprFunctionSubstring, String string, int n, Integer n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return exprFunctionSubstring.substring(string, n, n2);
    }

    private ExprFunctionSubstring() {
    }

    static {
        ExprFunctionSubstring exprFunctionSubstring;
        INSTANCE = exprFunctionSubstring = new ExprFunctionSubstring();
        signature = new FunctionSignature("substring", CollectionsKt.listOf((Object[])new SingleType[]{(SingleType)StaticType.STRING, (SingleType)StaticType.INT}), (StaticType)StaticType.INT, (StaticType)StaticType.STRING, null, 16, null);
    }

    @Override
    @NotNull
    public ExprValue callWithVariadic(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull List<? extends ExprValue> variadic) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        Intrinsics.checkNotNullParameter(variadic, (String)"variadic");
        return ExprFunction.DefaultImpls.callWithVariadic(this, session, required, variadic);
    }
}

