/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import java.math.BigDecimal;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.builtins.internal.ExprFunctionUnaryNumeric;
import org.partiql.lang.util.NumberExtensionsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionSqrt;", "Lorg/partiql/lang/eval/builtins/internal/ExprFunctionUnaryNumeric;", "()V", "call", "", "x", "partiql-lang"})
public final class ExprFunctionSqrt
extends ExprFunctionUnaryNumeric {
    @NotNull
    public static final ExprFunctionSqrt INSTANCE;

    @Override
    @NotNull
    public Number call(@NotNull Number x) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        if (NumberExtensionsKt.compareTo(x, 0L) < 0) {
            Void void_ = ExceptionsKt.errNoContext("Cannot take root of a negative number", ErrorCode.EVALUATOR_ARITHMETIC_EXCEPTION, false);
            throw new KotlinNothingValueException();
        }
        Number number2 = x;
        if (number2 instanceof Long) {
            double d = x.doubleValue();
            boolean bl = false;
            number = Math.sqrt(d);
        } else if (number2 instanceof Double) {
            double d = x.doubleValue();
            boolean bl = false;
            number = Math.sqrt(d);
        } else if (number2 instanceof Float) {
            float f = x.floatValue();
            boolean bl = false;
            number = Float.valueOf((float)Math.sqrt(f));
        } else if (number2 instanceof BigDecimal) {
            number = NumberExtensionsKt.squareRoot$default((BigDecimal)x, null, 1, null);
        } else {
            Void void_ = ExceptionsKt.errNoContext("Unknown number type", ErrorCode.INTERNAL_ERROR, true);
            throw new KotlinNothingValueException();
        }
        return number;
    }

    private ExprFunctionSqrt() {
        super("sqrt");
    }

    static {
        ExprFunctionSqrt exprFunctionSqrt;
        INSTANCE = exprFunctionSqrt = new ExprFunctionSqrt();
    }
}

