/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import java.math.BigDecimal;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.builtins.internal.ExprFunctionBinaryNumeric;
import org.partiql.lang.util.NumberExtensionsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionPow;", "Lorg/partiql/lang/eval/builtins/internal/ExprFunctionBinaryNumeric;", "()V", "call", "", "x", "y", "partiql-lang"})
public final class ExprFunctionPow
extends ExprFunctionBinaryNumeric {
    @NotNull
    public static final ExprFunctionPow INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Number call(@NotNull Number x, @NotNull Number y) {
        Number number;
        void first;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Pair<Number, Number> pair = NumberExtensionsKt.isPosInf(x) || NumberExtensionsKt.isNegInf(x) || NumberExtensionsKt.isNaN(x) ? TuplesKt.to((Object)x, (Object)y.doubleValue()) : (NumberExtensionsKt.isPosInf(y) || NumberExtensionsKt.isNegInf(y) || NumberExtensionsKt.isNaN(y) ? TuplesKt.to((Object)x.doubleValue(), (Object)y) : NumberExtensionsKt.coerceNumbers(x, y));
        Number number2 = (Number)pair.component1();
        Number second = (Number)pair.component2();
        pair = first;
        if (pair instanceof Long) {
            double d = first.doubleValue();
            double d2 = second.doubleValue();
            boolean bl = false;
            number = Math.pow(d, d2);
        } else if (pair instanceof Double) {
            if (first.doubleValue() < 0.0) {
                Number number3 = second;
                if (number3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
                }
                if ((Double)number3 % 1.0 != 0.0) {
                    Void void_ = ExceptionsKt.errNoContext("a negative number raised to a non-integer power yields a complex result", ErrorCode.EVALUATOR_ARITHMETIC_EXCEPTION, false);
                    throw new KotlinNothingValueException();
                }
            }
            double d = first.doubleValue();
            Number number4 = second;
            if (number4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
            }
            double d3 = (Double)number4;
            boolean bl = false;
            number = Math.pow(d, d3);
        } else if (pair instanceof BigDecimal) {
            BigDecimal bigDecimal;
            try {
                Number number5 = second;
                if (number5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.math.BigDecimal");
                }
                bigDecimal = NumberExtensionsKt.power$default((BigDecimal)first, (BigDecimal)number5, null, 2, null);
            }
            catch (Exception e) {
                String string = e.getMessage();
                if (string == null) {
                    string = "Arithmetic Error";
                }
                Void void_ = ExceptionsKt.errNoContext(string, ErrorCode.EVALUATOR_ARITHMETIC_EXCEPTION, false);
                throw new KotlinNothingValueException();
            }
            number = bigDecimal;
        } else {
            throw (Throwable)new IllegalStateException();
        }
        return number;
    }

    private ExprFunctionPow() {
        super("pow");
    }

    static {
        ExprFunctionPow exprFunctionPow;
        INSTANCE = exprFunctionPow = new ExprFunctionPow();
    }
}

