/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.eval.EvaluationSession;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.ExprFunction;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.builtins.internal.CodePointExtensionsKt;
import org.partiql.lang.types.FunctionSignature;
import org.partiql.types.StaticType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016J,\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionOverlay;", "Lorg/partiql/lang/eval/ExprFunction;", "()V", "signature", "Lorg/partiql/lang/types/FunctionSignature;", "getSignature", "()Lorg/partiql/lang/types/FunctionSignature;", "callWithOptional", "Lorg/partiql/lang/eval/ExprValue;", "session", "Lorg/partiql/lang/eval/EvaluationSession;", "required", "", "opt", "callWithRequired", "overlay", "arg0", "arg1", "arg2", "arg3", "partiql-lang"})
public final class ExprFunctionOverlay
implements ExprFunction {
    @NotNull
    private static final FunctionSignature signature;
    @NotNull
    public static final ExprFunctionOverlay INSTANCE;

    @Override
    @NotNull
    public FunctionSignature getSignature() {
        return signature;
    }

    @Override
    @NotNull
    public ExprValue callWithRequired(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        return ExprFunctionOverlay.overlay$default(this, required.get(0), required.get(1), required.get(2), null, 8, null);
    }

    @Override
    @NotNull
    public ExprValue callWithOptional(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull ExprValue opt) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        Intrinsics.checkNotNullParameter((Object)opt, (String)"opt");
        return this.overlay(required.get(0), required.get(1), required.get(2), opt);
    }

    private final ExprValue overlay(ExprValue arg0, ExprValue arg1, ExprValue arg2, ExprValue arg3) {
        int position = ExprValueExtensionsKt.intValue(arg2);
        if (position < 1) {
            Void void_ = ExceptionsKt.errNoContext("invalid position '" + position + "', must be at least 1", ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_TRIM, false);
            throw new KotlinNothingValueException();
        }
        String source = ExprValueExtensionsKt.stringValue(arg0);
        String overlay = ExprValueExtensionsKt.stringValue(arg1);
        ExprValue exprValue2 = arg3;
        int length = exprValue2 != null ? ExprValueExtensionsKt.intValue(exprValue2) : overlay.length();
        String result = CodePointExtensionsKt.codepointOverlay(source, overlay, position, length);
        return ExprValue.Companion.newString(result);
    }

    static /* synthetic */ ExprValue overlay$default(ExprFunctionOverlay exprFunctionOverlay, ExprValue exprValue2, ExprValue exprValue3, ExprValue exprValue4, ExprValue exprValue5, int n, Object object) {
        if ((n & 8) != 0) {
            exprValue5 = null;
        }
        return exprFunctionOverlay.overlay(exprValue2, exprValue3, exprValue4, exprValue5);
    }

    private ExprFunctionOverlay() {
    }

    static {
        ExprFunctionOverlay exprFunctionOverlay;
        INSTANCE = exprFunctionOverlay = new ExprFunctionOverlay();
        signature = new FunctionSignature("overlay", CollectionsKt.listOf((Object[])new StaticType[]{StaticType.TEXT, StaticType.TEXT, (StaticType)StaticType.INT}), (StaticType)StaticType.INT, (StaticType)StaticType.STRING, null, 16, null);
    }

    @Override
    @NotNull
    public ExprValue callWithVariadic(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull List<? extends ExprValue> variadic) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        Intrinsics.checkNotNullParameter(variadic, (String)"variadic");
        return ExprFunction.DefaultImpls.callWithVariadic(this, session, required, variadic);
    }
}

