/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import java.math.BigDecimal;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.eval.EvaluationException;
import org.partiql.lang.eval.EvaluationSession;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.ExprFunction;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.time.Time;
import org.partiql.lang.types.FunctionSignature;
import org.partiql.types.SingleType;
import org.partiql.types.StaticType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016J/\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0011H\u0002\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionMakeTime;", "Lorg/partiql/lang/eval/ExprFunction;", "()V", "signature", "Lorg/partiql/lang/types/FunctionSignature;", "getSignature", "()Lorg/partiql/lang/types/FunctionSignature;", "callWithOptional", "Lorg/partiql/lang/eval/ExprValue;", "session", "Lorg/partiql/lang/eval/EvaluationSession;", "required", "", "opt", "callWithRequired", "makeTime", "hour", "", "minute", "second", "Ljava/math/BigDecimal;", "tzMinutes", "(IILjava/math/BigDecimal;Ljava/lang/Integer;)Lorg/partiql/lang/eval/ExprValue;", "partiql-lang"})
public final class ExprFunctionMakeTime
implements ExprFunction {
    @NotNull
    private static final FunctionSignature signature;
    @NotNull
    public static final ExprFunctionMakeTime INSTANCE;

    @Override
    @NotNull
    public FunctionSignature getSignature() {
        return signature;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ExprValue callWithOptional(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull ExprValue opt) {
        void min;
        void hour;
        List<? extends ExprValue> list;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        Intrinsics.checkNotNullParameter((Object)opt, (String)"opt");
        List<? extends ExprValue> list2 = list = required;
        boolean bl = false;
        ExprValue exprValue2 = list2.get(0);
        list2 = list;
        bl = false;
        ExprValue exprValue3 = list2.get(1);
        list2 = list;
        bl = false;
        ExprValue sec = list2.get(2);
        return this.makeTime(ExprValueExtensionsKt.intValue((ExprValue)hour), ExprValueExtensionsKt.intValue((ExprValue)min), ExprValueExtensionsKt.bigDecimalValue(sec), ExprValueExtensionsKt.intValue(opt));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ExprValue callWithRequired(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required) {
        void min;
        void hour;
        List<? extends ExprValue> list;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        List<? extends ExprValue> list2 = list = required;
        boolean bl = false;
        ExprValue exprValue2 = list2.get(0);
        list2 = list;
        bl = false;
        ExprValue exprValue3 = list2.get(1);
        list2 = list;
        bl = false;
        ExprValue sec = list2.get(2);
        return this.makeTime(ExprValueExtensionsKt.intValue((ExprValue)hour), ExprValueExtensionsKt.intValue((ExprValue)min), ExprValueExtensionsKt.bigDecimalValue(sec), null);
    }

    private final ExprValue makeTime(int hour, int minute, BigDecimal second, Integer tzMinutes) {
        try {
            int n = second.intValue();
            BigDecimal bigDecimal = second.remainder(BigDecimal.ONE);
            int n2 = 1000000000;
            boolean bl = false;
            BigDecimal bigDecimal2 = BigDecimal.valueOf(n2);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"BigDecimal.valueOf(this.toLong())");
            return ExprValue.Companion.newTime(Time.Companion.of(hour, minute, n, bigDecimal.multiply(bigDecimal2).intValue(), second.scale(), tzMinutes));
        }
        catch (EvaluationException e) {
            Void void_ = ExceptionsKt.err(e.getMessage(), ErrorCode.EVALUATOR_TIME_FIELD_OUT_OF_RANGE, e.getErrorContext(), false);
            throw new KotlinNothingValueException();
        }
    }

    private ExprFunctionMakeTime() {
    }

    static {
        ExprFunctionMakeTime exprFunctionMakeTime;
        INSTANCE = exprFunctionMakeTime = new ExprFunctionMakeTime();
        signature = new FunctionSignature("make_time", CollectionsKt.listOf((Object[])new SingleType[]{(SingleType)StaticType.INT, (SingleType)StaticType.INT, (SingleType)StaticType.DECIMAL}), (StaticType)StaticType.INT, (StaticType)StaticType.TIME, null, 16, null);
    }

    @Override
    @NotNull
    public ExprValue callWithVariadic(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull List<? extends ExprValue> variadic) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        Intrinsics.checkNotNullParameter(variadic, (String)"variadic");
        return ExprFunction.DefaultImpls.callWithVariadic(this, session, required, variadic);
    }
}

