/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import com.amazon.ion.Timestamp;
import java.math.BigDecimal;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.eval.EvaluationSession;
import org.partiql.lang.eval.ExprFunction;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.types.FunctionSignature;
import org.partiql.types.StaticType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionFromUnix;", "Lorg/partiql/lang/eval/ExprFunction;", "()V", "millisPerSecond", "Ljava/math/BigDecimal;", "signature", "Lorg/partiql/lang/types/FunctionSignature;", "getSignature", "()Lorg/partiql/lang/types/FunctionSignature;", "callWithRequired", "Lorg/partiql/lang/eval/ExprValue;", "session", "Lorg/partiql/lang/eval/EvaluationSession;", "required", "", "partiql-lang"})
public final class ExprFunctionFromUnix
implements ExprFunction {
    private static final BigDecimal millisPerSecond;
    @NotNull
    private static final FunctionSignature signature;
    @NotNull
    public static final ExprFunctionFromUnix INSTANCE;

    @Override
    @NotNull
    public FunctionSignature getSignature() {
        return signature;
    }

    @Override
    @NotNull
    public ExprValue callWithRequired(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required) {
        Timestamp timestamp;
        BigDecimal unixTimestamp;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        BigDecimal bigDecimal = unixTimestamp = ExprValueExtensionsKt.bigDecimalValue(required.get(0));
        BigDecimal bigDecimal2 = millisPerSecond;
        boolean bl = false;
        BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"this.multiply(other)");
        BigDecimal numMillis = bigDecimal3.stripTrailingZeros();
        Timestamp timestamp2 = timestamp = Timestamp.forMillis((BigDecimal)numMillis, null);
        Intrinsics.checkNotNullExpressionValue((Object)timestamp2, (String)"timestamp");
        return ExprValue.Companion.newTimestamp(timestamp2);
    }

    private ExprFunctionFromUnix() {
    }

    static {
        ExprFunctionFromUnix exprFunctionFromUnix;
        INSTANCE = exprFunctionFromUnix = new ExprFunctionFromUnix();
        millisPerSecond = new BigDecimal(1000);
        signature = new FunctionSignature("from_unixtime", CollectionsKt.listOf((Object)StaticType.Companion.unionOf$default((StaticType.Companion)StaticType.Companion, (StaticType[])new StaticType[]{(StaticType)StaticType.DECIMAL, (StaticType)StaticType.INT}, null, (int)2, null)), (StaticType)StaticType.TIMESTAMP, null, 8, null);
    }

    @Override
    @NotNull
    public ExprValue callWithOptional(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull ExprValue opt) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        Intrinsics.checkNotNullParameter((Object)opt, (String)"opt");
        return ExprFunction.DefaultImpls.callWithOptional(this, session, required, opt);
    }

    @Override
    @NotNull
    public ExprValue callWithVariadic(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull List<? extends ExprValue> variadic) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        Intrinsics.checkNotNullParameter(variadic, (String)"variadic");
        return ExprFunction.DefaultImpls.callWithVariadic(this, session, required, variadic);
    }
}

