/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import java.math.BigInteger;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.eval.builtins.internal.ExprFunctionUnaryNumeric;
import org.partiql.lang.eval.builtins.internal.ExprFunctionsKt;
import org.partiql.lang.util.NumberExtensionsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionFloor;", "Lorg/partiql/lang/eval/builtins/internal/ExprFunctionUnaryNumeric;", "()V", "call", "", "x", "partiql-lang"})
public final class ExprFunctionFloor
extends ExprFunctionUnaryNumeric {
    @NotNull
    public static final ExprFunctionFloor INSTANCE;

    @Override
    @NotNull
    public Number call(@NotNull Number x) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Number number2 = x;
        if (Intrinsics.areEqual((Object)number2, (Object)Double.POSITIVE_INFINITY) || Intrinsics.areEqual((Object)number2, (Object)Double.NEGATIVE_INFINITY) || Intrinsics.areEqual((Object)number2, (Object)Double.NaN)) {
            number = x;
        } else {
            BigInteger bigInteger = NumberExtensionsKt.bigDecimalOf$default(x, null, 2, null).setScale(0, RoundingMode.FLOOR).toBigIntegerExact();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"bigDecimalOf(x).setScale\u2026LOOR).toBigIntegerExact()");
            number = ExprFunctionsKt.transformIntType(bigInteger);
        }
        return number;
    }

    private ExprFunctionFloor() {
        super("floor");
    }

    static {
        ExprFunctionFloor exprFunctionFloor;
        INSTANCE = exprFunctionFloor = new ExprFunctionFloor();
    }
}

