/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.eval.ErrorDetails;
import org.partiql.lang.eval.ErrorSignaler;
import org.partiql.lang.eval.ErrorSignalerKt;
import org.partiql.lang.eval.EvaluationSession;
import org.partiql.lang.eval.ExprFunction;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueType;
import org.partiql.lang.eval.TypingMode;
import org.partiql.lang.types.FunctionSignature;
import org.partiql.types.StaticType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionCollToScalar;", "Lorg/partiql/lang/eval/ExprFunction;", "typingMode", "Lorg/partiql/lang/eval/TypingMode;", "(Lorg/partiql/lang/eval/TypingMode;)V", "signaler", "Lorg/partiql/lang/eval/ErrorSignaler;", "signature", "Lorg/partiql/lang/types/FunctionSignature;", "getSignature", "()Lorg/partiql/lang/types/FunctionSignature;", "callWithRequired", "Lorg/partiql/lang/eval/ExprValue;", "session", "Lorg/partiql/lang/eval/EvaluationSession;", "required", "", "hiccup", "reason", "", "partiql-lang"})
public final class ExprFunctionCollToScalar
implements ExprFunction {
    @NotNull
    private final FunctionSignature signature;
    private final ErrorSignaler signaler;

    @Override
    @NotNull
    public FunctionSignature getSignature() {
        return this.signature;
    }

    private final ExprValue hiccup(String reason) {
        return this.signaler.error(ErrorCode.EVALUATOR_NON_SINGLETON_COLLECTION, (Function0<ErrorDetails>)((Function0)new Function0<ErrorDetails>(reason){
            final /* synthetic */ String $reason;

            @NotNull
            public final ErrorDetails invoke() {
                return new ErrorDetails(MapsKt.emptyMap(), this.$reason, null, 4, null);
            }
            {
                this.$reason = string;
                super(0);
            }
        }));
    }

    @Override
    @NotNull
    public ExprValue callWithRequired(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        ExprValue coll = required.get(0);
        if (!coll.getType().isSequence()) {
            return this.hiccup("because it is not a collection.");
        }
        Sequence seq2 = CollectionsKt.asSequence((Iterable)coll);
        if (SequencesKt.count((Sequence)seq2) != 1) {
            return this.hiccup("because the collection does not contain exactly one member.");
        }
        ExprValue struct = (ExprValue)SequencesKt.first((Sequence)seq2);
        if (struct.getType() != ExprValueType.STRUCT) {
            return this.hiccup("because the only member of the collection is not a struct.");
        }
        Sequence vals = CollectionsKt.asSequence((Iterable)struct);
        if (SequencesKt.count((Sequence)vals) != 1) {
            return this.hiccup("because the only struct member of the collection does not contain exactly one attribute.");
        }
        return (ExprValue)SequencesKt.first((Sequence)vals);
    }

    public ExprFunctionCollToScalar(@NotNull TypingMode typingMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)typingMode), (String)"typingMode");
        this.signature = new FunctionSignature("coll_to_scalar", CollectionsKt.listOf((Object)StaticType.ANY), (StaticType)StaticType.ANY, null, 8, null);
        this.signaler = ErrorSignalerKt.createErrorSignaler(typingMode);
    }

    @Override
    @NotNull
    public ExprValue callWithOptional(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull ExprValue opt) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        Intrinsics.checkNotNullParameter((Object)opt, (String)"opt");
        return ExprFunction.DefaultImpls.callWithOptional(this, session, required, opt);
    }

    @Override
    @NotNull
    public ExprValue callWithVariadic(@NotNull EvaluationSession session, @NotNull List<? extends ExprValue> required, @NotNull List<? extends ExprValue> variadic) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(required, (String)"required");
        Intrinsics.checkNotNullParameter(variadic, (String)"variadic");
        return ExprFunction.DefaultImpls.callWithVariadic(this, session, required, variadic);
    }
}

