/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval.builtins;

import java.math.BigDecimal;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.builtins.internal.ExprFunctionUnaryNumeric;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/partiql/lang/eval/builtins/ExprFunctionAbs;", "Lorg/partiql/lang/eval/builtins/internal/ExprFunctionUnaryNumeric;", "()V", "call", "", "x", "partiql-lang"})
public final class ExprFunctionAbs
extends ExprFunctionUnaryNumeric {
    @NotNull
    public static final ExprFunctionAbs INSTANCE;

    @Override
    @NotNull
    public Number call(@NotNull Number x) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Number number2 = x;
        if (number2 instanceof Long) {
            if (Intrinsics.areEqual((Object)x, (Object)Long.MIN_VALUE)) {
                Void void_ = ExceptionsKt.errIntOverflow$default(8, null, 2, null);
                throw new KotlinNothingValueException();
            }
            long l = x.longValue();
            boolean bl = false;
            number = Math.abs(l);
        } else if (number2 instanceof Double) {
            double d = x.doubleValue();
            boolean bl = false;
            number = Math.abs(d);
        } else if (number2 instanceof Float) {
            float f = x.floatValue();
            boolean bl = false;
            number = Float.valueOf(Math.abs(f));
        } else if (number2 instanceof BigDecimal) {
            BigDecimal bigDecimal = ((BigDecimal)x).abs();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"x.abs()");
            number = bigDecimal;
        } else {
            Void void_ = ExceptionsKt.errNoContext("Unknown number type", ErrorCode.INTERNAL_ERROR, true);
            throw new KotlinNothingValueException();
        }
        return number;
    }

    private ExprFunctionAbs() {
        super("abs");
    }

    static {
        ExprFunctionAbs exprFunctionAbs;
        INSTANCE = exprFunctionAbs = new ExprFunctionAbs();
    }
}

