/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval;

import com.amazon.ion.IonType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.lang.domains.PartiqlAst;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.eval.EvaluationException;
import org.partiql.lang.eval.ExprValueType;
import org.partiql.lang.syntax.LexerConstantsKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001f\b\u0086\u0001\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001!BM\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0000J\b\u0010\u000e\u001a\u00020\u0003H\u0007R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000bR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000bj\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b \u00a8\u0006\""}, d2={"Lorg/partiql/lang/eval/ExprValueType;", "", "isUnknown", "", "isNumber", "isText", "isLob", "isSequence", "isRangedFrom", "isScalar", "(Ljava/lang/String;IZZZZZZZ)V", "()Z", "isDirectlyComparableTo", "other", "isNull", "MISSING", "NULL", "BOOL", "INT", "FLOAT", "DECIMAL", "DATE", "TIMESTAMP", "TIME", "SYMBOL", "STRING", "CLOB", "BLOB", "LIST", "SEXP", "STRUCT", "BAG", "GRAPH", "Companion", "partiql-lang"})
public final class ExprValueType
extends Enum<ExprValueType> {
    public static final /* enum */ ExprValueType MISSING;
    public static final /* enum */ ExprValueType NULL;
    public static final /* enum */ ExprValueType BOOL;
    public static final /* enum */ ExprValueType INT;
    public static final /* enum */ ExprValueType FLOAT;
    public static final /* enum */ ExprValueType DECIMAL;
    public static final /* enum */ ExprValueType DATE;
    public static final /* enum */ ExprValueType TIMESTAMP;
    public static final /* enum */ ExprValueType TIME;
    public static final /* enum */ ExprValueType SYMBOL;
    public static final /* enum */ ExprValueType STRING;
    public static final /* enum */ ExprValueType CLOB;
    public static final /* enum */ ExprValueType BLOB;
    public static final /* enum */ ExprValueType LIST;
    public static final /* enum */ ExprValueType SEXP;
    public static final /* enum */ ExprValueType STRUCT;
    public static final /* enum */ ExprValueType BAG;
    public static final /* enum */ ExprValueType GRAPH;
    private static final /* synthetic */ ExprValueType[] $VALUES;
    private final boolean isUnknown;
    private final boolean isNumber;
    private final boolean isText;
    private final boolean isLob;
    private final boolean isSequence;
    private final boolean isRangedFrom;
    private final boolean isScalar;
    private static final Map<IonType, ExprValueType> ION_TYPE_MAP;
    private static final Map<String, ExprValueType> LEX_TYPE_MAP;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    static {
        void var3_4;
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        MISSING = new ExprValueType("MISSING", 0, true, false, false, false, false, false, false, 126, null);
        NULL = new ExprValueType("NULL", 1, true, false, false, false, false, false, false, 126, null);
        BOOL = new ExprValueType("BOOL", 2, false, false, false, false, false, false, true, 63, null);
        INT = new ExprValueType("INT", 3, false, true, false, false, false, false, true, 61, null);
        FLOAT = new ExprValueType("FLOAT", 4, false, true, false, false, false, false, true, 61, null);
        DECIMAL = new ExprValueType("DECIMAL", 5, false, true, false, false, false, false, true, 61, null);
        DATE = new ExprValueType("DATE", 6, false, false, false, false, false, false, true, 63, null);
        TIMESTAMP = new ExprValueType("TIMESTAMP", 7, false, false, false, false, false, false, true, 63, null);
        TIME = new ExprValueType("TIME", 8, false, false, false, false, false, false, true, 63, null);
        SYMBOL = new ExprValueType("SYMBOL", 9, false, false, true, false, false, false, true, 59, null);
        STRING = new ExprValueType("STRING", 10, false, false, true, false, false, false, true, 59, null);
        CLOB = new ExprValueType("CLOB", 11, false, false, false, true, false, false, true, 55, null);
        BLOB = new ExprValueType("BLOB", 12, false, false, false, true, false, false, true, 55, null);
        LIST = new ExprValueType("LIST", 13, false, false, false, false, true, true, false, 79, null);
        SEXP = new ExprValueType("SEXP", 14, false, false, false, false, true, false, false, 111, null);
        STRUCT = new ExprValueType("STRUCT", 15, false, false, false, false, false, false, false, 127, null);
        BAG = new ExprValueType("BAG", 16, false, false, false, false, true, true, false, 79, null);
        GRAPH = new ExprValueType("GRAPH", 17, false, false, false, false, false, false, false, 127, null);
        $VALUES = new ExprValueType[]{MISSING, NULL, BOOL, INT, FLOAT, DECIMAL, DATE, TIMESTAMP, TIME, SYMBOL, STRING, CLOB, BLOB, LIST, SEXP, STRUCT, BAG, GRAPH};
        Companion = new Companion(null);
        ION_TYPE_MAP = MapsKt.toMap((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])((Enum[])IonType.values())), (Function1)Companion.ION_TYPE_MAP.1.INSTANCE));
        Iterable iterable = LexerConstantsKt.CORE_TYPE_NAME_ARITY_MAP.keySet();
        ExprValueType[] exprValueTypeArray = $VALUES;
        boolean $i$f$map = false;
        void var2_3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ExprValueType exprValueType;
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            try {
                exprValueType = it;
                boolean bl2 = false;
                void v0 = exprValueType;
                if (v0 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string2 = v0.toUpperCase();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
                exprValueType = ExprValueType.valueOf(string2);
            }
            catch (IllegalArgumentException e) {
                ExprValueType exprValueType2;
                switch (it) {
                    case "boolean": {
                        exprValueType2 = BOOL;
                        break;
                    }
                    case "integer8": 
                    case "smallint": 
                    case "integer": 
                    case "integer4": {
                        exprValueType2 = INT;
                        break;
                    }
                    case "double_precision": 
                    case "real": {
                        exprValueType2 = FLOAT;
                        break;
                    }
                    case "numeric": {
                        exprValueType2 = DECIMAL;
                        break;
                    }
                    case "character_varying": 
                    case "character": {
                        exprValueType2 = STRING;
                        break;
                    }
                    case "tuple": {
                        exprValueType2 = STRUCT;
                        break;
                    }
                    default: {
                        throw (Throwable)new IllegalStateException("No ExprValueType handler for " + (String)it);
                    }
                }
                exprValueType = exprValueType2;
            }
            ExprValueType type2 = exprValueType;
            Pair pair = new Pair((Object)it, (Object)type2);
            collection.add(pair);
        }
        collection = (List)var3_4;
        ExprValueType[] exprValueTypeArray2 = exprValueTypeArray;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Pair[] pairArray = thisCollection$iv.toArray(new Pair[0]);
        if (pairArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        LEX_TYPE_MAP = MapsKt.mapOf((Pair[])Arrays.copyOf(pairArray, pairArray.length));
    }

    @Deprecated(message="Please use isUnknown instead", replaceWith=@ReplaceWith(imports={}, expression="isUnknown"))
    public final boolean isNull() {
        return this.isUnknown;
    }

    public final boolean isDirectlyComparableTo(@NotNull ExprValueType other) {
        Intrinsics.checkNotNullParameter((Object)((Object)other), (String)"other");
        return this == other || this.isNumber && other.isNumber || this.isText && other.isText || this.isLob && other.isLob;
    }

    public final boolean isUnknown() {
        return this.isUnknown;
    }

    public final boolean isNumber() {
        return this.isNumber;
    }

    public final boolean isText() {
        return this.isText;
    }

    public final boolean isLob() {
        return this.isLob;
    }

    public final boolean isSequence() {
        return this.isSequence;
    }

    public final boolean isRangedFrom() {
        return this.isRangedFrom;
    }

    public final boolean isScalar() {
        return this.isScalar;
    }

    private ExprValueType(boolean isUnknown, boolean isNumber, boolean isText, boolean isLob, boolean isSequence, boolean isRangedFrom, boolean isScalar) {
        this.isUnknown = isUnknown;
        this.isNumber = isNumber;
        this.isText = isText;
        this.isLob = isLob;
        this.isSequence = isSequence;
        this.isRangedFrom = isRangedFrom;
        this.isScalar = isScalar;
    }

    /* synthetic */ ExprValueType(String string, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        if ((n2 & 4) != 0) {
            bl3 = false;
        }
        if ((n2 & 8) != 0) {
            bl4 = false;
        }
        if ((n2 & 0x10) != 0) {
            bl5 = false;
        }
        if ((n2 & 0x20) != 0) {
            bl6 = false;
        }
        if ((n2 & 0x40) != 0) {
            bl7 = false;
        }
        this(bl, bl2, bl3, bl4, bl5, bl6, bl7);
    }

    public static ExprValueType[] values() {
        return (ExprValueType[])$VALUES.clone();
    }

    public static ExprValueType valueOf(String string) {
        return Enum.valueOf(ExprValueType.class, string);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/partiql/lang/eval/ExprValueType$Companion;", "", "()V", "ION_TYPE_MAP", "", "Lcom/amazon/ion/IonType;", "Lorg/partiql/lang/eval/ExprValueType;", "LEX_TYPE_MAP", "", "fromIonType", "ionType", "fromSqlDataType", "sqlDataType", "Lorg/partiql/lang/domains/PartiqlAst$Type;", "fromSqlDataTypeOrNull", "fromTypeName", "name", "partiql-lang"})
    public static final class Companion {
        @NotNull
        public final ExprValueType fromIonType(@NotNull IonType ionType) {
            Intrinsics.checkNotNullParameter((Object)ionType, (String)"ionType");
            Object v = ION_TYPE_MAP.get(ionType);
            Intrinsics.checkNotNull(v);
            return (ExprValueType)((Object)v);
        }

        @NotNull
        public final ExprValueType fromTypeName(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            ExprValueType exprValueType = (ExprValueType)((Object)LEX_TYPE_MAP.get(name));
            if (exprValueType == null) {
                throw (Throwable)new EvaluationException("No such value type for " + name, ErrorCode.LEXER_INVALID_NAME, null, null, true, 12, null);
            }
            return exprValueType;
        }

        @NotNull
        public final ExprValueType fromSqlDataType(@NotNull PartiqlAst.Type sqlDataType) {
            Intrinsics.checkNotNullParameter((Object)sqlDataType, (String)"sqlDataType");
            ExprValueType exprValueType = this.fromSqlDataTypeOrNull(sqlDataType);
            if (exprValueType == null) {
                throw (Throwable)new EvaluationException("No such ExprValueType for " + sqlDataType.getClass().getName(), ErrorCode.SEMANTIC_UNION_TYPE_INVALID, null, null, true, 12, null);
            }
            return exprValueType;
        }

        @Nullable
        public final ExprValueType fromSqlDataTypeOrNull(@NotNull PartiqlAst.Type sqlDataType) {
            ExprValueType exprValueType;
            Intrinsics.checkNotNullParameter((Object)sqlDataType, (String)"sqlDataType");
            PartiqlAst.Type type2 = sqlDataType;
            if (type2 instanceof PartiqlAst.Type.BooleanType) {
                exprValueType = BOOL;
            } else if (type2 instanceof PartiqlAst.Type.MissingType) {
                exprValueType = MISSING;
            } else if (type2 instanceof PartiqlAst.Type.NullType) {
                exprValueType = NULL;
            } else if (type2 instanceof PartiqlAst.Type.SmallintType) {
                exprValueType = INT;
            } else if (type2 instanceof PartiqlAst.Type.Integer4Type) {
                exprValueType = INT;
            } else if (type2 instanceof PartiqlAst.Type.Integer8Type) {
                exprValueType = INT;
            } else if (type2 instanceof PartiqlAst.Type.IntegerType) {
                exprValueType = INT;
            } else if (type2 instanceof PartiqlAst.Type.FloatType) {
                exprValueType = FLOAT;
            } else if (type2 instanceof PartiqlAst.Type.RealType) {
                exprValueType = FLOAT;
            } else if (type2 instanceof PartiqlAst.Type.DoublePrecisionType) {
                exprValueType = FLOAT;
            } else if (type2 instanceof PartiqlAst.Type.DecimalType) {
                exprValueType = DECIMAL;
            } else if (type2 instanceof PartiqlAst.Type.NumericType) {
                exprValueType = DECIMAL;
            } else if (type2 instanceof PartiqlAst.Type.TimestampType) {
                exprValueType = TIMESTAMP;
            } else if (type2 instanceof PartiqlAst.Type.CharacterType) {
                exprValueType = STRING;
            } else if (type2 instanceof PartiqlAst.Type.CharacterVaryingType) {
                exprValueType = STRING;
            } else if (type2 instanceof PartiqlAst.Type.StringType) {
                exprValueType = STRING;
            } else if (type2 instanceof PartiqlAst.Type.SymbolType) {
                exprValueType = SYMBOL;
            } else if (type2 instanceof PartiqlAst.Type.ClobType) {
                exprValueType = CLOB;
            } else if (type2 instanceof PartiqlAst.Type.BlobType) {
                exprValueType = BLOB;
            } else if (type2 instanceof PartiqlAst.Type.StructType) {
                exprValueType = STRUCT;
            } else if (type2 instanceof PartiqlAst.Type.TupleType) {
                exprValueType = STRUCT;
            } else if (type2 instanceof PartiqlAst.Type.ListType) {
                exprValueType = LIST;
            } else if (type2 instanceof PartiqlAst.Type.SexpType) {
                exprValueType = SEXP;
            } else if (type2 instanceof PartiqlAst.Type.BagType) {
                exprValueType = BAG;
            } else if (type2 instanceof PartiqlAst.Type.AnyType) {
                exprValueType = null;
            } else if (type2 instanceof PartiqlAst.Type.DateType) {
                exprValueType = DATE;
            } else if (type2 instanceof PartiqlAst.Type.TimeType || type2 instanceof PartiqlAst.Type.TimeWithTimeZoneType) {
                exprValueType = TIME;
            } else if (type2 instanceof PartiqlAst.Type.CustomType) {
                exprValueType = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return exprValueType;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

