/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval;

import com.amazon.ion.IntegerSize;
import com.amazon.ion.IonBlob;
import com.amazon.ion.IonBool;
import com.amazon.ion.IonClob;
import com.amazon.ion.IonDecimal;
import com.amazon.ion.IonFloat;
import com.amazon.ion.IonInt;
import com.amazon.ion.IonList;
import com.amazon.ion.IonNull;
import com.amazon.ion.IonString;
import com.amazon.ion.IonStruct;
import com.amazon.ion.IonSymbol;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonTimestamp;
import com.amazon.ion.IonType;
import com.amazon.ion.IonValue;
import com.amazon.ion.Timestamp;
import com.amazon.ion.system.IonSystemBuilder;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.lang.ast.SourceLocationMeta;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.errors.Property;
import org.partiql.lang.errors.PropertyValueMap;
import org.partiql.lang.eval.Addressed;
import org.partiql.lang.eval.Bindings;
import org.partiql.lang.eval.EvaluationException;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValueExtensionsKt;
import org.partiql.lang.eval.ExprValueExtensionsKt$WhenMappings;
import org.partiql.lang.eval.ExprValueType;
import org.partiql.lang.eval.Named;
import org.partiql.lang.eval.NaturalExprValueComparators;
import org.partiql.lang.eval.OrderedBindNames;
import org.partiql.lang.eval.OrdinalBindings;
import org.partiql.lang.eval.Scalar;
import org.partiql.lang.eval.StructExprValue;
import org.partiql.lang.eval.TypedOpBehavior;
import org.partiql.lang.eval.time.Time;
import org.partiql.lang.graph.Graph;
import org.partiql.lang.syntax.DateTimePart;
import org.partiql.lang.syntax.LexerConstantsKt;
import org.partiql.lang.types.StaticTypeUtils;
import org.partiql.lang.util.ConfigurableExprValueFormatter;
import org.partiql.lang.util.FacetExtensionsKt;
import org.partiql.lang.util.NumberExtensionsKt;
import org.partiql.lang.util.TimeExtensionsKt;
import org.partiql.types.BagType;
import org.partiql.types.BlobType;
import org.partiql.types.BoolType;
import org.partiql.types.ClobType;
import org.partiql.types.DateType;
import org.partiql.types.DecimalType;
import org.partiql.types.FloatType;
import org.partiql.types.IntType;
import org.partiql.types.ListType;
import org.partiql.types.MissingType;
import org.partiql.types.NullType;
import org.partiql.types.NumberConstraint;
import org.partiql.types.SexpType;
import org.partiql.types.SingleType;
import org.partiql.types.StringType;
import org.partiql.types.SymbolType;
import org.partiql.types.TimeType;
import org.partiql.types.TimestampType;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u00c8\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001b0\u001aH\u0000\u001a\n\u0010\u001c\u001a\u00020\u001d*\u00020\u0010\u001a\f\u0010\u001e\u001a\u00020\u001f*\u00020\u0010H\u0000\u001a\n\u0010 \u001a\u00020\u001b*\u00020\u0010\u001a\n\u0010!\u001a\u00020\"*\u00020\u0010\u001a,\u0010#\u001a\u00020\u0010*\u00020\u00102\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+\u001a\u0015\u0010,\u001a\u00020-*\u00020\u00102\u0006\u0010.\u001a\u00020\u0010H\u0086\u0002\u001a\f\u0010/\u001a\u000200*\u00020\u0010H\u0000\u001a\n\u00101\u001a\u000202*\u00020\u0010\u001a\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u001004*\b\u0012\u0004\u0012\u00020\u001004\u001a\u0012\u00105\u001a\u00020\u001b*\u00020\u00102\u0006\u0010.\u001a\u00020\u0010\u001a\f\u00106\u001a\u00020-*\u00020\u0010H\u0000\u001a\u0014\u00107\u001a\u00020\u001b*\u00020\u00102\u0006\u0010.\u001a\u00020\u0010H\u0000\u001a\f\u00108\u001a\u00020\u001b*\u00020\u0010H\u0000\u001a\f\u00109\u001a\u00020\u001b*\u00020\u0010H\u0000\u001a\f\u0010:\u001a\u00020;*\u00020\u0010H\u0000\u001a\u001c\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020-0=*\b\u0012\u0004\u0012\u00020\u001004\u001a\u0012\u0010>\u001a\u00020\u0010*\u00020\u00102\u0006\u0010?\u001a\u00020\u0010\u001a\f\u0010@\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\n\u0010A\u001a\u00020B*\u00020\u0010\u001a\u0018\u0010C\u001a\u00020\u0010*\u00020\u00102\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016\u001a\u0010\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00100F*\u00020\u0010\u001a\n\u0010G\u001a\u00020\u0001*\u00020\u0010\u001a\n\u0010H\u001a\u00020\u0001*\u00020\u0010\u001a\n\u0010I\u001a\u00020J*\u00020\u0010\u001a\n\u0010K\u001a\u00020L*\u00020\u0010\u001a\u0014\u0010M\u001a\u00020N*\u00020\u00102\u0006\u0010O\u001a\u00020PH\u0002\u001a\u0012\u0010Q\u001a\u00020R*\u00020\u00102\u0006\u0010O\u001a\u00020P\u001a\n\u0010S\u001a\u00020\u0010*\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u0010*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012\"\u001d\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0016*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006T"}, d2={"BAG_ANNOTATION", "", "DATE_ANNOTATION", "DEFAULT_COMPARATOR", "Lorg/partiql/lang/eval/NaturalExprValueComparators;", "getDEFAULT_COMPARATOR", "()Lorg/partiql/lang/eval/NaturalExprValueComparators;", "ION_TEXT_STRING_CAST_TYPES", "", "Lorg/partiql/lang/eval/ExprValueType;", "MISSING_ANNOTATION", "TIME_ANNOTATION", "datePatternRegex", "Lkotlin/text/Regex;", "genericTimeRegex", "address", "Lorg/partiql/lang/eval/ExprValue;", "getAddress", "(Lorg/partiql/lang/eval/ExprValue;)Lorg/partiql/lang/eval/ExprValue;", "name", "getName", "orderedNames", "", "getOrderedNames", "(Lorg/partiql/lang/eval/ExprValue;)Ljava/util/List;", "createUniqueExprValueFilter", "Lkotlin/Function1;", "", "asNamed", "Lorg/partiql/lang/eval/Named;", "bigDecimalValue", "Ljava/math/BigDecimal;", "booleanValue", "bytesValue", "", "cast", "targetType", "Lorg/partiql/types/SingleType;", "typedOpBehavior", "Lorg/partiql/lang/eval/TypedOpBehavior;", "locationMeta", "Lorg/partiql/lang/ast/SourceLocationMeta;", "defaultTimezoneOffset", "Ljava/time/ZoneOffset;", "compareTo", "", "other", "dateTimePartValue", "Lorg/partiql/lang/syntax/DateTimePart;", "dateValue", "Ljava/time/LocalDate;", "distinct", "Lkotlin/sequences/Sequence;", "exprEquals", "intValue", "isDirectlyComparableTo", "isNotUnknown", "isUnknown", "longValue", "", "multiplicities", "Ljava/util/TreeMap;", "namedValue", "nameValue", "normalizeForCastToInt", "numberValue", "", "orderedNamesValue", "names", "rangeOver", "", "stringValue", "stringify", "timeValue", "Lorg/partiql/lang/eval/time/Time;", "timestampValue", "Lcom/amazon/ion/Timestamp;", "toIonStruct", "Lcom/amazon/ion/IonStruct;", "ion", "Lcom/amazon/ion/IonSystem;", "toIonValue", "Lcom/amazon/ion/IonValue;", "unnamedValue", "partiql-lang"})
public final class ExprValueExtensionsKt {
    @NotNull
    public static final String MISSING_ANNOTATION = "$missing";
    @NotNull
    public static final String BAG_ANNOTATION = "$bag";
    @NotNull
    public static final String DATE_ANNOTATION = "$date";
    @NotNull
    public static final String TIME_ANNOTATION = "$time";
    @NotNull
    private static final NaturalExprValueComparators DEFAULT_COMPARATOR = NaturalExprValueComparators.NULLS_FIRST_ASC;
    private static final Set<ExprValueType> ION_TEXT_STRING_CAST_TYPES = SetsKt.setOf((Object[])new ExprValueType[]{ExprValueType.BOOL, ExprValueType.TIMESTAMP});
    private static final Regex datePatternRegex = new Regex("\\d\\d\\d\\d-\\d\\d-\\d\\d");
    private static final Regex genericTimeRegex = new Regex("\\d\\d:\\d\\d:\\d\\d(\\.\\d*)?([+|-]\\d\\d:\\d\\d)?");

    @NotNull
    public static final ExprValue orderedNamesValue(@NotNull ExprValue $this$orderedNamesValue, @NotNull List<String> names) {
        Intrinsics.checkNotNullParameter((Object)$this$orderedNamesValue, (String)"$this$orderedNamesValue");
        Intrinsics.checkNotNullParameter(names, (String)"names");
        return new ExprValue($this$orderedNamesValue, names){
            @NotNull
            private final List<String> orderedNames;
            private final /* synthetic */ ExprValue $$delegate_0;
            final /* synthetic */ ExprValue $this_orderedNamesValue;
            final /* synthetic */ List $names;

            @NotNull
            public List<String> getOrderedNames() {
                return this.orderedNames;
            }

            @Nullable
            public <T> T asFacet(@Nullable Class<T> type2) {
                Object object = FacetExtensionsKt.downcast(this, type2);
                if (object == null) {
                    object = this.$this_orderedNamesValue.asFacet(type2);
                }
                return object;
            }

            @NotNull
            public String toString() {
                return ExprValueExtensionsKt.stringify(this);
            }
            {
                this.$this_orderedNamesValue = $receiver;
                this.$names = $captured_local_variable$1;
                this.$$delegate_0 = this.$this_orderedNamesValue;
                this.orderedNames = $captured_local_variable$1;
            }

            @NotNull
            public Bindings<ExprValue> getBindings() {
                return this.$$delegate_0.getBindings();
            }

            @NotNull
            public Graph getGraphValue() {
                return this.$$delegate_0.getGraphValue();
            }

            @NotNull
            public OrdinalBindings getOrdinalBindings() {
                return this.$$delegate_0.getOrdinalBindings();
            }

            @NotNull
            public Scalar getScalar() {
                return this.$$delegate_0.getScalar();
            }

            @NotNull
            public ExprValueType getType() {
                return this.$$delegate_0.getType();
            }

            @NotNull
            public Iterator<ExprValue> iterator() {
                return this.$$delegate_0.iterator();
            }
        };
    }

    @Nullable
    public static final List<String> getOrderedNames(@NotNull ExprValue $this$orderedNames) {
        Intrinsics.checkNotNullParameter((Object)$this$orderedNames, (String)"$this$orderedNames");
        OrderedBindNames orderedBindNames2 = (OrderedBindNames)$this$orderedNames.asFacet(OrderedBindNames.class);
        return orderedBindNames2 != null ? orderedBindNames2.getOrderedNames() : null;
    }

    @NotNull
    public static final Named asNamed(@NotNull ExprValue $this$asNamed) {
        Intrinsics.checkNotNullParameter((Object)$this$asNamed, (String)"$this$asNamed");
        return new Named($this$asNamed){
            final /* synthetic */ ExprValue $this_asNamed;

            @NotNull
            public ExprValue getName() {
                return this.$this_asNamed;
            }
            {
                this.$this_asNamed = $receiver;
            }
        };
    }

    @NotNull
    public static final ExprValue namedValue(@NotNull ExprValue $this$namedValue, @NotNull ExprValue nameValue) {
        Intrinsics.checkNotNullParameter((Object)$this$namedValue, (String)"$this$namedValue");
        Intrinsics.checkNotNullParameter((Object)nameValue, (String)"nameValue");
        return new ExprValue($this$namedValue, nameValue){
            @NotNull
            private final ExprValue name;
            private final /* synthetic */ ExprValue $$delegate_0;
            final /* synthetic */ ExprValue $this_namedValue;
            final /* synthetic */ ExprValue $nameValue;

            @NotNull
            public ExprValue getName() {
                return this.name;
            }

            @Nullable
            public <T> T asFacet(@Nullable Class<T> type2) {
                Object object = FacetExtensionsKt.downcast(this, type2);
                if (object == null) {
                    object = this.$this_namedValue.asFacet(type2);
                }
                return object;
            }

            @NotNull
            public String toString() {
                return ExprValueExtensionsKt.stringify(this);
            }
            {
                this.$this_namedValue = $receiver;
                this.$nameValue = $captured_local_variable$1;
                this.$$delegate_0 = this.$this_namedValue;
                this.name = $captured_local_variable$1;
            }

            @NotNull
            public Bindings<ExprValue> getBindings() {
                return this.$$delegate_0.getBindings();
            }

            @NotNull
            public Graph getGraphValue() {
                return this.$$delegate_0.getGraphValue();
            }

            @NotNull
            public OrdinalBindings getOrdinalBindings() {
                return this.$$delegate_0.getOrdinalBindings();
            }

            @NotNull
            public Scalar getScalar() {
                return this.$$delegate_0.getScalar();
            }

            @NotNull
            public ExprValueType getType() {
                return this.$$delegate_0.getType();
            }

            @NotNull
            public Iterator<ExprValue> iterator() {
                return this.$$delegate_0.iterator();
            }
        };
    }

    @NotNull
    public static final ExprValue unnamedValue(@NotNull ExprValue $this$unnamedValue) {
        Intrinsics.checkNotNullParameter((Object)$this$unnamedValue, (String)"$this$unnamedValue");
        Named named = (Named)$this$unnamedValue.asFacet(Named.class);
        return named == null ? $this$unnamedValue : (ExprValue)new ExprValue($this$unnamedValue){
            private final /* synthetic */ ExprValue $$delegate_0;
            final /* synthetic */ ExprValue $this_unnamedValue;

            @Nullable
            public <T> T asFacet(@Nullable Class<T> type2) {
                Class<T> clazz = type2;
                return (T)(Intrinsics.areEqual(clazz, Named.class) ? null : this.$this_unnamedValue.asFacet(type2));
            }

            @NotNull
            public String toString() {
                return ExprValueExtensionsKt.stringify(this);
            }
            {
                this.$this_unnamedValue = $receiver;
                this.$$delegate_0 = this.$this_unnamedValue;
            }

            @NotNull
            public Bindings<ExprValue> getBindings() {
                return this.$$delegate_0.getBindings();
            }

            @NotNull
            public Graph getGraphValue() {
                return this.$$delegate_0.getGraphValue();
            }

            @NotNull
            public OrdinalBindings getOrdinalBindings() {
                return this.$$delegate_0.getOrdinalBindings();
            }

            @NotNull
            public Scalar getScalar() {
                return this.$$delegate_0.getScalar();
            }

            @NotNull
            public ExprValueType getType() {
                return this.$$delegate_0.getType();
            }

            @NotNull
            public Iterator<ExprValue> iterator() {
                return this.$$delegate_0.iterator();
            }
        };
    }

    @Nullable
    public static final ExprValue getName(@NotNull ExprValue $this$name) {
        Intrinsics.checkNotNullParameter((Object)$this$name, (String)"$this$name");
        Named named = (Named)$this$name.asFacet(Named.class);
        return named != null ? named.getName() : null;
    }

    @Nullable
    public static final ExprValue getAddress(@NotNull ExprValue $this$address) {
        Intrinsics.checkNotNullParameter((Object)$this$address, (String)"$this$address");
        Addressed addressed = (Addressed)$this$address.asFacet(Addressed.class);
        return addressed != null ? addressed.getAddress() : null;
    }

    public static final boolean booleanValue(@NotNull ExprValue $this$booleanValue) {
        Intrinsics.checkNotNullParameter((Object)$this$booleanValue, (String)"$this$booleanValue");
        Boolean bl = $this$booleanValue.getScalar().booleanValue();
        if (bl == null) {
            Void void_ = ExceptionsKt.errNoContext("Expected boolean: " + $this$booleanValue, ErrorCode.EVALUATOR_UNEXPECTED_VALUE_TYPE, false);
            throw new KotlinNothingValueException();
        }
        return bl;
    }

    @NotNull
    public static final Number numberValue(@NotNull ExprValue $this$numberValue) {
        Intrinsics.checkNotNullParameter((Object)$this$numberValue, (String)"$this$numberValue");
        Number number = $this$numberValue.getScalar().numberValue();
        if (number == null) {
            Void void_ = ExceptionsKt.errNoContext("Expected number: " + $this$numberValue, ErrorCode.EVALUATOR_UNEXPECTED_VALUE_TYPE, false);
            throw new KotlinNothingValueException();
        }
        return number;
    }

    @NotNull
    public static final LocalDate dateValue(@NotNull ExprValue $this$dateValue) {
        Intrinsics.checkNotNullParameter((Object)$this$dateValue, (String)"$this$dateValue");
        LocalDate localDate = $this$dateValue.getScalar().dateValue();
        if (localDate == null) {
            Void void_ = ExceptionsKt.errNoContext("Expected date: " + $this$dateValue, ErrorCode.EVALUATOR_UNEXPECTED_VALUE_TYPE, false);
            throw new KotlinNothingValueException();
        }
        return localDate;
    }

    @NotNull
    public static final Time timeValue(@NotNull ExprValue $this$timeValue) {
        Intrinsics.checkNotNullParameter((Object)$this$timeValue, (String)"$this$timeValue");
        Time time = $this$timeValue.getScalar().timeValue();
        if (time == null) {
            Void void_ = ExceptionsKt.errNoContext("Expected time: " + $this$timeValue, ErrorCode.EVALUATOR_UNEXPECTED_VALUE_TYPE, false);
            throw new KotlinNothingValueException();
        }
        return time;
    }

    @NotNull
    public static final Timestamp timestampValue(@NotNull ExprValue $this$timestampValue) {
        Intrinsics.checkNotNullParameter((Object)$this$timestampValue, (String)"$this$timestampValue");
        Timestamp timestamp = $this$timestampValue.getScalar().timestampValue();
        if (timestamp == null) {
            Void void_ = ExceptionsKt.errNoContext("Expected timestamp: " + $this$timestampValue, ErrorCode.EVALUATOR_UNEXPECTED_VALUE_TYPE, false);
            throw new KotlinNothingValueException();
        }
        return timestamp;
    }

    @NotNull
    public static final String stringValue(@NotNull ExprValue $this$stringValue) {
        Intrinsics.checkNotNullParameter((Object)$this$stringValue, (String)"$this$stringValue");
        String string = $this$stringValue.getScalar().stringValue();
        if (string == null) {
            Void void_ = ExceptionsKt.errNoContext("Expected string: " + $this$stringValue, ErrorCode.EVALUATOR_UNEXPECTED_VALUE_TYPE, false);
            throw new KotlinNothingValueException();
        }
        return string;
    }

    @NotNull
    public static final byte[] bytesValue(@NotNull ExprValue $this$bytesValue) {
        Intrinsics.checkNotNullParameter((Object)$this$bytesValue, (String)"$this$bytesValue");
        byte[] byArray = $this$bytesValue.getScalar().bytesValue();
        if (byArray == null) {
            Void void_ = ExceptionsKt.errNoContext("Expected byte array: " + $this$bytesValue, ErrorCode.EVALUATOR_UNEXPECTED_VALUE_TYPE, false);
            throw new KotlinNothingValueException();
        }
        return byArray;
    }

    @NotNull
    public static final DateTimePart dateTimePartValue(@NotNull ExprValue $this$dateTimePartValue) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$dateTimePartValue, (String)"$this$dateTimePartValue");
        try {
            object = ExprValueExtensionsKt.stringValue($this$dateTimePartValue);
            boolean bl = false;
            String string = object;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string2 = string.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
            object = DateTimePart.valueOf(string2);
        }
        catch (IllegalArgumentException e) {
            boolean bl = false;
            ErrorCode errorCode = ErrorCode.EVALUATOR_INVALID_ARGUMENTS_FOR_DATE_PART;
            PropertyValueMap propertyValueMap = null;
            String string = "invalid datetime part, valid values: [" + CollectionsKt.joinToString$default((Iterable)LexerConstantsKt.getDATE_TIME_PART_KEYWORDS(), null, null, null, (int)0, null, null, (int)63, null) + ']';
            Throwable throwable = e;
            throw (Throwable)new EvaluationException(string, errorCode, propertyValueMap, throwable, bl, 4, null);
        }
        return object;
    }

    public static final int intValue(@NotNull ExprValue $this$intValue) {
        Intrinsics.checkNotNullParameter((Object)$this$intValue, (String)"$this$intValue");
        return ExprValueExtensionsKt.numberValue($this$intValue).intValue();
    }

    public static final long longValue(@NotNull ExprValue $this$longValue) {
        Intrinsics.checkNotNullParameter((Object)$this$longValue, (String)"$this$longValue");
        return ExprValueExtensionsKt.numberValue($this$longValue).longValue();
    }

    @NotNull
    public static final BigDecimal bigDecimalValue(@NotNull ExprValue $this$bigDecimalValue) {
        Intrinsics.checkNotNullParameter((Object)$this$bigDecimalValue, (String)"$this$bigDecimalValue");
        String string = ExprValueExtensionsKt.numberValue($this$bigDecimalValue).toString();
        boolean bl = false;
        return new BigDecimal(string);
    }

    @NotNull
    public static final Iterable<ExprValue> rangeOver(@NotNull ExprValue $this$rangeOver) {
        Intrinsics.checkNotNullParameter((Object)$this$rangeOver, (String)"$this$rangeOver");
        return $this$rangeOver.getType().isRangedFrom() ? (Iterable)$this$rangeOver : (Iterable)CollectionsKt.listOf((Object)ExprValueExtensionsKt.unnamedValue($this$rangeOver));
    }

    @NotNull
    public static final String stringify(@NotNull ExprValue $this$stringify) {
        Intrinsics.checkNotNullParameter((Object)$this$stringify, (String)"$this$stringify");
        return ConfigurableExprValueFormatter.Companion.getStandard().format($this$stringify);
    }

    @NotNull
    public static final NaturalExprValueComparators getDEFAULT_COMPARATOR() {
        return DEFAULT_COMPARATOR;
    }

    public static final boolean exprEquals(@NotNull ExprValue $this$exprEquals, @NotNull ExprValue other) {
        Intrinsics.checkNotNullParameter((Object)$this$exprEquals, (String)"$this$exprEquals");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return DEFAULT_COMPARATOR.compare($this$exprEquals, other) == 0;
    }

    public static final int compareTo(@NotNull ExprValue $this$compareTo, @NotNull ExprValue other) {
        Intrinsics.checkNotNullParameter((Object)$this$compareTo, (String)"$this$compareTo");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if ($this$compareTo.getType().isUnknown() || other.getType().isUnknown()) {
            throw (Throwable)new EvaluationException("Null value cannot be compared: " + $this$compareTo + ", " + other, ErrorCode.EVALUATOR_INVALID_COMPARISION, null, null, false, 12, null);
        }
        if (!ExprValueExtensionsKt.isDirectlyComparableTo($this$compareTo, other)) {
            Void void_ = ExceptionsKt.errNoContext("Cannot compare values: " + $this$compareTo + ", " + other, ErrorCode.EVALUATOR_INVALID_COMPARISION, false);
            throw new KotlinNothingValueException();
        }
        return DEFAULT_COMPARATOR.compare($this$compareTo, other);
    }

    public static final boolean isDirectlyComparableTo(@NotNull ExprValue $this$isDirectlyComparableTo, @NotNull ExprValue other) {
        Intrinsics.checkNotNullParameter((Object)$this$isDirectlyComparableTo, (String)"$this$isDirectlyComparableTo");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$isDirectlyComparableTo.getType() == ExprValueType.TIME && other.getType() == ExprValueType.TIME ? ExprValueExtensionsKt.timeValue($this$isDirectlyComparableTo).isDirectlyComparableTo(ExprValueExtensionsKt.timeValue(other)) : $this$isDirectlyComparableTo.getType().isDirectlyComparableTo(other.getType());
    }

    @NotNull
    public static final ExprValue cast(@NotNull ExprValue $this$cast, @NotNull SingleType targetType, @NotNull TypedOpBehavior typedOpBehavior, @Nullable SourceLocationMeta locationMeta, @NotNull ZoneOffset defaultTimezoneOffset) {
        Function0<PropertyValueMap> $fun$castExceptionContext$1;
        block75: {
            SingleType singleType;
            Function2<String, SingleType, ExprValue> $fun$exprValue$4;
            block81: {
                Function3 $fun$castFailedErr$2;
                block80: {
                    block79: {
                        block78: {
                            Function2<Number, SingleType, ExprValue> $fun$exprValue$3;
                            block77: {
                                block76: {
                                    block74: {
                                        Intrinsics.checkNotNullParameter((Object)$this$cast, (String)"$this$cast");
                                        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
                                        Intrinsics.checkNotNullParameter((Object)((Object)typedOpBehavior), (String)"typedOpBehavior");
                                        Intrinsics.checkNotNullParameter((Object)defaultTimezoneOffset, (String)"defaultTimezoneOffset");
                                        $fun$castExceptionContext$1 = new Function0<PropertyValueMap>($this$cast, targetType, locationMeta){
                                            final /* synthetic */ ExprValue $this_cast;
                                            final /* synthetic */ SingleType $targetType;
                                            final /* synthetic */ SourceLocationMeta $locationMeta;

                                            @NotNull
                                            public final PropertyValueMap invoke() {
                                                PropertyValueMap errorContext;
                                                block0: {
                                                    Object object = new PropertyValueMap(null, 1, null);
                                                    boolean bl = false;
                                                    boolean bl2 = false;
                                                    Object it = object;
                                                    boolean bl3 = false;
                                                    ((PropertyValueMap)it).set(Property.CAST_FROM, this.$this_cast.getType().toString());
                                                    ((PropertyValueMap)it).set(Property.CAST_TO, StaticTypeUtils.getRuntimeType(this.$targetType).toString());
                                                    errorContext = object;
                                                    SourceLocationMeta sourceLocationMeta = this.$locationMeta;
                                                    if (sourceLocationMeta == null) break block0;
                                                    object = sourceLocationMeta;
                                                    bl = false;
                                                    bl2 = false;
                                                    it = object;
                                                    boolean bl4 = false;
                                                    ExceptionsKt.fillErrorContext(errorContext, (SourceLocationMeta)it);
                                                }
                                                return errorContext;
                                            }
                                            {
                                                this.$this_cast = exprValue2;
                                                this.$targetType = singleType;
                                                this.$locationMeta = sourceLocationMeta;
                                                super(0);
                                            }
                                        };
                                        $fun$castFailedErr$2 = new Function3($fun$castExceptionContext$1, locationMeta){
                                            final /* synthetic */ cast.1 $castExceptionContext$1;
                                            final /* synthetic */ SourceLocationMeta $locationMeta;

                                            @NotNull
                                            public final Void invoke(@NotNull String message, boolean internal, @Nullable Throwable cause) {
                                                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                                                Object errorContext = this.$castExceptionContext$1.invoke();
                                                ErrorCode errorCode = this.$locationMeta == null ? ErrorCode.EVALUATOR_CAST_FAILED_NO_LOCATION : ErrorCode.EVALUATOR_CAST_FAILED;
                                                Throwable throwable = cause;
                                                boolean bl = internal;
                                                throw (Throwable)new EvaluationException(message, errorCode, (PropertyValueMap)errorContext, throwable, bl);
                                            }

                                            public static /* synthetic */ Void invoke$default(cast.2 var0, String string, boolean bl, Throwable throwable, int n, Object object) {
                                                if ((n & 4) != 0) {
                                                    throwable = null;
                                                }
                                                return var0.invoke(string, bl, throwable);
                                            }
                                            {
                                                this.$castExceptionContext$1 = var1_1;
                                                this.$locationMeta = sourceLocationMeta;
                                                super(3);
                                            }
                                        };
                                        BigDecimal longMaxDecimal = NumberExtensionsKt.bigDecimalOf$default(Long.MAX_VALUE, null, 2, null);
                                        BigDecimal longMinDecimal = NumberExtensionsKt.bigDecimalOf$default(Long.MIN_VALUE, null, 2, null);
                                        $fun$exprValue$3 = new Function2<Number, SingleType, ExprValue>($fun$castFailedErr$2, typedOpBehavior, longMinDecimal, longMaxDecimal){
                                            final /* synthetic */ cast.2 $castFailedErr$2;
                                            final /* synthetic */ TypedOpBehavior $typedOpBehavior;
                                            final /* synthetic */ BigDecimal $longMinDecimal;
                                            final /* synthetic */ BigDecimal $longMaxDecimal;

                                            /*
                                             * Enabled force condition propagation
                                             * Lifted jumps to return sites
                                             */
                                            @NotNull
                                            public final ExprValue invoke(@NotNull Number $this$exprValue, @NotNull SingleType type2) {
                                                ExprValue exprValue2;
                                                SingleType singleType;
                                                block33: {
                                                    boolean bl;
                                                    Number number;
                                                    Number number2;
                                                    LongRange rangeForType;
                                                    block35: {
                                                        block34: {
                                                            LongRange longRange;
                                                            Intrinsics.checkNotNullParameter((Object)$this$exprValue, (String)"$this$exprValue");
                                                            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                                                            singleType = type2;
                                                            if (!(singleType instanceof IntType)) break block33;
                                                            if (NumberExtensionsKt.isNaN($this$exprValue) || NumberExtensionsKt.isNegInf($this$exprValue) || NumberExtensionsKt.isPosInf($this$exprValue)) {
                                                                Void void_ = cast.2.invoke$default(this.$castFailedErr$2, "Can't convert Infinity or NaN to INT.", false, null, 4, null);
                                                                throw new KotlinNothingValueException();
                                                            }
                                                            block0 : switch (ExprValueExtensionsKt$WhenMappings.$EnumSwitchMapping$1[this.$typedOpBehavior.ordinal()]) {
                                                                case 1: {
                                                                    longRange = new LongRange(Long.MIN_VALUE, Long.MAX_VALUE);
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    switch (ExprValueExtensionsKt$WhenMappings.$EnumSwitchMapping$0[((IntType)type2).getRangeConstraint().ordinal()]) {
                                                                        case 1: {
                                                                            longRange = new LongRange((long)Short.MIN_VALUE, (long)Short.MAX_VALUE);
                                                                            break block0;
                                                                        }
                                                                        case 2: {
                                                                            longRange = new LongRange((long)Integer.MIN_VALUE, (long)Integer.MAX_VALUE);
                                                                            break block0;
                                                                        }
                                                                        case 3: 
                                                                        case 4: {
                                                                            longRange = new LongRange(Long.MIN_VALUE, Long.MAX_VALUE);
                                                                            break block0;
                                                                        }
                                                                    }
                                                                    throw new NoWhenBranchMatchedException();
                                                                }
                                                                default: {
                                                                    throw new NoWhenBranchMatchedException();
                                                                }
                                                            }
                                                            rangeForType = longRange;
                                                            BigDecimal bigDecimal = this.$longMinDecimal;
                                                            BigDecimal bigDecimal2 = BigDecimal.ONE;
                                                            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"BigDecimal.ONE");
                                                            BigDecimal bigDecimal3 = bigDecimal2;
                                                            boolean bl2 = false;
                                                            BigDecimal bigDecimal4 = bigDecimal.subtract(bigDecimal3);
                                                            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"this.subtract(other)");
                                                            if (NumberExtensionsKt.compareTo($this$exprValue, bigDecimal4) <= 0) break block34;
                                                            bigDecimal = this.$longMaxDecimal;
                                                            BigDecimal bigDecimal5 = BigDecimal.ONE;
                                                            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"BigDecimal.ONE");
                                                            bigDecimal3 = bigDecimal5;
                                                            bl2 = false;
                                                            BigDecimal bigDecimal6 = bigDecimal.add(bigDecimal3);
                                                            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal6, (String)"this.add(other)");
                                                            if (NumberExtensionsKt.compareTo($this$exprValue, bigDecimal6) < 0) break block35;
                                                        }
                                                        Void void_ = ExceptionsKt.errIntOverflow$default(8, null, 2, null);
                                                        throw new KotlinNothingValueException();
                                                    }
                                                    switch (ExprValueExtensionsKt$WhenMappings.$EnumSwitchMapping$2[this.$typedOpBehavior.ordinal()]) {
                                                        case 1: {
                                                            number2 = $this$exprValue;
                                                            if (number2 instanceof BigDecimal) {
                                                                number = ((BigDecimal)$this$exprValue).divideToIntegralValue(BigDecimal.ONE);
                                                                break;
                                                            }
                                                            number = $this$exprValue;
                                                            break;
                                                        }
                                                        case 2: {
                                                            number2 = $this$exprValue;
                                                            if (number2 instanceof BigDecimal) {
                                                                number = ((BigDecimal)$this$exprValue).setScale(0, RoundingMode.HALF_EVEN);
                                                                break;
                                                            }
                                                            if (number2 instanceof Float) {
                                                                float f = $this$exprValue.floatValue();
                                                                bl = false;
                                                                number = Float.valueOf((float)Math.rint(f));
                                                                break;
                                                            }
                                                            if (number2 instanceof Double) {
                                                                double d = $this$exprValue.doubleValue();
                                                                boolean bl3 = false;
                                                                number = Math.rint(d);
                                                                break;
                                                            }
                                                            number = $this$exprValue;
                                                            break;
                                                        }
                                                        default: {
                                                            throw new NoWhenBranchMatchedException();
                                                        }
                                                    }
                                                    number2 = number;
                                                    boolean bl4 = false;
                                                    bl = false;
                                                    Number it = number2;
                                                    boolean bl5 = false;
                                                    Number number3 = it;
                                                    Intrinsics.checkNotNullExpressionValue((Object)number3, (String)"it");
                                                    if (NumberExtensionsKt.compareTo(number3, rangeForType.getFirst()) < 0 || NumberExtensionsKt.compareTo(it, rangeForType.getLast()) > 0) {
                                                        Void void_ = ExceptionsKt.errIntOverflow$default(8, null, 2, null);
                                                        throw new KotlinNothingValueException();
                                                    }
                                                    long result = it.longValue();
                                                    exprValue2 = ExprValue.Companion.newInt(result);
                                                    return exprValue2;
                                                }
                                                if (singleType instanceof FloatType) {
                                                    exprValue2 = ExprValue.Companion.newFloat($this$exprValue.doubleValue());
                                                    return exprValue2;
                                                }
                                                if (singleType instanceof DecimalType) {
                                                    if (NumberExtensionsKt.isNaN($this$exprValue) || NumberExtensionsKt.isNegInf($this$exprValue) || NumberExtensionsKt.isPosInf($this$exprValue)) {
                                                        Void void_ = cast.2.invoke$default(this.$castFailedErr$2, "Can't convert Infinity or NaN to DECIMAL.", false, null, 4, null);
                                                        throw new KotlinNothingValueException();
                                                    }
                                                    switch (ExprValueExtensionsKt$WhenMappings.$EnumSwitchMapping$3[this.$typedOpBehavior.ordinal()]) {
                                                        case 1: {
                                                            exprValue2 = ExprValue.Companion.newDecimal(NumberExtensionsKt.coerce($this$exprValue, BigDecimal.class));
                                                            return exprValue2;
                                                        }
                                                        case 2: {
                                                            DecimalType.PrecisionScaleConstraint constraint = ((DecimalType)type2).getPrecisionScaleConstraint();
                                                            if (Intrinsics.areEqual((Object)constraint, (Object)DecimalType.PrecisionScaleConstraint.Unconstrained.INSTANCE)) {
                                                                exprValue2 = ExprValue.Companion.newDecimal(NumberExtensionsKt.coerce($this$exprValue, BigDecimal.class));
                                                                return exprValue2;
                                                            } else {
                                                                if (!(constraint instanceof DecimalType.PrecisionScaleConstraint.Constrained)) throw new NoWhenBranchMatchedException();
                                                                BigDecimal decimal = NumberExtensionsKt.coerce($this$exprValue, BigDecimal.class);
                                                                BigDecimal result = decimal.round(new MathContext(((DecimalType.PrecisionScaleConstraint.Constrained)constraint).getPrecision())).setScale(((DecimalType.PrecisionScaleConstraint.Constrained)constraint).getScale(), RoundingMode.HALF_UP);
                                                                if (result.precision() > ((DecimalType.PrecisionScaleConstraint.Constrained)constraint).getPrecision()) {
                                                                    Void void_ = cast.2.invoke$default(this.$castFailedErr$2, "target type DECIMAL(" + ((DecimalType.PrecisionScaleConstraint.Constrained)constraint).getPrecision() + ", " + ((DecimalType.PrecisionScaleConstraint.Constrained)constraint).getScale() + ") too small for value " + decimal + '.', false, null, 4, null);
                                                                    throw new KotlinNothingValueException();
                                                                }
                                                                BigDecimal bigDecimal = result;
                                                                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"result");
                                                                exprValue2 = ExprValue.Companion.newDecimal(bigDecimal);
                                                            }
                                                            return exprValue2;
                                                        }
                                                        default: {
                                                            throw new NoWhenBranchMatchedException();
                                                        }
                                                    }
                                                }
                                                Void void_ = cast.2.invoke$default(this.$castFailedErr$2, "Invalid type for numeric conversion: " + type2 + " (this code should be unreachable)", true, null, 4, null);
                                                throw new KotlinNothingValueException();
                                            }
                                            {
                                                this.$castFailedErr$2 = var1_1;
                                                this.$typedOpBehavior = typedOpBehavior;
                                                this.$longMinDecimal = bigDecimal;
                                                this.$longMaxDecimal = bigDecimal2;
                                                super(2);
                                            }
                                        };
                                        $fun$exprValue$4 = new Function2<String, SingleType, ExprValue>(typedOpBehavior, $fun$castFailedErr$2){
                                            final /* synthetic */ TypedOpBehavior $typedOpBehavior;
                                            final /* synthetic */ cast.2 $castFailedErr$2;

                                            /*
                                             * Unable to fully structure code
                                             */
                                            @NotNull
                                            public final ExprValue invoke(@NotNull String $this$exprValue, @NotNull SingleType type) {
                                                block12: {
                                                    block11: {
                                                        Intrinsics.checkNotNullParameter((Object)$this$exprValue, (String)"$this$exprValue");
                                                        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                                                        var3_3 = type;
                                                        if (!(var3_3 instanceof StringType)) break block11;
                                                        switch (ExprValueExtensionsKt$WhenMappings.$EnumSwitchMapping$4[this.$typedOpBehavior.ordinal()]) {
                                                            case 1: {
                                                                v0 = ExprValue.Companion.newString($this$exprValue);
                                                                break block12;
                                                            }
                                                            case 2: {
                                                                constraint = ((StringType)type).getLengthConstraint();
                                                                if (!Intrinsics.areEqual((Object)constraint, (Object)StringType.StringLengthConstraint.Unconstrained.INSTANCE)) ** GOTO lbl14
                                                                v0 = ExprValue.Companion.newString($this$exprValue);
                                                                break block12;
lbl14:
                                                                // 1 sources

                                                                if (!(constraint instanceof StringType.StringLengthConstraint.Constrained)) ** GOTO lbl64
                                                                var6_5 = $this$exprValue;
                                                                var7_7 = 0;
                                                                var8_9 = $this$exprValue.length();
                                                                var9_12 = 0;
                                                                actualCodepointCount = var6_5.codePointCount(var7_7, var8_9);
                                                                if (actualCodepointCount <= (lengthConstraint = ((StringType.StringLengthConstraint.Constrained)constraint).getLength().getValue())) {
                                                                    v1 = $this$exprValue;
                                                                } else {
                                                                    var8_10 = $this$exprValue;
                                                                    var9_12 = 0;
                                                                    var10_15 = $this$exprValue;
                                                                    var11_17 = 0;
                                                                    var12_19 = false;
                                                                    var10_16 = var10_15.offsetByCodePoints(var11_17, lengthConstraint);
                                                                    var11_17 = 0;
                                                                    v2 = var8_10.substring(var9_12, var10_16);
                                                                    v1 = v2;
                                                                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                                                }
                                                                truncatedString = v1;
                                                                v3 = ExprValue.Companion;
                                                                var8_11 = ((StringType.StringLengthConstraint.Constrained)constraint).getLength();
                                                                if (!(var8_11 instanceof NumberConstraint.Equals)) ** GOTO lbl58
                                                                var9_13 = truncatedString;
                                                                var17_20 = v3;
                                                                $i$f$trimEnd = false;
                                                                $this$trimEnd$iv$iv = (CharSequence)$this$trimEnd$iv;
                                                                $i$f$trimEnd = false;
                                                                var13_21 = $this$trimEnd$iv$iv.length();
                                                                --var13_21;
                                                                var14_22 = false;
                                                                while (var13_21 >= 0) {
                                                                    c = $this$trimEnd$iv$iv.charAt((int)index$iv$iv);
                                                                    $i$a$-trimEnd-ExprValueExtensionsKt$cast$4$1 = false;
                                                                    if (c == ' ') ** GOTO lbl51
                                                                    v4 = $this$trimEnd$iv$iv.subSequence(0, (int)(index$iv$iv + true));
                                                                    ** GOTO lbl54
lbl51:
                                                                    // 1 sources

                                                                    --index$iv$iv;
                                                                }
                                                                v4 = "";
lbl54:
                                                                // 2 sources

                                                                var18_25 = v4.toString();
                                                                v3 = var17_20;
                                                                v5 = var18_25;
                                                                ** GOTO lbl62
lbl58:
                                                                // 1 sources

                                                                if (var8_11 instanceof NumberConstraint.UpTo) {
                                                                    v5 = truncatedString;
                                                                } else {
                                                                    throw new NoWhenBranchMatchedException();
                                                                }
lbl62:
                                                                // 2 sources

                                                                v0 = v3.newString(v5);
                                                                break block12;
lbl64:
                                                                // 1 sources

                                                                throw new NoWhenBranchMatchedException();
                                                            }
                                                            default: {
                                                                throw new NoWhenBranchMatchedException();
                                                            }
                                                        }
                                                    }
                                                    if (var3_3 instanceof SymbolType) {
                                                        v0 = ExprValue.Companion.newSymbol($this$exprValue);
                                                    } else {
                                                        v6 = cast.2.invoke$default(this.$castFailedErr$2, "Invalid type for textual conversion: " + type + " (this code should be unreachable)", true, null, 4, null);
                                                        throw new KotlinNothingValueException();
                                                    }
                                                }
                                                return v0;
                                            }
                                            {
                                                this.$typedOpBehavior = typedOpBehavior;
                                                this.$castFailedErr$2 = var2_2;
                                                super(2);
                                            }
                                        };
                                        if ($this$cast.getType().isUnknown() && targetType instanceof MissingType) {
                                            return ExprValue.Companion.getMissingValue();
                                        }
                                        if ($this$cast.getType().isUnknown() && targetType instanceof NullType) {
                                            return ExprValue.Companion.getNullValue();
                                        }
                                        if ($this$cast.getType().isUnknown()) {
                                            return $this$cast;
                                        }
                                        if ($this$cast.getType() == StaticTypeUtils.getRuntimeType(targetType) && $this$cast.getType() != ExprValueType.TIME) {
                                            SingleType singleType2 = targetType;
                                            return singleType2 instanceof IntType || singleType2 instanceof FloatType || singleType2 instanceof DecimalType ? $fun$exprValue$3.invoke(ExprValueExtensionsKt.numberValue($this$cast), targetType) : (singleType2 instanceof StringType ? $fun$exprValue$4.invoke(ExprValueExtensionsKt.stringValue($this$cast), targetType) : $this$cast);
                                        }
                                        singleType = targetType;
                                        if (!(singleType instanceof BoolType)) break block74;
                                        if ($this$cast.getType().isNumber()) {
                                            return NumberExtensionsKt.compareTo(ExprValueExtensionsKt.numberValue($this$cast), 0L) == 0 ? ExprValue.Companion.newBoolean(false) : ExprValue.Companion.newBoolean(true);
                                        }
                                        if ($this$cast.getType().isText()) {
                                            ExprValue exprValue2;
                                            String string = ExprValueExtensionsKt.stringValue($this$cast);
                                            boolean bl = false;
                                            String string2 = string;
                                            if (string2 == null) {
                                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                            }
                                            String string3 = string2.toLowerCase();
                                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                                            switch (string3) {
                                                case "true": {
                                                    exprValue2 = ExprValue.Companion.newBoolean(true);
                                                    break;
                                                }
                                                case "false": {
                                                    exprValue2 = ExprValue.Companion.newBoolean(false);
                                                    break;
                                                }
                                                default: {
                                                    Void void_ = cast.2.invoke$default($fun$castFailedErr$2, "can't convert string value to BOOL", false, null, 4, null);
                                                    throw new KotlinNothingValueException();
                                                }
                                            }
                                            return exprValue2;
                                        }
                                        break block75;
                                    }
                                    if (!(singleType instanceof IntType)) break block76;
                                    if ($this$cast.getType() == ExprValueType.BOOL) {
                                        return ExprValueExtensionsKt.booleanValue($this$cast) ? $fun$exprValue$3.invoke((Number)1L, targetType) : $fun$exprValue$3.invoke((Number)0L, targetType);
                                    }
                                    if ($this$cast.getType().isNumber()) {
                                        return $fun$exprValue$3.invoke(ExprValueExtensionsKt.numberValue($this$cast), targetType);
                                    }
                                    if ($this$cast.getType().isText()) {
                                        Function1<String, Long> $fun$parseToLong$5 = new Function1<String, Long>($fun$castFailedErr$2, locationMeta){
                                            final /* synthetic */ cast.2 $castFailedErr$2;
                                            final /* synthetic */ SourceLocationMeta $locationMeta;

                                            public final long invoke(@NotNull String s) {
                                                IonInt ionInt;
                                                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                                                IonSystem ion = IonSystemBuilder.standard().build();
                                                try {
                                                    String normalized = ExprValueExtensionsKt.access$normalizeForCastToInt(s);
                                                    IonValue ionValue = ion.singleValue(normalized);
                                                    if (ionValue == null) {
                                                        throw new NullPointerException("null cannot be cast to non-null type com.amazon.ion.IonInt");
                                                    }
                                                    ionInt = (IonInt)ionValue;
                                                }
                                                catch (Exception e) {
                                                    Void void_ = this.$castFailedErr$2.invoke("can't convert string value to INT", false, e);
                                                    throw new KotlinNothingValueException();
                                                }
                                                IonInt value = ionInt;
                                                IntegerSize integerSize = value.getIntegerSize();
                                                if (integerSize != null) {
                                                    switch (ExprValueExtensionsKt$WhenMappings.$EnumSwitchMapping$5[integerSize.ordinal()]) {
                                                        case 1: {
                                                            Void void_ = ExceptionsKt.errIntOverflow(8, ExceptionsKt.errorContextFrom(this.$locationMeta));
                                                            throw new KotlinNothingValueException();
                                                        }
                                                    }
                                                }
                                                return value.longValue();
                                            }
                                            {
                                                this.$castFailedErr$2 = var1_1;
                                                this.$locationMeta = sourceLocationMeta;
                                                super(1);
                                            }
                                        };
                                        return $fun$exprValue$3.invoke((Number)$fun$parseToLong$5.invoke(ExprValueExtensionsKt.stringValue($this$cast)), targetType);
                                    }
                                    break block75;
                                }
                                if (!(singleType instanceof FloatType)) break block77;
                                if ($this$cast.getType() == ExprValueType.BOOL) {
                                    return ExprValueExtensionsKt.booleanValue($this$cast) ? $fun$exprValue$3.invoke((Number)1.0, targetType) : $fun$exprValue$3.invoke((Number)0.0, targetType);
                                }
                                if ($this$cast.getType().isNumber()) {
                                    return $fun$exprValue$3.invoke((Number)ExprValueExtensionsKt.numberValue($this$cast).doubleValue(), targetType);
                                }
                                if ($this$cast.getType().isText()) {
                                    try {
                                        String $fun$parseToLong$5 = ExprValueExtensionsKt.stringValue($this$cast);
                                        boolean bl = false;
                                        return $fun$exprValue$3.invoke((Number)Double.parseDouble($fun$parseToLong$5), targetType);
                                    }
                                    catch (NumberFormatException e) {
                                        Void void_ = $fun$castFailedErr$2.invoke("can't convert string value to FLOAT", false, e);
                                        throw new KotlinNothingValueException();
                                    }
                                }
                                break block75;
                            }
                            if (!(singleType instanceof DecimalType)) break block78;
                            if ($this$cast.getType() == ExprValueType.BOOL) {
                                ExprValue exprValue3;
                                if (ExprValueExtensionsKt.booleanValue($this$cast)) {
                                    BigDecimal bigDecimal = BigDecimal.ONE;
                                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimal.ONE");
                                    exprValue3 = $fun$exprValue$3.invoke((Number)bigDecimal, targetType);
                                } else {
                                    BigDecimal bigDecimal = BigDecimal.ZERO;
                                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimal.ZERO");
                                    exprValue3 = $fun$exprValue$3.invoke((Number)bigDecimal, targetType);
                                }
                                return exprValue3;
                            }
                            if ($this$cast.getType().isNumber()) {
                                return $fun$exprValue$3.invoke(ExprValueExtensionsKt.numberValue($this$cast), targetType);
                            }
                            if ($this$cast.getType().isText()) {
                                try {
                                    return $fun$exprValue$3.invoke((Number)NumberExtensionsKt.bigDecimalOf$default(ExprValueExtensionsKt.stringValue($this$cast), null, 2, null), targetType);
                                }
                                catch (NumberFormatException e) {
                                    Void void_ = $fun$castFailedErr$2.invoke("can't convert string value to DECIMAL", false, e);
                                    throw new KotlinNothingValueException();
                                }
                            }
                            break block75;
                        }
                        if (!(singleType instanceof TimestampType)) break block79;
                        if ($this$cast.getType().isText()) {
                            try {
                                Timestamp timestamp = Timestamp.valueOf((CharSequence)ExprValueExtensionsKt.stringValue($this$cast));
                                Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"Timestamp.valueOf(stringValue())");
                                return ExprValue.Companion.newTimestamp(timestamp);
                            }
                            catch (IllegalArgumentException e) {
                                Void void_ = $fun$castFailedErr$2.invoke("can't convert string value to TIMESTAMP", false, e);
                                throw new KotlinNothingValueException();
                            }
                        }
                        break block75;
                    }
                    if (!(singleType instanceof DateType)) break block80;
                    if ($this$cast.getType() == ExprValueType.TIMESTAMP) {
                        Timestamp ts = ExprValueExtensionsKt.timestampValue($this$cast);
                        LocalDate localDate = LocalDate.of(ts.getYear(), ts.getMonth(), ts.getDay());
                        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"LocalDate.of(ts.year, ts.month, ts.day)");
                        return ExprValue.Companion.newDate(localDate);
                    }
                    if ($this$cast.getType().isText()) {
                        try {
                            LocalDate date;
                            if (!datePatternRegex.matches((CharSequence)ExprValueExtensionsKt.stringValue($this$cast))) {
                                Void void_ = cast.2.invoke$default($fun$castFailedErr$2, "Can't convert string value to DATE. Expected valid date string and the date format to be YYYY-MM-DD", false, null, 4, null);
                                throw new KotlinNothingValueException();
                            }
                            LocalDate localDate = date = LocalDate.parse(ExprValueExtensionsKt.stringValue($this$cast));
                            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"date");
                            return ExprValue.Companion.newDate(localDate);
                        }
                        catch (DateTimeParseException e) {
                            Void void_ = $fun$castFailedErr$2.invoke("Can't convert string value to DATE. Expected valid date string and the date format to be YYYY-MM-DD", false, e);
                            throw new KotlinNothingValueException();
                        }
                    }
                    break block75;
                }
                if (!(singleType instanceof TimeType)) break block81;
                Integer precision = ((TimeType)targetType).getPrecision();
                if ($this$cast.getType() == ExprValueType.TIME) {
                    ZoneOffset zoneOffset;
                    Time time = ExprValueExtensionsKt.timeValue($this$cast);
                    boolean bl = ((TimeType)targetType).getWithTimeZone();
                    if (bl) {
                        zoneOffset = time.getZoneOffset();
                        if (zoneOffset == null) {
                            zoneOffset = defaultTimezoneOffset;
                        }
                    } else {
                        zoneOffset = null;
                    }
                    ZoneOffset timeZoneOffset = zoneOffset;
                    Integer n = precision;
                    return ExprValue.Companion.newTime(Time.Companion.of(time.getLocalTime(), n != null ? n.intValue() : time.getPrecision(), timeZoneOffset));
                }
                if ($this$cast.getType() == ExprValueType.TIMESTAMP) {
                    Integer n;
                    Timestamp ts = ExprValueExtensionsKt.timestampValue($this$cast);
                    int n2 = ((TimeType)targetType).getWithTimeZone();
                    if (n2 == 1) {
                        Integer n3 = ts.getLocalOffset();
                        if (n3 == null) {
                            Void void_ = cast.2.invoke$default($fun$castFailedErr$2, "Can't convert timestamp value with unknown local offset (i.e. -00:00) to TIME WITH TIME ZONE.", false, null, 4, null);
                            throw new KotlinNothingValueException();
                        }
                        n = (int)n3;
                    } else {
                        n = null;
                    }
                    Integer timeZoneOffset = n;
                    int n4 = ts.getHour();
                    int n5 = ts.getMinute();
                    int n6 = ts.getSecond();
                    BigDecimal bigDecimal = ts.getDecimalSecond().remainder(BigDecimal.ONE);
                    n2 = 1000000000;
                    boolean bl = false;
                    BigDecimal bigDecimal2 = BigDecimal.valueOf(n2);
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"BigDecimal.valueOf(this.toLong())");
                    Integer n7 = precision;
                    return ExprValue.Companion.newTime(Time.Companion.of(n4, n5, n6, bigDecimal.multiply(bigDecimal2).intValue(), n7 != null ? n7.intValue() : ts.getDecimalSecond().scale(), timeZoneOffset));
                }
                if (!$this$cast.getType().isText()) break block75;
                try {
                    Object object;
                    LocalTime localTime;
                    block83: {
                        block82: {
                            Matcher matcher = genericTimeRegex.toPattern().matcher(ExprValueExtensionsKt.stringValue($this$cast));
                            if (!matcher.find()) {
                                Void void_ = cast.2.invoke$default($fun$castFailedErr$2, "Can't convert string value to TIME. Expected valid time string and the time to be of the format HH:MM:SS[.ddddd...][+|-HH:MM]", false, null, 4, null);
                                throw new KotlinNothingValueException();
                            }
                            localTime = LocalTime.parse(ExprValueExtensionsKt.stringValue($this$cast), DateTimeFormatter.ISO_TIME);
                            String zoneOffsetString = matcher.group(2);
                            object = zoneOffsetString;
                            if (object == null) break block82;
                            String string = object;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string;
                            boolean bl3 = false;
                            object = ZoneOffset.of(it);
                            if (object != null) break block83;
                        }
                        object = defaultTimezoneOffset;
                    }
                    Object zoneOffset = object;
                    LocalTime localTime2 = localTime;
                    Intrinsics.checkNotNullExpressionValue((Object)localTime2, (String)"localTime");
                    Integer n = precision;
                    boolean bl = ((TimeType)targetType).getWithTimeZone();
                    return ExprValue.Companion.newTime(Time.Companion.of(localTime2, n != null ? n : TimeExtensionsKt.getPrecisionFromTimeString(ExprValueExtensionsKt.stringValue($this$cast)), (ZoneOffset)(bl ? zoneOffset : null)));
                }
                catch (DateTimeParseException e) {
                    Void void_ = $fun$castFailedErr$2.invoke("Can't convert string value to TIME. Expected valid time string and the time format to be HH:MM:SS[.ddddd...][+|-HH:MM]", false, e);
                    throw new KotlinNothingValueException();
                }
            }
            if (singleType instanceof StringType || singleType instanceof SymbolType) {
                if ($this$cast.getType().isNumber()) {
                    return $fun$exprValue$4.invoke(ExprValueExtensionsKt.numberValue($this$cast).toString(), targetType);
                }
                if ($this$cast.getType().isText()) {
                    return $fun$exprValue$4.invoke(ExprValueExtensionsKt.stringValue($this$cast), targetType);
                }
                if ($this$cast.getType() == ExprValueType.DATE) {
                    String string = ExprValueExtensionsKt.dateValue($this$cast).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dateValue().toString()");
                    return $fun$exprValue$4.invoke(string, targetType);
                }
                if ($this$cast.getType() == ExprValueType.TIME) {
                    return $fun$exprValue$4.invoke(ExprValueExtensionsKt.timeValue($this$cast).toString(), targetType);
                }
                if ($this$cast.getType() == ExprValueType.BOOL) {
                    return $fun$exprValue$4.invoke(String.valueOf(ExprValueExtensionsKt.booleanValue($this$cast)), targetType);
                }
                if ($this$cast.getType() == ExprValueType.TIMESTAMP) {
                    String string = ExprValueExtensionsKt.timestampValue($this$cast).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"timestampValue().toString()");
                    return $fun$exprValue$4.invoke(string, targetType);
                }
            } else if (singleType instanceof ClobType) {
                if ($this$cast.getType().isLob()) {
                    return ExprValue.Companion.newClob(ExprValueExtensionsKt.bytesValue($this$cast));
                }
            } else if (singleType instanceof BlobType) {
                if ($this$cast.getType().isLob()) {
                    return ExprValue.Companion.newBlob(ExprValueExtensionsKt.bytesValue($this$cast));
                }
            } else if (singleType instanceof ListType) {
                if ($this$cast.getType().isSequence()) {
                    return ExprValue.Companion.newList((Sequence<? extends ExprValue>)CollectionsKt.asSequence((Iterable)$this$cast));
                }
            } else if (singleType instanceof SexpType) {
                if ($this$cast.getType().isSequence()) {
                    return ExprValue.Companion.newSexp((Sequence<? extends ExprValue>)CollectionsKt.asSequence((Iterable)$this$cast));
                }
            } else if (singleType instanceof BagType && $this$cast.getType().isSequence()) {
                return ExprValue.Companion.newBag((Sequence<? extends ExprValue>)CollectionsKt.asSequence((Iterable)$this$cast));
            }
        }
        ErrorCode errorCode = locationMeta == null ? ErrorCode.EVALUATOR_INVALID_CAST_NO_LOCATION : ErrorCode.EVALUATOR_INVALID_CAST;
        Void void_ = ExceptionsKt.err("Cannot convert " + (Object)((Object)$this$cast.getType()) + " to " + targetType, errorCode, (PropertyValueMap)$fun$castExceptionContext$1.invoke(), false);
        throw new KotlinNothingValueException();
    }

    /*
     * WARNING - void declaration
     */
    private static final String normalizeForCastToInt(String $this$normalizeForCastToInt) {
        String string;
        normalizeForCastToInt.1 $fun$isSign$1 = normalizeForCastToInt.1.INSTANCE;
        normalizeForCastToInt.2 $fun$isHexOrBase2Marker$2 = normalizeForCastToInt.2.INSTANCE;
        normalizeForCastToInt.3 $fun$possiblyHexOrBase2$3 = normalizeForCastToInt.3.INSTANCE;
        if ($this$normalizeForCastToInt.length() == 0) {
            string = $this$normalizeForCastToInt;
        } else if ($fun$possiblyHexOrBase2$3.invoke($this$normalizeForCastToInt)) {
            string = $this$normalizeForCastToInt.charAt(0) == '+' ? StringsKt.drop((String)$this$normalizeForCastToInt, (int)1) : $this$normalizeForCastToInt;
        } else {
            void isNegative;
            int startIndex;
            int toDrop;
            Pair pair;
            switch ($this$normalizeForCastToInt.charAt(0)) {
                case '-': {
                    pair = new Pair((Object)true, (Object)1);
                    break;
                }
                case '+': {
                    pair = new Pair((Object)false, (Object)1);
                    break;
                }
                default: {
                    pair = new Pair((Object)false, (Object)0);
                }
            }
            Pair pair2 = pair;
            boolean bl = (Boolean)pair2.component1();
            for (toDrop = startIndex = ((Number)pair2.component2()).intValue(); toDrop < $this$normalizeForCastToInt.length() && $this$normalizeForCastToInt.charAt(toDrop) == '0'; ++toDrop) {
            }
            if (toDrop == $this$normalizeForCastToInt.length()) {
                string = "0";
            } else if (toDrop == 0) {
                string = $this$normalizeForCastToInt;
            } else if (toDrop == 1 && isNegative != false) {
                string = $this$normalizeForCastToInt;
            } else if (toDrop > 1 && isNegative != false) {
                char c = '-';
                String string2 = StringsKt.drop((String)$this$normalizeForCastToInt, (int)toDrop);
                boolean bl2 = false;
                string = String.valueOf(c) + string2;
            } else {
                string = StringsKt.drop((String)$this$normalizeForCastToInt, (int)toDrop);
            }
        }
        return string;
    }

    public static final boolean isUnknown(@NotNull ExprValue $this$isUnknown) {
        Intrinsics.checkNotNullParameter((Object)$this$isUnknown, (String)"$this$isUnknown");
        return $this$isUnknown.getType().isUnknown();
    }

    public static final boolean isNotUnknown(@NotNull ExprValue $this$isNotUnknown) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotUnknown, (String)"$this$isNotUnknown");
        return !$this$isNotUnknown.getType().isUnknown();
    }

    @NotNull
    public static final Function1<ExprValue, Boolean> createUniqueExprValueFilter() {
        TreeSet seen = new TreeSet(DEFAULT_COMPARATOR);
        return (Function1)new Function1<ExprValue, Boolean>(seen){
            final /* synthetic */ TreeSet $seen;

            public final boolean invoke(@NotNull ExprValue exprValue2) {
                Intrinsics.checkNotNullParameter((Object)exprValue2, (String)"exprValue");
                return this.$seen.add(exprValue2);
            }
            {
                this.$seen = treeSet;
                super(1);
            }
        };
    }

    @NotNull
    public static final Sequence<ExprValue> distinct(@NotNull Sequence<? extends ExprValue> $this$distinct) {
        Intrinsics.checkNotNullParameter($this$distinct, (String)"$this$distinct");
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super ExprValue>, Continuation<? super Unit>, Object>($this$distinct, null){
            private /* synthetic */ Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ Sequence $this_distinct;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$sequence = (SequenceScope)this.L$0;
                        seen = new TreeSet(ExprValueExtensionsKt.getDEFAULT_COMPARATOR());
                        $this$forEach$iv = this.$this_distinct;
                        $i$f$forEach = false;
                        var6_7 = $this$forEach$iv.iterator();
lbl10:
                        // 4 sources

                        while (var6_7.hasNext()) {
                            element$iv = var6_7.next();
                            it = (ExprValue)element$iv;
                            $i$a$-forEach-ExprValueExtensionsKt$distinct$1$1 = false;
                            if (seen.contains(it)) continue;
                            seen.add(ExprValueExtensionsKt.unnamedValue(it));
                            this.L$0 = $this$sequence;
                            this.L$1 = seen;
                            this.L$2 = var6_7;
                            this.label = 1;
                            v0 = $this$sequence.yield((Object)it, (Continuation)this);
                            if (v0 != var10_2) continue;
                            return var10_2;
                        }
                        break;
                    }
                    case 1: {
                        $i$f$forEach = false;
                        $i$a$-forEach-ExprValueExtensionsKt$distinct$1$1 = false;
                        var6_7 = (Iterator)this.L$2;
                        seen = (TreeSet)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl10
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$this_distinct = sequence;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<SequenceScope<? super ExprValue>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                Object object = function2.L$0 = value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public static final TreeMap<ExprValue, Integer> multiplicities(@NotNull Sequence<? extends ExprValue> $this$multiplicities) {
        Intrinsics.checkNotNullParameter($this$multiplicities, (String)"$this$multiplicities");
        TreeMap<ExprValue, Integer> multiplicities2 = new TreeMap<ExprValue, Integer>(DEFAULT_COMPARATOR);
        Sequence<? extends ExprValue> $this$forEach$iv = $this$multiplicities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExprValue it = (ExprValue)element$iv;
            boolean bl = false;
            multiplicities2.compute(it, multiplicities.1.1.INSTANCE);
        }
        return multiplicities2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IonValue toIonValue(@NotNull ExprValue $this$toIonValue, @NotNull IonSystem ion) {
        IonValue ionValue;
        Intrinsics.checkNotNullParameter((Object)$this$toIonValue, (String)"$this$toIonValue");
        Intrinsics.checkNotNullParameter((Object)ion, (String)"ion");
        switch (ExprValueExtensionsKt$WhenMappings.$EnumSwitchMapping$6[$this$toIonValue.getType().ordinal()]) {
            case 1: {
                IonValue ionValue2 = ion.newNull((IonType)$this$toIonValue.asFacet(IonType.class));
                ionValue = ionValue2;
                Intrinsics.checkNotNullExpressionValue((Object)ionValue2, (String)"ion.newNull(asFacet(IonType::class.java))");
                break;
            }
            case 2: {
                IonNull ionNull = ion.newNull();
                boolean bl = false;
                boolean bl2 = false;
                IonNull $this$apply = ionNull;
                boolean bl3 = false;
                $this$apply.addTypeAnnotation(MISSING_ANNOTATION);
                IonNull ionNull2 = ionNull;
                Intrinsics.checkNotNullExpressionValue((Object)ionNull2, (String)"ion.newNull().apply { ad\u2026ion(MISSING_ANNOTATION) }");
                ionValue = (IonValue)ionNull2;
                break;
            }
            case 3: {
                IonBool ionBool = ion.newBool(ExprValueExtensionsKt.booleanValue($this$toIonValue));
                Intrinsics.checkNotNullExpressionValue((Object)ionBool, (String)"ion.newBool(booleanValue())");
                ionValue = (IonValue)ionBool;
                break;
            }
            case 4: {
                IonInt ionInt = ion.newInt(ExprValueExtensionsKt.longValue($this$toIonValue));
                Intrinsics.checkNotNullExpressionValue((Object)ionInt, (String)"ion.newInt(longValue())");
                ionValue = (IonValue)ionInt;
                break;
            }
            case 5: {
                IonFloat ionFloat = ion.newFloat(ExprValueExtensionsKt.numberValue($this$toIonValue).doubleValue());
                Intrinsics.checkNotNullExpressionValue((Object)ionFloat, (String)"ion.newFloat(numberValue().toDouble())");
                ionValue = (IonValue)ionFloat;
                break;
            }
            case 6: {
                IonDecimal ionDecimal = ion.newDecimal(ExprValueExtensionsKt.bigDecimalValue($this$toIonValue));
                Intrinsics.checkNotNullExpressionValue((Object)ionDecimal, (String)"ion.newDecimal(bigDecimalValue())");
                ionValue = (IonValue)ionDecimal;
                break;
            }
            case 7: {
                LocalDate value = ExprValueExtensionsKt.dateValue($this$toIonValue);
                IonTimestamp ionTimestamp = ion.newTimestamp(Timestamp.forDay((int)value.getYear(), (int)value.getMonthValue(), (int)value.getDayOfMonth()));
                boolean bl = false;
                boolean bl4 = false;
                IonTimestamp $this$apply = ionTimestamp;
                boolean bl5 = false;
                $this$apply.addTypeAnnotation(DATE_ANNOTATION);
                IonTimestamp ionTimestamp2 = ionTimestamp;
                Intrinsics.checkNotNullExpressionValue((Object)ionTimestamp2, (String)"ion.newTimestamp(Timesta\u2026ANNOTATION)\n            }");
                ionValue = (IonValue)ionTimestamp2;
                break;
            }
            case 8: {
                IonTimestamp ionTimestamp = ion.newTimestamp(ExprValueExtensionsKt.timestampValue($this$toIonValue));
                Intrinsics.checkNotNullExpressionValue((Object)ionTimestamp, (String)"ion.newTimestamp(timestampValue())");
                ionValue = (IonValue)ionTimestamp;
                break;
            }
            case 9: {
                ionValue = (IonValue)ExprValueExtensionsKt.timeValue($this$toIonValue).toIonValue(ion);
                break;
            }
            case 10: {
                IonSymbol ionSymbol = ion.newSymbol(ExprValueExtensionsKt.stringValue($this$toIonValue));
                Intrinsics.checkNotNullExpressionValue((Object)ionSymbol, (String)"ion.newSymbol(stringValue())");
                ionValue = (IonValue)ionSymbol;
                break;
            }
            case 11: {
                IonString ionString = ion.newString(ExprValueExtensionsKt.stringValue($this$toIonValue));
                Intrinsics.checkNotNullExpressionValue((Object)ionString, (String)"ion.newString(stringValue())");
                ionValue = (IonValue)ionString;
                break;
            }
            case 12: {
                IonClob ionClob = ion.newClob(ExprValueExtensionsKt.bytesValue($this$toIonValue));
                Intrinsics.checkNotNullExpressionValue((Object)ionClob, (String)"ion.newClob(bytesValue())");
                ionValue = (IonValue)ionClob;
                break;
            }
            case 13: {
                IonBlob ionBlob = ion.newBlob(ExprValueExtensionsKt.bytesValue($this$toIonValue));
                Intrinsics.checkNotNullExpressionValue((Object)ionBlob, (String)"ion.newBlob(bytesValue())");
                ionValue = (IonValue)ionBlob;
                break;
            }
            case 14: {
                void $this$mapTo$iv;
                Iterable value = $this$toIonValue;
                Collection destination$iv = (Collection)ion.newEmptyList();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    ExprValue bl5 = (ExprValue)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    IonValue ionValue3 = it instanceof StructExprValue ? (IonValue)ExprValueExtensionsKt.toIonStruct((ExprValue)it, ion) : ExprValueExtensionsKt.toIonValue((ExprValue)it, ion).clone();
                    collection.add(ionValue3);
                }
                Collection collection = destination$iv;
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"mapTo(ion.newEmptyList()\u2026ue(ion).clone()\n        }");
                ionValue = (IonValue)collection;
                break;
            }
            case 15: {
                Iterable $this$mapTo$iv = $this$toIonValue;
                Collection destination$iv = (Collection)ion.newEmptySexp();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    ExprValue it = (ExprValue)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    IonValue ionValue4 = it instanceof StructExprValue ? (IonValue)ExprValueExtensionsKt.toIonStruct(it, ion) : ExprValueExtensionsKt.toIonValue(it, ion).clone();
                    collection.add(ionValue4);
                }
                Collection collection = destination$iv;
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"mapTo(ion.newEmptySexp()\u2026ue(ion).clone()\n        }");
                ionValue = (IonValue)collection;
                break;
            }
            case 16: {
                void var3_12;
                Iterable $this$mapTo$iv = $this$toIonValue;
                Object destination$iv = ion.newEmptyList();
                boolean $i$f$mapTo = false;
                boolean bl = false;
                IonList $this$apply = destination$iv;
                boolean bl62 = false;
                $this$apply.addTypeAnnotation(BAG_ANNOTATION);
                destination$iv = (Collection)destination$iv;
                $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    ExprValue bl62 = (ExprValue)item$iv;
                    Object object = destination$iv;
                    boolean bl7 = false;
                    IonValue ionValue5 = it instanceof StructExprValue ? (IonValue)ExprValueExtensionsKt.toIonStruct((ExprValue)it, ion) : ExprValueExtensionsKt.toIonValue((ExprValue)it, ion).clone();
                    object.add(ionValue5);
                }
                void v15 = var3_12;
                Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"mapTo(\n            ion.n\u2026ue(ion).clone()\n        }");
                ionValue = (IonValue)v15;
                break;
            }
            case 17: {
                ionValue = (IonValue)ExprValueExtensionsKt.toIonStruct($this$toIonValue, ion);
                break;
            }
            case 18: {
                String string = "Ion representation for graph values, maybe?";
                boolean bl = false;
                throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return ionValue;
    }

    private static final IonStruct toIonStruct(ExprValue $this$toIonStruct, IonSystem ion) {
        IonStruct ionStruct = ion.newEmptyStruct();
        boolean bl = false;
        boolean bl2 = false;
        IonStruct $this$apply = ionStruct;
        boolean bl3 = false;
        Iterable $this$forEach$iv = $this$toIonStruct;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExprValue it = (ExprValue)element$iv;
            boolean bl4 = false;
            ExprValue nameVal = ExprValueExtensionsKt.getName(it);
            if (nameVal == null || !nameVal.getType().isText() || it.getType() == ExprValueType.MISSING) continue;
            String name = ExprValueExtensionsKt.stringValue(nameVal);
            $this$apply.add(name, ExprValueExtensionsKt.toIonValue(it, ion).clone());
        }
        IonStruct ionStruct2 = ionStruct;
        Intrinsics.checkNotNullExpressionValue((Object)ionStruct2, (String)"ion.newEmptyStruct().app\u2026        }\n        }\n    }");
        return ionStruct2;
    }

    public static final /* synthetic */ String access$normalizeForCastToInt(String $this$access_u24normalizeForCastToInt) {
        return ExprValueExtensionsKt.normalizeForCastToInt($this$access_u24normalizeForCastToInt);
    }
}

