/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval;

import com.amazon.ion.Decimal;
import com.amazon.ion.IonBlob;
import com.amazon.ion.IonBool;
import com.amazon.ion.IonClob;
import com.amazon.ion.IonDatagram;
import com.amazon.ion.IonDecimal;
import com.amazon.ion.IonFloat;
import com.amazon.ion.IonInt;
import com.amazon.ion.IonList;
import com.amazon.ion.IonReader;
import com.amazon.ion.IonSexp;
import com.amazon.ion.IonString;
import com.amazon.ion.IonStruct;
import com.amazon.ion.IonSymbol;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonTimestamp;
import com.amazon.ion.IonType;
import com.amazon.ion.IonValue;
import com.amazon.ion.Timestamp;
import com.amazon.ion.facet.Faceted;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.eval.BaseExprValue;
import org.partiql.lang.eval.Bindings;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.ExprValue;
import org.partiql.lang.eval.ExprValue$Companion$WhenMappings;
import org.partiql.lang.eval.ExprValueType;
import org.partiql.lang.eval.IonStructBindings;
import org.partiql.lang.eval.OrdinalBindings;
import org.partiql.lang.eval.Scalar;
import org.partiql.lang.eval.StructExprValue;
import org.partiql.lang.eval.StructOrdering;
import org.partiql.lang.eval.time.Time;
import org.partiql.lang.graph.Graph;
import org.partiql.lang.util.IonValueExtensionsKt;
import org.partiql.lang.util.PropertyMapHelpersKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\b\u0003\bf\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0002\u0019\u001aJ\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00000\u0018H\u00a6\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0014X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lorg/partiql/lang/eval/ExprValue;", "", "Lcom/amazon/ion/facet/Faceted;", "bindings", "Lorg/partiql/lang/eval/Bindings;", "getBindings", "()Lorg/partiql/lang/eval/Bindings;", "graphValue", "Lorg/partiql/lang/graph/Graph;", "getGraphValue", "()Lorg/partiql/lang/graph/Graph;", "ordinalBindings", "Lorg/partiql/lang/eval/OrdinalBindings;", "getOrdinalBindings", "()Lorg/partiql/lang/eval/OrdinalBindings;", "scalar", "Lorg/partiql/lang/eval/Scalar;", "getScalar", "()Lorg/partiql/lang/eval/Scalar;", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "iterator", "", "Companion", "IonStructExprValue", "partiql-lang"})
public interface ExprValue
extends Iterable<ExprValue>,
Faceted,
KMappedMarker {
    @NotNull
    public static final Companion Companion = org.partiql.lang.eval.ExprValue$Companion.$$INSTANCE;

    @NotNull
    public ExprValueType getType();

    @NotNull
    public Scalar getScalar();

    @NotNull
    public Bindings<ExprValue> getBindings();

    @NotNull
    public OrdinalBindings getOrdinalBindings();

    @Override
    @NotNull
    public Iterator<ExprValue> iterator();

    @NotNull
    public Graph getGraphValue();

    @NotNull
    public static ExprValue getMissingValue() {
        return Companion.getMissingValue();
    }

    @NotNull
    public static ExprValue getNullValue() {
        return Companion.getNullValue();
    }

    @JvmStatic
    @NotNull
    public static ExprValue newNull(@NotNull IonType ionType) {
        return Companion.newNull(ionType);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newBoolean(boolean value) {
        return Companion.newBoolean(value);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newString(@NotNull String value) {
        return Companion.newString(value);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newSymbol(@NotNull String value) {
        return Companion.newSymbol(value);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newInt(long value) {
        return Companion.newInt(value);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newInt(int value) {
        return Companion.newInt(value);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newFloat(double value) {
        return Companion.newFloat(value);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newDecimal(@NotNull BigDecimal value) {
        return Companion.newDecimal(value);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newDecimal(int value) {
        return Companion.newDecimal(value);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newDecimal(long value) {
        return Companion.newDecimal(value);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newDate(@NotNull LocalDate value) {
        return Companion.newDate(value);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newDate(int year2, int month, int day) {
        return Companion.newDate(year2, month, day);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newDate(@NotNull String value) {
        return Companion.newDate(value);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newTimestamp(@NotNull Timestamp value) {
        return Companion.newTimestamp(value);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newTime(@NotNull Time value) {
        return Companion.newTime(value);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newClob(@NotNull byte[] value) {
        return Companion.newClob(value);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newBlob(@NotNull byte[] value) {
        return Companion.newBlob(value);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newList(@NotNull Sequence<? extends ExprValue> values) {
        return Companion.newList(values);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newList(@NotNull Iterable<? extends ExprValue> values) {
        return Companion.newList(values);
    }

    @NotNull
    public static ExprValue getEmptyList() {
        return Companion.getEmptyList();
    }

    @JvmStatic
    @NotNull
    public static ExprValue newBag(@NotNull Sequence<? extends ExprValue> values) {
        return Companion.newBag(values);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newBag(@NotNull Iterable<? extends ExprValue> values) {
        return Companion.newBag(values);
    }

    @NotNull
    public static ExprValue getEmptyBag() {
        return Companion.getEmptyBag();
    }

    @JvmStatic
    @NotNull
    public static ExprValue newSexp(@NotNull Sequence<? extends ExprValue> values) {
        return Companion.newSexp(values);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newSexp(@NotNull Iterable<? extends ExprValue> values) {
        return Companion.newSexp(values);
    }

    @NotNull
    public static ExprValue getEmptySexp() {
        return Companion.getEmptySexp();
    }

    @JvmStatic
    @NotNull
    public static ExprValue newStruct(@NotNull Sequence<? extends ExprValue> values, @NotNull StructOrdering ordering) {
        return Companion.newStruct(values, ordering);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newStruct(@NotNull Iterable<? extends ExprValue> values, @NotNull StructOrdering ordering) {
        return Companion.newStruct(values, ordering);
    }

    @NotNull
    public static ExprValue getEmptyStruct() {
        return Companion.getEmptyStruct();
    }

    @JvmStatic
    @NotNull
    public static ExprValue newGraph(@NotNull Graph graph) {
        return Companion.newGraph(graph);
    }

    @JvmStatic
    @NotNull
    public static ExprValue newFromIonReader(@NotNull IonSystem ion, @NotNull IonReader reader) {
        return Companion.newFromIonReader(ion, reader);
    }

    @JvmStatic
    @NotNull
    public static ExprValue of(@NotNull IonValue value) {
        return Companion.of(value);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/partiql/lang/eval/ExprValue$IonStructExprValue;", "Lorg/partiql/lang/eval/StructExprValue;", "ionStruct", "Lcom/amazon/ion/IonStruct;", "(Lcom/amazon/ion/IonStruct;)V", "bindings", "Lorg/partiql/lang/eval/Bindings;", "Lorg/partiql/lang/eval/ExprValue;", "getBindings", "()Lorg/partiql/lang/eval/Bindings;", "partiql-lang"})
    private static final class IonStructExprValue
    extends StructExprValue {
        @NotNull
        private final Bindings<ExprValue> bindings;

        @Override
        @NotNull
        public Bindings<ExprValue> getBindings() {
            return this.bindings;
        }

        public IonStructExprValue(@NotNull IonStruct ionStruct) {
            Intrinsics.checkNotNullParameter((Object)ionStruct, (String)"ionStruct");
            super(StructOrdering.UNORDERED, (Sequence<? extends ExprValue>)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)ionStruct)), (Function1)1.INSTANCE));
            this.bindings = new IonStructBindings(ionStruct);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0011MNOPQRSTUVWXYZ[\\]B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001e\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 H\u0007J\u0016\u0010\u001e\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040!H\u0007J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$H\u0007J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010#\u001a\u00020&H\u0007J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$H\u0007J\u0010\u0010(\u001a\u00020\u00042\u0006\u0010#\u001a\u00020)H\u0007J \u0010(\u001a\u00020\u00042\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020+H\u0007J\u0010\u0010(\u001a\u00020\u00042\u0006\u0010#\u001a\u00020.H\u0007J\u0010\u0010/\u001a\u00020\u00042\u0006\u0010#\u001a\u000200H\u0007J\u0010\u0010/\u001a\u00020\u00042\u0006\u0010#\u001a\u00020+H\u0007J\u0010\u0010/\u001a\u00020\u00042\u0006\u0010#\u001a\u000201H\u0007J\u0010\u00102\u001a\u00020\u00042\u0006\u0010#\u001a\u000203H\u0007J\u0018\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0007J\u0010\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020;H\u0007J\u0010\u0010<\u001a\u00020\u00042\u0006\u0010#\u001a\u00020+H\u0007J\u0010\u0010<\u001a\u00020\u00042\u0006\u0010#\u001a\u000201H\u0007J\u0016\u0010=\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 H\u0007J\u0016\u0010=\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040!H\u0007J\u0010\u0010>\u001a\u00020\u00042\u0006\u0010?\u001a\u00020@H\u0007J\u0016\u0010A\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 H\u0007J\u0016\u0010A\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040!H\u0007J\u0010\u0010B\u001a\u00020\u00042\u0006\u0010#\u001a\u00020.H\u0007J\u001e\u0010C\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 2\u0006\u0010D\u001a\u00020EH\u0007J\u001e\u0010C\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040!2\u0006\u0010D\u001a\u00020EH\u0007J\u0010\u0010F\u001a\u00020\u00042\u0006\u0010#\u001a\u00020.H\u0007J\u0010\u0010G\u001a\u00020\u00042\u0006\u0010#\u001a\u00020HH\u0007J\u0010\u0010I\u001a\u00020\u00042\u0006\u0010#\u001a\u00020JH\u0007J\u0010\u0010K\u001a\u00020\u00042\u0006\u0010#\u001a\u00020LH\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007R\u001c\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u0007R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0002\u001a\u0004\b\u0019\u0010\u0007R\u001c\u0010\u001a\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001b\u0010\u0002\u001a\u0004\b\u001c\u0010\u0007R\u000e\u0010\u001d\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lorg/partiql/lang/eval/ExprValue$Companion;", "", "()V", "emptyBag", "Lorg/partiql/lang/eval/ExprValue;", "getEmptyBag$annotations", "getEmptyBag", "()Lorg/partiql/lang/eval/ExprValue;", "emptyList", "getEmptyList$annotations", "getEmptyList", "emptySexp", "getEmptySexp$annotations", "getEmptySexp", "emptyString", "Lorg/partiql/lang/eval/ExprValue$Companion$StringExprValue;", "emptyStruct", "getEmptyStruct$annotations", "getEmptyStruct", "emptySymbol", "Lorg/partiql/lang/eval/ExprValue$Companion$SymbolExprValue;", "falseValue", "Lorg/partiql/lang/eval/ExprValue$Companion$BooleanExprValue;", "missingValue", "getMissingValue$annotations", "getMissingValue", "nullValue", "getNullValue$annotations", "getNullValue", "trueValue", "newBag", "values", "", "Lkotlin/sequences/Sequence;", "newBlob", "value", "", "newBoolean", "", "newClob", "newDate", "Ljava/time/LocalDate;", "year", "", "month", "day", "", "newDecimal", "Ljava/math/BigDecimal;", "", "newFloat", "", "newFromIonReader", "ion", "Lcom/amazon/ion/IonSystem;", "reader", "Lcom/amazon/ion/IonReader;", "newGraph", "graph", "Lorg/partiql/lang/graph/Graph;", "newInt", "newList", "newNull", "ionType", "Lcom/amazon/ion/IonType;", "newSexp", "newString", "newStruct", "ordering", "Lorg/partiql/lang/eval/StructOrdering;", "newSymbol", "newTime", "Lorg/partiql/lang/eval/time/Time;", "newTimestamp", "Lcom/amazon/ion/Timestamp;", "of", "Lcom/amazon/ion/IonValue;", "BagExprValue", "BlobExprValue", "BooleanExprValue", "ClobExprValue", "DateExprValue", "DecimalExprValue", "FloatExprValue", "GraphExprValue", "IntExprValue", "ListExprValue", "NullExprValue", "ScalarExprValue", "SexpExprValue", "StringExprValue", "SymbolExprValue", "TimeExprValue", "TimestampExprValue", "partiql-lang"})
    public static final class Companion {
        private static final BooleanExprValue trueValue;
        private static final BooleanExprValue falseValue;
        private static final StringExprValue emptyString;
        private static final SymbolExprValue emptySymbol;
        @NotNull
        private static final ExprValue missingValue;
        @NotNull
        private static final ExprValue nullValue;
        @NotNull
        private static final ExprValue emptyList;
        @NotNull
        private static final ExprValue emptyBag;
        @NotNull
        private static final ExprValue emptySexp;
        @NotNull
        private static final ExprValue emptyStruct;
        static final /* synthetic */ Companion $$INSTANCE;

        @JvmStatic
        public static /* synthetic */ void getMissingValue$annotations() {
        }

        @NotNull
        public final ExprValue getMissingValue() {
            return missingValue;
        }

        @JvmStatic
        public static /* synthetic */ void getNullValue$annotations() {
        }

        @NotNull
        public final ExprValue getNullValue() {
            return nullValue;
        }

        @JvmStatic
        @NotNull
        public final ExprValue newNull(@NotNull IonType ionType) {
            ExprValue exprValue2;
            Intrinsics.checkNotNullParameter((Object)ionType, (String)"ionType");
            switch (ExprValue$Companion$WhenMappings.$EnumSwitchMapping$0[ionType.ordinal()]) {
                case 1: {
                    exprValue2 = nullValue;
                    break;
                }
                default: {
                    exprValue2 = new NullExprValue(ionType);
                }
            }
            return exprValue2;
        }

        @JvmStatic
        @NotNull
        public final ExprValue newBoolean(boolean value) {
            ExprValue exprValue2;
            boolean bl = value;
            if (bl) {
                exprValue2 = trueValue;
            } else if (!bl) {
                exprValue2 = falseValue;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return exprValue2;
        }

        @JvmStatic
        @NotNull
        public final ExprValue newString(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            CharSequence charSequence = value;
            boolean bl = false;
            return charSequence.length() == 0 ? (ExprValue)emptyString : (ExprValue)new StringExprValue(value);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newSymbol(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            CharSequence charSequence = value;
            boolean bl = false;
            return charSequence.length() == 0 ? (ExprValue)emptySymbol : (ExprValue)new SymbolExprValue(value);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newInt(long value) {
            return new IntExprValue(value);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newInt(int value) {
            return new IntExprValue(value);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newFloat(double value) {
            return new FloatExprValue(value);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newDecimal(@NotNull BigDecimal value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new DecimalExprValue(value);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newDecimal(int value) {
            BigDecimal bigDecimal = BigDecimal.valueOf(value);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimal.valueOf(value.toLong())");
            return new DecimalExprValue(bigDecimal);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newDecimal(long value) {
            BigDecimal bigDecimal = BigDecimal.valueOf(value);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"BigDecimal.valueOf(value)");
            return new DecimalExprValue(bigDecimal);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newDate(@NotNull LocalDate value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new DateExprValue(value);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newDate(int year2, int month, int day) {
            LocalDate localDate = LocalDate.of(year2, month, day);
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"LocalDate.of(year, month, day)");
            return new DateExprValue(localDate);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newDate(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            LocalDate localDate = LocalDate.parse(value);
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"LocalDate.parse(value)");
            return new DateExprValue(localDate);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newTimestamp(@NotNull Timestamp value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new TimestampExprValue(value);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newTime(@NotNull Time value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new TimeExprValue(value);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newClob(@NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new ClobExprValue(value);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newBlob(@NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new BlobExprValue(value);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newList(@NotNull Sequence<? extends ExprValue> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return new ListExprValue(values);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newList(@NotNull Iterable<? extends ExprValue> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return new ListExprValue((Sequence<? extends ExprValue>)CollectionsKt.asSequence(values));
        }

        @JvmStatic
        public static /* synthetic */ void getEmptyList$annotations() {
        }

        @NotNull
        public final ExprValue getEmptyList() {
            return emptyList;
        }

        @JvmStatic
        @NotNull
        public final ExprValue newBag(@NotNull Sequence<? extends ExprValue> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return new BagExprValue(values);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newBag(@NotNull Iterable<? extends ExprValue> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return new BagExprValue((Sequence<? extends ExprValue>)CollectionsKt.asSequence(values));
        }

        @JvmStatic
        public static /* synthetic */ void getEmptyBag$annotations() {
        }

        @NotNull
        public final ExprValue getEmptyBag() {
            return emptyBag;
        }

        @JvmStatic
        @NotNull
        public final ExprValue newSexp(@NotNull Sequence<? extends ExprValue> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return new SexpExprValue(values);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newSexp(@NotNull Iterable<? extends ExprValue> values) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            return new SexpExprValue((Sequence<? extends ExprValue>)CollectionsKt.asSequence(values));
        }

        @JvmStatic
        public static /* synthetic */ void getEmptySexp$annotations() {
        }

        @NotNull
        public final ExprValue getEmptySexp() {
            return emptySexp;
        }

        @JvmStatic
        @NotNull
        public final ExprValue newStruct(@NotNull Sequence<? extends ExprValue> values, @NotNull StructOrdering ordering) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Intrinsics.checkNotNullParameter((Object)((Object)ordering), (String)"ordering");
            return new StructExprValue(ordering, values);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newStruct(@NotNull Iterable<? extends ExprValue> values, @NotNull StructOrdering ordering) {
            Intrinsics.checkNotNullParameter(values, (String)"values");
            Intrinsics.checkNotNullParameter((Object)((Object)ordering), (String)"ordering");
            return new StructExprValue(ordering, (Sequence<? extends ExprValue>)CollectionsKt.asSequence(values));
        }

        @JvmStatic
        public static /* synthetic */ void getEmptyStruct$annotations() {
        }

        @NotNull
        public final ExprValue getEmptyStruct() {
            return emptyStruct;
        }

        @JvmStatic
        @NotNull
        public final ExprValue newGraph(@NotNull Graph graph) {
            Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
            return new GraphExprValue(graph);
        }

        @JvmStatic
        @NotNull
        public final ExprValue newFromIonReader(@NotNull IonSystem ion, @NotNull IonReader reader) {
            Intrinsics.checkNotNullParameter((Object)ion, (String)"ion");
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            IonValue ionValue = ion.newValue(reader);
            Intrinsics.checkNotNullExpressionValue((Object)ionValue, (String)"ion.newValue(reader)");
            return this.of(ionValue);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final ExprValue of(@NotNull IonValue value) {
            ExprValue exprValue2;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (value.isNullValue() && value.hasTypeAnnotation("$missing")) {
                exprValue2 = missingValue;
            } else if (value.isNullValue()) {
                IonType ionType = value.getType();
                Intrinsics.checkNotNullExpressionValue((Object)ionType, (String)"value.type");
                exprValue2 = this.newNull(ionType);
            } else if (value instanceof IonBool) {
                exprValue2 = this.newBoolean(((IonBool)value).booleanValue());
            } else if (value instanceof IonInt) {
                exprValue2 = this.newInt(((IonInt)value).longValue());
            } else if (value instanceof IonFloat) {
                exprValue2 = this.newFloat(((IonFloat)value).doubleValue());
            } else if (value instanceof IonDecimal) {
                Decimal decimal = ((IonDecimal)value).decimalValue();
                Intrinsics.checkNotNullExpressionValue((Object)decimal, (String)"value.decimalValue()");
                exprValue2 = this.newDecimal((BigDecimal)decimal);
            } else if (value instanceof IonTimestamp && value.hasTypeAnnotation("$date")) {
                Timestamp timestampValue;
                Timestamp timestamp = timestampValue = ((IonTimestamp)value).timestampValue();
                Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"timestampValue");
                exprValue2 = this.newDate(timestamp.getYear(), timestampValue.getMonth(), timestampValue.getDay());
            } else if (value instanceof IonTimestamp) {
                Timestamp timestamp = ((IonTimestamp)value).timestampValue();
                Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"value.timestampValue()");
                exprValue2 = this.newTimestamp(timestamp);
            } else if (value instanceof IonStruct && value.hasTypeAnnotation("$time")) {
                IonValue ionValue = ((IonStruct)value).get("hour");
                if (ionValue == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.amazon.ion.IonInt");
                }
                int hourValue = ((IonInt)ionValue).intValue();
                IonValue ionValue2 = ((IonStruct)value).get("minute");
                if (ionValue2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.amazon.ion.IonInt");
                }
                int minuteValue = ((IonInt)ionValue2).intValue();
                IonValue ionValue3 = ((IonStruct)value).get("second");
                if (ionValue3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.amazon.ion.IonDecimal");
                }
                Decimal secondInDecimal = ((IonDecimal)ionValue3).decimalValue();
                int secondValue = secondInDecimal.intValue();
                BigDecimal bigDecimal = secondInDecimal.remainder(BigDecimal.ONE);
                int n = 1000000000;
                boolean bl = false;
                BigDecimal bigDecimal2 = BigDecimal.valueOf(n);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"BigDecimal.valueOf(this.toLong())");
                int nanoValue = bigDecimal.multiply(bigDecimal2).intValue();
                IonValue ionValue4 = ((IonStruct)value).get("timezone_hour");
                if (ionValue4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.amazon.ion.IonInt");
                }
                int timeZoneHourValue = ((IonInt)ionValue4).intValue();
                IonValue ionValue5 = ((IonStruct)value).get("timezone_minute");
                if (ionValue5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.amazon.ion.IonInt");
                }
                int timeZoneMinuteValue = ((IonInt)ionValue5).intValue();
                exprValue2 = this.newTime(Time.Companion.of(hourValue, minuteValue, secondValue, nanoValue, secondInDecimal.scale(), timeZoneHourValue * 60 + timeZoneMinuteValue));
            } else if (value instanceof IonSymbol) {
                String string = ((IonSymbol)value).stringValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.stringValue()");
                exprValue2 = this.newSymbol(string);
            } else if (value instanceof IonString) {
                String string = ((IonString)value).stringValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.stringValue()");
                exprValue2 = this.newString(string);
            } else if (value instanceof IonClob) {
                exprValue2 = this.newClob(IonValueExtensionsKt.bytesValue(value));
            } else if (value instanceof IonBlob) {
                exprValue2 = this.newBlob(IonValueExtensionsKt.bytesValue(value));
            } else if (value instanceof IonList && value.hasTypeAnnotation("$bag")) {
                Collection<ExprValue> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable hourValue = (Iterable)value;
                Companion companion = this;
                boolean $i$f$map = false;
                void secondInDecimal = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IonValue ionValue = (IonValue)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    void v14 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"it");
                    ExprValue exprValue3 = this.of((IonValue)v14);
                    collection.add(exprValue3);
                }
                collection = (List)destination$iv$iv;
                exprValue2 = companion.newBag((Iterable<? extends ExprValue>)collection);
            } else if (value instanceof IonList) {
                Collection<ExprValue> collection;
                Iterable $this$map$iv = (Iterable)value;
                Companion companion = this;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    IonValue it = (IonValue)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    IonValue ionValue = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ionValue, (String)"it");
                    ExprValue exprValue4 = this.of(ionValue);
                    collection.add(exprValue4);
                }
                collection = (List)destination$iv$iv;
                exprValue2 = companion.newList((Iterable<? extends ExprValue>)collection);
            } else if (value instanceof IonSexp) {
                Collection<ExprValue> collection;
                Iterable $this$map$iv = (Iterable)value;
                Companion companion = this;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    IonValue it = (IonValue)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    IonValue ionValue = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ionValue, (String)"it");
                    ExprValue exprValue5 = this.of(ionValue);
                    collection.add(exprValue5);
                }
                collection = (List)destination$iv$iv;
                exprValue2 = companion.newSexp((Iterable<? extends ExprValue>)collection);
            } else if (value instanceof IonStruct) {
                exprValue2 = new IonStructExprValue((IonStruct)value);
            } else if (value instanceof IonDatagram) {
                Collection<ExprValue> collection;
                Iterable $this$map$iv = (Iterable)value;
                Companion companion = this;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    IonValue it = (IonValue)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    IonValue ionValue = it;
                    Intrinsics.checkNotNullExpressionValue((Object)ionValue, (String)"it");
                    ExprValue exprValue6 = this.of(ionValue);
                    collection.add(exprValue6);
                }
                collection = (List)destination$iv$iv;
                exprValue2 = companion.newBag((Iterable<? extends ExprValue>)collection);
            } else {
                String string = "Unrecognized IonValue to transform to ExprValue: " + value;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return exprValue2;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            trueValue = new BooleanExprValue(true);
            falseValue = new BooleanExprValue(false);
            emptyString = new StringExprValue("");
            emptySymbol = new SymbolExprValue("");
            missingValue = new BaseExprValue(){
                @NotNull
                private final ExprValueType type;

                @NotNull
                public ExprValueType getType() {
                    return this.type;
                }
                {
                    this.type = ExprValueType.MISSING;
                }
            };
            nullValue = new NullExprValue(null, 1, null);
            emptyList = new ListExprValue((Sequence<? extends ExprValue>)SequencesKt.sequenceOf((Object[])new ExprValue[0]));
            emptyBag = new BagExprValue((Sequence<? extends ExprValue>)SequencesKt.sequenceOf((Object[])new ExprValue[0]));
            emptySexp = new SexpExprValue((Sequence<? extends ExprValue>)SequencesKt.sequenceOf((Object[])new ExprValue[0]));
            emptyStruct = new StructExprValue(StructOrdering.UNORDERED, (Sequence<? extends ExprValue>)SequencesKt.sequenceOf((Object[])new ExprValue[0]));
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J%\u0010\u000b\u001a\u0004\u0018\u0001H\f\"\u0004\b\u0000\u0010\f2\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u0002H\f\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/partiql/lang/eval/ExprValue$Companion$NullExprValue;", "Lorg/partiql/lang/eval/BaseExprValue;", "ionType", "Lcom/amazon/ion/IonType;", "(Lcom/amazon/ion/IonType;)V", "getIonType", "()Lcom/amazon/ion/IonType;", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "provideFacet", "T", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "partiql-lang"})
        private static final class NullExprValue
        extends BaseExprValue {
            @NotNull
            private final ExprValueType type;
            @NotNull
            private final IonType ionType;

            @Override
            @NotNull
            public ExprValueType getType() {
                return this.type;
            }

            @Override
            @Nullable
            public <T> T provideFacet(@Nullable Class<T> type2) {
                Class<T> clazz = type2;
                return (T)(Intrinsics.areEqual(clazz, IonType.class) ? (Object)this.ionType : null);
            }

            @NotNull
            public final IonType getIonType() {
                return this.ionType;
            }

            public NullExprValue(@NotNull IonType ionType) {
                Intrinsics.checkNotNullParameter((Object)ionType, (String)"ionType");
                this.ionType = ionType;
                this.type = ExprValueType.NULL;
            }

            public /* synthetic */ NullExprValue(IonType ionType, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    ionType = IonType.NULL;
                }
                this(ionType);
            }

            public NullExprValue() {
                this(null, 1, null);
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\"\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/partiql/lang/eval/ExprValue$Companion$ScalarExprValue;", "Lorg/partiql/lang/eval/BaseExprValue;", "Lorg/partiql/lang/eval/Scalar;", "()V", "scalar", "getScalar", "()Lorg/partiql/lang/eval/Scalar;", "partiql-lang"})
        private static abstract class ScalarExprValue
        extends BaseExprValue
        implements Scalar {
            @Override
            @NotNull
            public Scalar getScalar() {
                return this;
            }

            @Override
            @Nullable
            public Boolean booleanValue() {
                return Scalar.DefaultImpls.booleanValue(this);
            }

            @Override
            @Nullable
            public Number numberValue() {
                return Scalar.DefaultImpls.numberValue(this);
            }

            @Override
            @Nullable
            public Timestamp timestampValue() {
                return Scalar.DefaultImpls.timestampValue(this);
            }

            @Override
            @Nullable
            public LocalDate dateValue() {
                return Scalar.DefaultImpls.dateValue(this);
            }

            @Override
            @Nullable
            public Time timeValue() {
                return Scalar.DefaultImpls.timeValue(this);
            }

            @Override
            @Nullable
            public String stringValue() {
                return Scalar.DefaultImpls.stringValue(this);
            }

            @Override
            @Nullable
            public byte[] bytesValue() {
                return Scalar.DefaultImpls.bytesValue(this);
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/partiql/lang/eval/ExprValue$Companion$BooleanExprValue;", "Lorg/partiql/lang/eval/ExprValue$Companion$ScalarExprValue;", "value", "", "(Z)V", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "getValue", "()Z", "booleanValue", "()Ljava/lang/Boolean;", "partiql-lang"})
        private static final class BooleanExprValue
        extends ScalarExprValue {
            @NotNull
            private final ExprValueType type;
            private final boolean value;

            @Override
            @NotNull
            public ExprValueType getType() {
                return this.type;
            }

            @Override
            @NotNull
            public Boolean booleanValue() {
                return this.value;
            }

            public final boolean getValue() {
                return this.value;
            }

            public BooleanExprValue(boolean value) {
                this.value = value;
                this.type = ExprValueType.BOOL;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/partiql/lang/eval/ExprValue$Companion$StringExprValue;", "Lorg/partiql/lang/eval/ExprValue$Companion$ScalarExprValue;", "value", "", "(Ljava/lang/String;)V", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "getValue", "()Ljava/lang/String;", "stringValue", "partiql-lang"})
        private static final class StringExprValue
        extends ScalarExprValue {
            @NotNull
            private final ExprValueType type;
            @NotNull
            private final String value;

            @Override
            @NotNull
            public ExprValueType getType() {
                return this.type;
            }

            @Override
            @NotNull
            public String stringValue() {
                return this.value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            public StringExprValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.value = value;
                this.type = ExprValueType.STRING;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/partiql/lang/eval/ExprValue$Companion$SymbolExprValue;", "Lorg/partiql/lang/eval/ExprValue$Companion$ScalarExprValue;", "value", "", "(Ljava/lang/String;)V", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "getValue", "()Ljava/lang/String;", "stringValue", "partiql-lang"})
        private static final class SymbolExprValue
        extends ScalarExprValue {
            @NotNull
            private final ExprValueType type;
            @NotNull
            private final String value;

            @Override
            @NotNull
            public ExprValueType getType() {
                return this.type;
            }

            @Override
            @NotNull
            public String stringValue() {
                return this.value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            public SymbolExprValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.value = value;
                this.type = ExprValueType.SYMBOL;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/partiql/lang/eval/ExprValue$Companion$IntExprValue;", "Lorg/partiql/lang/eval/ExprValue$Companion$ScalarExprValue;", "value", "", "(J)V", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "getValue", "()J", "numberValue", "()Ljava/lang/Long;", "partiql-lang"})
        private static final class IntExprValue
        extends ScalarExprValue {
            @NotNull
            private final ExprValueType type;
            private final long value;

            @Override
            @NotNull
            public ExprValueType getType() {
                return this.type;
            }

            @Override
            @NotNull
            public Long numberValue() {
                return this.value;
            }

            public final long getValue() {
                return this.value;
            }

            public IntExprValue(long value) {
                this.value = value;
                this.type = ExprValueType.INT;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/partiql/lang/eval/ExprValue$Companion$FloatExprValue;", "Lorg/partiql/lang/eval/ExprValue$Companion$ScalarExprValue;", "value", "", "(D)V", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "getValue", "()D", "numberValue", "()Ljava/lang/Double;", "partiql-lang"})
        private static final class FloatExprValue
        extends ScalarExprValue {
            @NotNull
            private final ExprValueType type;
            private final double value;

            @Override
            @NotNull
            public ExprValueType getType() {
                return this.type;
            }

            @Override
            @NotNull
            public Double numberValue() {
                return this.value;
            }

            public final double getValue() {
                return this.value;
            }

            public FloatExprValue(double value) {
                this.value = value;
                this.type = ExprValueType.FLOAT;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/partiql/lang/eval/ExprValue$Companion$DecimalExprValue;", "Lorg/partiql/lang/eval/ExprValue$Companion$ScalarExprValue;", "value", "Ljava/math/BigDecimal;", "(Ljava/math/BigDecimal;)V", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "getValue", "()Ljava/math/BigDecimal;", "numberValue", "partiql-lang"})
        private static final class DecimalExprValue
        extends ScalarExprValue {
            @NotNull
            private final ExprValueType type;
            @NotNull
            private final BigDecimal value;

            @Override
            @NotNull
            public ExprValueType getType() {
                return this.type;
            }

            @Override
            @NotNull
            public BigDecimal numberValue() {
                return this.value;
            }

            @NotNull
            public final BigDecimal getValue() {
                return this.value;
            }

            public DecimalExprValue(@NotNull BigDecimal value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.value = value;
                this.type = ExprValueType.DECIMAL;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/partiql/lang/eval/ExprValue$Companion$DateExprValue;", "Lorg/partiql/lang/eval/ExprValue$Companion$ScalarExprValue;", "value", "Ljava/time/LocalDate;", "(Ljava/time/LocalDate;)V", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "getValue", "()Ljava/time/LocalDate;", "dateValue", "partiql-lang"})
        private static final class DateExprValue
        extends ScalarExprValue {
            @NotNull
            private final ExprValueType type;
            @NotNull
            private final LocalDate value;

            @Override
            @NotNull
            public ExprValueType getType() {
                return this.type;
            }

            @Override
            @NotNull
            public LocalDate dateValue() {
                return this.value;
            }

            @NotNull
            public final LocalDate getValue() {
                return this.value;
            }

            public DateExprValue(@NotNull LocalDate value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.value = value;
                if (this.value.getYear() < 0 || this.value.getYear() > 9999) {
                    Void void_ = ExceptionsKt.err("Year should be in the range 0 to 9999 inclusive.", ErrorCode.EVALUATOR_DATE_FIELD_OUT_OF_RANGE, PropertyMapHelpersKt.propertyValueMapOf(new Pair[0]), false);
                    throw new KotlinNothingValueException();
                }
                this.type = ExprValueType.DATE;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/partiql/lang/eval/ExprValue$Companion$TimestampExprValue;", "Lorg/partiql/lang/eval/ExprValue$Companion$ScalarExprValue;", "value", "Lcom/amazon/ion/Timestamp;", "(Lcom/amazon/ion/Timestamp;)V", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "getValue", "()Lcom/amazon/ion/Timestamp;", "timestampValue", "partiql-lang"})
        private static final class TimestampExprValue
        extends ScalarExprValue {
            @NotNull
            private final ExprValueType type;
            @NotNull
            private final Timestamp value;

            @Override
            @NotNull
            public ExprValueType getType() {
                return this.type;
            }

            @Override
            @NotNull
            public Timestamp timestampValue() {
                return this.value;
            }

            @NotNull
            public final Timestamp getValue() {
                return this.value;
            }

            public TimestampExprValue(@NotNull Timestamp value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.value = value;
                this.type = ExprValueType.TIMESTAMP;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/partiql/lang/eval/ExprValue$Companion$TimeExprValue;", "Lorg/partiql/lang/eval/ExprValue$Companion$ScalarExprValue;", "value", "Lorg/partiql/lang/eval/time/Time;", "(Lorg/partiql/lang/eval/time/Time;)V", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "getValue", "()Lorg/partiql/lang/eval/time/Time;", "timeValue", "partiql-lang"})
        private static final class TimeExprValue
        extends ScalarExprValue {
            @NotNull
            private final ExprValueType type;
            @NotNull
            private final Time value;

            @Override
            @NotNull
            public ExprValueType getType() {
                return this.type;
            }

            @Override
            @NotNull
            public Time timeValue() {
                return this.value;
            }

            @NotNull
            public final Time getValue() {
                return this.value;
            }

            public TimeExprValue(@NotNull Time value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.value = value;
                this.type = ExprValueType.TIME;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/partiql/lang/eval/ExprValue$Companion$ClobExprValue;", "Lorg/partiql/lang/eval/ExprValue$Companion$ScalarExprValue;", "value", "", "([B)V", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "getValue", "()[B", "bytesValue", "partiql-lang"})
        private static final class ClobExprValue
        extends ScalarExprValue {
            @NotNull
            private final ExprValueType type;
            @NotNull
            private final byte[] value;

            @Override
            @NotNull
            public ExprValueType getType() {
                return this.type;
            }

            @Override
            @NotNull
            public byte[] bytesValue() {
                return this.value;
            }

            @NotNull
            public final byte[] getValue() {
                return this.value;
            }

            public ClobExprValue(@NotNull byte[] value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.value = value;
                this.type = ExprValueType.CLOB;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/partiql/lang/eval/ExprValue$Companion$BlobExprValue;", "Lorg/partiql/lang/eval/ExprValue$Companion$ScalarExprValue;", "value", "", "([B)V", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "getValue", "()[B", "bytesValue", "partiql-lang"})
        private static final class BlobExprValue
        extends ScalarExprValue {
            @NotNull
            private final ExprValueType type;
            @NotNull
            private final byte[] value;

            @Override
            @NotNull
            public ExprValueType getType() {
                return this.type;
            }

            @Override
            @NotNull
            public byte[] bytesValue() {
                return this.value;
            }

            @NotNull
            public final byte[] getValue() {
                return this.value;
            }

            public BlobExprValue(@NotNull byte[] value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                this.value = value;
                this.type = ExprValueType.BLOB;
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013H\u0096\u0002R\u001b\u0010\u0006\u001a\u00020\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/partiql/lang/eval/ExprValue$Companion$ListExprValue;", "Lorg/partiql/lang/eval/BaseExprValue;", "values", "Lkotlin/sequences/Sequence;", "Lorg/partiql/lang/eval/ExprValue;", "(Lkotlin/sequences/Sequence;)V", "ordinalBindings", "Lorg/partiql/lang/eval/OrdinalBindings;", "getOrdinalBindings", "()Lorg/partiql/lang/eval/OrdinalBindings;", "ordinalBindings$delegate", "Lkotlin/Lazy;", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "getValues", "()Lkotlin/sequences/Sequence;", "iterator", "", "partiql-lang"})
        private static final class ListExprValue
        extends BaseExprValue {
            @NotNull
            private final ExprValueType type;
            @NotNull
            private final Lazy ordinalBindings$delegate;
            @NotNull
            private final Sequence<ExprValue> values;

            @Override
            @NotNull
            public ExprValueType getType() {
                return this.type;
            }

            @Override
            @NotNull
            public OrdinalBindings getOrdinalBindings() {
                Lazy lazy = this.ordinalBindings$delegate;
                ListExprValue listExprValue = this;
                Object var3_3 = null;
                boolean bl = false;
                return (OrdinalBindings)lazy.getValue();
            }

            @Override
            @NotNull
            public Iterator<ExprValue> iterator() {
                return SequencesKt.mapIndexed(this.values, (Function2)iterator.1.INSTANCE).iterator();
            }

            @NotNull
            public final Sequence<ExprValue> getValues() {
                return this.values;
            }

            public ListExprValue(@NotNull Sequence<? extends ExprValue> values) {
                Intrinsics.checkNotNullParameter(values, (String)"values");
                this.values = values;
                this.type = ExprValueType.LIST;
                this.ordinalBindings$delegate = LazyKt.lazy((Function0)((Function0)new Function0<OrdinalBindings>(this){
                    final /* synthetic */ ListExprValue this$0;

                    @NotNull
                    public final OrdinalBindings invoke() {
                        return OrdinalBindings.Companion.ofList(CollectionsKt.toList((Iterable)this.this$0));
                    }
                    {
                        this.this$0 = listExprValue;
                        super(0);
                    }
                }));
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0011H\u0096\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lorg/partiql/lang/eval/ExprValue$Companion$BagExprValue;", "Lorg/partiql/lang/eval/BaseExprValue;", "values", "Lkotlin/sequences/Sequence;", "Lorg/partiql/lang/eval/ExprValue;", "(Lkotlin/sequences/Sequence;)V", "ordinalBindings", "Lorg/partiql/lang/eval/OrdinalBindings;", "getOrdinalBindings", "()Lorg/partiql/lang/eval/OrdinalBindings;", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "getValues", "()Lkotlin/sequences/Sequence;", "iterator", "", "partiql-lang"})
        private static final class BagExprValue
        extends BaseExprValue {
            @NotNull
            private final ExprValueType type;
            @NotNull
            private final OrdinalBindings ordinalBindings;
            @NotNull
            private final Sequence<ExprValue> values;

            @Override
            @NotNull
            public ExprValueType getType() {
                return this.type;
            }

            @Override
            @NotNull
            public OrdinalBindings getOrdinalBindings() {
                return this.ordinalBindings;
            }

            @Override
            @NotNull
            public Iterator<ExprValue> iterator() {
                return this.values.iterator();
            }

            @NotNull
            public final Sequence<ExprValue> getValues() {
                return this.values;
            }

            public BagExprValue(@NotNull Sequence<? extends ExprValue> values) {
                Intrinsics.checkNotNullParameter(values, (String)"values");
                this.values = values;
                this.type = ExprValueType.BAG;
                this.ordinalBindings = OrdinalBindings.Companion.getEMPTY();
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013H\u0096\u0002R\u001b\u0010\u0006\u001a\u00020\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lorg/partiql/lang/eval/ExprValue$Companion$SexpExprValue;", "Lorg/partiql/lang/eval/BaseExprValue;", "values", "Lkotlin/sequences/Sequence;", "Lorg/partiql/lang/eval/ExprValue;", "(Lkotlin/sequences/Sequence;)V", "ordinalBindings", "Lorg/partiql/lang/eval/OrdinalBindings;", "getOrdinalBindings", "()Lorg/partiql/lang/eval/OrdinalBindings;", "ordinalBindings$delegate", "Lkotlin/Lazy;", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "getValues", "()Lkotlin/sequences/Sequence;", "iterator", "", "partiql-lang"})
        private static final class SexpExprValue
        extends BaseExprValue {
            @NotNull
            private final ExprValueType type;
            @NotNull
            private final Lazy ordinalBindings$delegate;
            @NotNull
            private final Sequence<ExprValue> values;

            @Override
            @NotNull
            public ExprValueType getType() {
                return this.type;
            }

            @Override
            @NotNull
            public OrdinalBindings getOrdinalBindings() {
                Lazy lazy = this.ordinalBindings$delegate;
                SexpExprValue sexpExprValue = this;
                Object var3_3 = null;
                boolean bl = false;
                return (OrdinalBindings)lazy.getValue();
            }

            @Override
            @NotNull
            public Iterator<ExprValue> iterator() {
                return SequencesKt.mapIndexed(this.values, (Function2)iterator.1.INSTANCE).iterator();
            }

            @NotNull
            public final Sequence<ExprValue> getValues() {
                return this.values;
            }

            public SexpExprValue(@NotNull Sequence<? extends ExprValue> values) {
                Intrinsics.checkNotNullParameter(values, (String)"values");
                this.values = values;
                this.type = ExprValueType.SEXP;
                this.ordinalBindings$delegate = LazyKt.lazy((Function0)((Function0)new Function0<OrdinalBindings>(this){
                    final /* synthetic */ SexpExprValue this$0;

                    @NotNull
                    public final OrdinalBindings invoke() {
                        return OrdinalBindings.Companion.ofList(CollectionsKt.toList((Iterable)this.this$0));
                    }
                    {
                        this.this$0 = sexpExprValue;
                        super(0);
                    }
                }));
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/partiql/lang/eval/ExprValue$Companion$GraphExprValue;", "Lorg/partiql/lang/eval/BaseExprValue;", "graph", "Lorg/partiql/lang/graph/Graph;", "(Lorg/partiql/lang/graph/Graph;)V", "graphValue", "getGraphValue", "()Lorg/partiql/lang/graph/Graph;", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "partiql-lang"})
        private static final class GraphExprValue
        extends BaseExprValue {
            @NotNull
            private final ExprValueType type;
            @NotNull
            private final Graph graphValue;

            @Override
            @NotNull
            public ExprValueType getType() {
                return this.type;
            }

            @Override
            @NotNull
            public Graph getGraphValue() {
                return this.graphValue;
            }

            public GraphExprValue(@NotNull Graph graph) {
                Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
                this.type = ExprValueType.GRAPH;
                this.graphValue = graph;
            }
        }
    }
}

