/*
 * Decompiled with CFR 0.152.
 */
package org.partiql.lang.eval;

import java.time.LocalDate;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.partiql.lang.errors.ErrorCode;
import org.partiql.lang.eval.ExceptionsKt;
import org.partiql.lang.eval.ExprValueType;
import org.partiql.lang.eval.ScalarExprValue;
import org.partiql.lang.util.PropertyMapHelpersKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/partiql/lang/eval/DateExprValue;", "Lorg/partiql/lang/eval/ScalarExprValue;", "value", "Ljava/time/LocalDate;", "(Ljava/time/LocalDate;)V", "type", "Lorg/partiql/lang/eval/ExprValueType;", "getType", "()Lorg/partiql/lang/eval/ExprValueType;", "getValue", "()Ljava/time/LocalDate;", "dateValue", "partiql-lang"})
final class DateExprValue
extends ScalarExprValue {
    @NotNull
    private final ExprValueType type;
    @NotNull
    private final LocalDate value;

    @Override
    @NotNull
    public ExprValueType getType() {
        return this.type;
    }

    @Override
    @Nullable
    public LocalDate dateValue() {
        return this.value;
    }

    @NotNull
    public final LocalDate getValue() {
        return this.value;
    }

    public DateExprValue(@NotNull LocalDate value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        if (this.value.getYear() < 0 || this.value.getYear() > 9999) {
            Void void_ = ExceptionsKt.err("Year should be in the range 0 to 9999 inclusive.", ErrorCode.EVALUATOR_DATE_FIELD_OUT_OF_RANGE, PropertyMapHelpersKt.propertyValueMapOf(new Pair[0]), false);
            throw new KotlinNothingValueException();
        }
        this.type = ExprValueType.DATE;
    }
}

