/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.security.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextFactory;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.CallbackLogic;
import org.pac4j.core.engine.DefaultCallbackLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.util.FindBest;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.JEEContextFactory;
import org.pac4j.jee.context.session.JEESessionStore;
import org.pac4j.jee.http.adapter.JEEHttpActionAdapter;
import org.pac4j.springframework.security.util.KeepActionHttpActionAdapter;
import org.pac4j.springframework.security.util.KeepRequestResponseFilterChain;
import org.pac4j.springframework.security.web.AbstractPathFilter;
import org.springframework.context.ApplicationContext;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.SecurityFilterChain;

public class CallbackFilter
extends AbstractPathFilter {
    public static final String DEFAULT_CALLBACK_SUFFIX = "/callback";
    private CallbackLogic callbackLogic;
    private Config config;
    private String defaultUrl;
    private Boolean renewSession;
    private String defaultClient;
    private ApplicationContext applicationContext;
    private List<Filter> additionalFilters = new ArrayList<Filter>();

    public CallbackFilter() {
        this.setSuffix(DEFAULT_CALLBACK_SUFFIX);
    }

    public CallbackFilter(Config config) {
        this();
        this.config = config;
    }

    public CallbackFilter(Config config, String defaultUrl) {
        this(config);
        this.defaultUrl = defaultUrl;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        this.init();
        SessionStore bestSessionStore = FindBest.sessionStore(null, (Config)this.config, (SessionStore)JEESessionStore.INSTANCE);
        KeepActionHttpActionAdapter keepActionHttpActionAdapter = new KeepActionHttpActionAdapter();
        CallbackLogic bestLogic = FindBest.callbackLogic((CallbackLogic)this.callbackLogic, (Config)this.config, (CallbackLogic)DefaultCallbackLogic.INSTANCE);
        WebContext context = FindBest.webContextFactory(null, (Config)this.config, (WebContextFactory)JEEContextFactory.INSTANCE).newContext(new Object[]{request, response});
        boolean mustApply = this.mustApply(context);
        if (mustApply) {
            bestLogic.perform(context, bestSessionStore, this.config, (HttpActionAdapter)keepActionHttpActionAdapter, this.defaultUrl, this.renewSession, this.defaultClient);
            HttpServletRequest newRequest = request;
            HttpServletResponse newResponse = response;
            for (Filter additionalFilter : this.additionalFilters) {
                KeepRequestResponseFilterChain filterChain = new KeepRequestResponseFilterChain();
                additionalFilter.doFilter((ServletRequest)newRequest, (ServletResponse)newResponse, (FilterChain)filterChain);
                if (filterChain.hasRequest()) {
                    newRequest = filterChain.getRequest();
                }
                if (!filterChain.hasResponse()) continue;
                newResponse = filterChain.getResponse();
            }
            JEEContext newContext = new JEEContext(newRequest, newResponse);
            HttpActionAdapter bestAdapter = FindBest.httpActionAdapter(null, (Config)this.config, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
            bestAdapter.adapt(keepActionHttpActionAdapter.getAction(), (WebContext)newContext);
        } else {
            chain.doFilter(req, resp);
        }
    }

    public void destroy() {
    }

    protected void internalInit(boolean forceReinit) {
        FilterChainProxy springSecurityFilterChain;
        if (this.applicationContext != null && (springSecurityFilterChain = (FilterChainProxy)this.applicationContext.getBean("springSecurityFilterChain")) != null) {
            List chains = springSecurityFilterChain.getFilterChains();
            for (SecurityFilterChain chain : chains) {
                List filters = chain.getFilters();
                boolean addFilter = false;
                for (Filter filter : filters) {
                    if (addFilter) {
                        this.additionalFilters.add(filter);
                        continue;
                    }
                    if (filter != this) continue;
                    addFilter = true;
                }
                if (!addFilter) continue;
                break;
            }
        }
    }

    public CallbackLogic getCallbackLogic() {
        return this.callbackLogic;
    }

    public void setCallbackLogic(CallbackLogic callbackLogic) {
        this.callbackLogic = callbackLogic;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public Boolean getRenewSession() {
        return this.renewSession;
    }

    public void setRenewSession(Boolean renewSession) {
        this.renewSession = renewSession;
    }

    public String getDefaultClient() {
        return this.defaultClient;
    }

    public void setDefaultClient(String defaultClient) {
        this.defaultClient = defaultClient;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

